/*
 * Decompiled with CFR 0.152.
 */
package it.nectosoft.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_M_Product_Acct;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;

public class CreateExpensesProduct
extends SvrProcess {
    private int m_AD_Client_ID = 0;
    private Properties m_ctx = null;
    private String m_trx = null;
    private Trx localTrx = null;
    private int m_C_TaxCategory_ID = 0;
    private int m_Pricelistversion_ID = 0;
    private int m_C_ElementValue_ID_From = 0;
    private int m_C_ElementValue_ID_To = 0;
    private int m_M_Product_Category_ID = 0;

    @Override
    protected void prepare() {
        this.m_ctx = this.getCtx();
        this.m_AD_Client_ID = this.getAD_Client_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_ElementValue_ID")) {
                    this.m_C_ElementValue_ID_From = para[i].getParameterAsInt();
                    this.m_C_ElementValue_ID_To = para[i].getParameter_ToAsInt();
                } else if (name.equals("C_TaxCategory_ID")) {
                    this.m_C_TaxCategory_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("M_PriceList_Version_ID")) {
                    this.m_Pricelistversion_ID = para[i].getParameterAsInt();
                } else if (name.equals("M_Product_Category_ID")) {
                    this.m_M_Product_Category_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        int countError;
        int count;
        block8: {
            count = 0;
            countError = 0;
            PO price = null;
            StringBuffer sql = new StringBuffer("SELECT * FROM c_elementvalue ").append(" WHERE AD_Client_ID=?").append(" AND value between (SELECT value FROM c_elementvalue WHERE c_elementvalue_id= ? )  AND (SELECT VALUE FROM C_ELEMENTVALUE WHERE C_ELEMENTVALUE_ID=?)");
            this.m_trx = Trx.createTrxName("IDRV");
            this.localTrx = Trx.get(this.m_trx, true);
            CPreparedStatement pstmt = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), this.m_trx);
                    int index = 1;
                    pstmt.setInt(index++, this.m_AD_Client_ID);
                    pstmt.setInt(index++, this.m_C_ElementValue_ID_From);
                    pstmt.setInt(index++, this.m_C_ElementValue_ID_To);
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MProduct product = new MProduct(this.m_ctx, 0, this.get_TrxName());
                        if (this.m_C_TaxCategory_ID != 0) {
                            product.setC_TaxCategory_ID(this.m_C_TaxCategory_ID);
                        }
                        product.setM_Product_Category_ID(this.m_M_Product_Category_ID);
                        product.setProductType("E");
                        product.setName(rs.getString("Name"));
                        product.setValue(rs.getString("Value"));
                        product.setC_UOM_ID(100);
                        product.saveEx();
                        if (this.m_Pricelistversion_ID != 0) {
                            price = new MProductPrice(this.m_ctx, this.m_Pricelistversion_ID, product.getM_Product_ID(), Env.ZERO, Env.ZERO, Env.ZERO, this.get_TrxName());
                        }
                        price.saveEx();
                        ArrayList<Object> params = new ArrayList<Object>();
                        String whereClause = "M_Product_ID= ?";
                        params.add(product.getM_Product_ID());
                        X_M_Product_Acct pacct = (X_M_Product_Acct)new Query(this.m_ctx, "M_Product_Acct", whereClause, this.get_TrxName()).setParameters(params).first();
                        pacct.setP_COGS_Acct(rs.getInt("C_ElementValue_ID"));
                        pacct.setP_Expense_Acct(rs.getInt("C_ElementValue_ID"));
                        pacct.saveEx();
                    }
                    rs.close();
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), e);
                    DB.close(pstmt);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(pstmt);
                throw throwable;
            }
            DB.close(pstmt);
        }
        this.localTrx.close();
        return "@Completed@ = " + count + " - @Errors@=" + countError;
    }
}

