/*
 * Decompiled with CFR 0.152.
 */
package it.nectosoft.process;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MTable;
import org.compiere.process.DocAction;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Login;

public class CompleteDocumentsBatch
extends SvrProcess {
    private int m_AD_Client_ID = 0;
    private int m_AD_Table_ID = 0;
    private Timestamp m_DateAcct_from = null;
    private Timestamp m_DateAcct_to = null;
    private int m_C_BPartner_ID = 0;
    private int m_C_Project_ID = 0;
    private boolean m_isSOTrx = true;
    private Properties m_ctx = null;

    @Override
    protected String doIt() throws Exception {
        int countError;
        int count;
        block30: {
            MTable m_table = new MTable(this.m_ctx, this.m_AD_Table_ID, this.get_TrxName());
            Class<?> clazz = MTable.getClass(m_table.getTableName());
            if (clazz == null) {
                return "No suitable Class found for " + m_table.getTableName();
            }
            boolean okclass = false;
            Class<?>[] classArray = clazz.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> cz = classArray[n2];
                if (cz.equals(DocAction.class)) {
                    okclass = true;
                }
                ++n2;
            }
            if (!okclass) {
                return "Class does not implements DocAction " + clazz.getName();
            }
            DocAction action = null;
            Constructor<?> constructor = null;
            try {
                constructor = clazz.getDeclaredConstructor(Properties.class, ResultSet.class, String.class);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "(id) - Table=" + m_table.getTableName() + ",Class=" + clazz, e);
                return e.toString();
            }
            boolean hasBP = m_table.getColumn("C_BPartner_ID") != null;
            boolean hasSO = m_table.getColumn("IsSOTrx") != null;
            boolean hasDA = m_table.getColumn("DateAcct") != null;
            boolean hasPJ = m_table.getColumn("C_Project_ID") != null;
            StringBuffer sql = new StringBuffer("SELECT * FROM ").append(m_table.getTableName()).append(" WHERE AD_Client_ID=?").append(" AND Processing='N' AND Posted='N' AND IsActive='Y'").append(" AND DocStatus IN ('DR','IN','IP')");
            if (this.m_C_BPartner_ID > 0 && hasBP) {
                sql.append(" AND C_BPartner_ID=?");
            }
            if (hasSO) {
                sql.append(" AND IsSOTrx=?");
            }
            if (this.m_DateAcct_from != null && this.m_DateAcct_to != null && hasDA) {
                sql.append(" AND DATEACCT BETWEEN ? AND ?");
            }
            if (this.m_C_Project_ID > 0 && hasPJ) {
                sql.append(" AND C_PROJECT_ID= ? ");
            }
            count = 0;
            countError = 0;
            CPreparedStatement pstmt = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), null);
                    int index = 1;
                    pstmt.setInt(index++, this.m_AD_Client_ID);
                    if (this.m_C_BPartner_ID > 0 && hasBP) {
                        pstmt.setInt(index++, this.m_C_BPartner_ID);
                    }
                    if (hasSO) {
                        if (this.m_isSOTrx) {
                            pstmt.setString(index++, "Y");
                        } else {
                            pstmt.setString(index++, "N");
                        }
                    }
                    if (hasDA) {
                        pstmt.setTimestamp(index++, this.m_DateAcct_from);
                        pstmt.setTimestamp(index++, this.m_DateAcct_to);
                    }
                    if (this.m_C_Project_ID > 0 && hasPJ) {
                        pstmt.setInt(index++, this.m_C_Project_ID);
                    }
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        boolean ok = true;
                        try {
                            action = (DocAction)constructor.newInstance(this.m_ctx, rs, this.get_TrxName());
                            if (action != null) {
                                if (action.getDocStatus().equals("IN") && !(ok = action.processIt("PR"))) {
                                    this.log.warning("CompleteDocumentsBatch - Prepare failed: " + action);
                                }
                                if (action.getDocStatus().equals("DR") || action.getDocStatus().equals("IP")) {
                                    ok = action.processIt("CO");
                                    if (!ok) {
                                        this.log.warning("CompleteDocumentsBatch - Complete failed: " + action);
                                    }
                                } else {
                                    this.log.warning("CompleteDocumentsBatch - Invalid Status: " + action.getDocStatus() + " - " + action.getDocumentInfo());
                                }
                                action.save();
                                this.commit();
                                this.addLog(action.get_ID(), null, null, String.valueOf(action.getDocStatus()) + " - " + action.getDocumentInfo());
                            }
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, String.valueOf(this.getName()) + ": " + m_table.getTableName(), e);
                            ok = false;
                        }
                        if (ok) {
                            ++count;
                            continue;
                        }
                        ++countError;
                    }
                    rs.close();
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), e);
                    DB.close(pstmt);
                    break block30;
                }
            }
            catch (Throwable throwable) {
                DB.close(pstmt);
                throw throwable;
            }
            DB.close(pstmt);
        }
        return "@Completed@ = " + count + " - @Errors@=" + countError;
    }

    @Override
    protected void prepare() {
        this.m_ctx = this.getCtx();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Client_ID")) {
                    this.m_AD_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("AD_Table_ID")) {
                    this.m_AD_Table_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("IsSOTrx")) {
                    this.m_isSOTrx = "Y".equals(para[i].getParameter());
                } else if (name.equals("C_BPartner_ID")) {
                    this.m_C_BPartner_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_Project_ID")) {
                    this.m_C_Project_ID = para[i].getParameterAsInt();
                } else if (name.equals("DateAcct")) {
                    this.m_DateAcct_from = (Timestamp)para[i].getParameter();
                    this.m_DateAcct_to = (Timestamp)para[i].getParameter_To();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("format : java CompleteDocumentsBatch AD_Client_ID AD_Table_ID IsSOTrx");
            System.out.println("example: java CompleteDocumentsBatch 1000001 318 N");
            System.exit(1);
        }
        Login.initTest(false);
        Integer iAD_Client_ID = new Integer(args[0]);
        Integer iAD_Table_ID = new Integer(args[1]);
        CompleteDocumentsBatch cdb = new CompleteDocumentsBatch();
        cdb.m_AD_Client_ID = iAD_Client_ID;
        cdb.m_AD_Table_ID = iAD_Table_ID;
        cdb.m_isSOTrx = args[2].equalsIgnoreCase("Y");
        cdb.m_ctx = Env.getCtx();
        try {
            System.out.println(cdb.doIt());
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        System.exit(0);
    }
}

