/*
 * Decompiled with CFR 0.152.
 */
package it.nectosoft.process;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import org.compiere.model.MPayment;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class AllocationReCreate
extends SvrProcess {
    private int nalloc = 0;
    private int npay = 0;

    @Override
    protected String doIt() throws Exception {
        this.multyInvoicePayments();
        this.singleInvoicePayments();
        return "Allocation created: " + this.nalloc + " of " + this.npay;
    }

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    private void singleInvoicePayments() throws SQLException {
        StringBuilder wh = new StringBuilder();
        wh.append(" PROCESSED='Y' AND DOCSTATUS IN ('CO','CL') AND C_INVOICE_ID IS NOT NULL").append(" AND NOT EXISTS ").append(" (SELECT 1 FROM C_ALLOCATIONLINE AL WHERE AL.C_PAYMENT_ID = C_PAYMENT.C_PAYMENT_ID)");
        List payments = new Query(this.getCtx(), "C_Payment", wh.toString(), this.get_TrxName()).setClient_ID().list();
        this.npay += payments.size();
        for (MPayment payment : payments) {
            try {
                if (!payment.allocateIt()) continue;
                ++this.nalloc;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "Allocation not created: " + e);
            }
        }
    }

    private void multyInvoicePayments() throws SQLException {
        block8: {
            StringBuilder wh = new StringBuilder();
            wh.append(" SELECT DISTINCT P.C_PAYMENT_ID FROM C_PAYMENT P ").append(" INNER JOIN C_PAYMENTALLOCATE PA ON (PA.C_PAYMENT_ID=P.C_PAYMENT_ID) ").append(" WHERE PA.C_INVOICE_ID IS NOT NULL ").append(" AND P.DOCSTATUS IN ('CO','CL') ").append(" AND NOT EXISTS (SELECT 1 FROM C_ALLOCATIONLINE AL WHERE AL.C_PAYMENT_ID = PA.C_PAYMENT_ID)");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(wh.toString(), this.get_TrxName());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        ++this.npay;
                        int pay_id = rs.getInt(1);
                        MPayment payment = new MPayment(this.getCtx(), pay_id, this.get_TrxName());
                        try {
                            if (!payment.allocateIt()) continue;
                            ++this.nalloc;
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, "Allocation not created: " + e);
                        }
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, wh.toString(), e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }
}

