/*
 * Decompiled with CFR 0.152.
 */
package it.nectosoft.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class LIT_TaxAcct {
    private static CLogger s_log = CLogger.getCLogger(LIT_TaxAcct.class);
    public static final int ACCTTYPE_TaxDue = 0;
    public static final int ACCTTYPE_TaxLiability = 1;
    public static final int ACCTTYPE_TaxCredit = 2;
    public static final int ACCTTYPE_TaxReceivables = 3;
    public static final int ACCTTYPE_TaxExpense = 4;
    public static final int ACCTTYPE_TaxSuspended = 5;

    public static MAccount getAccount(int C_Tax_ID, int AcctType, MAcctSchema as) {
        int validCombination_ID;
        block8: {
            if (AcctType < 0 || AcctType > 5) {
                return null;
            }
            String sql = "SELECT T_Due_Acct, T_Liability_Acct, T_Credit_Acct, T_Receivables_Acct, T_Expense_Acct, T_Suspended_Acct FROM C_Tax_Acct WHERE C_Tax_ID=? AND C_AcctSchema_ID=?";
            validCombination_ID = 0;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, C_Tax_ID);
                    pstmt.setInt(2, as.getC_AcctSchema_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        validCombination_ID = rs.getInt(AcctType + 1);
                    }
                }
                catch (SQLException e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (validCombination_ID == 0) {
            return null;
        }
        return MAccount.get(as.getCtx(), validCombination_ID);
    }
}

