/*
 * Decompiled with CFR 0.152.
 */
package it.nectosoft.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MDocType;
import org.compiere.model.MLITInvoiceWithholding;
import org.compiere.model.MOrder;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPayment;
import org.compiere.model.MTax;
import org.compiere.model.X_LIT_WithholdingCalc;
import org.compiere.model.X_LIT_WithholdingRule;
import org.compiere.model.X_LIT_WithholdingRuleConf;
import org.compiere.model.X_LIT_WithholdingType;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class LIT_MOrder
extends MOrder {
    private static final long serialVersionUID = 1593001707838363487L;

    public LIT_MOrder(Properties ctx, int C_Order_ID, String trxName) {
        super(ctx, C_Order_ID, trxName);
    }

    public int recalcWithholdings(MPayment pay) {
        MDocType dt = new MDocType(this.getCtx(), this.getC_DocTypeTarget_ID(), this.get_TrxName());
        String genwh = dt.get_ValueAsString("GenerateWithholding");
        if (genwh == null || genwh.equals("N")) {
            return 0;
        }
        ArrayList<MLITInvoiceWithholding> whlist = new ArrayList<MLITInvoiceWithholding>();
        int noins = 0;
        this.log.info("");
        BigDecimal totwith = new BigDecimal("0");
        try {
            String sqldel = "DELETE FROM LIT_InvoiceWithholding  WHERE C_Payment_ID = ? AND Processed = 'N'";
            CPreparedStatement pstmtdel = DB.prepareStatement(sqldel, this.get_TrxName());
            pstmtdel.setInt(1, pay.get_ID());
            int nodel = pstmtdel.executeUpdate();
            this.log.config("LIT_InvoiceWithholding deleted=" + nodel);
            pstmtdel.close();
            MBPartner bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
            Integer bp_isic_int = (Integer)bp.get_Value("LIT_ISIC_ID");
            int bp_isic_id = 0;
            if (bp_isic_int != null) {
                bp_isic_id = bp_isic_int;
            }
            Integer bp_taxpayertype_int = (Integer)bp.get_Value("LIT_TaxPayerType_ID");
            int bp_taxpayertype_id = 0;
            if (bp_taxpayertype_int != null) {
                bp_taxpayertype_id = bp_taxpayertype_int;
            }
            MOrgInfo oi = MOrgInfo.get(this.getCtx(), this.getAD_Org_ID());
            Integer org_isic_int = (Integer)oi.get_Value("LIT_ISIC_ID");
            int org_isic_id = 0;
            if (org_isic_int != null) {
                org_isic_id = org_isic_int;
            }
            Integer org_taxpayertype_int = (Integer)oi.get_Value("LIT_TaxPayerType_ID");
            int org_taxpayertype_id = 0;
            if (org_taxpayertype_int != null) {
                org_taxpayertype_id = org_taxpayertype_int;
            }
            String sqlt = "SELECT LIT_WithholdingType_ID  FROM LIT_WithholdingType  WHERE IsSOTrx = ? AND IsActive = 'Y'";
            CPreparedStatement pstmtt = DB.prepareStatement(sqlt, this.get_TrxName());
            pstmtt.setString(1, this.isSOTrx() ? "Y" : "N");
            ResultSet rst = pstmtt.executeQuery();
            while (rst.next()) {
                boolean addedlines;
                int wcid;
                int i;
                X_LIT_WithholdingType wt = new X_LIT_WithholdingType(this.getCtx(), rst.getInt(1), this.get_TrxName());
                X_LIT_WithholdingRuleConf wrc = null;
                this.log.info("Withholding Type: " + wt.getLIT_WithholdingType_ID() + "/" + wt.getName());
                String sqlrc = "SELECT *  FROM LIT_WithholdingRuleConf  WHERE LIT_WithholdingType_ID = ? AND IsActive = 'Y'";
                CPreparedStatement pstmtrc = DB.prepareStatement(sqlrc, this.get_TrxName());
                pstmtrc.setInt(1, wt.getLIT_WithholdingType_ID());
                ResultSet rsrc = pstmtrc.executeQuery();
                if (!rsrc.next()) {
                    this.log.warning("No LIT_WithholdingRuleConf for LIT_WithholdingType = " + wt.getLIT_WithholdingType_ID());
                    rsrc.close();
                    pstmtrc.close();
                    continue;
                }
                wrc = new X_LIT_WithholdingRuleConf(this.getCtx(), rsrc, this.get_TrxName());
                rsrc.close();
                pstmtrc.close();
                StringBuffer sqlr = new StringBuffer("SELECT LIT_WithholdingRule_ID   FROM LIT_WithholdingRule  WHERE LIT_WithholdingType_ID = ?    AND IsActive = 'Y'    AND ValidFrom <= ? ");
                if (wrc.isUseBPISIC()) {
                    sqlr.append(" AND LIT_BP_ISIC_ID = ? ");
                }
                if (wrc.isUseBPTaxPayerType()) {
                    sqlr.append(" AND LIT_BP_TaxPayerType_ID = ? ");
                }
                if (wrc.isUseOrgISIC()) {
                    sqlr.append(" AND LIT_Org_ISIC_ID = ? ");
                }
                if (wrc.isUseOrgTaxPayerType()) {
                    sqlr.append(" AND LIT_Org_TaxPayerType_ID = ? ");
                }
                if (wrc.isUseWithholdingCategory()) {
                    String sqlwcs = "SELECT DISTINCT COALESCE (p.LIT_WithholdingCategory_ID, COALESCE (c.LIT_WithholdingCategory_ID, 0))   FROM C_OrderLine ol   LEFT OUTER JOIN M_Product p ON (ol.M_Product_ID = p.M_Product_ID)   LEFT OUTER JOIN C_Charge c ON (ol.C_Charge_ID = c.C_Charge_ID)   WHERE C_Order_ID = ? AND ol.IsActive='Y'";
                    CPreparedStatement pstmtwcs = DB.prepareStatement(sqlwcs, this.get_TrxName());
                    pstmtwcs.setInt(1, this.getC_Order_ID());
                    ResultSet rswcs = pstmtwcs.executeQuery();
                    i = 0;
                    wcid = 0;
                    addedlines = false;
                    while (rswcs.next()) {
                        wcid = rswcs.getInt(1);
                        if (wcid <= 0) continue;
                        if (i == 0) {
                            sqlr.append(" AND LIT_WithholdingCategory_ID IN (");
                            addedlines = true;
                        } else {
                            sqlr.append(",");
                        }
                        sqlr.append(wcid);
                        ++i;
                    }
                    if (addedlines) {
                        sqlr.append(") ");
                    }
                    rswcs.close();
                    pstmtwcs.close();
                }
                if (wrc.isUseProductTaxCategory()) {
                    String sqlwct = "SELECT DISTINCT COALESCE (p.C_TaxCategory_ID, COALESCE (c.C_TaxCategory_ID, 0))   FROM C_OrderLine ol   LEFT OUTER JOIN M_Product p ON (ol.M_Product_ID = p.M_Product_ID)   LEFT OUTER JOIN C_Charge c ON (ol.C_Charge_ID = c.C_Charge_ID)   WHERE C_Order_ID = ? AND ol.IsActive='Y'";
                    CPreparedStatement pstmtwct = DB.prepareStatement(sqlwct, this.get_TrxName());
                    pstmtwct.setInt(1, this.getC_Order_ID());
                    ResultSet rswct = pstmtwct.executeQuery();
                    i = 0;
                    wcid = 0;
                    addedlines = false;
                    while (rswct.next()) {
                        wcid = rswct.getInt(1);
                        if (wcid <= 0) continue;
                        if (i == 0) {
                            sqlr.append(" AND C_TaxCategory_ID IN (");
                            addedlines = true;
                        } else {
                            sqlr.append(",");
                        }
                        sqlr.append(wcid);
                        ++i;
                    }
                    if (addedlines) {
                        sqlr.append(") ");
                    }
                    rswct.close();
                    pstmtwct.close();
                }
                CPreparedStatement pstmtr = DB.prepareStatement(sqlr.toString(), this.get_TrxName());
                int idxpar = 1;
                pstmtr.setInt(idxpar, wt.getLIT_WithholdingType_ID());
                pstmtr.setTimestamp(++idxpar, this.getDateOrdered());
                if (wrc.isUseBPISIC()) {
                    pstmtr.setInt(++idxpar, bp_isic_id);
                }
                if (wrc.isUseBPTaxPayerType()) {
                    pstmtr.setInt(++idxpar, bp_taxpayertype_id);
                }
                if (wrc.isUseOrgISIC()) {
                    pstmtr.setInt(++idxpar, org_isic_id);
                }
                if (wrc.isUseOrgTaxPayerType()) {
                    pstmtr.setInt(++idxpar, org_taxpayertype_id);
                }
                ResultSet rsr = pstmtr.executeQuery();
                while (rsr.next()) {
                    X_LIT_WithholdingRule wr = new X_LIT_WithholdingRule(this.getCtx(), rsr.getInt(1), this.get_TrxName());
                    if (wr.getLIT_WithholdingCalc_ID() == 0) {
                        this.log.severe("Rule without calc " + rsr.getInt(1));
                        continue;
                    }
                    X_LIT_WithholdingCalc wc = new X_LIT_WithholdingCalc(this.getCtx(), wr.getLIT_WithholdingCalc_ID(), this.get_TrxName());
                    if (!wc.isCalcOnPayment()) continue;
                    MTax tax = new MTax(this.getCtx(), wc.getC_Tax_ID(), this.get_TrxName());
                    this.log.info("WithholdingRule: " + wr.getLIT_WithholdingRule_ID() + "/" + wr.getName() + " BaseType:" + wc.getBaseType() + " Calc: " + wc.getLIT_WithholdingCalc_ID() + "/" + wc.getName() + " CalcOnPayment:" + wc.isCalcOnPayment() + " Tax: " + tax.getC_Tax_ID() + "/" + tax.getName());
                    BigDecimal base = null;
                    if (wc.getBaseType() == null) {
                        this.log.severe("Base Type null in calc record " + wr.getLIT_WithholdingCalc_ID());
                    } else if (wc.getBaseType().equals("D")) {
                        base = this.getTotalLines();
                    } else if (wc.getBaseType().equals("L")) {
                        String sqllca = wrc.isUseWithholdingCategory() && wrc.isUseProductTaxCategory() ? "SELECT SUM (LineNetAmt)   FROM C_OrderLine ol  WHERE IsActive='Y' AND C_Order_ID = ?    AND (   EXISTS (               SELECT 1                 FROM M_Product p                WHERE ol.M_Product_ID = p.M_Product_ID                  AND p.C_TaxCategory_ID = ?                  AND p.LIT_WithholdingCategory_ID = ?)         OR EXISTS (               SELECT 1                 FROM C_Charge c                WHERE ol.C_Charge_ID = c.C_Charge_ID                  AND c.C_TaxCategory_ID = ?                  AND c.LIT_WithholdingCategory_ID = ?)        ) " : (wrc.isUseWithholdingCategory() ? "SELECT SUM (LineNetAmt)   FROM C_OrderLine ol  WHERE IsActive='Y' AND C_Order_ID = ?    AND (   EXISTS (               SELECT 1                 FROM M_Product p                WHERE ol.M_Product_ID = p.M_Product_ID                  AND p.LIT_WithholdingCategory_ID = ?)         OR EXISTS (               SELECT 1                 FROM C_Charge c                WHERE ol.C_Charge_ID = c.C_Charge_ID                  AND c.LIT_WithholdingCategory_ID = ?)        ) " : (wrc.isUseProductTaxCategory() ? "SELECT SUM (LineNetAmt)   FROM C_OrderLine ol  WHERE IsActive='Y' AND C_Order_ID = ?    AND (   EXISTS (               SELECT 1                 FROM M_Product p                WHERE ol.M_Product_ID = p.M_Product_ID                  AND p.C_TaxCategory_ID = ?)         OR EXISTS (               SELECT 1                 FROM C_Charge c                WHERE ol.C_Charge_ID = c.C_Charge_ID                  AND c.C_TaxCategory_ID = ?)        ) " : "SELECT SUM (LineNetAmt)   FROM C_OrderLine ol  WHERE IsActive='Y' AND C_Order_ID = ? "));
                        CPreparedStatement pstmtlca = DB.prepareStatement(sqllca, this.get_TrxName());
                        pstmtlca.setInt(1, this.getC_Order_ID());
                        if (wrc.isUseWithholdingCategory() && wrc.isUseProductTaxCategory()) {
                            pstmtlca.setInt(2, wr.getC_TaxCategory_ID());
                            pstmtlca.setInt(3, wr.getLIT_WithholdingCategory_ID());
                            pstmtlca.setInt(4, wr.getC_TaxCategory_ID());
                            pstmtlca.setInt(5, wr.getLIT_WithholdingCategory_ID());
                        } else if (wrc.isUseWithholdingCategory()) {
                            pstmtlca.setInt(2, wr.getLIT_WithholdingCategory_ID());
                            pstmtlca.setInt(3, wr.getLIT_WithholdingCategory_ID());
                        } else if (wrc.isUseProductTaxCategory()) {
                            pstmtlca.setInt(2, wr.getC_TaxCategory_ID());
                            pstmtlca.setInt(3, wr.getC_TaxCategory_ID());
                        }
                        ResultSet rslca = pstmtlca.executeQuery();
                        if (rslca.next()) {
                            base = rslca.getBigDecimal(1);
                        }
                        rslca.close();
                        pstmtlca.close();
                    } else if (wc.getBaseType().equals("T")) {
                        if (wc.getC_BaseTax_ID() != 0) {
                            String sqlbst = "SELECT SUM(TaxAmt)  FROM C_OrderTax  WHERE IsActive='Y' AND C_Order_ID = ?    AND C_Tax_ID = ?";
                            CPreparedStatement pstmtbst = DB.prepareStatement(sqlbst, this.get_TrxName());
                            pstmtbst.setInt(1, this.getC_Order_ID());
                            pstmtbst.setInt(2, wc.getC_BaseTax_ID());
                            ResultSet rsbst = pstmtbst.executeQuery();
                            if (rsbst.next()) {
                                base = rsbst.getBigDecimal(1);
                            }
                            rsbst.close();
                            pstmtbst.close();
                        } else {
                            String sqlbsat = "SELECT SUM(TaxAmt)  FROM C_OrderTax  WHERE IsActive='Y' AND C_Order_ID = ? ";
                            CPreparedStatement pstmtbsat = DB.prepareStatement(sqlbsat, this.get_TrxName());
                            pstmtbsat.setInt(1, this.getC_Order_ID());
                            ResultSet rsbsat = pstmtbsat.executeQuery();
                            if (rsbsat.next()) {
                                base = rsbsat.getBigDecimal(1);
                            }
                            rsbsat.close();
                            pstmtbsat.close();
                        }
                    }
                    this.log.info("Base: " + base + " Thresholdmin:" + wc.getThresholdmin());
                    if (base == null || base.compareTo(Env.ZERO) == 0 || base.compareTo(wc.getThresholdmin()) < 0 || tax.getRate() == null || tax.getRate().compareTo(Env.ZERO) == 0) continue;
                    MLITInvoiceWithholding iwh = new MLITInvoiceWithholding(this.getCtx(), 0, this.get_TrxName());
                    iwh.setAD_Org_ID(this.getAD_Org_ID());
                    iwh.setC_Order_ID(this.getC_Order_ID());
                    iwh.setC_Payment_ID(pay.get_ID());
                    iwh.setIsProRataOnUnderpayment(false);
                    iwh.setDateAcct(this.getDateAcct());
                    iwh.setDateTrx(this.getDateOrdered());
                    iwh.setIsCalcOnPayment(true);
                    iwh.setIsTaxIncluded(false);
                    iwh.setLIT_WithholdingRule_ID(wr.getLIT_WithholdingRule_ID());
                    iwh.setLIT_WithholdingType_ID(wt.getLIT_WithholdingType_ID());
                    iwh.setC_Tax_ID(tax.getC_Tax_ID());
                    iwh.setPercent(tax.getRate());
                    iwh.setProcessed(false);
                    BigDecimal taxamt = tax.calculateTax(base, false, this.getPrecision());
                    iwh.setTaxAmt(taxamt);
                    iwh.setTaxBaseAmt(base);
                    whlist.add(iwh);
                    totwith = totwith.add(taxamt);
                    ++noins;
                }
            }
            this.save();
            rst.close();
            pstmtt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "", e);
            return -1;
        }
        double percent = 1.0;
        BigDecimal allocationSource = pay.getPayAmt().abs();
        BigDecimal netOrder = this.getGrandTotal().subtract(totwith);
        if (this.getGrandTotal().subtract(totwith).compareTo(allocationSource) != 0) {
            double d = percent = netOrder.signum() != 0 ? allocationSource.doubleValue() / netOrder.doubleValue() : 1.0;
            if (percent > 0.99 && percent < 1.01) {
                percent = 1.0;
            }
        }
        BigDecimal newtotwh = Env.ZERO;
        for (MLITInvoiceWithholding iw : whlist) {
            if (percent != 1.0) {
                iw.setTaxBaseAmt(iw.getTaxBaseAmt().multiply(new BigDecimal(percent)).setScale(this.getPrecision(), 4));
                iw.setTaxAmt(iw.getPercent().multiply(iw.getTaxBaseAmt()).divide(Env.ONEHUNDRED).setScale(this.getPrecision(), 4));
            }
            newtotwh = newtotwh.add(iw.getTaxAmt());
            iw.save();
            this.log.info("LIT_InvoiceWithholding saved:" + iw.getTaxAmt());
        }
        pay.setWriteOffAmt(newtotwh);
        pay.save();
        return noins;
    }
}

