/*
 * Decompiled with CFR 0.152.
 */
package it.nectosoft.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.LIT_Sequence;
import org.compiere.model.MSequence;
import org.compiere.model.X_LIT_TaxIdType;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class LIT_Callouts
extends CalloutEngine {
    public String docType(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_DocType_ID = (Integer)value;
        if (C_DocType_ID == null || C_DocType_ID == 0) {
            return "";
        }
        boolean IsSOTrx = Env.getContext(ctx, WindowNo, "IsSOTrx").equals("Y");
        if (!IsSOTrx) {
            String sql = "SELECT coalesce(de.IsIntraVAT,'N') as IsIntraVAT, coalesce(de.IsReverseCharge,'N') as IsReverseCharge FROM C_DocType d  LEFT OUTER JOIN LIT_DocTypeExt de on (d.LIT_DocTypeExt_ID = de.LIT_DocTypeExt_ID) WHERE C_DocType_ID=? ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), null);
                    pstmt.setInt(1, C_DocType_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        mTab.setValue("IsIntraVAT", (Object)rs.getString(1));
                        mTab.setValue("IsReverseCharge", (Object)rs.getString(2));
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, e);
                    String string = e.getLocalizedMessage();
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    return string;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return "";
    }

    public String VATLedgerNo(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        if (this.isCalloutActive() || value == null || value.equals(oldValue)) {
            return "";
        }
        Integer doc_id = (Integer)mTab.getValue("C_DocTypeTarget_ID");
        if (doc_id == null || doc_id == 0) {
            return "";
        }
        String sql = "SELECT coalesce(vl.DocNoSequence_ID,0) as VatNoSeq_ID, s.DateColumn FROM C_DocType d  LEFT OUTER JOIN LIT_DocTypeExt de on (d.LIT_DocTypeExt_ID = de.LIT_DocTypeExt_ID) LEFT OUTER JOIN LIT_VatLedgerDef vl on (vl.LIT_VatLedgerDef_ID = de.LIT_VatLedgerDef_ID) LEFT OUTER JOIN AD_Sequence s on (vl.DocNoSequence_ID = s.AD_Sequence_ID) WHERE d.C_DocType_ID=? ";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                int seqID;
                pstmt = DB.prepareStatement(sql.toString(), null);
                pstmt.setInt(1, doc_id);
                rs = pstmt.executeQuery();
                if (rs.next() && (seqID = rs.getInt(1)) > 0) {
                    String dateColumn = rs.getString(2);
                    mTab.setValue("VATLedgerNo", (Object)("<" + LIT_Sequence.getPreliminaryNoByYear(mTab, seqID, dateColumn, null) + ">"));
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
                String string = e.getLocalizedMessage();
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return "";
    }

    public String docTypeAuto(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_DocType_ID = (Integer)value;
        if (C_DocType_ID == null || C_DocType_ID == 0) {
            return "";
        }
        String sql = "SELECT d.IsDocNoControlled, s.CurrentNext, s.StartNewYear, s.DateColumn, s.AD_Sequence_ID FROM C_DocType d, AD_Sequence s WHERE C_DocType_ID=? AND d.DocNoSequence_ID=s.AD_Sequence_ID(+)";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, C_DocType_ID);
                rs = pstmt.executeQuery();
                if (rs.next() && rs.getString(1).equals("Y")) {
                    if ("Y".equals(rs.getString(3))) {
                        String dateColumn = rs.getString(4);
                        mTab.setValue("DocumentNo", (Object)("<" + MSequence.getPreliminaryNoByYear(mTab, rs.getInt(5), dateColumn, null) + ">"));
                    } else {
                        mTab.setValue("DocumentNo", (Object)("<" + rs.getString(2) + ">"));
                    }
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
                String string = e.getLocalizedMessage();
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return "";
    }

    public String VATLedgerNoAuto(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        if (this.isCalloutActive() || value == null || value.equals(oldValue)) {
            return "";
        }
        Integer doc_id = (Integer)mTab.getValue("C_DocTypeAutoInvoice_ID");
        if (doc_id == null || doc_id == 0) {
            return "";
        }
        String sql = "SELECT coalesce(vl.DocNoSequence_ID,0) as VatNoSeq_ID, s.DateColumn FROM C_DocType d  LEFT OUTER JOIN LIT_DocTypeExt de on (d.LIT_DocTypeExt_ID = de.LIT_DocTypeExt_ID) LEFT OUTER JOIN LIT_VatLedgerDef vl on (vl.LIT_VatLedgerDef_ID = de.LIT_VatLedgerDef_ID) LEFT OUTER JOIN AD_Sequence s on (vl.DocNoSequence_ID = s.AD_Sequence_ID) WHERE d.C_DocType_ID=? ";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                int seqID;
                pstmt = DB.prepareStatement(sql.toString(), null);
                pstmt.setInt(1, doc_id);
                rs = pstmt.executeQuery();
                if (rs.next() && (seqID = rs.getInt(1)) > 0) {
                    String dateColumn = rs.getString(2);
                    mTab.setValue("VATLedgerNo", (Object)("<" + LIT_Sequence.getPreliminaryNoByYear(mTab, seqID, dateColumn, null) + ">"));
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
                String string = e.getLocalizedMessage();
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return "";
    }

    public String bPartner(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String sql;
        String isSuspendedVat;
        mTab.setValue("IsSuspendedVAT", (Object)"N");
        Integer C_BPartner_ID = (Integer)value;
        if (C_BPartner_ID == null || C_BPartner_ID == 0) {
            return "";
        }
        boolean IsSOTrx = Env.getContext(ctx, WindowNo, "IsSOTrx").equals("Y");
        if (IsSOTrx && (isSuspendedVat = DB.getSQLValueString(null, sql = "SELECT p.IsSuspendedVAT  FROM C_BPartner p  WHERE p.C_BPartner_ID=? AND p.IsActive='Y'", C_BPartner_ID)) != null && isSuspendedVat.length() != 0) {
            mTab.setValue("IsSuspendedVAT", (Object)isSuspendedVat);
        }
        return "";
    }

    public String checkTaxIdDigit(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        return "";
    }

    public String taxIdType(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        this.log.info("");
        if (value == null) {
            return "";
        }
        int taxidtype_id = (Integer)value;
        X_LIT_TaxIdType taxidtype = new X_LIT_TaxIdType(ctx, taxidtype_id, null);
        mTab.setValue("IsUseTaxIdDigit", (Object)taxidtype.isUseTaxIdDigit());
        mTab.setValue("IsDetailedNames", (Object)taxidtype.isDetailedNames());
        Env.setContext(ctx, WindowNo, "IsDigitChecked", taxidtype.isDigitChecked());
        return "";
    }

    public String fillName(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        String filledName;
        this.log.info("");
        if (mTab.getValue("FirstName1") == null && mTab.getValue("FirstName2") == null && mTab.getValue("LastName1") == null && mTab.getValue("LastName2") == null) {
            mTab.setValue("Name", null);
        }
        if ((filledName = (String)mTab.getValue("LastName1")) == null) {
            filledName = new String("");
        }
        if (mTab.getValue("LastName2") != null) {
            filledName = String.valueOf(filledName) + " " + ((String)mTab.getValue("LastName2")).trim();
        }
        if (filledName != null) {
            filledName = String.valueOf(filledName) + " ";
        }
        if (mTab.getValue("FirstName1") != null) {
            filledName = String.valueOf(filledName) + ((String)mTab.getValue("FirstName1")).trim();
        }
        if (mTab.getValue("FirstName2") != null) {
            filledName = String.valueOf(filledName) + " " + ((String)mTab.getValue("FirstName2")).trim();
        }
        if (filledName.length() > 60) {
            filledName = filledName.substring(0, 60);
        }
        mTab.setValue("Name", (Object)filledName);
        return "";
    }
}

