/*
 * Decompiled with CFR 0.152.
 */
package it.nectosoft.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MInvoice;
import org.compiere.model.MLITInvoiceWithholding;
import org.compiere.model.MTax;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class LIT_CalloutWithholding
extends CalloutEngine {
    public String fillIsUse(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        this.log.info("");
        int wht_id = (Integer)mTab.getValue("LIT_WithholdingType_ID");
        String sql = "SELECT IsUseBPISIC, IsUseBPTaxPayerType, IsUseOrgISIC, IsUseOrgTaxPayerType, IsUseWithholdingCategory, IsUseProductTaxCategory FROM LIT_WithholdingRuleConf WHERE LIT_WithholdingType_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, wht_id);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                mTab.setValue("IsUseBPISIC", (Object)rs.getString("IsUseBPISIC"));
                mTab.setValue("IsUseBPTaxPayerType", (Object)rs.getString("IsUseBPTaxPayerType"));
                mTab.setValue("IsUseOrgISIC", (Object)rs.getString("IsUseOrgISIC"));
                mTab.setValue("IsUseOrgTaxPayerType", (Object)rs.getString("IsUseOrgTaxPayerType"));
                mTab.setValue("IsUseWithholdingCategory", (Object)rs.getString("IsUseWithholdingCategory"));
                mTab.setValue("IsUseProductTaxCategory", (Object)rs.getString("IsUseProductTaxCategory"));
            } else {
                mTab.setValue("IsUseBPISIC", (Object)"N");
                mTab.setValue("IsUseBPTaxPayerType", (Object)"N");
                mTab.setValue("IsUseOrgISIC", (Object)"N");
                mTab.setValue("IsUseOrgTaxPayerType", (Object)"N");
                mTab.setValue("IsUseWithholdingCategory", (Object)"N");
                mTab.setValue("IsUseProductTaxCategory", (Object)"N");
                this.log.warning("Rule not configured for withholding type");
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
            return e.getLocalizedMessage();
        }
        return "";
    }

    public String fillPercentFromTax(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        this.log.info("");
        int taxint = 0;
        BigDecimal percent = null;
        if (value != null) {
            taxint = (Integer)value;
        }
        if (taxint != 0) {
            MTax tax = new MTax(ctx, taxint, null);
            percent = tax.getRate();
        }
        mTab.setValue("Percent", percent);
        return this.recalc_taxamt(ctx, WindowNo, mTab, mField, value, oldValue);
    }

    public String recalc_taxamt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        BigDecimal oldtaxbaseamt;
        BigDecimal newtaxbaseamt;
        this.log.info("");
        if (mField.getColumnName().equals("TaxBaseAmt") && value != null && oldValue != null && (newtaxbaseamt = (BigDecimal)value).compareTo(oldtaxbaseamt = (BigDecimal)oldValue) == 0) {
            return "";
        }
        BigDecimal percent = (BigDecimal)mTab.getValue("Percent");
        BigDecimal taxbaseamt = (BigDecimal)mTab.getValue("TaxBaseAmt");
        BigDecimal taxamt = null;
        if (percent != null && taxbaseamt != null) {
            taxamt = percent.multiply(taxbaseamt).divide(Env.ONEHUNDRED);
        }
        mTab.setValue("TaxAmt", taxamt);
        return "";
    }

    public String fillWriteOff(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        this.log.info("");
        if (this.isCalloutActive()) {
            return "";
        }
        Integer invInt = (Integer)value;
        int inv_id = 0;
        if (value != null) {
            inv_id = invInt;
        }
        if (inv_id > 0) {
            BigDecimal WhFullAmt = MLITInvoiceWithholding.getOpenWithholdingAmt(null, inv_id, "Y", "N");
            BigDecimal WhProRataAmt = MLITInvoiceWithholding.getOpenWithholdingAmt(null, inv_id, "Y", "Y");
            mTab.setValue("WriteOffAmt", (Object)WhFullAmt.add(WhProRataAmt));
            Env.setContext(ctx, WindowNo, "FullWithholding", WhFullAmt.toString());
            Env.setContext(ctx, WindowNo, "ProRataWithholding", WhProRataAmt.toString());
        }
        return "";
    }

    public String updateWriteOff(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        BigDecimal WhProRataAmt;
        BigDecimal WhFullAmt;
        int inv_id;
        this.log.info("");
        int n = inv_id = mTab.getValue("C_Invoice_ID") != null ? (Integer)mTab.getValue("C_Invoice_ID") : 0;
        if (this.isCalloutActive() || inv_id == 0) {
            return "";
        }
        String tableName = mTab.getTableName();
        String orgColumn = mField.getColumnName();
        String colName = tableName.equals("C_Payment") ? "PayAmt" : "Amount";
        BigDecimal PayAmt = (BigDecimal)mTab.getValue(colName);
        BigDecimal OrgAmt = null;
        if (colName.equals(orgColumn)) {
            OrgAmt = (BigDecimal)oldValue;
        }
        if (OrgAmt != null && OrgAmt.signum() != 0 && OrgAmt.compareTo(PayAmt) != 0) {
            BigDecimal OverUnderAmt = (BigDecimal)mTab.getValue("OverUnderAmt");
            mTab.setValue("OverUnderAmt", (Object)OverUnderAmt.add(OrgAmt.subtract(PayAmt)));
            mTab.setValue("IsOverUnderPayment", (Object)Boolean.TRUE);
        }
        MInvoice invoice = null;
        invoice = new MInvoice(ctx, inv_id, null);
        String sfullamt = Env.getContext(ctx, WindowNo, "FullWithholding");
        String srataamt = Env.getContext(ctx, WindowNo, "ProRataWithholding");
        if (sfullamt != null && sfullamt.length() > 0 && srataamt != null && srataamt.length() > 0) {
            WhFullAmt = new BigDecimal(sfullamt);
            WhProRataAmt = new BigDecimal(srataamt);
        } else {
            WhFullAmt = MLITInvoiceWithholding.getOpenWithholdingAmt(null, inv_id, "Y", "N");
            WhProRataAmt = MLITInvoiceWithholding.getOpenWithholdingAmt(null, inv_id, "Y", "Y");
            Env.setContext(ctx, WindowNo, "FullWithholding", WhFullAmt.toString());
            Env.setContext(ctx, WindowNo, "ProRataWithholding", WhProRataAmt.toString());
        }
        if (WhProRataAmt.signum() != 0) {
            double percent = PayAmt.doubleValue() / invoice.getOpenAmt().subtract(WhFullAmt).subtract(WhProRataAmt).doubleValue();
            if (percent > 0.99 && percent < 1.01) {
                percent = 1.0;
            }
            BigDecimal writeoff = WhProRataAmt.multiply(new BigDecimal(percent)).add(WhFullAmt).setScale(invoice.getPrecision(), 4);
            mTab.setValue("WriteOffAmt", (Object)writeoff);
        }
        return "";
    }
}

