/*
 * Decompiled with CFR 0.152.
 */
package it.cnr.imaa.essi.lablib.gui.checkboxtree;

import it.cnr.imaa.essi.lablib.gui.checkboxtree.DefaultTreeCheckingModel;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingMode;
import javax.swing.tree.TreePath;

public class PropagateUpWhiteTreeCheckingMode
extends TreeCheckingMode {
    PropagateUpWhiteTreeCheckingMode(DefaultTreeCheckingModel defaultTreeCheckingModel) {
        super(defaultTreeCheckingModel);
    }

    @Override
    public void checkPath(TreePath treePath) {
        this.model.checkSubTree(treePath);
        TreePath[] treePathArray = new TreePath[treePath.getPathCount()];
        treePathArray[0] = treePath;
        TreePath treePath2 = treePath;
        while ((treePath2 = treePath2.getParentPath()) != null) {
            this.model.updatePathGreyness(treePath2);
        }
    }

    @Override
    public void uncheckPath(TreePath treePath) {
        this.model.uncheckSubTree(treePath);
        TreePath treePath2 = treePath;
        while ((treePath2 = treePath2.getParentPath()) != null) {
            this.model.removeFromCheckedPathsSet(treePath2);
            this.model.updatePathGreyness(treePath2);
        }
    }

    @Override
    public void updateCheckAfterChildrenInserted(TreePath treePath) {
        if (this.model.isPathChecked(treePath)) {
            this.checkPath(treePath);
        } else {
            this.uncheckPath(treePath);
        }
    }

    @Override
    public void updateCheckAfterChildrenRemoved(TreePath treePath) {
        if (!this.model.isPathChecked(treePath) && this.model.getChildrenPath(treePath).length != 0 && !this.model.pathHasChildrenWithValue(treePath, false)) {
            this.checkPath(treePath);
        }
        this.model.updatePathGreyness(treePath);
        this.model.updateAncestorsGreyness(treePath);
    }

    @Override
    public void updateCheckAfterStructureChanged(TreePath treePath) {
        if (this.model.isPathChecked(treePath)) {
            this.checkPath(treePath);
        } else {
            this.uncheckPath(treePath);
        }
    }
}

