/*
 * Decompiled with CFR 0.152.
 */
package it.cnr.imaa.essi.lablib.gui.checkboxtree;

import it.cnr.imaa.essi.lablib.gui.checkboxtree.PropagatePreservingCheckTreeCheckingMode;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.PropagatePreservingUncheckTreeCheckingMode;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.PropagateTreeCheckingMode;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.PropagateUpWhiteTreeCheckingMode;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.SimpleTreeCheckingMode;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingEvent;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingListener;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingMode;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingModel;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class DefaultTreeCheckingModel
implements TreeCheckingModel {
    private HashSet<TreePath> checkedPathsSet;
    private HashSet<TreePath> greyedPathsSet;
    private HashSet<TreePath> disabledPathsSet;
    private HashSet<TreePath> checkBoxPathsSet;
    private PropagateCheckingListener propagateCheckingListener;
    protected TreeCheckingMode checkingMode;
    protected TreeModel model;
    protected EventListenerList listenerList = new EventListenerList();

    public DefaultTreeCheckingModel(TreeModel treeModel) {
        this.model = treeModel;
        this.checkedPathsSet = new HashSet();
        this.greyedPathsSet = new HashSet();
        this.disabledPathsSet = new HashSet();
        this.checkBoxPathsSet = new HashSet();
        this.propagateCheckingListener = new PropagateCheckingListener();
        this.setCheckingMode(TreeCheckingModel.CheckingMode.PROPAGATE);
    }

    @Override
    @Deprecated
    public TreeModelListener getTreeModelListener() {
        return null;
    }

    public void setCheckedPathsSet(HashSet<TreePath> hashSet) {
        this.checkedPathsSet = hashSet;
    }

    public void setGreyedPathsSet(HashSet<TreePath> hashSet) {
        this.greyedPathsSet = hashSet;
    }

    public void setDisabledPathsSet(HashSet<TreePath> hashSet) {
        this.disabledPathsSet = hashSet;
    }

    public void setCheckBoxPathsSet(HashSet<TreePath> hashSet) {
        this.checkBoxPathsSet = hashSet;
    }

    public void updateCheckingConsistency() {
        this.updateSubTreeCheckingConsistency(new TreePath(this.model.getRoot()));
    }

    public void updateSubTreeCheckingConsistency(TreePath treePath) {
        if (this.isPathGreyed(treePath)) {
            for (TreePath treePath2 : this.getChildrenPath(treePath)) {
                this.updateSubTreeCheckingConsistency(treePath2);
            }
        } else {
            if (this.isPathChecked(treePath)) {
                this.checkSubTree(treePath);
            } else {
                this.uncheckSubTree(treePath);
            }
            return;
        }
        this.updatePathGreyness(treePath);
    }

    @Override
    public boolean isPathCheckBox(TreePath treePath) {
        return this.checkBoxPathsSet.contains(treePath);
    }

    @Override
    public boolean isPathChecked(TreePath treePath) {
        return this.checkedPathsSet.contains(treePath);
    }

    @Override
    public boolean isPathEnabled(TreePath treePath) {
        return !this.disabledPathsSet.contains(treePath);
    }

    @Override
    public boolean isPathGreyed(TreePath treePath) {
        return this.greyedPathsSet.contains(treePath);
    }

    void addToGreyedPathsSet(TreePath treePath) {
        this.greyedPathsSet.add(treePath);
    }

    void removeFromGreyedPathsSet(TreePath treePath) {
        this.greyedPathsSet.remove(treePath);
    }

    @Override
    public void setPathEnabled(TreePath treePath, boolean bl) {
        if (bl) {
            this.disabledPathsSet.remove(treePath);
        } else {
            this.disabledPathsSet.add(treePath);
        }
    }

    @Override
    public void setPathsEnabled(TreePath[] treePathArray, boolean bl) {
        for (TreePath treePath : treePathArray) {
            this.setPathEnabled(treePath, bl);
        }
    }

    public void addToCheckBoxPathsSet(TreePath treePath) {
        this.checkBoxPathsSet.add(treePath);
    }

    void addToCheckedPathsSet(TreePath treePath) {
        this.checkedPathsSet.add(treePath);
    }

    void removeFromCheckedPathsSet(TreePath treePath) {
        this.checkedPathsSet.remove(treePath);
    }

    public void ungreySubTree(TreePath treePath) {
        this.removeFromGreyedPathsSet(treePath);
        for (TreePath treePath2 : this.getChildrenPath(treePath)) {
            this.ungreySubTree(treePath2);
        }
    }

    public void checkSubTree(TreePath treePath) {
        this.addToCheckedPathsSet(treePath);
        this.removeFromGreyedPathsSet(treePath);
        Object object = treePath.getLastPathComponent();
        int n = this.model.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            TreePath treePath2 = treePath.pathByAddingChild(this.model.getChild(object, i));
            this.checkSubTree(treePath2);
        }
    }

    public void uncheckSubTree(TreePath treePath) {
        this.removeFromCheckedPathsSet(treePath);
        this.removeFromGreyedPathsSet(treePath);
        Object object = treePath.getLastPathComponent();
        int n = this.model.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            TreePath treePath2 = treePath.pathByAddingChild(this.model.getChild(object, i));
            this.uncheckSubTree(treePath2);
        }
    }

    @Override
    public void toggleCheckingPath(TreePath treePath) {
        if (!this.isPathEnabled(treePath)) {
            return;
        }
        if (this.isPathChecked(treePath)) {
            this.removeCheckingPath(treePath);
        } else {
            this.addCheckingPath(treePath);
        }
    }

    @Override
    public void setCheckingPath(TreePath treePath) {
        this.clearChecking();
        this.addCheckingPath(treePath);
    }

    @Override
    public void setCheckingPaths(TreePath[] treePathArray) {
        this.clearChecking();
        for (TreePath treePath : treePathArray) {
            this.addCheckingPath(treePath);
        }
    }

    @Override
    public void clearChecking() {
        this.checkedPathsSet.clear();
        this.greyedPathsSet.clear();
        this.fireValueChanged(new TreeCheckingEvent(new TreePath(this.model.getRoot())));
    }

    @Override
    public TreePath[] getGreyingPaths() {
        return this.greyedPathsSet.toArray(new TreePath[this.greyedPathsSet.size()]);
    }

    @Override
    public TreePath[] getCheckingPaths() {
        return this.checkedPathsSet.toArray(new TreePath[this.checkedPathsSet.size()]);
    }

    @Override
    public TreePath[] getCheckingRoots() {
        Vector<TreePath> vector = this.getCheckingRoots(new TreePath(this.model.getRoot()));
        return vector.toArray(new TreePath[0]);
    }

    private Vector<TreePath> getCheckingRoots(TreePath treePath) {
        Object object = treePath.getLastPathComponent();
        Vector<TreePath> vector = new Vector<TreePath>();
        if (!this.isPathGreyed(treePath)) {
            if (this.isPathChecked(treePath)) {
                vector.add(treePath);
            }
            return vector;
        }
        int n = this.model.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            TreePath treePath2 = treePath.pathByAddingChild(this.model.getChild(object, i));
            vector.addAll(this.getCheckingRoots(treePath2));
        }
        return vector;
    }

    @Override
    public TreeCheckingModel.CheckingMode getCheckingMode() {
        if (this.checkingMode instanceof SimpleTreeCheckingMode) {
            return TreeCheckingModel.CheckingMode.SIMPLE;
        }
        if (this.checkingMode instanceof PropagateTreeCheckingMode) {
            return TreeCheckingModel.CheckingMode.PROPAGATE;
        }
        if (this.checkingMode instanceof PropagatePreservingCheckTreeCheckingMode) {
            return TreeCheckingModel.CheckingMode.PROPAGATE_PRESERVING_CHECK;
        }
        if (this.checkingMode instanceof PropagatePreservingUncheckTreeCheckingMode) {
            return TreeCheckingModel.CheckingMode.PROPAGATE_PRESERVING_UNCHECK;
        }
        if (this.checkingMode instanceof PropagateUpWhiteTreeCheckingMode) {
            return TreeCheckingModel.CheckingMode.PROPAGATE_UP_UNCHECK;
        }
        return null;
    }

    @Override
    public void setCheckingMode(TreeCheckingModel.CheckingMode checkingMode) {
        switch (checkingMode) {
            case SIMPLE: {
                this.checkingMode = new SimpleTreeCheckingMode(this);
                break;
            }
            case PROPAGATE: {
                this.checkingMode = new PropagateTreeCheckingMode(this);
                break;
            }
            case PROPAGATE_PRESERVING_CHECK: {
                this.checkingMode = new PropagatePreservingCheckTreeCheckingMode(this);
                break;
            }
            case PROPAGATE_PRESERVING_UNCHECK: {
                this.checkingMode = new PropagatePreservingUncheckTreeCheckingMode(this);
                break;
            }
            case PROPAGATE_UP_UNCHECK: {
                this.checkingMode = new PropagateUpWhiteTreeCheckingMode(this);
                break;
            }
        }
    }

    public void setCheckingMode(TreeCheckingMode treeCheckingMode) {
        this.checkingMode = treeCheckingMode;
    }

    @Override
    public void addCheckingPaths(TreePath[] treePathArray) {
        for (TreePath treePath : treePathArray) {
            this.addCheckingPath(treePath);
        }
    }

    @Override
    public void addCheckingPath(TreePath treePath) {
        this.checkingMode.checkPath(treePath);
        TreeCheckingEvent treeCheckingEvent = new TreeCheckingEvent(treePath);
        this.fireValueChanged(treeCheckingEvent);
    }

    @Override
    public void removeCheckingPath(TreePath treePath) {
        this.checkingMode.uncheckPath(treePath);
        TreeCheckingEvent treeCheckingEvent = new TreeCheckingEvent(treePath);
        this.fireValueChanged(treeCheckingEvent);
    }

    @Override
    public void removeCheckingPaths(TreePath[] treePathArray) {
        for (TreePath treePath : treePathArray) {
            this.removeCheckingPath(treePath);
        }
    }

    protected void fireValueChanged(TreeCheckingEvent treeCheckingEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeCheckingListener.class) continue;
            ((TreeCheckingListener)objectArray[i + 1]).valueChanged(treeCheckingEvent);
        }
    }

    @Override
    public void addTreeCheckingListener(TreeCheckingListener treeCheckingListener) {
        this.listenerList.add(TreeCheckingListener.class, treeCheckingListener);
    }

    @Override
    public void removeTreeCheckingListener(TreeCheckingListener treeCheckingListener) {
        this.listenerList.remove(TreeCheckingListener.class, treeCheckingListener);
    }

    protected void updatePathGreyness(TreePath treePath) {
        boolean bl = this.isPathCheckBox(treePath);
        Object object = treePath.getLastPathComponent();
        if (!this.isPathCheckBox(treePath)) {
            this.addToCheckBoxPathsSet(treePath);
            return;
        }
    }

    public void updateSubTreeGreyness(TreePath treePath) {
    }

    public void updateTreeGreyness() {
        this.updateSubTreeGreyness(new TreePath(this.model.getRoot()));
    }

    public ChildrenChecking getChildrenChecking(TreePath treePath) {
        Object object = treePath.getLastPathComponent();
        int n = this.model.getChildCount(object);
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            TreePath treePath2 = treePath.pathByAddingChild(this.model.getChild(object, i));
            if (this.isPathGreyed(treePath2)) {
                return ChildrenChecking.HALF_CHECKED;
            }
            if (this.isPathChecked(treePath2)) {
                if (bl2) {
                    return ChildrenChecking.HALF_CHECKED;
                }
                bl = true;
                continue;
            }
            if (bl) {
                return ChildrenChecking.HALF_CHECKED;
            }
            bl2 = true;
        }
        if (bl) {
            return ChildrenChecking.ALL_CHECKED;
        }
        if (bl2) {
            return ChildrenChecking.ALL_UNCHECKED;
        }
        return ChildrenChecking.NO_CHILDREN;
    }

    public boolean pathHasUncheckedChildren(TreePath treePath) {
        Object object = treePath.getLastPathComponent();
        int n = this.model.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            TreePath treePath2 = treePath.pathByAddingChild(this.model.getChild(object, i));
            if (!(this.isPathGreyed(treePath2) | !this.isPathChecked(treePath2))) continue;
            return true;
        }
        return false;
    }

    public boolean pathHasCheckedChildren(TreePath treePath) {
        return this.pathHasChildrenWithValue(treePath, true);
    }

    protected boolean pathHasChildrenWithValue(TreePath treePath, boolean bl) {
        TreePath treePath2;
        int n;
        Object object = treePath.getLastPathComponent();
        int n2 = this.model.getChildCount(object);
        for (n = 0; n < n2; ++n) {
            treePath2 = treePath.pathByAddingChild(this.model.getChild(object, n));
            if (this.isPathChecked(treePath2) != bl) continue;
            return true;
        }
        for (n = 0; n < n2; ++n) {
            treePath2 = treePath.pathByAddingChild(this.model.getChild(object, n));
            if (!this.pathHasChildrenWithValue(treePath2, bl)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDifferentChildren(TreePath treePath) {
        return this.pathHasChildrenWithValue(treePath, !this.isPathChecked(treePath));
    }

    public void updateAncestorsGreyness(TreePath treePath) {
        TreePath[] treePathArray = new TreePath[treePath.getPathCount()];
        treePathArray[0] = treePath;
        boolean bl = this.isPathGreyed(treePath);
        for (int i = 1; i < treePathArray.length; ++i) {
            treePathArray[i] = treePathArray[i - 1].getParentPath();
            if (bl) {
                this.addToGreyedPathsSet(treePathArray[i]);
                continue;
            }
            this.updatePathGreyness(treePathArray[i]);
            bl = this.isPathGreyed(treePathArray[i]);
        }
    }

    protected TreePath[] getChildrenPath(TreePath treePath) {
        Object object = treePath.getLastPathComponent();
        int n = this.model.getChildCount(object);
        TreePath[] treePathArray = new TreePath[n];
        for (int i = 0; i < n; ++i) {
            treePathArray[i] = treePath.pathByAddingChild(this.model.getChild(object, i));
        }
        return treePathArray;
    }

    @Override
    public TreeModel getTreeModel() {
        return this.model;
    }

    @Override
    public void setTreeModel(TreeModel treeModel) {
        TreeModel treeModel2 = this.model;
        if (treeModel2 != null) {
            treeModel2.removeTreeModelListener(this.propagateCheckingListener);
        }
        this.model = treeModel;
        if (treeModel != null) {
            treeModel.addTreeModelListener(this.propagateCheckingListener);
        }
        this.clearChecking();
    }

    public String toString() {
        return this.toString(new TreePath(this.model.getRoot()));
    }

    private String toString(TreePath treePath) {
        String string = "n";
        String string2 = "n";
        String string3 = "n";
        if (this.isPathChecked(treePath)) {
            string = "y";
        }
        if (this.isPathEnabled(treePath)) {
            string3 = "y";
        }
        if (this.isPathGreyed(treePath)) {
            string2 = "y";
        }
        String string4 = "Path checked: " + string + " greyed: " + string2 + " enabled: " + string3 + " Name: " + treePath.toString() + "\n";
        for (TreePath treePath2 : this.getChildrenPath(treePath)) {
            string4 = string4 + this.toString(treePath2);
        }
        return string4;
    }

    public static enum ChildrenChecking {
        ALL_CHECKED,
        HALF_CHECKED,
        ALL_UNCHECKED,
        NO_CHILDREN;

    }

    private class PropagateCheckingListener
    implements TreeModelListener {
        private PropagateCheckingListener() {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            DefaultTreeCheckingModel.this.checkingMode.updateCheckAfterChildrenInserted(treePath);
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            DefaultTreeCheckingModel.this.checkingMode.updateCheckAfterChildrenRemoved(treePath);
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            DefaultTreeCheckingModel.this.updateSubTreeGreyness(treePath);
            DefaultTreeCheckingModel.this.updateAncestorsGreyness(treePath);
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            DefaultTreeCheckingModel.this.checkingMode.updateCheckAfterStructureChanged(treePath);
        }
    }
}

