/*
 * Decompiled with CFR 0.152.
 */
package it.cnr.imaa.essi.lablib.gui.checkboxtree;

import it.cnr.imaa.essi.lablib.gui.checkboxtree.CheckboxTree;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.CheckboxTreeCellRenderer;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.QuadristateButtonModel;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.QuadristateCheckbox;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class DefaultCheckboxTreeCellRenderer
extends JPanel
implements CheckboxTreeCellRenderer {
    protected QuadristateCheckbox checkBox = new QuadristateCheckbox();
    protected DefaultTreeCellRenderer label = new DefaultTreeCellRenderer();

    public DefaultCheckboxTreeCellRenderer() {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add(this.checkBox);
        this.add(this.label);
        this.checkBox.setBackground(UIManager.getColor("Tree.textBackground"));
        this.setBackground(UIManager.getColor("Tree.textBackground"));
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.checkBox.getPreferredSize();
        Dimension dimension2 = this.label.getPreferredSize();
        return new Dimension(dimension.width + dimension2.width, dimension.height < dimension2.height ? dimension2.height : dimension.height);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.label.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        if (jTree instanceof CheckboxTree) {
            TreeCheckingModel treeCheckingModel = ((CheckboxTree)jTree).getCheckingModel();
            TreePath treePath = jTree.getPathForRow(n);
            this.checkBox.setEnabled(treeCheckingModel.isPathEnabled(treePath));
            boolean bl5 = treeCheckingModel.isPathChecked(treePath);
            boolean bl6 = treeCheckingModel.isPathGreyed(treePath);
            if (bl5 && !bl6) {
                this.checkBox.setState(QuadristateButtonModel.State.CHECKED);
            }
            if (!bl5 && bl6) {
                this.checkBox.setState(QuadristateButtonModel.State.GREY_UNCHECKED);
            }
            if (bl5 && bl6) {
                this.checkBox.setState(QuadristateButtonModel.State.GREY_CHECKED);
            }
            if (!bl5 && !bl6) {
                this.checkBox.setState(QuadristateButtonModel.State.UNCHECKED);
            }
        }
        return this;
    }

    @Override
    public boolean isOnHotspot(int n, int n2) {
        return this.checkBox.getBounds().contains(n, n2);
    }

    protected static ImageIcon loadIcon(String string) {
        try {
            return new ImageIcon(DefaultCheckboxTreeCellRenderer.class.getClassLoader().getResource(string));
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @Override
    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public void setOpenIcon(Icon icon) {
        this.label.setOpenIcon(icon);
    }

    public void setClosedIcon(Icon icon) {
        this.label.setClosedIcon(icon);
    }

    public void setLeafIcon(Icon icon) {
        this.label.setLeafIcon(icon);
    }
}

