/*
 * Decompiled with CFR 0.152.
 */
package it.cnr.imaa.essi.lablib.gui.checkboxtree;

import it.cnr.imaa.essi.lablib.gui.checkboxtree.CheckboxTreeCellRenderer;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.DefaultCheckboxTreeCellRenderer;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.DefaultTreeCheckingModel;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingEvent;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingListener;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingModel;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CheckboxTree
extends JTree {
    private TreeCheckingModel checkingModel;

    public CheckboxTree() {
        super(CheckboxTree.getDefaultTreeModel());
        this.initialize();
    }

    public CheckboxTree(TreeNode treeNode) {
        super(treeNode);
        this.initialize();
    }

    public CheckboxTree(TreeModel treeModel) {
        super(treeModel);
        this.initialize();
    }

    private void initialize() {
        this.setCheckingModel(new DefaultTreeCheckingModel(this.treeModel));
        this.setCellRenderer(new DefaultCheckboxTreeCellRenderer());
        this.addMouseListener(new NodeCheckListener());
        this.selectionModel.setSelectionMode(4);
        this.setShowsRootHandles(true);
        this.putClientProperty("JTree.lineStyle", "Angled");
    }

    public void setCellRenderer(CheckboxTreeCellRenderer checkboxTreeCellRenderer) {
        super.setCellRenderer(checkboxTreeCellRenderer);
    }

    @Override
    @Deprecated
    public void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        super.setCellRenderer(treeCellRenderer);
    }

    @Override
    public void setModel(TreeModel treeModel) {
        super.setModel(treeModel);
        if (this.checkingModel != null) {
            this.checkingModel.setTreeModel(treeModel);
        }
    }

    public TreeCheckingModel getCheckingModel() {
        return this.checkingModel;
    }

    public void setCheckingModel(TreeCheckingModel treeCheckingModel) {
        TreeCheckingModel treeCheckingModel2 = this.checkingModel;
        if (treeCheckingModel2 != null) {
            treeCheckingModel2.setTreeModel(null);
        }
        this.checkingModel = treeCheckingModel;
        if (treeCheckingModel != null) {
            treeCheckingModel.setTreeModel(this.getModel());
            treeCheckingModel.addTreeCheckingListener(new TreeCheckingListener(){

                @Override
                public void valueChanged(TreeCheckingEvent treeCheckingEvent) {
                    CheckboxTree.this.repaint();
                }
            });
        }
    }

    public TreePath[] getCheckingPaths() {
        return this.getCheckingModel().getCheckingPaths();
    }

    public TreePath[] getCheckingRoots() {
        return this.getCheckingModel().getCheckingRoots();
    }

    public void clearChecking() {
        this.getCheckingModel().clearChecking();
    }

    public void addCheckingPaths(TreePath[] treePathArray) {
        this.getCheckingModel().addCheckingPaths(treePathArray);
    }

    public void addCheckingPath(TreePath treePath) {
        this.getCheckingModel().addCheckingPath(treePath);
    }

    public void setCheckingPath(TreePath treePath) {
        this.getCheckingModel().setCheckingPath(treePath);
    }

    public void setCheckingPaths(TreePath[] treePathArray) {
        this.getCheckingModel().setCheckingPaths(treePathArray);
    }

    public TreePath[] getGreyingPaths() {
        return this.getCheckingModel().getGreyingPaths();
    }

    public void addTreeCheckingListener(TreeCheckingListener treeCheckingListener) {
        this.checkingModel.addTreeCheckingListener(treeCheckingListener);
    }

    public void removeTreeCheckingListener(TreeCheckingListener treeCheckingListener) {
        this.checkingModel.removeTreeCheckingListener(treeCheckingListener);
    }

    public void expandAll() {
        this.expandSubTree(this.getPathForRow(0));
    }

    private void expandSubTree(TreePath treePath) {
        this.expandPath(treePath);
        Object object = treePath.getLastPathComponent();
        int n = this.getModel().getChildCount(object);
        TreePath[] treePathArray = new TreePath[n];
        for (int i = 0; i < n; ++i) {
            treePathArray[i] = treePath.pathByAddingChild(this.getModel().getChild(object, i));
            this.expandSubTree(treePathArray[i]);
        }
    }

    @Override
    public String toString() {
        String string = super.toString();
        TreeCheckingModel treeCheckingModel = this.getCheckingModel();
        if (treeCheckingModel != null) {
            return string + "\n" + treeCheckingModel.toString();
        }
        return string;
    }

    private class NodeCheckListener
    extends MouseAdapter {
        private NodeCheckListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            int n3 = CheckboxTree.this.getRowForLocation(n2, n = mouseEvent.getY());
            if (n3 == -1) {
                return;
            }
            Rectangle rectangle = CheckboxTree.this.getRowBounds(n3);
            if (rectangle == null) {
                return;
            }
            if (((CheckboxTreeCellRenderer)CheckboxTree.this.getCellRenderer()).isOnHotspot(n2 - rectangle.x, n - rectangle.y)) {
                CheckboxTree.this.getCheckingModel().toggleCheckingPath(CheckboxTree.this.getPathForRow(n3));
            }
        }
    }
}

