/*
 * Decompiled with CFR 0.152.
 */
package it.adempiere.maintenance.process;

import com.f3p.adempiere.util.ModelFactory;
import com.f3p.adempiere.util.QueryRepo;
import com.f3p.commons.Utils;
import it.adempiere.maintenance.model.MCOrderMntPaySched;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.MRequest;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class InvoiceGenerate
extends SvrProcess {
    public static final String QUERY_BASE_NAME = "it/adempiere/maintenance/process/";
    protected Timestamp m_tsInvoiceDate = null;
    protected boolean m_bConsolidateDocument = false;
    protected int m_iC_BPartner_ID = 0;
    protected int m_iC_Order_ID = 0;

    @Override
    protected String doIt() throws Exception {
        String sMntLinesSQL = QueryRepo.getQuery("it/adempiere/maintenance/process/get_mntschedule_lines", this.getClass().getClassLoader());
        CPreparedStatement pstmtMntLines = DB.prepareStatement(sMntLinesSQL, this.get_TrxName());
        ResultSet rsMntLines = null;
        try {
            pstmtMntLines.setInt(1, Env.getAD_Org_ID(this.getCtx()));
            pstmtMntLines.setTimestamp(2, this.m_tsInvoiceDate);
            pstmtMntLines.setInt(3, this.m_iC_Order_ID);
            pstmtMntLines.setInt(4, this.m_iC_Order_ID);
            pstmtMntLines.setInt(5, this.m_iC_BPartner_ID);
            pstmtMntLines.setInt(6, this.m_iC_BPartner_ID);
            rsMntLines = pstmtMntLines.executeQuery();
            int iLastCOrderID = -1;
            MInvoice mCurrentInvoice = null;
            while (rsMntLines.next()) {
                int C_Order_ID = rsMntLines.getInt("C_Order_ID");
                Timestamp tsPaymentDate = rsMntLines.getTimestamp("PAYMENTDATE");
                if (C_Order_ID != iLastCOrderID) {
                    MOrder mOrder = ModelFactory.getOrder(this.getCtx(), C_Order_ID, this.get_TrxName());
                    mCurrentInvoice = new MInvoice(mOrder, -1, this.m_tsInvoiceDate);
                    mCurrentInvoice.setDateInvoiced(this.m_tsInvoiceDate);
                    mCurrentInvoice.saveEx();
                    this.addLog(mCurrentInvoice.getC_Invoice_ID(), mCurrentInvoice.getDateInvoiced(), null, mCurrentInvoice.getDocumentNo());
                    iLastCOrderID = C_Order_ID;
                }
                String sDescription = rsMntLines.getString("Description");
                int M_Product_ID = rsMntLines.getInt("M_Product_ID");
                int C_Charge_ID = rsMntLines.getInt("C_Charge_ID");
                int C_OrderMntPaySched_ID = rsMntLines.getInt("C_OrderMntPaySched_ID");
                BigDecimal bdAmount = rsMntLines.getBigDecimal("Amount");
                MInvoiceLine mInvoiceLine = new MInvoiceLine(mCurrentInvoice);
                int iNumSched = DB.getSQLValue(this.get_TrxName(), "select count('OK') from C_ORDERMNTPAYSCHED where c_order_id = ?", C_Order_ID);
                if (iNumSched > 1) {
                    String sDesc = Msg.getMsg(this.getCtx(), "itmnt.mntInvoiceDescription", new Object[]{tsPaymentDate});
                    sDescription = Utils.isEmptyString(sDescription) ? sDesc : String.valueOf(sDescription) + " " + sDesc;
                }
                mInvoiceLine.setDescription(sDescription);
                if (M_Product_ID > 0) {
                    mInvoiceLine.setM_Product_ID(M_Product_ID);
                }
                if (C_Charge_ID > 0) {
                    mInvoiceLine.setC_Charge_ID(C_Charge_ID);
                }
                mInvoiceLine.setPrice(bdAmount);
                mInvoiceLine.setQty(BigDecimal.ONE);
                mInvoiceLine.saveEx();
                MCOrderMntPaySched mPaySched = MCOrderMntPaySched.get(this.getCtx(), C_OrderMntPaySched_ID, this.get_TrxName());
                mPaySched.setC_InvoiceLine_ID(mInvoiceLine.getC_InvoiceLine_ID());
                mPaySched.saveEx();
            }
        }
        catch (Throwable throwable) {
            DB.close(rsMntLines, pstmtMntLines);
            throw throwable;
        }
        DB.close(rsMntLines, pstmtMntLines);
        String sSql = QueryRepo.getQuery("it/adempiere/maintenance/process/get_invoicable_projects", this.getClass().getClassLoader());
        CPreparedStatement pstmtReqOrderPrj = DB.prepareStatement(sSql, this.get_TrxName());
        ResultSet rsReqOrderPrj = null;
        HashMap<String, MInvoice> mapInvoiceBreak = null;
        if (this.m_bConsolidateDocument) {
            mapInvoiceBreak = new HashMap<String, MInvoice>();
        }
        try {
            pstmtReqOrderPrj.setInt(1, Env.getAD_Org_ID(this.getCtx()));
            pstmtReqOrderPrj.setTimestamp(2, this.m_tsInvoiceDate);
            pstmtReqOrderPrj.setInt(3, this.m_iC_Order_ID);
            pstmtReqOrderPrj.setInt(4, this.m_iC_Order_ID);
            pstmtReqOrderPrj.setInt(5, this.m_iC_BPartner_ID);
            pstmtReqOrderPrj.setInt(6, this.m_iC_BPartner_ID);
            rsReqOrderPrj = pstmtReqOrderPrj.executeQuery();
            int iLastRequest_ID = -1;
            while (rsReqOrderPrj.next()) {
                MOrder mOrder = ModelFactory.getOrder(this.getCtx(), rsReqOrderPrj.getInt("C_Order_ID"), this.get_TrxName());
                MProject mProject = ModelFactory.getProject(this.getCtx(), rsReqOrderPrj.getInt("C_Project_ID"), this.get_TrxName());
                MRequest mRequest = ModelFactory.getRequest(this.getCtx(), rsReqOrderPrj.getInt("R_Request_ID"), this.get_TrxName());
                MInvoice mInvoice = this.getInvoice(mProject, mOrder, mRequest);
                if (mapInvoiceBreak != null) {
                    String sKey = this.getConsolidationKey(mInvoice);
                    if (mapInvoiceBreak.containsKey(sKey)) {
                        mInvoice = (MInvoice)mapInvoiceBreak.get(sKey);
                    } else {
                        mInvoice.setDateInvoiced(this.m_tsInvoiceDate);
                        mInvoice.saveEx();
                        this.addLog(mInvoice.getC_Invoice_ID(), mInvoice.getDateInvoiced(), null, mInvoice.getDocumentNo());
                        mapInvoiceBreak.put(sKey, mInvoice);
                    }
                } else {
                    mInvoice.setDateInvoiced(this.m_tsInvoiceDate);
                    mInvoice.saveEx();
                    this.addLog(mInvoice.getC_Invoice_ID(), mInvoice.getDateInvoiced(), null, mInvoice.getDocumentNo());
                }
                if (mRequest.getR_Request_ID() != iLastRequest_ID) {
                    MInvoiceLine mDescLine = new MInvoiceLine(mInvoice);
                    mDescLine.setIsDescription(true);
                    mDescLine.setDescription(Msg.getMsg(this.getCtx(), "itmnt.mntInvoiceLineDescriptionAppointment", new Object[]{mRequest.getDocumentNo(), mRequest.getStartDate()}));
                    mDescLine.saveEx();
                    if (mOrder.getC_BPartner_ID() == mProject.getC_BPartner_ID()) {
                        mDescLine = new MInvoiceLine(mInvoice);
                        mDescLine.setIsDescription(true);
                        mDescLine.setDescription(Msg.getMsg(this.getCtx(), "itmnt.mntInvoiceLineDescriptionOrder", new Object[]{mOrder.getDocumentNo(), mOrder.getDateOrdered()}));
                        mDescLine.saveEx();
                    }
                    iLastRequest_ID = mRequest.getR_Request_ID();
                    mRequest.setC_Invoice_ID(mInvoice.getC_Invoice_ID());
                    mRequest.saveEx();
                }
                List lstProjectLines = new Query(Env.getCtx(), "C_ProjectLine", "C_Project_ID= ?", this.get_TrxName()).setParameters(mProject.getC_Project_ID()).setOnlyActiveRecords(true).list();
                for (MProjectLine mProjectLine : lstProjectLines) {
                    MInvoiceLine mInvoiceLine = new MInvoiceLine(mInvoice);
                    mInvoiceLine.setC_Project_ID(mProject.getC_Project_ID());
                    mInvoiceLine.setQty(mProjectLine.getCommittedQty());
                    mInvoiceLine.setQtyInvoiced(mProjectLine.getCommittedQty());
                    mInvoiceLine.setPrice(mProjectLine.getPlannedPrice());
                    mInvoiceLine.setDescription(mProjectLine.getDescription());
                    mInvoiceLine.setM_Product_ID(mProjectLine.getM_Product_ID());
                    mInvoiceLine.saveEx();
                    mProjectLine.setInvoicedQty(mProjectLine.getCommittedQty());
                    mProjectLine.saveEx();
                }
            }
        }
        catch (Throwable throwable) {
            DB.close(rsReqOrderPrj, pstmtReqOrderPrj);
            throw throwable;
        }
        DB.close(rsReqOrderPrj, pstmtReqOrderPrj);
        return "@Ok@";
    }

    public MInvoice getInvoice(MProject mProject, MOrder mOrder, MRequest mRequest) {
        MInvoice mInvoice = new MInvoice(this.getCtx(), 0, this.get_TrxName());
        if (mOrder.getC_BPartner_ID() == mProject.getC_BPartner_ID()) {
            mInvoice.setC_BPartner_ID(mOrder.getBill_BPartner_ID());
            mInvoice.setC_BPartner_Location_ID(mOrder.getBill_Location_ID());
            mInvoice.setSalesRep_ID(mOrder.getSalesRep_ID());
        } else {
            MBPartnerLocation mLocation = ModelFactory.getPartnerLocation(this.getCtx(), mProject.getC_BPartner_Location_ID(), this.get_TrxName());
            mInvoice.setC_BPartner_ID(mProject.getC_BPartner_ID());
            mInvoice.setSalesRep_ID(mRequest.getSalesRep_ID());
            if (!mLocation.isBillTo()) {
                MBPartnerLocation[] mLocations;
                MBPartner mBP = MBPartner.get(this.getCtx(), mProject.getC_BPartner_ID());
                MBPartnerLocation[] mBPartnerLocationArray = mLocations = mBP.getLocations(true);
                int n = mLocations.length;
                int n2 = 0;
                while (n2 < n) {
                    MBPartnerLocation mLoc = mBPartnerLocationArray[n2];
                    if (mLoc.isBillTo()) {
                        mLocation = mLoc;
                        break;
                    }
                    ++n2;
                }
                mInvoice.setC_BPartner_Location_ID(mLocation.getC_BPartner_Location_ID());
            }
        }
        mInvoice.setIsSOTrx(true);
        mInvoice.setC_Currency_ID(mProject.getC_Currency_ID());
        mInvoice.setM_PriceList_ID(mProject.getM_PriceList_ID());
        mInvoice.setAD_User_ID(mProject.getAD_User_ID());
        mInvoice.setC_Project_ID(mProject.get_ID());
        mInvoice.setC_Campaign_ID(mProject.getC_Campaign_ID());
        mInvoice.setDescription(mProject.getDescription());
        mInvoice.setC_PaymentTerm_ID(mOrder.getC_PaymentTerm_ID());
        mInvoice.setPaymentRule(mOrder.getPaymentRule());
        mInvoice.setSalesRep_ID(mProject.getSalesRep_ID());
        mInvoice.setC_Order_ID(mOrder.getC_Order_ID());
        return mInvoice;
    }

    public String getConsolidationKey(MInvoice mInv) {
        StringBuilder sbKey = new StringBuilder();
        sbKey.append(mInv.getC_BPartner_ID()).append('|').append(mInv.getC_BPartner_Location_ID()).append('|').append(mInv.getC_Currency_ID()).append('|').append(mInv.getM_PriceList_ID()).append('|').append(mInv.getAD_User_ID()).append('|').append(mInv.getC_PaymentTerm_ID()).append('|').append(mInv.getPaymentRule());
        return sbKey.toString();
    }

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DateInvoiced")) {
                    this.m_tsInvoiceDate = (Timestamp)para[i].getParameter();
                } else if (name.equals("C_BPartner_ID")) {
                    this.m_iC_BPartner_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_Order_ID")) {
                    this.m_iC_Order_ID = para[i].getParameterAsInt();
                } else if (name.equals("ConsolidateDocument")) {
                    this.m_bConsolidateDocument = "Y".equals(para[i].getParameter());
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        if (this.m_tsInvoiceDate == null) {
            this.m_tsInvoiceDate = Env.getContextAsDate(this.getCtx(), "#Date");
        }
        if (this.m_tsInvoiceDate == null) {
            this.m_tsInvoiceDate = new Timestamp(System.currentTimeMillis());
        }
    }
}

