/*
 * Decompiled with CFR 0.152.
 */
package it.adempiere.maintenance.process;

import com.f3p.commons.Utils;
import it.adempiere.maintenance.model.MNTIAsset;
import it.adempiere.maintenance.model.X_A_AssetMntData;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.compiere.model.MAsset;
import org.compiere.model.Query;
import org.compiere.model.X_I_Asset;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class ImportAsset
extends SvrProcess {
    private int m_AD_Client_ID = 0;
    private int m_AD_Org_ID = 0;
    private Timestamp m_DateValue = null;
    protected static final String AD_ERROR_TRANSCODE_MESSAGE = "ITMNT_Error_Transcode";
    protected static final String AD_ERROR_INVALID_BPARTNER = "ITMNT_Error_Invalid_BPartner";
    protected static final String AD_ERROR_INVALID_MNT_DATA = "ITMNT_Error_Maintenance_Data";

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("AD_Client_ID")) {
                this.m_AD_Client_ID = para[i].getParameterAsInt();
            } else {
                this.log.info("ImportAsset.prepare - Unknown Parameter: " + name);
            }
            ++i;
        }
        this.m_DateValue = new Timestamp(System.currentTimeMillis());
    }

    @Override
    protected String doIt() throws Exception {
        StringBuffer sql = null;
        int no = 0;
        String clientCheck = " AND AD_Client_ID=" + this.m_AD_Client_ID;
        sql = new StringBuffer("UPDATE I_Asset SET AD_Client_ID = COALESCE (AD_Client_ID, ").append(this.m_AD_Client_ID).append("), AD_Org_ID = COALESCE (AD_Org_ID, 0), IsActive = COALESCE (IsActive, 'Y'), CreatedBy = COALESCE (CreatedBy, 0), UpdatedBy = COALESCE (UpdatedBy, 0), I_ErrorMsg = NULL, I_IsImported = 'N' WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        int noInsert = 0;
        int noUpdate = 0;
        sql = new StringBuffer("SELECT I_Asset_ID, A_Asset_ID FROM I_Asset WHERE I_IsImported='N'").append(clientCheck).append(" Order By I_Asset_ID");
        try {
            StringBuffer sqlA = new StringBuffer("INSERT INTO A_Asset (A_Asset_ID,AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,Value,Name,Description,Help,A_Asset_Group_ID,M_Product_ID,SerNo,LOT,VersionNo,GuaranteeDate,AssetServiceDate,IsOwned,AssetDepreciationDate, UseLifeYears, UseLifeMonths,LifeUseUnits, UseUnits, Isdisposed, AssetDisposalDate, IsInPosession,LocationComment, M_Locator_ID, C_BPartner_ID, C_BPartner_Location_ID,C_Location_ID, IsDepreciated, IsFullyDepreciated, AD_User_ID,M_AttributeSetInstance_ID, A_Parent_Asset_ID, A_QTY_Original,A_QTY_Current,A_Asset_Type_ID, LastMaintenanceDate, LastMaintenanceNote, NextMaintenanceDate,M_Product_Category_ID, SKU, Model) SELECT ?,AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,Value,Name,Description,Help,A_Asset_Group_ID,M_Product_ID,SerNo,LOT,VersionNo,GuaranteeDate,AssetServiceDate,COALESCE(IsOwned,'N'),AssetDepreciationDate, UseLifeYears, UseLifeMonths,LifeUseUnits, UseUnits, COALESCE(Isdisposed,'N'), AssetDisposalDate, COALESCE(IsInPosession,'N'),LocationComment, M_Locator_ID, C_BPartner_ID, C_BPartner_Location_ID,C_Location_ID, COALESCE(IsDepreciated,'N'), COALESCE(IsFullyDepreciated,'N'), AD_User_ID,M_AttributeSetInstance_ID, CASE WHEN A_Parent_Asset_ID IS NULL OR A_Parent_Asset_ID = 0 THEN ? ELSE A_Parent_Asset_ID END, A_QTY_Original,A_QTY_Current,A_Asset_Type_ID, LastMaintenanceDate, LastMaintenanceNote, NextMaintenanceDate, M_Product_Category_ID, SKU, Model FROM I_Asset WHERE I_Asset_ID=?");
            CPreparedStatement pstmt_insertProduct = DB.prepareStatement(sqlA.toString(), 1004, 1008, this.get_TrxName());
            StringBuffer sqlB = new StringBuffer("UPDATE A_Asset SET (A_Asset_ID,AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,Value,Name,Description,Help,A_Asset_Group_ID,M_Product_ID,SerNo,LOT,VersionNo,GuaranteeDate,AssetServiceDate,IsOwned,AssetDepreciationDate, UseLifeYears, UseLifeMonths,LifeUseUnits, UseUnits, Isdisposed, AssetDisposalDate, IsInPosession,LocationComment, M_Locator_ID, C_BPartner_ID, C_BPartner_Location_ID,C_Location_ID, IsDepreciated, IsFullyDepreciated, AD_User_ID,M_AttributeSetInstance_ID, A_Parent_Asset_ID, A_QTY_Original,A_QTY_Current,A_Asset_Type_ID, LastMaintenanceDate, LastMaintenanceNote, NextMaintenanceDate, M_Product_Category_ID, SKU, Model) = (SELECT A_Asset_ID,AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,Value,Name,Description,Help,A_Asset_Group_ID,M_Product_ID,SerNo,LOT,VersionNo,GuaranteeDate,AssetServiceDate,COALESCE(IsOwned,'N'),AssetDepreciationDate, UseLifeYears, UseLifeMonths,LifeUseUnits, UseUnits, COALESCE(Isdisposed,'N'), AssetDisposalDate, COALESCE(IsInPosession,'N'),LocationComment, M_Locator_ID, C_BPartner_ID, C_BPartner_Location_ID,C_Location_ID, COALESCE(IsDepreciated,'N'), COALESCE(IsFullyDepreciated,'N'), AD_User_ID,M_AttributeSetInstance_ID, A_Parent_Asset_ID, A_QTY_Original,A_QTY_Current,CASE WHEN A_Parent_Asset_ID IS NULL OR A_Parent_Asset_ID = 0 THEN A_Asset_ID ELSE A_Parent_Asset_ID END, LastMaintenanceDate, LastMaintenanceNote, NextMaintenanceDate, M_Product_Category_ID, SKU, Model FROM I_Asset WHERE I_Asset_ID=?) WHERE A_Asset_ID=?");
            CPreparedStatement pstmt_updateProduct = DB.prepareStatement(sqlB.toString(), 1005, 1008, null);
            StringBuffer sqlC = new StringBuffer("INSERT INTO A_Asset_Acct (A_ASSET_ID, C_ACCTSCHEMA_ID, AD_CLIENT_ID,AD_ORG_ID,ISACTIVE, CREATED, CREATEDBY, UPDATED ,UPDATEDBY,A_DEPRECIATION_ID, A_DEPRECIATION_ACCT, A_ACCUMDEPRECIATION_ACCT,A_DISPOSAL_LOSS, A_DISPOSAL_REVENUE, A_ASSET_ACCT,A_ASSET_SPREAD_ID,A_DEPRECIATION_METHOD_ID,A_PERIOD_START,A_PERIOD_END, A_DEPRECIATION_CONV_ID,A_SALVAGE_VALUE, POSTINGTYPE, A_SPLIT_PERCENT, A_DEPRECIATION_MANUAL_AMOUNT, A_DEPRECIATION_MANUAL_PERIOD, A_DEPRECIATION_VARIABLE_PERC, A_ASSET_ACCT_ID) SELECT ?,C_ACCTSCHEMA_ID,AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,DEPRECIATIONTYPE, A_DEPRECIATION_ACCT, A_ACCUMDEPRECIATION_ACCT,A_DISPOSAL_LOSS, A_DISPOSAL_REVENUE, A_ASSET_ACCT,A_ASSET_SPREAD_TYPE,A_DEPRECIATION_CALC_TYPE,A_PERIOD_START,A_PERIOD_END, CONVENTIONTYPE,A_SALVAGE_VALUE, POSTINGTYPE, A_SPLIT_PERCENT, A_DEPRECIATION_MANUAL_AMOUNT,A_DEPRECIATION_MANUAL_PERIOD, A_DEPRECIATION_VARIABLE_PERC, ? FROM I_Asset WHERE I_Asset_ID=? AND IsDepreciated = 'Y'");
            CPreparedStatement pstmt_insertAssetAcct = DB.prepareStatement(sqlC.toString(), 1004, 1008, this.get_TrxName());
            StringBuffer sqlD = new StringBuffer("INSERT INTO A_DEPRECIATION_WORKFILE (A_DEPRECIATION_WORKFILE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE,CREATED, CREATEDBY, UPDATED, UPDATEDBY, A_ASSET_ID, A_ASSET_COST,A_ACCUMULATED_DEPR, A_CALC_ACCUMULATED_DEPR, A_LIFE_PERIOD,A_PERIOD_POSTED, A_CURRENT_PERIOD, A_PRIOR_YEAR_ACCUMULATED_DEPR,A_BASE_AMOUNT, A_SALVAGE_VALUE, A_CURR_DEP_EXP, A_ASSET_LIFE_YEARS,A_ASSET_LIFE_CURRENT_YEAR, ISDEPRECIATED, POSTINGTYPE, A_QTY_CURRENT)SELECT ?, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE,CREATED, CREATEDBY, UPDATED, UPDATEDBY, ?, A_ASSET_COST,A_ACCUMULATED_DEPR, A_CALC_ACCUMULATED_DEPR, A_LIFE_PERIOD,A_PERIOD_POSTED, A_CURRENT_PERIOD, A_PRIOR_YEAR_ACCUMULATED_DEPR,A_BASE_AMOUNT, A_SALVAGE_VALUE, A_CURR_DEP_EXP, A_ASSET_LIFE_YEARS,A_ASSET_LIFE_CURRENT_YEAR, ISDEPRECIATED, POSTINGTYPE, A_QTY_CURRENT FROM I_Asset WHERE I_Asset_ID=? AND IsDepreciated = 'Y'");
            CPreparedStatement pstmt_insertAssetBal = DB.prepareStatement(sqlD.toString(), 1004, 1008, this.get_TrxName());
            StringBuffer sqlE = new StringBuffer("INSERT INTO A_Asset_Addition ( A_ASSET_ADDITION_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY,  UPDATED, UPDATEDBY, A_ASSET_ID, ASSETVALUEAMT, DESCRIPTION,  M_INOUTLINE_ID,  POSTINGTYPE, A_QTY_CURRENT, A_SOURCETYPE, A_CAPVSEXP) SELECT  ?, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY,  UPDATED, UPDATEDBY, ?, A_ASSET_COST, 'Imported Asset', '1',  POSTINGTYPE, A_QTY_CURRENT, 'IMP', 'Cap' FROM I_Asset WHERE I_Asset_ID=? AND IsDepreciated = 'Y'");
            CPreparedStatement pstmt_insertAssetAdd = DB.prepareStatement(sqlE.toString(), 1004, 1008, this.get_TrxName());
            StringBuffer sqlF = new StringBuffer("INSERT INTO A_Asset_Change (A_ASSET_CHANGE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, A_ASSET_ID, CHANGETYPE,  USELIFEYEARS, USELIFEMONTHS, LIFEUSEUNITS, ASSETDEPRECIATIONDATE, A_ASSET_ADDITION_ID, SERNO,LOT, VERSIONNO, ASSETACCUMDEPRECIATIONAMT, TEXTDETAILS, ASSETSERVICEDATE, ASSETBOOKVALUEAMT, ASSETMARKETVALUEAMT, ASSETVALUEAMT, ASSETDISPOSALDATE, A_PARENT_ASSET_ID, C_BPARTNER_ID, C_BPARTNER_LOCATION_ID, C_LOCATION_ID, A_DEPRECIATION_ACCT, A_ACCUMDEPRECIATION_ACCT, A_DISPOSAL_LOSS, A_DISPOSAL_REVENUE, A_ASSET_ACCT, A_ASSET_SPREAD_TYPE, A_DEPRECIATION_CALC_TYPE, A_PERIOD_START, A_PERIOD_END, A_SALVAGE_VALUE, POSTINGTYPE, A_ASSET_ACCT_ID, CONVENTIONTYPE, A_SPLIT_PERCENT, DEPRECIATIONTYPE, A_QTY_CURRENT, ISDEPRECIATED, ISFULLYDEPRECIATED, ISINPOSESSION, ISDISPOSED, ISOWNED) SELECT ?, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ?, 'IMP',  USELIFEYEARS, USELIFEMONTHS, LIFEUSEUNITS, ASSETDEPRECIATIONDATE, ?, SERNO, LOT, VERSIONNO, A_ACCUMULATED_DEPR, 'Imported Fixed Asset', ASSETSERVICEDATE, A_BASE_AMOUNT, ASSETMARKETVALUEAMT, A_ASSET_COST, ASSETDISPOSALDATE, A_PARENT_ASSET_ID, C_BPARTNER_ID, C_BPARTNER_LOCATION_ID, C_LOCATION_ID, A_DEPRECIATION_ACCT, A_ACCUMDEPRECIATION_ACCT, A_DISPOSAL_LOSS, A_DISPOSAL_REVENUE, A_ASSET_ACCT, A_ASSET_SPREAD_TYPE, A_DEPRECIATION_CALC_TYPE, A_PERIOD_START, A_PERIOD_END, A_SALVAGE_VALUE, POSTINGTYPE, ?, CONVENTIONTYPE, A_SPLIT_PERCENT, DEPRECIATIONTYPE, A_QTY_CURRENT, ISDEPRECIATED, ISFULLYDEPRECIATED, ISINPOSESSION, ISDISPOSED, ISOWNED FROM I_Asset WHERE I_Asset_ID=? AND IsDepreciated = 'Y'");
            CPreparedStatement pstmt_insertAssetChg = DB.prepareStatement(sqlF.toString(), 1004, 1008, this.get_TrxName());
            CPreparedStatement pstmt_setImported = DB.prepareStatement("UPDATE I_Asset SET I_IsImported='Y', Processed='Y' WHERE I_Asset_ID=?", 1004, 1008, this.get_TrxName());
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), 1004, 1008, this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            int x = 0;
            while (rs.next()) {
                int A_Asset_ID;
                X_I_Asset mIAsset;
                int I_Asset_ID;
                block16: {
                    ++x;
                    I_Asset_ID = rs.getInt(1);
                    boolean bError = false;
                    mIAsset = this.getIAsset(I_Asset_ID);
                    boolean bl = bError = !this.check(mIAsset);
                    if (bError) continue;
                    A_Asset_ID = rs.getInt(2);
                    if (A_Asset_ID <= 0) {
                        String sValue = mIAsset.getValue();
                        String sSerNo = mIAsset.getSerNo();
                        int iM_Product_ID = mIAsset.getM_Product_ID();
                        if (iM_Product_ID > 0 && sSerNo != null) {
                            A_Asset_ID = sValue != null ? this.getAssetID(sValue, iM_Product_ID, sSerNo) : this.getAssetID(iM_Product_ID, sSerNo);
                        }
                    }
                    int A_Asset_Acct_ID = 0;
                    int A_DEPRECIATION_WORKFILE_ID = 0;
                    int A_ASSET_ADDITION_ID = 0;
                    int A_ASSET_CHANGE_ID = 0;
                    boolean newAsset = true;
                    if (A_Asset_ID <= 0) {
                        A_Asset_ID = DB.getNextID(this.m_AD_Client_ID, "A_Asset", null);
                        A_Asset_Acct_ID = DB.getNextID(this.m_AD_Client_ID, "A_Asset_Acct", null);
                        A_DEPRECIATION_WORKFILE_ID = DB.getNextID(this.m_AD_Client_ID, "A_Depreciation_Workfile", null);
                        A_ASSET_ADDITION_ID = DB.getNextID(this.m_AD_Client_ID, "A_Asset_Addition", null);
                        A_ASSET_CHANGE_ID = DB.getNextID(this.m_AD_Client_ID, "A_Asset_Change", null);
                        newAsset = true;
                    } else {
                        int found = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(*) FROM A_ASSET WHERE A_ASSET_ID = " + A_Asset_ID + clientCheck);
                        if (found == 0) {
                            newAsset = true;
                            A_DEPRECIATION_WORKFILE_ID = DB.getNextID(this.m_AD_Client_ID, "A_Depreciation_Workfile", this.get_TrxName());
                            A_ASSET_ADDITION_ID = DB.getNextID(this.m_AD_Client_ID, "A_Asset_Addition", this.get_TrxName());
                            A_ASSET_CHANGE_ID = DB.getNextID(this.m_AD_Client_ID, "A_Asset_Change", this.get_TrxName());
                            A_Asset_Acct_ID = DB.getNextID(this.m_AD_Client_ID, "A_Asset_Acct", this.get_TrxName());
                        } else {
                            newAsset = false;
                        }
                    }
                    if (newAsset) {
                        pstmt_insertProduct.setInt(1, A_Asset_ID);
                        pstmt_insertProduct.setInt(2, A_Asset_ID);
                        pstmt_insertProduct.setInt(3, I_Asset_ID);
                        pstmt_insertAssetAcct.setInt(1, A_Asset_ID);
                        pstmt_insertAssetAcct.setInt(2, A_Asset_Acct_ID);
                        pstmt_insertAssetAcct.setInt(3, I_Asset_ID);
                        pstmt_insertAssetBal.setInt(1, A_DEPRECIATION_WORKFILE_ID);
                        pstmt_insertAssetBal.setInt(2, A_Asset_ID);
                        pstmt_insertAssetBal.setInt(3, I_Asset_ID);
                        pstmt_insertAssetAdd.setInt(1, A_ASSET_ADDITION_ID);
                        pstmt_insertAssetAdd.setInt(2, A_Asset_ID);
                        pstmt_insertAssetAdd.setInt(3, I_Asset_ID);
                        pstmt_insertAssetChg.setInt(1, A_ASSET_CHANGE_ID);
                        pstmt_insertAssetChg.setInt(2, A_Asset_ID);
                        pstmt_insertAssetChg.setInt(3, A_ASSET_ADDITION_ID);
                        pstmt_insertAssetChg.setInt(4, A_Asset_Acct_ID);
                        pstmt_insertAssetChg.setInt(5, I_Asset_ID);
                        try {
                            no = pstmt_insertProduct.executeUpdate();
                            no = pstmt_insertAssetAcct.executeUpdate();
                            no = pstmt_insertAssetBal.executeUpdate();
                            no = pstmt_insertAssetAdd.executeUpdate();
                            no = pstmt_insertAssetChg.executeUpdate();
                            ++noInsert;
                            break block16;
                        }
                        catch (SQLException ex) {
                            sql = new StringBuffer("UPDATE I_Asset SET I_IsImported='E', I_ErrorMsg=").append(DB.TO_STRING("Insert Asset: " + ex.toString())).append(" WHERE I_Asset_ID=").append(I_Asset_ID);
                            DB.executeUpdate(sql.toString(), this.get_TrxName());
                            continue;
                        }
                    }
                    pstmt_updateProduct.setInt(1, I_Asset_ID);
                    pstmt_updateProduct.setInt(2, A_Asset_ID);
                    try {
                        pstmt_updateProduct.executeUpdate();
                        ++noUpdate;
                    }
                    catch (SQLException ex) {
                        sql = new StringBuffer("UPDATE I_Asset SET I_IsImported='E', I_ErrorMsg=").append(DB.TO_STRING("Update Asset: " + ex.toString())).append(" WHERE I_Asset_ID=").append(I_Asset_ID);
                        continue;
                    }
                }
                pstmt_setImported.setInt(1, I_Asset_ID);
                no = pstmt_setImported.executeUpdate();
                this.updateAsset(mIAsset, A_Asset_ID);
            }
            rs.close();
            pstmt.close();
            pstmt_insertProduct.close();
            pstmt_updateProduct.close();
            pstmt_setImported.close();
        }
        catch (SQLException e) {
            throw new Exception("ImportAsset3.doIt", e);
        }
        sql = new StringBuffer("UPDATE I_Asset SET I_IsImported='N' WHERE I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noInsert), "@A_Asset_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noUpdate), "@A_Asset_ID@: @Updated@");
        return "";
    }

    protected boolean check(X_I_Asset mIAsset) {
        Timestamp nextServMNTDate;
        String sBPLocName;
        int iCBPartnerLocation;
        String sMsg;
        String sContactName;
        int iADUserID;
        String sMsg2;
        String sBPartnerValue;
        int iCBPartnerID;
        String sAssetGroupName;
        int iAssetGroupID;
        String sProductValue;
        int iMProductID;
        String sProductServiceValue;
        int iMProductServiceID;
        String sAssetTypeValue;
        boolean bError = false;
        boolean bSave = false;
        StringBuffer sbMsgError = new StringBuffer();
        int iA_Asset_Type_ID = MNTIAsset.getA_Asset_Type_ID(mIAsset);
        if (iA_Asset_Type_ID <= 0 && !Utils.isEmptyString(sAssetTypeValue = MNTIAsset.getAssetTypeValue(mIAsset))) {
            iA_Asset_Type_ID = this.getAssetTypeID(sAssetTypeValue);
            if (iA_Asset_Type_ID > 0) {
                MNTIAsset.setA_Asset_Type_ID(mIAsset, iA_Asset_Type_ID);
                bSave = true;
            } else {
                Object[] args = new Object[]{Msg.getElement(this.getCtx(), "A_Asset_Type_ID")};
                String sMsg3 = Msg.getMsg(this.getCtx(), AD_ERROR_TRANSCODE_MESSAGE, args);
                if (sbMsgError.length() != 0) {
                    sbMsgError.append("\n");
                }
                sbMsgError.append(sMsg3);
                bError = true;
            }
        }
        if ((iMProductServiceID = MNTIAsset.getM_ProductService_ID(mIAsset)) <= 0 && !Utils.isEmptyString(sProductServiceValue = MNTIAsset.getProductServiceValue(mIAsset))) {
            iMProductServiceID = this.getProductServiceID(sProductServiceValue);
            if (iMProductServiceID > 0) {
                MNTIAsset.setM_ProductService_ID(mIAsset, iMProductServiceID);
                bSave = true;
            } else {
                Object[] args = new Object[]{Msg.getElement(this.getCtx(), "M_ProductService_ID")};
                String sMsg4 = Msg.getMsg(this.getCtx(), AD_ERROR_TRANSCODE_MESSAGE, args);
                if (sbMsgError.length() != 0) {
                    sbMsgError.append("\n");
                }
                sbMsgError.append(sMsg4);
                bError = true;
            }
        }
        if ((iMProductID = mIAsset.getM_Product_ID()) <= 0 && !Utils.isEmptyString(sProductValue = MNTIAsset.getProductValue(mIAsset))) {
            iMProductID = this.getProductID(sProductValue);
            if (iMProductID > 0) {
                mIAsset.setM_Product_ID(iMProductID);
                bSave = true;
            } else {
                Object[] args = new Object[]{Msg.getElement(this.getCtx(), "M_Product_ID")};
                String sMsg5 = Msg.getMsg(this.getCtx(), AD_ERROR_TRANSCODE_MESSAGE, args);
                if (sbMsgError.length() != 0) {
                    sbMsgError.append("\n");
                }
                sbMsgError.append(sMsg5);
                bError = true;
            }
        }
        if ((iAssetGroupID = mIAsset.getA_Asset_Group_ID()) <= 0 && !Utils.isEmptyString(sAssetGroupName = MNTIAsset.getAssetGroupName(mIAsset))) {
            iAssetGroupID = this.getAssetGroupID(sAssetGroupName);
            if (iAssetGroupID > 0) {
                mIAsset.setA_Asset_Group_ID(iAssetGroupID);
                bSave = true;
            } else {
                Object[] args = new Object[]{Msg.getElement(this.getCtx(), "A_Asset_Group_ID")};
                String sMsg6 = Msg.getMsg(this.getCtx(), AD_ERROR_TRANSCODE_MESSAGE, args);
                if (sbMsgError.length() != 0) {
                    sbMsgError.append("\n");
                }
                sbMsgError.append(sMsg6);
                bError = true;
            }
        }
        if ((iCBPartnerID = mIAsset.getC_BPartner_ID()) <= 0 && !Utils.isEmptyString(sBPartnerValue = MNTIAsset.getBPartnerValue(mIAsset))) {
            iCBPartnerID = this.getBPartnerID(sBPartnerValue);
            if (iCBPartnerID > 0) {
                mIAsset.setC_BPartner_ID(iCBPartnerID);
                bSave = true;
            } else {
                Object[] args = new Object[]{Msg.getElement(this.getCtx(), "C_BPartner_ID")};
                sMsg2 = Msg.getMsg(this.getCtx(), AD_ERROR_TRANSCODE_MESSAGE, args);
                if (sbMsgError.length() != 0) {
                    sbMsgError.append("\n");
                }
                sbMsgError.append(sMsg2);
                bError = true;
            }
        }
        if ((iADUserID = mIAsset.getAD_User_ID()) <= 0 && !Utils.isEmptyString(sContactName = MNTIAsset.getContactName(mIAsset))) {
            if (iCBPartnerID > 0) {
                iADUserID = this.getUserID(sContactName, iCBPartnerID);
                if (iADUserID > 0) {
                    mIAsset.setAD_User_ID(iADUserID);
                    bSave = true;
                } else {
                    Object[] args = new Object[]{Msg.getElement(this.getCtx(), "AD_User_ID")};
                    sMsg = Msg.getMsg(this.getCtx(), AD_ERROR_TRANSCODE_MESSAGE, args);
                    if (sbMsgError.length() != 0) {
                        sbMsgError.append("\n");
                    }
                    sbMsgError.append(sMsg);
                    bError = true;
                }
            } else {
                sMsg2 = Msg.getMsg(this.getCtx(), AD_ERROR_INVALID_BPARTNER);
                if (sbMsgError.length() != 0) {
                    sbMsgError.append("\n");
                }
                sbMsgError.append(sMsg2);
                bError = true;
            }
        }
        if ((iCBPartnerLocation = mIAsset.getC_BPartner_Location_ID()) <= 0 && !Utils.isEmptyString(sBPLocName = MNTIAsset.getBPLocName(mIAsset))) {
            if (iCBPartnerID > 0) {
                iCBPartnerLocation = this.getBPartnerLocationID(sBPLocName, iCBPartnerID);
                if (iCBPartnerLocation > 0) {
                    mIAsset.setC_BPartner_Location_ID(iCBPartnerLocation);
                    bSave = true;
                } else {
                    Object[] args = new Object[]{Msg.getElement(this.getCtx(), "C_BPartner_Location_ID")};
                    String sMsg7 = Msg.getMsg(this.getCtx(), AD_ERROR_TRANSCODE_MESSAGE, args);
                    if (sbMsgError.length() != 0) {
                        sbMsgError.append("\n");
                    }
                    sbMsgError.append(sMsg7);
                    bError = true;
                }
            } else {
                sMsg = Msg.getMsg(this.getCtx(), AD_ERROR_INVALID_BPARTNER);
                if (sbMsgError.length() != 0) {
                    sbMsgError.append("\n");
                }
                sbMsgError.append(sMsg);
                bError = true;
            }
        }
        if (!((nextServMNTDate = MNTIAsset.getNextServMntDate(mIAsset)) != null && iMProductServiceID > 0 || nextServMNTDate == null && iMProductServiceID <= 0)) {
            sMsg = Msg.getMsg(this.getCtx(), AD_ERROR_INVALID_MNT_DATA);
            if (sbMsgError.length() != 0) {
                sbMsgError.append("\n");
            }
            sbMsgError.append(sMsg);
            bError = true;
        }
        if (bError) {
            mIAsset.setI_ErrorMsg(sbMsgError.toString());
            bSave = true;
        }
        if (bSave) {
            mIAsset.saveEx();
        }
        return !bError;
    }

    protected void updateAsset(X_I_Asset mIAsset, int A_Asset_ID) {
        Timestamp nextMntDate;
        String sLastMaintNote;
        Timestamp lastMntDate;
        boolean bSave = false;
        MAsset mAsset = this.getAsset(A_Asset_ID);
        int iAssetTypeID = MNTIAsset.getA_Asset_Type_ID(mIAsset);
        if (iAssetTypeID > 0) {
            mAsset.setA_Asset_Type_ID(iAssetTypeID);
            bSave = true;
        }
        if ((lastMntDate = MNTIAsset.getLastMaintenanceDate(mIAsset)) != null) {
            mAsset.setLastMaintenanceDate(lastMntDate);
            bSave = true;
        }
        if (!Utils.isEmptyString(sLastMaintNote = MNTIAsset.getLastMaintenanceNote(mIAsset))) {
            mAsset.setLastMaintenanceNote(sLastMaintNote);
            bSave = true;
        }
        if ((nextMntDate = MNTIAsset.getNextMaintenanceDate(mIAsset)) != null) {
            mAsset.setNextMaintenanceDate(nextMntDate);
            bSave = true;
        }
        if (bSave) {
            mAsset.saveEx();
        }
        int iMProductServiceID = MNTIAsset.getM_ProductService_ID(mIAsset);
        Timestamp lastServMntDate = MNTIAsset.getLastServMntDate(mIAsset);
        Timestamp nextServMntDate = MNTIAsset.getNextServMntDate(mIAsset);
        if (iMProductServiceID > 0 && nextServMntDate != null) {
            this.createAssetMntData(A_Asset_ID, iMProductServiceID, lastServMntDate, nextServMntDate);
        }
    }

    protected void createAssetMntData(int A_Asset_ID, int M_Product_ID, Timestamp lastServMntDate, Timestamp nextServMntDate) {
        X_A_AssetMntData mAssetMntData = new X_A_AssetMntData(this.getCtx(), 0, this.get_TrxName());
        mAssetMntData.setA_Asset_ID(A_Asset_ID);
        mAssetMntData.setM_Product_ID(M_Product_ID);
        mAssetMntData.setLastMaintenanceDate(lastServMntDate);
        mAssetMntData.setNextMaintenanceDate(nextServMntDate);
        mAssetMntData.saveEx();
    }

    protected X_I_Asset getIAsset(int I_Asset_ID) {
        Query q = new Query(this.getCtx(), "I_Asset", "I_Asset_ID = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(I_Asset_ID);
        return (X_I_Asset)q.first();
    }

    protected int getAssetID(String sValue, int M_Product_ID, String sSerialNo) {
        Query q = new Query(this.getCtx(), "A_Asset", "Value = ? AND M_Product_ID = ? AND SerNo = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(sValue, M_Product_ID, sSerialNo);
        return q.firstId();
    }

    protected int getAssetID(int M_Product_ID, String sSerialNo) {
        Query q = new Query(this.getCtx(), "A_Asset", "M_Product_ID = ? AND SerNo = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(M_Product_ID, sSerialNo);
        return q.firstId();
    }

    protected MAsset getAsset(int A_Asset_ID) {
        Query q = new Query(this.getCtx(), "A_Asset", "A_Asset_ID = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(A_Asset_ID);
        return (MAsset)q.first();
    }

    protected int getAssetTypeID(String sAssetTypeValue) {
        Query q = new Query(this.getCtx(), "A_Asset_Type", "Value = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(sAssetTypeValue);
        return q.firstId();
    }

    protected int getProductServiceID(String sProductServiceValue) {
        Query q = new Query(this.getCtx(), "M_Product", "Value = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(sProductServiceValue);
        return q.firstId();
    }

    protected int getProductID(String sProductValue) {
        Query q = new Query(this.getCtx(), "M_Product", "Value = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(sProductValue);
        return q.firstId();
    }

    protected int getAssetGroupID(String sAssetGroupName) {
        Query q = new Query(this.getCtx(), "A_Asset_Group", "Name = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(sAssetGroupName);
        return q.firstId();
    }

    protected int getBPartnerID(String sBPartnerValue) {
        Query q = new Query(this.getCtx(), "C_BPartner", "Value = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(sBPartnerValue);
        return q.firstId();
    }

    protected int getUserID(String sContactName, int C_BPartner_ID) {
        Query q = new Query(this.getCtx(), "AD_User", "Name = ? AND C_BPartner_ID = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(sContactName, C_BPartner_ID);
        return q.firstId();
    }

    protected int getBPartnerLocationID(String sBPLocName, int C_BPartner_ID) {
        Query q = new Query(this.getCtx(), "C_BPartner_Location", "Name = ? AND C_BPartner_ID = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(sBPLocName, C_BPartner_ID);
        return q.firstId();
    }
}

