/*
 * Decompiled with CFR 0.152.
 */
package it.adempiere.maintenance.process;

import it.adempiere.maintenance.model.MNTMOrder;
import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.model.MOrder;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CopyFromOrder
extends SvrProcess {
    private int p_C_Order_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_Order_ID")) {
                    this.p_C_Order_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        int To_C_Order_ID = this.getRecord_ID();
        this.log.info("From C_Order_ID=" + this.p_C_Order_ID + " to " + To_C_Order_ID);
        if (To_C_Order_ID == 0) {
            throw new IllegalArgumentException("Target C_Order_ID == 0");
        }
        if (this.p_C_Order_ID == 0) {
            throw new IllegalArgumentException("Source C_Order_ID == 0");
        }
        if (this.p_C_Order_ID == To_C_Order_ID) {
            throw new IllegalArgumentException(Msg.getMsg(Env.getCtx(), "itmnt.sameSourceAndDestOrder"));
        }
        MOrder from = new MOrder(this.getCtx(), this.p_C_Order_ID, this.get_TrxName());
        MOrder to = new MOrder(this.getCtx(), To_C_Order_ID, this.get_TrxName());
        String sToDocTypeTarget = to.getC_DocTypeTarget().getDocSubTypeSO();
        String sFromDocTypeTarget = from.getC_DocTypeTarget().getDocSubTypeSO();
        int no = 0;
        if (sToDocTypeTarget != null && sToDocTypeTarget.equals("MN") && sFromDocTypeTarget != null && sFromDocTypeTarget.equals("MN")) {
            no = MNTMOrder.copyLinesFrom(from, to, false, false);
            MNTMOrder.copyMaintenanceLinesFrom(this.getCtx(), from, to, this.get_TrxName());
        } else {
            no = to.copyLinesFrom(from, false, false);
        }
        return "@Copied@=" + no;
    }
}

