/*
 * Decompiled with CFR 0.152.
 */
package it.adempiere.maintenance.model;

import com.f3p.adempiere.model.AbstractBoostrappableValidator;
import com.f3p.adempiere.util.ModelFactory;
import com.f3p.adempiere.util.QueryRepo;
import com.f3p.adempiere.util.TimePeriodHelper;
import it.adempiere.maintenance.form.AppointmentResult;
import it.adempiere.maintenance.form.AssetItem;
import it.adempiere.maintenance.model.MNTMProduct;
import it.adempiere.maintenance.model.MNTMRequestType;
import it.adempiere.maintenance.model.MNTTimeExpenseLine;
import it.adempiere.maintenance.model.MRRequestResource;
import it.adempiere.maintenance.model.X_A_AssetMntData;
import it.adempiere.maintenance.model.X_M_ProductMntData;
import it.adempiere.maintenance.model.X_R_RequestAsset;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAsset;
import org.compiere.model.MClient;
import org.compiere.model.MProduct;
import org.compiere.model.MRequest;
import org.compiere.model.MRequestType;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTimeExpenseLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_R_Request;
import org.compiere.model.X_S_ResourceAssignment;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;

public class MaintenanceRequestValidator
extends AbstractBoostrappableValidator {
    public static final String QUERY_BASE_NAME = "it/adempiere/maintenance/model/";
    public static final String SYSC_DAYS_BEFORE = "ITMNT_MAINTENANCEDATE_RANGE_DAYS_BEFORE";
    public static final String SYSC_DAYS_AFTER = "ITMNT_MAINTENANCEDATE_RANGE_DAYS_AFTER";

    @Override
    public String docValidate(PO arg0, int arg1) {
        return null;
    }

    @Override
    public void initialize(ModelValidationEngine engine, MClient mClient) {
        engine.addModelChange("R_Request", this.getValidator());
        engine.addModelChange("R_RequestAsset", this.getValidator());
        engine.addModelChange("S_ResourceAssignment", this.getValidator());
    }

    @Override
    public String login(int arg0, int arg1, int arg2) {
        return null;
    }

    @Override
    public String modelChange(PO model, int nType) throws Exception {
        X_R_RequestAsset mRequestAsset;
        MRequest mRequest;
        MRequestType mRequestType;
        String sMainReqType;
        X_R_Request mRequest2;
        MRequestType mRequestType2;
        String sMainReqType2;
        if (model instanceof X_R_Request && (nType == 1 || nType == 2) && (sMainReqType2 = MNTMRequestType.getIsMaintRequest(mRequestType2 = ModelFactory.getRequestType((mRequest2 = (X_R_Request)model).getCtx(), mRequest2.getR_RequestType_ID(), model.get_TrxName()))) != null && sMainReqType2.equals("M")) {
            if (mRequest2.is_ValueChanged("A_Asset_ID") && mRequest2.getA_Asset_ID() > 0) {
                this.checkAndUpadteAssetMntData(mRequest2, mRequest2.getA_Asset_ID(), 0, null, null, true);
            }
            int R_Status_ID_Close = MNTMRequestType.getRequestCloseStatusID(mRequest2.getCtx(), mRequestType2.getR_RequestType_ID());
            if (mRequest2.is_ValueChanged("R_Status_ID") && mRequest2.getR_Status_ID() == R_Status_ID_Close) {
                List<AssetItem> lstRequestAsset = AppointmentResult.getAssets(mRequest2.getCtx(), mRequest2.getR_Request_ID(), mRequest2.get_TrxName());
                HashSet<Integer> setUpdatedAssetMntData = new HashSet<Integer>();
                HashSet<Integer> setUpdatedAsset = new HashSet<Integer>();
                if (lstRequestAsset != null && lstRequestAsset.size() > 0) {
                    for (AssetItem aItem : lstRequestAsset) {
                        this.checkAndUpadteAssetMntData(mRequest2, aItem.getA_Asset_ID(), aItem.getM_Product_ID(), setUpdatedAssetMntData, setUpdatedAsset, false);
                    }
                }
            }
        }
        if (model instanceof X_R_RequestAsset && (nType == 1 || nType == 2) && (sMainReqType = MNTMRequestType.getIsMaintRequest(mRequestType = ModelFactory.getRequestType((mRequest = ModelFactory.getRequest((mRequestAsset = (X_R_RequestAsset)model).getCtx(), mRequestAsset.getR_Request_ID(), mRequestAsset.get_TrxName())).getCtx(), mRequest.getR_RequestType_ID(), model.get_TrxName()))) != null && sMainReqType.equals("M")) {
            this.checkAndUpadteAssetMntData(mRequest, mRequestAsset.getA_Asset_ID(), mRequestAsset.getM_Product_ID(), null, null, true);
        }
        if (model instanceof X_S_ResourceAssignment && nType == 2 && (model.is_ValueChanged("AssignDateFrom") || model.is_ValueChanged("S_Resource_ID"))) {
            X_S_ResourceAssignment mAssignment = (X_S_ResourceAssignment)model;
            List<MRRequestResource> lstRR = MRRequestResource.getByResourceAssignment(model.getCtx(), mAssignment.getS_ResourceAssignment_ID(), model.get_TrxName());
            if (lstRR != null && lstRR.size() > 0) {
                Timestamp tsDate;
                if (mAssignment.is_ValueChanged("S_Resource_ID")) {
                    for (MRRequestResource mRRes : lstRR) {
                        tsDate = mAssignment.getAssignDateFrom();
                        if (model.is_ValueChanged("AssignDateFrom")) {
                            tsDate = (Timestamp)mAssignment.get_ValueOld("AssignDateFrom");
                        }
                        if (mRRes.isValidResourceAssignment(tsDate, mAssignment.get_ValueOldAsInt("S_Resource_ID"))) continue;
                        throw new AdempiereException("@itmnt.mntExistingTimeExpLine@");
                    }
                }
                if (model.is_ValueChanged("AssignDateFrom")) {
                    for (MRRequestResource mRRes : lstRR) {
                        if (mRRes.isValidDateAssignment(mAssignment)) continue;
                        throw new AdempiereException("@itmnt.mntExistingAppDate@");
                    }
                    String sSqlTELines = QueryRepo.getQuery("it/adempiere/maintenance/model/get_teline_fordatechange", this.getClass().getClassLoader());
                    Timestamp tsOldDate = (Timestamp)mAssignment.get_ValueOld("AssignDateFrom");
                    tsDate = TimeUtil.getDay(mAssignment.getAssignDateFrom());
                    for (MRRequestResource mRRes : lstRR) {
                        CPreparedStatement pstmt = DB.prepareStatement(sSqlTELines, model.get_TrxName());
                        ResultSet rs = null;
                        try {
                            pstmt = DB.prepareStatement(sSqlTELines, model.get_TrxName());
                            pstmt.setInt(1, mRRes.getR_Request_ID());
                            pstmt.setTimestamp(2, tsOldDate);
                            pstmt.setInt(3, mAssignment.getS_Resource_ID());
                            rs = pstmt.executeQuery();
                            while (rs.next()) {
                                int S_TimeExpenseLine_ID = rs.getInt("S_TimeExpenseLine_ID");
                                int AD_User_ID = rs.getInt("AD_User_ID");
                                int S_TimeExpense_ID = MNTTimeExpenseLine.getS_TimeExpense_ID(model.getCtx(), AD_User_ID, tsDate, model.get_TrxName());
                                MTimeExpenseLine mTEL = ModelFactory.getTimeExpenseLine(model.getCtx(), S_TimeExpenseLine_ID, model.get_TrxName());
                                mTEL.setDateExpense(tsDate);
                                mTEL.setS_TimeExpense_ID(S_TimeExpense_ID);
                                mTEL.saveEx();
                            }
                        }
                        catch (Throwable throwable) {
                            DB.close(rs, pstmt);
                            throw throwable;
                        }
                        DB.close(rs, pstmt);
                    }
                }
            }
        }
        return null;
    }

    public boolean checkAndUpadteAssetMntData(X_R_Request mRequest, int A_Asset_ID, int M_ProductService_ID, HashSet<Integer> setUpdatedAssetMntData, HashSet<Integer> setUpdatedAsset, boolean bJustCheck) {
        MAsset mAsset;
        MProduct mProduct;
        if (M_ProductService_ID > 0 && !MNTMProduct.isForcedMnt(mProduct = MProduct.get(mRequest.getCtx(), M_ProductService_ID))) {
            M_ProductService_ID = 0;
        }
        if (M_ProductService_ID > 0) {
            mAsset = ModelFactory.getAsset(mRequest.getCtx(), A_Asset_ID, mRequest.get_TrxName());
            Query qAssetMntData = new Query(mRequest.getCtx(), "A_AssetMntData", "A_Asset_ID = ? AND M_Product_ID = ?", mRequest.get_TrxName());
            qAssetMntData.setOnlyActiveRecords(true).setApplyAccessFilter(true);
            X_A_AssetMntData mAssetMntData = (X_A_AssetMntData)qAssetMntData.setParameters(A_Asset_ID, M_ProductService_ID).first();
            if (mAssetMntData == null) {
                throw new IllegalArgumentException("No " + Msg.translate(mRequest.getCtx(), "A_AssetMntData_ID"));
            }
            if (setUpdatedAssetMntData != null && setUpdatedAssetMntData.contains(mAssetMntData.getA_AssetMntData_ID())) {
                return false;
            }
            Query qProductMntData = new Query(mRequest.getCtx(), "M_ProductMntData", "M_Product_ID = ? and M_ProductService_ID = ?", mRequest.get_TrxName());
            qProductMntData.setOnlyActiveRecords(true).setApplyAccessFilter(true);
            X_M_ProductMntData mProductMntData = (X_M_ProductMntData)qProductMntData.setParameters(mAsset.getM_Product_ID(), M_ProductService_ID).first();
            if (mProductMntData == null) {
                throw new IllegalArgumentException("No " + Msg.translate(mRequest.getCtx(), "M_ProductMntData_ID"));
            }
            if (!bJustCheck) {
                int nPeriod = mProductMntData.getNPeriod();
                String sUomPeriod = mProductMntData.getUomPeriod();
                Timestamp tsMntDate = mRequest.getStartDate();
                if (tsMntDate == null) {
                    tsMntDate = new Timestamp(System.currentTimeMillis());
                }
                if (mAssetMntData.getNextMaintenanceDate() != null && MaintenanceRequestValidator.isMaintenanceDateInRange(tsMntDate, mAssetMntData.getNextMaintenanceDate(), mRequest.getAD_Client_ID(), mRequest.getAD_Org_ID())) {
                    tsMntDate = mAssetMntData.getNextMaintenanceDate();
                }
                Timestamp tsNextMntDate = TimePeriodHelper.getNextDate(sUomPeriod, nPeriod, tsMntDate, false);
                mAssetMntData.setLastMaintenanceDate(tsMntDate);
                mAssetMntData.setNextMaintenanceDate(tsNextMntDate);
                mAssetMntData.setR_Request_ID(mRequest.getR_Request_ID());
                mAssetMntData.saveEx();
                if (setUpdatedAssetMntData != null) {
                    setUpdatedAssetMntData.add(mAssetMntData.getA_AssetMntData_ID());
                }
            }
        } else {
            if (setUpdatedAsset != null && setUpdatedAsset.contains(A_Asset_ID)) {
                return false;
            }
            if (mRequest.getC_Order_ID() <= 0) {
                throw new IllegalArgumentException("No " + Msg.translate(mRequest.getCtx(), "C_Ordine_ID"));
            }
            mAsset = ModelFactory.getAsset(mRequest.getCtx(), A_Asset_ID, mRequest.get_TrxName());
            String sSql = QueryRepo.getQuery("it/adempiere/maintenance/model/get_orderline_for_asset", this.getClass().getClassLoader());
            CPreparedStatement pstmt = DB.prepareStatement(sSql, mRequest.get_TrxName());
            ResultSet rs = null;
            int nPeriod = -1;
            String sUomPeriod = null;
            try {
                try {
                    pstmt.setInt(1, M_ProductService_ID);
                    pstmt.setInt(2, M_ProductService_ID);
                    pstmt.setInt(3, A_Asset_ID);
                    pstmt.setInt(4, mRequest.getC_Order_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        nPeriod = rs.getInt("NPeriod");
                        sUomPeriod = rs.getString("UomPeriod");
                    }
                }
                catch (SQLException e) {
                    throw new AdempiereException(e);
                }
            }
            catch (Throwable tsMntDate) {
                DB.close(rs, pstmt);
                throw tsMntDate;
            }
            DB.close(rs, pstmt);
            if (sUomPeriod == null || nPeriod <= 0) {
                throw new AdempiereException("@Missing@ @NPeriod@/@UomPeriod@ @A_Asset_ID@: " + mAsset.getName());
            }
            if (!bJustCheck) {
                Timestamp tsMntDate = mRequest.getStartDate();
                if (tsMntDate == null) {
                    tsMntDate = new Timestamp(System.currentTimeMillis());
                }
                if (mAsset.getNextMaintenanceDate() != null && MaintenanceRequestValidator.isMaintenanceDateInRange(tsMntDate, mAsset.getNextMaintenanceDate(), mRequest.getAD_Client_ID(), mRequest.getAD_Org_ID())) {
                    tsMntDate = mAsset.getNextMaintenanceDate();
                }
                Timestamp tsNextMntDate = TimePeriodHelper.getNextDate(sUomPeriod, nPeriod, tsMntDate, false);
                mAsset.setLastMaintenanceDate(tsMntDate);
                mAsset.setNextMaintenanceDate(tsNextMntDate);
                mAsset.saveEx();
                if (setUpdatedAsset != null) {
                    setUpdatedAsset.add(A_Asset_ID);
                }
            }
        }
        return true;
    }

    public static boolean isMaintenanceDateInRange(Timestamp tsDate, Timestamp tsNextMaintDate, int AD_Client_ID, int AD_Org_ID) {
        int nDaysBefore = MSysConfig.getIntValue(SYSC_DAYS_BEFORE, 0, AD_Client_ID, AD_Org_ID);
        int nDaysAfter = MSysConfig.getIntValue(SYSC_DAYS_AFTER, 0, AD_Client_ID, AD_Org_ID);
        Timestamp tsLowLimit = TimeUtil.addDays(tsNextMaintDate, -nDaysBefore);
        Timestamp tsHighLimit = TimeUtil.addDays(tsNextMaintDate, nDaysAfter);
        return TimeUtil.inRange(tsLowLimit, tsHighLimit, tsDate, tsDate);
    }
}

