/*
 * Decompiled with CFR 0.152.
 */
package it.adempiere.maintenance.model;

import com.f3p.adempiere.model.AbstractBoostrappableValidator;
import com.f3p.adempiere.util.TimePeriodHelper;
import it.adempiere.maintenance.model.MNTMOrderLine;
import it.adempiere.maintenance.model.X_A_AssetMntData;
import it.adempiere.maintenance.model.X_C_OrderLineAsset;
import it.adempiere.maintenance.model.X_C_OrderMntPaySched;
import it.adempiere.maintenance.model.X_M_ProductMntData;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import org.compiere.model.I_C_Invoice;
import org.compiere.model.I_C_InvoiceLine;
import org.compiere.model.I_C_Order;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_A_Asset;
import org.compiere.model.X_C_Order;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;

public class MaintenanceOrderValidator
extends AbstractBoostrappableValidator {
    public static final String SQL_UNLINKPAYSCHED_INVLINE = "UPDATE C_OrderMntPaySched SET C_InvoiceLine_ID = NULL WHERE C_InvoiceLine_ID = ?";
    public static final String SQL_UNLINKPAYSCHED_INVOICE = "UPDATE C_OrderMntPaySched SET C_InvoiceLine_ID = NULL WHERE  EXISTS (SELECT 'ok' FROM C_InvoiceLine WHERE \t\t\tC_InvoiceLine.C_InvoiceLine_ID = C_OrderMntPaySched.C_InvoiceLine_ID and C_InvoiceLine.C_Invoice_ID = ?)";

    @Override
    public void initialize(ModelValidationEngine engine, MClient mClient) {
        engine.addModelChange("C_Order", this.getValidator());
        engine.addModelChange("C_OrderLineAsset", this.getValidator());
        engine.addModelChange("C_OrderMntPaySched", this.getValidator());
        engine.addModelChange("A_Asset", this.getValidator());
        engine.addModelChange("C_Invoice", this.getValidator());
        engine.addModelChange("C_InvoiceLine", this.getValidator());
        engine.addDocValidate("C_Order", this.getValidator());
    }

    @Override
    public String login(int arg0, int arg1, int arg2) {
        return null;
    }

    @Override
    public String docValidate(PO po, int nTiming) {
        if (nTiming == 7) {
            boolean cfr_ignored_0 = po instanceof I_C_Order;
        }
        return null;
    }

    @Override
    public String modelChange(PO model, int nType) throws Exception {
        block12: {
            X_A_Asset mAsset;
            block13: {
                block11: {
                    MOrder order;
                    String sDocSubTypeSO;
                    if (!(model instanceof X_C_Order)) break block11;
                    if ((nType == 2 || nType == 1) && (sDocSubTypeSO = (order = (MOrder)model).getC_DocTypeTarget().getDocSubTypeSO()) != null && sDocSubTypeSO.equals("MN")) {
                        order.setDeliveryRule("M");
                        order.setInvoiceRule("S");
                    }
                    break block12;
                }
                if (!(model instanceof X_C_OrderLineAsset)) break block13;
                if (nType != 5 && nType != 4 && nType != 6) break block12;
                X_C_OrderLineAsset olAsset = (X_C_OrderLineAsset)model;
                MOrderLine orderLine = new MOrderLine(Env.getCtx(), olAsset.getC_OrderLine_ID(), olAsset.get_TrxName());
                MOrder order = new MOrder(Env.getCtx(), orderLine.getC_Order_ID(), olAsset.get_TrxName());
                if (!order.getDocStatus().equals("DR") && !order.getDocStatus().equals("IP")) break block12;
                int nQty = MNTMOrderLine.countOrderLineAsset(orderLine);
                orderLine.setQty(new BigDecimal(nQty));
                orderLine.saveEx();
                break block12;
            }
            if (model instanceof X_C_OrderMntPaySched) {
                X_C_OrderMntPaySched paySched;
                if ((nType == 2 || nType == 1) && (paySched = (X_C_OrderMntPaySched)model).getC_Charge_ID() == 0 && paySched.getM_Product_ID() == 0) {
                    return Msg.getMsg(Env.getCtx(), "itmnt.ChargeOrProduct");
                }
            } else if (model instanceof X_A_Asset && nType == 4 && (mAsset = (X_A_Asset)model).getM_InOutLine_ID() > 0 && mAsset.getM_Product_ID() > 0) {
                Query qProductMntData = new Query(model.getCtx(), "M_ProductMntData", "M_Product_ID = ?", model.get_TrxName());
                qProductMntData.setOnlyActiveRecords(true).setApplyAccessFilter(true).setParameters(mAsset.getM_Product_ID());
                List lstProductMntData = qProductMntData.list();
                if (lstProductMntData != null) {
                    for (X_M_ProductMntData mProductMntData : lstProductMntData) {
                        X_A_AssetMntData mAssetMntData = new X_A_AssetMntData(model.getCtx(), 0, model.get_TrxName());
                        mAssetMntData.setA_Asset_ID(mAsset.getA_Asset_ID());
                        mAssetMntData.setM_Product_ID(mProductMntData.getM_ProductService_ID());
                        Timestamp tsStartDate = mAsset.getAssetServiceDate();
                        if (tsStartDate == null) {
                            tsStartDate = TimeUtil.getDay(System.currentTimeMillis());
                        }
                        Timestamp tsNextMaintDate = TimePeriodHelper.getNextDate(mProductMntData.getUomPeriod(), mProductMntData.getNPeriod(), tsStartDate, false);
                        mAssetMntData.setNextMaintenanceDate(tsNextMaintDate);
                        mAssetMntData.setLastMaintenanceDate(null);
                        mAssetMntData.saveEx();
                    }
                }
            }
        }
        if (nType == 3) {
            Object mInvLine;
            if (model instanceof I_C_InvoiceLine) {
                mInvLine = (I_C_InvoiceLine)((Object)model);
                DB.executeUpdate(SQL_UNLINKPAYSCHED_INVLINE, mInvLine.getC_InvoiceLine_ID(), model.get_TrxName());
            }
            if (model instanceof I_C_Invoice) {
                mInvLine = (I_C_Invoice)((Object)model);
                DB.executeUpdate(SQL_UNLINKPAYSCHED_INVOICE, mInvLine.getC_Invoice_ID(), model.get_TrxName());
            }
        }
        return null;
    }
}

