/*
 * Decompiled with CFR 0.152.
 */
package it.adempiere.maintenance.model;

import com.f3p.adempiere.util.ModelFactory;
import com.f3p.adempiere.util.QueryRepo;
import it.adempiere.maintenance.model.X_R_RequestResource;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.compiere.model.I_S_ResourceAssignment;
import org.compiere.model.MResourceAssignment;
import org.compiere.model.Query;
import org.compiere.model.X_R_Request;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MRRequestResource
extends X_R_RequestResource {
    private static final String QUERY_BASE_NAME = "it/adempiere/maintenance/model/";
    private static final String CHECK_DATE_QUERY = "it/adempiere/maintenance/model/check_rresource_date";
    private static final String CHECK_RESOURCE_QUERY = "it/adempiere/maintenance/model/check_rassignment_resource";
    public static final String COLUMNNAME_R_Request_ID = "R_Request_ID";
    private static final long serialVersionUID = -1475641548013954624L;

    public MRRequestResource(Properties ctx, int R_RequestResource_ID, String trxName) {
        super(ctx, R_RequestResource_ID, trxName);
    }

    public MRRequestResource(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MRRequestResource getByID(Properties ctx, int R_RequestResource_ID, String sTrx) {
        Query qPPC = new Query(ctx, "R_RequestResource", "R_RequestResource_ID = ?", sTrx);
        return (MRRequestResource)qPPC.setParameters(R_RequestResource_ID).first();
    }

    public static List<MRRequestResource> getByResourceAssignment(Properties ctx, int S_ResourceAssignment_ID, String sTrx) {
        Query qPPC = new Query(ctx, "R_RequestResource", "S_ResourceAssignment_ID = ?", sTrx);
        return qPPC.setParameters(S_ResourceAssignment_ID).list();
    }

    public static void setR_Request_ID(X_R_RequestResource mRequestResource, int R_Request_ID) {
        if (R_Request_ID < 1) {
            mRequestResource.set_ValueOfColumn(COLUMNNAME_R_Request_ID, null);
        } else {
            mRequestResource.set_ValueOfColumn(COLUMNNAME_R_Request_ID, (Object)R_Request_ID);
        }
    }

    public static int getR_Request_ID(X_R_RequestResource mRequestResource) {
        Integer ii = (Integer)mRequestResource.get_Value(COLUMNNAME_R_Request_ID);
        if (ii == null) {
            return 0;
        }
        return ii;
    }

    public static MRRequestResource[] getRequestResource(X_R_Request request) {
        String sql = "R_Request_ID=?";
        List<MRRequestResource> list = new Query(Env.getCtx(), "R_RequestResource", "R_Request_ID=?", request.get_TrxName()).setParameters(request.getR_Request_ID()).list();
        MRRequestResource[] retValue = new MRRequestResource[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public boolean isValidDateAssignment(I_S_ResourceAssignment mResourceAssignment) {
        String sSQL = QueryRepo.getQuery(CHECK_DATE_QUERY, this.getClass().getClassLoader());
        String sRes = DB.getSQLValueString(this.get_TrxName(), sSQL, mResourceAssignment.getS_Resource_ID(), mResourceAssignment.getAssignDateFrom(), this.getR_RequestResource_ID(), this.getR_Request_ID());
        return sRes == null;
    }

    public boolean isValidResourceAssignment(Timestamp tsDate, int S_Resource_ID) {
        String sSQL = QueryRepo.getQuery(CHECK_RESOURCE_QUERY, this.getClass().getClassLoader());
        String sRes = DB.getSQLValueString(this.get_TrxName(), sSQL, this.getR_Request_ID(), tsDate, S_Resource_ID);
        return sRes == null;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MResourceAssignment ra = ModelFactory.getResourceAssignment(this.getCtx(), this.getS_ResourceAssignment_ID(), this.get_TrxName());
        if (!this.isValidDateAssignment(ra)) {
            this.log.saveError("itmnt.mntExistingAppDate", "");
            return false;
        }
        return super.beforeSave(newRecord);
    }
}

