/*
 * Decompiled with CFR 0.152.
 */
package it.adempiere.maintenance.model;

import com.f3p.adempiere.util.ModelFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.compiere.model.MRequestType;
import org.compiere.model.MStatus;
import org.compiere.model.MSysConfig;
import org.compiere.model.X_R_RequestType;
import org.compiere.util.Env;

public class MNTMRequestType {
    public static final String SYSC_CLOSE_STATE = "ITMNT_REQUEST_CLOSE_STATUS_NAME";
    public static final String SYSC_AVAILABLE_STATES = "ITMNT_REQUEST_IS_APPOINTMENT_STATUS_NAMES";
    public static final String COLUMNNAME_IsMaintRequest = "IsMaintRequest";
    public static final String ISMAINTREQUEST_No = "N";
    public static final String ISMAINTREQUEST_Maintenance = "M";
    public static final String ISMAINTREQUEST_Support = "S";

    public static void setIsMaintRequest(X_R_RequestType mRequestType, String sMaintRequest) {
        mRequestType.set_ValueOfColumn(COLUMNNAME_IsMaintRequest, (Object)sMaintRequest);
    }

    public static String getIsMaintRequest(X_R_RequestType mRequestType) {
        return (String)mRequestType.get_Value(COLUMNNAME_IsMaintRequest);
    }

    public static boolean isMaintRequest(X_R_RequestType mRequestType) {
        String sIsMainRequest = MNTMRequestType.getIsMaintRequest(mRequestType);
        return sIsMainRequest != null && (sIsMainRequest.equals(ISMAINTREQUEST_Maintenance) || sIsMainRequest.equals(ISMAINTREQUEST_Support));
    }

    public static int getRequestCloseStatusID(Properties ctx, int R_RequestType_ID) {
        String sName = MSysConfig.getValue(SYSC_CLOSE_STATE, Env.getAD_Client_ID(ctx), Env.getAD_Org_ID(ctx));
        MRequestType mRType = MRequestType.get(ctx, R_RequestType_ID);
        MStatus mStatus = ModelFactory.getRequestStatus(ctx, mRType.getR_StatusCategory_ID(), sName, null);
        if (mStatus != null) {
            return mStatus.getR_Status_ID();
        }
        return -1;
    }

    public static List<Integer> getAvailableRequestStates(Properties ctx) {
        String sNames = MSysConfig.getValue(SYSC_AVAILABLE_STATES, Env.getAD_Client_ID(ctx), Env.getAD_Org_ID(ctx));
        ArrayList<Integer> lstIDs = new ArrayList<Integer>();
        if (sNames == null) {
            return lstIDs;
        }
        String[] sNamesArr = sNames.split(Pattern.quote(","));
        int i = 0;
        while (i < sNamesArr.length) {
            List<MStatus> mStatusLst;
            String sName = sNamesArr[i];
            if (sName.length() > 0 && (mStatusLst = ModelFactory.getRequestStatuses(ctx, sName, null)) != null && mStatusLst.size() > 0) {
                for (MStatus mStatus : mStatusLst) {
                    lstIDs.add(mStatus.getR_Status_ID());
                }
            }
            ++i;
        }
        return lstIDs;
    }
}

