/*
 * Decompiled with CFR 0.152.
 */
package it.adempiere.maintenance.model;

import it.adempiere.maintenance.model.MNTMProduct;
import it.adempiere.maintenance.model.X_C_OrderLineAsset;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MAsset;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_OrderLine;
import org.compiere.model.X_M_Product;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MNTMOrderLine {
    public static final String COLUMNNAME_IsMntLine = "IsMntLine";
    public static final String COLUMNNAME_NPeriod = "NPeriod";
    public static final String COLUMNNAME_UomPeriod = "UomPeriod";
    public static final String COLUMNNAME_IsSuppLine = "IsSuppLine";
    public static final String COLUMNNAME_IsMaterialIncl = "IsMaterialIncl";
    public static final String COLUMNNAME_IsResIncl = "IsResIncl";
    public static final String SQL_COUNT_ASSET = "SELECT COUNT('ok') FROM C_OrderLineAsset WHERE C_OrderLine_ID = ? AND isActive = 'Y'";
    public static final String SQL_WHERE_ACTIVE_AND_ID = "C_ORDERLINE_ID = ? AND ISACTIVE ='Y'";

    public static X_C_OrderLineAsset[] getAssetLines(X_C_OrderLine line) {
        List<X_C_OrderLineAsset> assetLines = new Query(Env.getCtx(), "C_OrderLineAsset", SQL_WHERE_ACTIVE_AND_ID, line.get_TrxName()).setParameters(line.getC_OrderLine_ID()).list();
        return assetLines.toArray(new X_C_OrderLineAsset[assetLines.size()]);
    }

    public static void copyAssetLinesFrom(Properties ctx, MOrderLine fromOLine, MOrderLine toOLine, String sTrx) {
        X_C_OrderLineAsset[] assetLines = MNTMOrderLine.getAssetLines(fromOLine);
        MProduct mProduct = fromOLine.getProduct();
        X_C_OrderLineAsset[] x_C_OrderLineAssetArray = assetLines;
        int n = assetLines.length;
        int n2 = 0;
        while (n2 < n) {
            X_C_OrderLineAsset mAssLine = x_C_OrderLineAssetArray[n2];
            if (MNTMOrderLine.canCopyOrderLineAsset(mProduct, mAssLine)) {
                X_C_OrderLineAsset newAssLine = new X_C_OrderLineAsset(Env.getCtx(), 0, sTrx);
                PO.copyValues(mAssLine, newAssLine);
                newAssLine.setC_OrderLine_ID(toOLine.getC_OrderLine_ID());
                newAssLine.saveEx(sTrx);
            }
            ++n2;
        }
    }

    protected static boolean canCopyOrderLineAsset(X_M_Product mProduct, X_C_OrderLineAsset mOrderLineAsset) {
        MAsset mAsset;
        boolean bCanCopy = false;
        if (mOrderLineAsset.isActive() && (mAsset = new MAsset(mProduct.getCtx(), mOrderLineAsset.getA_Asset_ID(), mProduct.get_TrxName())).isActive()) {
            if (mProduct != null && MNTMProduct.isMntLine(mProduct) && MNTMProduct.isForcedMnt(mProduct)) {
                Query qHasAssetMntLine = new Query(mOrderLineAsset.getCtx(), "A_AssetMntData", "A_Asset_ID = ? AND M_Product_ID = ?", mOrderLineAsset.get_TrxName());
                qHasAssetMntLine.setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(mAsset.getA_Asset_ID(), mProduct.getM_Product_ID());
                if (qHasAssetMntLine.firstId() > 0) {
                    bCanCopy = true;
                }
            } else {
                bCanCopy = mAsset.getNextMaintenanceDate() != null;
            }
        }
        return bCanCopy;
    }

    public static int countOrderLineAsset(X_C_OrderLine line) {
        return DB.getSQLValue(line.get_TrxName(), SQL_COUNT_ASSET, line.getC_OrderLine_ID());
    }

    public static void setIsMntLine(X_C_OrderLine line, boolean bValue) {
        line.set_ValueOfColumn(COLUMNNAME_IsMntLine, (Object)bValue);
    }

    public static boolean isMntLine(X_C_OrderLine line) {
        Object oo = line.get_Value(COLUMNNAME_IsMntLine);
        if (oo != null) {
            if (oo instanceof Boolean) {
                return (Boolean)oo;
            }
            return "Y".equals(oo);
        }
        return false;
    }

    public static void setNPeriod(X_C_OrderLine line, int NPeriod) {
        line.set_ValueOfColumn(COLUMNNAME_NPeriod, (Object)NPeriod);
    }

    public static int getNPeriod(X_C_OrderLine line) {
        Integer ii = (Integer)line.get_Value(COLUMNNAME_NPeriod);
        if (ii == null) {
            return 0;
        }
        return ii;
    }

    public static void setUomPeriod(X_C_OrderLine line, String sUom) {
        line.set_ValueOfColumn(COLUMNNAME_UomPeriod, (Object)sUom);
    }

    public static String getUomPeriod(X_C_OrderLine line) {
        return (String)line.get_Value(COLUMNNAME_UomPeriod);
    }

    public static void setIsSuppLine(X_C_OrderLine line, boolean bValue) {
        line.set_ValueOfColumn(COLUMNNAME_IsSuppLine, (Object)bValue);
    }

    public static boolean isSuppLine(X_C_OrderLine line) {
        Object oo = line.get_Value(COLUMNNAME_IsSuppLine);
        if (oo != null) {
            if (oo instanceof Boolean) {
                return (Boolean)oo;
            }
            return "Y".equals(oo);
        }
        return false;
    }

    public static void setIsMaterialIncl(X_C_OrderLine line, boolean bValue) {
        line.set_ValueOfColumn(COLUMNNAME_IsMaterialIncl, (Object)bValue);
    }

    public static boolean isMaterialIncl(X_C_OrderLine line) {
        Object oo = line.get_Value(COLUMNNAME_IsMaterialIncl);
        if (oo != null) {
            if (oo instanceof Boolean) {
                return (Boolean)oo;
            }
            return "Y".equals(oo);
        }
        return false;
    }

    public static void setIsResIncl(X_C_OrderLine line, boolean bValue) {
        line.set_ValueOfColumn(COLUMNNAME_IsResIncl, (Object)bValue);
    }

    public static boolean isResIncl(X_C_OrderLine line) {
        Object oo = line.get_Value(COLUMNNAME_IsResIncl);
        if (oo != null) {
            if (oo instanceof Boolean) {
                return (Boolean)oo;
            }
            return "Y".equals(oo);
        }
        return false;
    }
}

