/*
 * Decompiled with CFR 0.152.
 */
package it.adempiere.maintenance.model;

import it.adempiere.maintenance.model.MNTMOrderLine;
import it.adempiere.maintenance.model.X_C_OrderMntExpense;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MGoal;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_Order;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class MNTMOrder {
    private static CLogger s_log = CLogger.getCLogger(MGoal.class);
    public static final String DocSubTypeSO_Maintenance = "MN";
    public static final String COLUMNNAME_ValidFrom = "ValidFrom";
    public static final String COLUMNNAME_ValidTo = "ValidTo";
    public static final String SQL_WHERE_ACTIVE_AND_ORDER_ID = "C_ORDER_ID = ? AND ISACTIVE ='Y'";

    public static X_C_OrderMntExpense[] getMaintenanceExpenseLines(X_C_Order order) {
        List<X_C_OrderMntExpense> expenseLines = new Query(Env.getCtx(), "C_OrderMntExpense", SQL_WHERE_ACTIVE_AND_ORDER_ID, order.get_TrxName()).setParameters(order.getC_Order_ID()).list();
        return expenseLines.toArray(new X_C_OrderMntExpense[expenseLines.size()]);
    }

    public static void copyMaintenanceLinesFrom(Properties ctx, MOrder fromOrder, MOrder toOrder, String sTrx) {
        X_C_OrderMntExpense[] expenseLines;
        X_C_OrderMntExpense[] x_C_OrderMntExpenseArray = expenseLines = MNTMOrder.getMaintenanceExpenseLines(fromOrder);
        int n = expenseLines.length;
        int n2 = 0;
        while (n2 < n) {
            X_C_OrderMntExpense mntLine = x_C_OrderMntExpenseArray[n2];
            if (mntLine.isActive() && (fromOrder.getC_BPartner_ID() == toOrder.getC_BPartner_ID() || mntLine.getC_BPartner_Location_ID() <= 0)) {
                X_C_OrderMntExpense newMntLine = new X_C_OrderMntExpense(Env.getCtx(), 0, sTrx);
                PO.copyValues(mntLine, newMntLine);
                newMntLine.setC_Order_ID(toOrder.getC_Order_ID());
                newMntLine.saveEx(sTrx);
            }
            ++n2;
        }
    }

    public static void setValidFrom(X_C_Order order, Timestamp date) {
        order.set_ValueOfColumn(COLUMNNAME_ValidFrom, (Object)date);
    }

    public static Timestamp getValidFrom(X_C_Order order) {
        return (Timestamp)order.get_Value(COLUMNNAME_ValidFrom);
    }

    public static void setValidTo(X_C_Order order, Timestamp date) {
        order.set_ValueOfColumn(COLUMNNAME_ValidTo, (Object)date);
    }

    public static Timestamp getValidTo(X_C_Order order) {
        return (Timestamp)order.get_Value(COLUMNNAME_ValidTo);
    }

    public static int copyLinesFrom(MOrder fromOrder, MOrder toOrder, boolean counter, boolean copyASI) {
        if (toOrder.isProcessed() || toOrder.isPosted() || fromOrder == null) {
            return 0;
        }
        MOrderLine[] fromLines = fromOrder.getLines(false, null);
        int count = 0;
        int i = 0;
        while (i < fromLines.length) {
            MOrderLine line = new MOrderLine(toOrder);
            PO.copyValues(fromLines[i], line);
            line.setC_Order_ID(toOrder.getC_Order_ID());
            line.setQtyDelivered(Env.ZERO);
            line.setQtyInvoiced(Env.ZERO);
            line.setQtyReserved(Env.ZERO);
            line.setDateDelivered(null);
            line.setDateInvoiced(null);
            line.setOrder(toOrder);
            if (!copyASI) {
                line.setM_AttributeSetInstance_ID(0);
                line.setS_ResourceAssignment_ID(0);
            }
            if (counter) {
                line.setRef_OrderLine_ID(fromLines[i].getC_OrderLine_ID());
            } else {
                line.setRef_OrderLine_ID(0);
            }
            line.setLink_OrderLine_ID(0);
            if (toOrder.getC_BPartner_ID() != fromOrder.getC_BPartner_ID()) {
                line.setTax();
            }
            line.setProcessed(false);
            if (line.save(toOrder.get_TrxName())) {
                ++count;
            }
            if (counter) {
                fromLines[i].setRef_OrderLine_ID(line.getC_OrderLine_ID());
                fromLines[i].save(toOrder.get_TrxName());
            }
            MNTMOrderLine.copyAssetLinesFrom(Env.getCtx(), fromLines[i], line, fromOrder.get_TrxName());
            ++i;
        }
        if (fromLines.length != count) {
            s_log.log(Level.SEVERE, "Line difference - From=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }
}

