/*
 * Decompiled with CFR 0.152.
 */
package it.adempiere.maintenance.form;

import it.adempiere.maintenance.form.GenericListItem;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public class ResourceAppItem
extends GenericListItem {
    protected String m_sTypeName;
    protected String m_sResourceName;
    protected BigDecimal m_bdQty;
    protected Timestamp m_tsAppDate;
    protected int m_iResourceAD_User_ID;
    protected int m_iR_Request_ID;
    protected int m_iS_Resource_ID;
    protected int m_iS_TimeExpenseLine_ID;
    protected int m_iR_RequestResource_ID;
    protected boolean m_bIsReported;

    public ResourceAppItem(int R_Request_ID, String sTypeName, String sResourceName, Timestamp tsAppDate, BigDecimal bdQty, int AD_User_ID, int S_TimeExpenseLine_ID, int iS_Resource_ID, boolean bIsReported, int R_RequestResource_ID) {
        this.m_iR_Request_ID = R_Request_ID;
        this.m_sTypeName = sTypeName;
        this.m_sResourceName = sResourceName;
        this.m_tsAppDate = tsAppDate;
        this.m_bdQty = bdQty;
        this.m_iResourceAD_User_ID = AD_User_ID;
        this.m_iS_TimeExpenseLine_ID = S_TimeExpenseLine_ID;
        this.m_bIsReported = bIsReported;
        this.m_iS_Resource_ID = iS_Resource_ID;
        this.m_iR_RequestResource_ID = R_RequestResource_ID;
        if (this.m_iR_RequestResource_ID <= 0 || this.m_iS_TimeExpenseLine_ID <= 0) {
            this.setIsNewItem(true);
        } else {
            this.setIsNewItem(false);
        }
    }

    public ResourceAppItem(int R_Request_ID, ResultSet rs) throws SQLException {
        this.m_iR_Request_ID = R_Request_ID;
        this.m_sTypeName = rs.getString("TypeName");
        this.m_sResourceName = rs.getString("ResName");
        this.m_tsAppDate = rs.getTimestamp("ASSIGNDATEFROM");
        this.m_iResourceAD_User_ID = rs.getInt("AD_User_ID");
        this.m_bdQty = rs.getBigDecimal("Qty");
        this.m_iS_TimeExpenseLine_ID = rs.getInt("S_TimeExpenseLine_ID");
        this.m_iS_Resource_ID = rs.getInt("S_Resource_ID");
        this.m_iR_RequestResource_ID = rs.getInt("R_RequestResource_ID");
        String sIsReported = rs.getString("IsReported");
        this.m_bIsReported = sIsReported != null && sIsReported.equals("Y");
        this.setIsNewItem(false);
    }

    public ResourceAppItem getCopyAsNew() {
        ResourceAppItem rItemNew = new ResourceAppItem(this.m_iR_Request_ID, this.m_sTypeName, this.m_sResourceName, this.m_tsAppDate, BigDecimal.ZERO, this.m_iResourceAD_User_ID, -1, this.m_iS_Resource_ID, false, -1);
        rItemNew.setIsNewItem(true);
        return rItemNew;
    }

    public int getR_Request_ID() {
        return this.m_iR_Request_ID;
    }

    public BigDecimal getQty() {
        return this.m_bdQty;
    }

    public void setQty(BigDecimal bdQty) {
        this.m_bdQty = bdQty;
    }

    public String getTypeName() {
        return this.getSafeString(this.m_sTypeName, 0);
    }

    public String getResourceName() {
        return this.getSafeString(this.m_sResourceName, 0);
    }

    public Timestamp getAppDate() {
        return this.m_tsAppDate;
    }

    public void setAppDate(Timestamp tsDate) {
        this.m_tsAppDate = tsDate;
    }

    public int getResourceAD_User_ID() {
        return this.m_iResourceAD_User_ID;
    }

    public int getS_TimeExpenseLine_ID() {
        return this.m_iS_TimeExpenseLine_ID;
    }

    public int getS_Resource_ID() {
        return this.m_iS_Resource_ID;
    }

    public void setS_TimeExpenseLine_ID(int ID2) {
        this.m_iS_TimeExpenseLine_ID = ID2;
    }

    public boolean isReported() {
        return this.m_bIsReported;
    }

    public int getR_RequestResource_ID() {
        return this.m_iR_RequestResource_ID;
    }

    public void setR_RequestResource_ID(int R_RequestResource_ID) {
        this.m_iR_RequestResource_ID = R_RequestResource_ID;
    }
}

