/*
 * Decompiled with CFR 0.152.
 */
package it.adempiere.maintenance.form;

import it.adempiere.maintenance.form.GenericListItem;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.compiere.model.MProduct;
import org.compiere.util.Env;

public class AssetItem
extends GenericListItem {
    protected int m_iR_RequestAsset_ID;
    protected int m_iA_Asset_ID;
    protected int m_iM_Product_ID;
    protected String m_sAssetName;
    protected String m_sSerNo;
    protected String m_sProductName;
    protected Timestamp m_tsGuaranteeDate;
    protected Timestamp m_tsNextMaintenanceDate;
    protected boolean m_bIsHeaderAsset;

    public AssetItem(int R_RequestAsset_ID, int A_Asset_ID, String sAssetName, String sSerNo, Timestamp tsGuaranteeDate, Timestamp tsNextMaintDate, int M_Product_ID, boolean bIsHeaderAsset) {
        this.m_iR_RequestAsset_ID = R_RequestAsset_ID;
        this.m_iA_Asset_ID = A_Asset_ID;
        this.m_sAssetName = sAssetName;
        this.m_sSerNo = sSerNo;
        this.m_tsGuaranteeDate = tsGuaranteeDate;
        this.m_tsNextMaintenanceDate = tsNextMaintDate;
        this.m_iM_Product_ID = M_Product_ID;
        this.m_bIsHeaderAsset = bIsHeaderAsset;
        if (this.m_iM_Product_ID > 0) {
            MProduct mProd = MProduct.get(Env.getCtx(), this.m_iM_Product_ID);
            this.m_sProductName = mProd.getName();
        }
    }

    public AssetItem(ResultSet rs) throws SQLException {
        this.m_iR_RequestAsset_ID = rs.getInt("R_RequestAsset_ID");
        this.m_iA_Asset_ID = rs.getInt("A_Asset_ID");
        this.m_sAssetName = rs.getString("Name");
        this.m_sSerNo = rs.getString("SerNo");
        this.m_tsGuaranteeDate = rs.getTimestamp("GUARANTEEDATE");
        this.m_tsNextMaintenanceDate = rs.getTimestamp("NEXTMAINTENANCEDATE");
        this.m_iM_Product_ID = rs.getInt("M_Product_ID");
        this.m_sProductName = rs.getString("ProductName");
    }

    public int getR_RequestAsset_ID() {
        return this.m_iR_RequestAsset_ID;
    }

    public int getA_Asset_ID() {
        return this.m_iA_Asset_ID;
    }

    public String getAssetName() {
        return this.getSafeString(this.m_sAssetName, 0);
    }

    public String getSerNo() {
        return this.getSafeString(this.m_sSerNo, 0);
    }

    public Timestamp getGuaranteeDate() {
        return this.m_tsGuaranteeDate;
    }

    public Timestamp getNextMaintenanceDate() {
        return this.m_tsNextMaintenanceDate;
    }

    public int getM_Product_ID() {
        return this.m_iM_Product_ID;
    }

    public String getProductName() {
        return this.m_sProductName;
    }

    public boolean isHeaderAsset() {
        return this.m_bIsHeaderAsset;
    }
}

