/*
 * Decompiled with CFR 0.152.
 */
package it.adempiere.maintenance.form;

import com.f3p.adempiere.util.ModelFactory;
import com.f3p.adempiere.util.QueryRepo;
import it.adempiere.maintenance.form.AppointmentNotesItem;
import it.adempiere.maintenance.form.AssetItem;
import it.adempiere.maintenance.form.ProductItem;
import it.adempiere.maintenance.form.RAppExpenseItem;
import it.adempiere.maintenance.form.RequestItem;
import it.adempiere.maintenance.form.RequestTextFilter;
import it.adempiere.maintenance.form.ResourceAppItem;
import it.adempiere.maintenance.form.VAppointmentResult;
import it.adempiere.maintenance.model.MNTMProduct;
import it.adempiere.maintenance.model.MNTMProjectLine;
import it.adempiere.maintenance.model.MNTMRequest;
import it.adempiere.maintenance.model.MNTMRequestType;
import it.adempiere.maintenance.model.MNTTimeExpenseLine;
import it.adempiere.maintenance.model.MRRequestResource;
import it.adempiere.maintenance.model.X_R_RequestAsset;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_C_UOM;
import org.compiere.model.MAsset;
import org.compiere.model.MCharge;
import org.compiere.model.MDocType;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MProductPricing;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.MRequest;
import org.compiere.model.MResource;
import org.compiere.model.MResourceAssignment;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTimeExpense;
import org.compiere.model.MTimeExpenseLine;
import org.compiere.model.MUOMConversion;
import org.compiere.model.MWarehouse;
import org.compiere.model.Query;
import org.compiere.model.X_C_ProjectLine;
import org.compiere.model.X_R_Request;
import org.compiere.model.X_S_TimeExpenseLine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.TimeUtil;

public class AppointmentResult {
    public static final KeyNamePair EMPTY_PAIR = new KeyNamePair(-1, "-----");
    public static final String QUERY_BASE_NAME = "it/adempiere/maintenance/form/";
    public static CLogger s_log = CLogger.getCLogger(VAppointmentResult.class);
    public static final String SYSC_INVENTORY_CHARGE = "ITMNT_INVENTORY_CHARGE_NAME";
    public static final String APP_PRINT_PROCESS_NAME = "ITMNT_APPOINTMENT_PRINT";
    protected static final int C_UOM_ID = 101;
    protected int m_iAD_User_ID = -1;
    protected int m_iAD_Role_ID = -1;
    protected Timestamp m_tsToday = null;
    protected Properties m_ctx = null;

    public void dynInit() throws Exception {
        this.m_iAD_User_ID = Env.getAD_User_ID(this.m_ctx);
        this.m_iAD_Role_ID = Env.getAD_Role_ID(this.m_ctx);
        this.m_tsToday = TimeUtil.getDay(System.currentTimeMillis());
    }

    public Properties getCtx() {
        return this.m_ctx;
    }

    public Timestamp getToday() {
        return this.m_tsToday;
    }

    public int getRequestCloseStatusID(RequestItem item) {
        return MNTMRequestType.getRequestCloseStatusID(this.getCtx(), item.getR_RequestType_ID());
    }

    public List<Integer> getAvailableRequestStates() {
        return MNTMRequestType.getAvailableRequestStates(this.getCtx());
    }

    public int getInventoryC_Charge_ID() {
        MCharge mCharge;
        String sName = MSysConfig.getValue(SYSC_INVENTORY_CHARGE, Env.getAD_Client_ID(this.getCtx()), Env.getAD_Org_ID(this.getCtx()));
        if (sName != null && (mCharge = ModelFactory.getCharge(this.getCtx(), sName, null)) != null) {
            return mCharge.getC_Charge_ID();
        }
        return -1;
    }

    public List<RequestItem> getRequests(String sFilter, String sTrx) {
        String sSQL = QueryRepo.getQuery("it/adempiere/maintenance/form/get_requests", this.getClass().getClassLoader());
        CPreparedStatement pstmt = DB.prepareStatement(sSQL, sTrx);
        ResultSet rs = null;
        ArrayList<RequestItem> lstRequests = new ArrayList<RequestItem>();
        RequestTextFilter reqFilter = new RequestTextFilter(sFilter);
        List<Integer> lstAvailableStatuses = this.getAvailableRequestStates();
        if (lstAvailableStatuses.size() == 0) {
            throw new AdempiereException("@Invalid@ @R_Status_ID@ @Name@");
        }
        try {
            try {
                pstmt.setInt(1, this.m_iAD_User_ID);
                pstmt.setInt(2, this.m_iAD_User_ID);
                pstmt.setInt(3, this.m_iAD_Role_ID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    RequestItem rItem = new RequestItem(rs);
                    if (!lstAvailableStatuses.contains(rItem.getR_Status_ID()) || !reqFilter.isAcceptableItem(rItem)) continue;
                    lstRequests.add(rItem);
                }
            }
            catch (Exception e) {
                s_log.severe(e.getLocalizedMessage());
                throw new AdempiereException(e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close(rs, pstmt);
        return lstRequests;
    }

    public List<ResourceAppItem> getResourceApps(int R_Request_ID, String sTrx) {
        String sSQL = QueryRepo.getQuery("it/adempiere/maintenance/form/get_resourceandapps", this.getClass().getClassLoader());
        CPreparedStatement pstmt = DB.prepareStatement(sSQL, sTrx);
        ResultSet rs = null;
        ArrayList<ResourceAppItem> lstResAndApps = new ArrayList<ResourceAppItem>();
        boolean bIsTeamLeader = this.isTeamLeader(R_Request_ID, sTrx);
        try {
            try {
                pstmt.setInt(1, R_Request_ID);
                pstmt.setInt(2, this.m_iAD_User_ID);
                pstmt.setInt(3, this.m_iAD_User_ID);
                pstmt.setInt(4, this.m_iAD_Role_ID);
                if (bIsTeamLeader) {
                    pstmt.setString(5, "Y");
                } else {
                    pstmt.setString(5, "N");
                }
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ResourceAppItem raItem = new ResourceAppItem(R_Request_ID, rs);
                    lstResAndApps.add(raItem);
                }
            }
            catch (Exception e) {
                s_log.severe(e.getLocalizedMessage());
                throw new AdempiereException(e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close(rs, pstmt);
        return lstResAndApps;
    }

    public List<RAppExpenseItem> getExpenseItems(ResourceAppItem appItem, String sTrx) {
        String sSQL = QueryRepo.getQuery("it/adempiere/maintenance/form/get_resourceandapp_expenses", this.getClass().getClassLoader());
        CPreparedStatement pstmt = DB.prepareStatement(sSQL, sTrx);
        ResultSet rs = null;
        ArrayList<RAppExpenseItem> lstExpItems = new ArrayList<RAppExpenseItem>();
        Timestamp tsDateApp = TimeUtil.getDay(appItem.getAppDate());
        try {
            try {
                pstmt.setInt(1, appItem.getR_Request_ID());
                pstmt.setTimestamp(2, tsDateApp);
                pstmt.setInt(3, appItem.getResourceAD_User_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    RAppExpenseItem raeItem = new RAppExpenseItem(appItem, rs);
                    lstExpItems.add(raeItem);
                }
            }
            catch (Exception e) {
                s_log.severe(e.getLocalizedMessage());
                throw new AdempiereException(e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close(rs, pstmt);
        return lstExpItems;
    }

    public List<ProductItem> getProducts(int R_Request_ID, String sTrx) {
        String sSQL = QueryRepo.getQuery("it/adempiere/maintenance/form/get_products", this.getClass().getClassLoader());
        CPreparedStatement pstmt = DB.prepareStatement(sSQL, sTrx);
        ResultSet rs = null;
        ArrayList<ProductItem> lstProductItems = new ArrayList<ProductItem>();
        try {
            try {
                pstmt.setInt(1, R_Request_ID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ProductItem pi = new ProductItem(rs);
                    lstProductItems.add(pi);
                }
            }
            catch (Exception e) {
                s_log.severe(e.getLocalizedMessage());
                throw new AdempiereException(e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close(rs, pstmt);
        return lstProductItems;
    }

    public List<AssetItem> getAssets(int R_Request_ID, String sTrx) {
        return AppointmentResult.getAssets(this.getCtx(), R_Request_ID, sTrx);
    }

    public static List<AssetItem> getAssets(Properties ctx, int R_Request_ID, String sTrx) {
        String sSQL = QueryRepo.getQuery("it/adempiere/maintenance/form/get_assets", AppointmentResult.class.getClassLoader());
        CPreparedStatement pstmt = DB.prepareStatement(sSQL, sTrx);
        ResultSet rs = null;
        ArrayList<AssetItem> lstAssetItems = new ArrayList<AssetItem>();
        MRequest mRequest = ModelFactory.getRequest(ctx, R_Request_ID, sTrx);
        if (mRequest.getA_Asset_ID() > 0) {
            MAsset mAsset = ModelFactory.getAsset(ctx, mRequest.getA_Asset_ID(), sTrx);
            AssetItem aItem = new AssetItem(0, mRequest.getA_Asset_ID(), mAsset.getName(), mAsset.getSerNo(), mAsset.getGuaranteeDate(), mAsset.getNextMaintenanceDate(), 0, true);
            lstAssetItems.add(aItem);
        }
        try {
            try {
                pstmt.setInt(1, R_Request_ID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    AssetItem ai = new AssetItem(rs);
                    lstAssetItems.add(ai);
                }
            }
            catch (Exception e) {
                s_log.severe(e.getLocalizedMessage());
                throw new AdempiereException(e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close(rs, pstmt);
        return lstAssetItems;
    }

    public AppointmentNotesItem getAppointmentNotes(RequestItem rItem, String sTrx) {
        return new AppointmentNotesItem(this.getCtx(), rItem.getR_Request_ID(), sTrx);
    }

    public static List<KeyNamePair> getExpensesProducts(Properties ctx, boolean bAddEmpy, String sTrx) {
        ArrayList<KeyNamePair> lstProducts = new ArrayList<KeyNamePair>();
        List<MProduct> lstModels = MNTMProduct.getExpenses(ctx, sTrx);
        lstProducts = new ArrayList(lstModels.size());
        if (bAddEmpy) {
            lstProducts.add(EMPTY_PAIR);
        }
        for (MProduct mp : lstModels) {
            KeyNamePair knp = new KeyNamePair(mp.getM_Product_ID(), mp.getName());
            lstProducts.add(knp);
        }
        return lstProducts;
    }

    public boolean isMaterialIncluded(int R_Request_ID, String sTrx) {
        boolean bIsMaterialIncluded = false;
        List<AssetItem> lstAssets = this.getAssets(R_Request_ID, sTrx);
        if (lstAssets.size() == 0) {
            return bIsMaterialIncluded;
        }
        StringBuilder sbIn = new StringBuilder("(");
        for (AssetItem aItem : lstAssets) {
            sbIn.append(aItem.getA_Asset_ID()).append(',');
        }
        sbIn.setCharAt(sbIn.length() - 1, ')');
        String sBaseSQL = QueryRepo.getQuery("it/adempiere/maintenance/form/ismaterialincluded", this.getClass().getClassLoader());
        CPreparedStatement pstmt = DB.prepareStatement(String.valueOf(sBaseSQL) + sbIn.toString(), sTrx);
        ResultSet rs = null;
        try {
            try {
                pstmt.setInt(1, R_Request_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    bIsMaterialIncluded = true;
                }
            }
            catch (Exception e) {
                s_log.severe(e.getLocalizedMessage());
                throw new AdempiereException(e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close(rs, pstmt);
        return bIsMaterialIncluded;
    }

    public boolean isTeamLeader(int R_Request_ID, String sTrx) {
        String sSQL = QueryRepo.getQuery("it/adempiere/maintenance/form/isteamleader", this.getClass().getClassLoader());
        CPreparedStatement pstmt = DB.prepareStatement(sSQL, sTrx);
        ResultSet rs = null;
        boolean bIsTeamLeader = false;
        try {
            try {
                pstmt.setInt(1, R_Request_ID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    if (rs.getInt("SalesRep_ID") != this.m_iAD_User_ID && rs.getInt("AD_User_ID") != this.m_iAD_User_ID && rs.getInt("AD_Role_ID") != this.m_iAD_Role_ID) continue;
                    bIsTeamLeader = true;
                    break;
                }
            }
            catch (Exception e) {
                s_log.severe(e.getLocalizedMessage());
                throw new AdempiereException(e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close(rs, pstmt);
        return bIsTeamLeader;
    }

    public void closeRequest(RequestItem rItem, boolean bIsTeamLeader, String sTrx) {
        if (bIsTeamLeader) {
            Query qReq = new Query(this.getCtx(), "R_Request", "R_Request_ID = ?", sTrx);
            X_R_Request rReq = (X_R_Request)qReq.setParameters(rItem.getR_Request_ID()).first();
            int R_Status_ID = this.getRequestCloseStatusID(rItem);
            if (R_Status_ID < 0) {
                throw new AdempiereException("@Invalid@ @Status@ @Name@");
            }
            if (rReq != null && R_Status_ID != 0) {
                rReq.setR_Status_ID(R_Status_ID);
                rReq.saveEx();
                this.addTimeExpenseProductToProject(rItem, sTrx);
                this.createAndCompleteInventory(rItem, sTrx);
            }
        } else {
            String sSQL = QueryRepo.getQuery("it/adempiere/maintenance/form/close_requestresource", this.getClass().getClassLoader());
            DB.executeUpdateEx(sSQL, new Object[]{rItem.getR_Request_ID(), this.m_iAD_User_ID}, sTrx);
        }
    }

    protected void addTimeExpenseProductToProject(RequestItem rItem, String sTrx) {
        String sTimeExpenseSQL = QueryRepo.getQuery("it/adempiere/maintenance/form/get_expense_and_resource_for_request", rItem.getClass().getClassLoader());
        int C_Project_ID = rItem.getC_Project_ID();
        MProject mProject = ModelFactory.getProject(this.getCtx(), C_Project_ID, sTrx);
        CPreparedStatement pstmt = DB.prepareStatement(sTimeExpenseSQL, sTrx);
        ResultSet rs = null;
        try {
            try {
                pstmt.setInt(1, rItem.getR_Request_ID());
                pstmt.setInt(2, rItem.getR_Request_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String sType = rs.getString("type");
                    int M_Product_ID = rs.getInt("M_Product_ID");
                    BigDecimal bdQty = rs.getBigDecimal("Qty");
                    List<MProjectLine> lstProjectLines = ModelFactory.getProductProjectLines(this.getCtx(), C_Project_ID, M_Product_ID, sTrx);
                    MProjectLine mProjectLine = null;
                    if (M_Product_ID <= 0) {
                        throw new AdempiereException("@Invalid@ @M_Product_ID@");
                    }
                    if (lstProjectLines.size() > 0) {
                        mProjectLine = lstProjectLines.get(0);
                    }
                    if (sType.equals("R")) {
                        BigDecimal bdRate;
                        MProduct mProduct = MProduct.get(this.getCtx(), M_Product_ID);
                        int C_Uom_ID_Src = rs.getInt("C_UOM_ID");
                        I_C_UOM mUom = mProduct.getC_UOM();
                        if (mProjectLine == null) {
                            mProjectLine = new MProjectLine(mProject);
                            mProjectLine.setM_Product_ID(M_Product_ID);
                        }
                        if ((bdRate = MUOMConversion.getProductRateTo(this.getCtx(), M_Product_ID, C_Uom_ID_Src)) == null && (bdRate = MUOMConversion.getRate(C_Uom_ID_Src, mProduct.getC_UOM_ID())) == null) {
                            throw new AdempiereException("@NoUOMConversion@ " + mProduct.getName());
                        }
                        BigDecimal bdConvertedQty = bdQty.multiply(bdRate).setScale(mUom.getStdPrecision(), 4);
                        BigDecimal bdCmtQty = mProjectLine.getCommittedQty().add(bdConvertedQty);
                        mProjectLine.setCommittedQty(bdCmtQty);
                        mProjectLine.setCommittedAmt(bdCmtQty.multiply(mProjectLine.getPlannedPrice()));
                        mProjectLine.saveEx();
                        continue;
                    }
                    if (mProjectLine == null) continue;
                    BigDecimal bdCmtQty = mProjectLine.getCommittedQty().add(bdQty);
                    mProjectLine.setCommittedQty(bdCmtQty);
                    mProjectLine.saveEx();
                }
            }
            catch (SQLException e) {
                throw new AdempiereException(e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close(rs, pstmt);
    }

    protected void createAndCompleteInventory(RequestItem rItem, String sTrx) {
        String sProductSQL = QueryRepo.getQuery("it/adempiere/maintenance/form/get_article_from_projectlines", rItem.getClass().getClassLoader());
        String sLocatorSQL = QueryRepo.getQuery("it/adempiere/maintenance/form/get_locator_for_product_qty", rItem.getClass().getClassLoader());
        int C_Project_ID = rItem.getC_Project_ID();
        MProject mProject = ModelFactory.getProject(this.getCtx(), C_Project_ID, sTrx);
        int M_Warehouse_ID = mProject.getM_Warehouse_ID();
        int C_Charge_ID = this.getInventoryC_Charge_ID();
        if (C_Charge_ID < 0) {
            throw new AdempiereException("@Missing@ @C_Charge_ID@");
        }
        if (M_Warehouse_ID <= 0) {
            M_Warehouse_ID = Env.getContextAsInt(this.getCtx(), "#M_Warehouse_ID");
        }
        MWarehouse mWarehouse = MWarehouse.get(this.getCtx(), M_Warehouse_ID);
        MInventory mInv = new MInventory(mWarehouse, sTrx);
        int iDocType = MDocType.getDocType("MMI");
        mInv.setMovementDate(rItem.getStartDate());
        mInv.setC_Project_ID(mProject.getC_Project_ID());
        mInv.setC_Campaign_ID(mProject.getC_Campaign_ID());
        mInv.setC_DocType_ID(iDocType);
        mInv.saveEx();
        CPreparedStatement pstmt = DB.prepareStatement(sProductSQL, sTrx);
        CPreparedStatement pstmtLoc = null;
        ResultSet rs = null;
        ResultSet rsLoc = null;
        try {
            try {
                pstmt.setInt(1, mProject.getC_Project_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int M_Product_ID = rs.getInt("M_Product_ID");
                    MProduct mProduct = MProduct.get(this.getCtx(), M_Product_ID);
                    int M_Locator_ID_Product = mProduct.getM_Locator_ID();
                    int M_Locator_ID = -1;
                    BigDecimal bdQty = rs.getBigDecimal("Qty");
                    pstmtLoc = DB.prepareStatement(sLocatorSQL, sTrx);
                    pstmtLoc.setInt(1, M_Product_ID);
                    pstmtLoc.setBigDecimal(2, bdQty);
                    rsLoc = pstmtLoc.executeQuery();
                    while (rsLoc.next()) {
                        int ID2 = rsLoc.getInt("M_Locator_ID");
                        if (ID2 == M_Locator_ID_Product) {
                            M_Locator_ID = ID2;
                            break;
                        }
                        if (M_Locator_ID >= 0) continue;
                        M_Locator_ID = ID2;
                    }
                    DB.close(rsLoc, pstmtLoc);
                    pstmtLoc = null;
                    rsLoc = null;
                    if (M_Locator_ID < 0) {
                        throw new AdempiereException("@NoQtyAvailable@" + mProduct.getName());
                    }
                    MInventoryLine mLine = new MInventoryLine(this.getCtx(), 0, sTrx);
                    mLine.setM_Inventory_ID(mInv.getM_Inventory_ID());
                    mLine.setM_Product_ID(M_Product_ID);
                    mLine.setM_Locator_ID(M_Locator_ID);
                    mLine.setQtyInternalUse(bdQty);
                    mLine.setC_Charge_ID(C_Charge_ID);
                    mLine.saveEx();
                }
                mInv.processIt("CO");
                mInv.saveEx();
            }
            catch (SQLException e) {
                throw new AdempiereException(e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            DB.close(rsLoc, pstmtLoc);
            throw throwable;
        }
        DB.close(rs, pstmt);
        DB.close(rsLoc, pstmtLoc);
    }

    public void closeRequest(RequestItem rItem, String sTrx) {
        this.closeRequest(rItem, rItem.isTeamLeader(this, sTrx), sTrx);
    }

    public void modifyAppDate(ResourceAppItem riTem, Timestamp tsNewDate, String sTrx) {
        MRRequestResource mRRes = MRRequestResource.getByID(this.getCtx(), riTem.getR_RequestResource_ID(), sTrx);
        MResourceAssignment mAssignment = ModelFactory.getResourceAssignment(this.getCtx(), mRRes.getS_ResourceAssignment_ID(), sTrx);
        mAssignment.setAssignDateFrom(tsNewDate);
        mAssignment.setAssignDateTo(tsNewDate);
        mAssignment.saveEx();
    }

    public void saveItem(ResourceAppItem item, String sTrx) {
        if (item.isMarkedForDelete()) {
            if (item.isNewItem() || item.getS_TimeExpenseLine_ID() <= 0) {
                return;
            }
            X_S_TimeExpenseLine mTELine = this.getTimeExpenseLine(item.getS_TimeExpenseLine_ID(), sTrx);
            if (mTELine != null) {
                mTELine.delete(false);
            }
        } else {
            if (item.getR_RequestResource_ID() <= 0) {
                MRRequestResource mReqResNew = new MRRequestResource(this.getCtx(), 0, sTrx);
                MResourceAssignment mResAssign = new MResourceAssignment(this.getCtx(), 0, sTrx);
                mResAssign.setAssignDateFrom(item.getAppDate());
                mResAssign.setAssignDateTo(item.getAppDate());
                mResAssign.setS_Resource_ID(item.getS_Resource_ID());
                mResAssign.setQty(BigDecimal.ONE);
                mResAssign.saveEx();
                MResource res = ModelFactory.getResource(this.getCtx(), item.getS_Resource_ID(), sTrx);
                mReqResNew.setR_Request_ID(item.getR_Request_ID());
                mReqResNew.setIsReported(item.isReported());
                mReqResNew.setIsTeamLeader(false);
                mReqResNew.setS_ResourceType_ID(res.getS_ResourceType_ID());
                mReqResNew.setS_ResourceAssignment_ID(mResAssign.getS_ResourceAssignment_ID());
                mReqResNew.saveEx();
                item.setR_RequestResource_ID(mReqResNew.getR_RequestResource_ID());
            }
            MProduct mProd = ModelFactory.getResourceProduct(this.getCtx(), item.getS_Resource_ID(), sTrx);
            int S_TimeExpenseLine_ID = this.createOrUpdateTimeExpenseLine(item.getR_Request_ID(), item.getResourceAD_User_ID(), item.getS_TimeExpenseLine_ID(), item.getAppDate(), mProd.getM_Product_ID(), item.getQty(), BigDecimal.ZERO, true, sTrx);
            if (S_TimeExpenseLine_ID > 0 && item.getS_TimeExpenseLine_ID() <= 0) {
                item.setIsNewItem(false);
                item.setS_TimeExpenseLine_ID(S_TimeExpenseLine_ID);
            }
        }
    }

    public void saveItem(RAppExpenseItem item, String sTrx) {
        if (item.getM_Product_ID() <= 0) {
            return;
        }
        if (item.isMarkedForDelete()) {
            if (item.isNewItem() || item.getS_TimeExpenseLine_ID() <= 0) {
                return;
            }
            X_S_TimeExpenseLine mTELine = this.getTimeExpenseLine(item.getS_TimeExpenseLine_ID(), sTrx);
            if (mTELine != null) {
                mTELine.deleteEx(false);
            }
        } else {
            ResourceAppItem appItem = item.getAppItem();
            int S_TimeExpenseLine_ID = this.createOrUpdateTimeExpenseLine(appItem.getR_Request_ID(), appItem.getResourceAD_User_ID(), item.getS_TimeExpenseLine_ID(), appItem.getAppDate(), item.getM_Product_ID(), item.getQty(), item.getExpenseAmt(), false, sTrx);
            if (S_TimeExpenseLine_ID > 0 && item.isNewItem()) {
                item.setIsNewItem(false);
                item.setS_TimeExpenseLine_ID(S_TimeExpenseLine_ID);
            }
        }
    }

    public void saveItem(AppointmentNotesItem item, String sTrx) {
        MRequest mReq = ModelFactory.getRequest(this.getCtx(), item.getR_Request_ID(), sTrx);
        MNTMRequest.setWorkDone(mReq, item.getWorkDone());
        MNTMRequest.setDefectOrNotes(mReq, item.getDefectOrNote());
        MNTMRequest.setInternalNotes(mReq, item.getInternalNote());
        MNTMRequest.setCustomerSatisfaction(mReq, item.getCustomerSatisfaction());
        MNTMRequest.setCustomerSatisfactionNotes(mReq, item.getCustomerSatisfactionNote());
        mReq.saveEx();
    }

    public int getS_TimeExpense_ID(int AD_User_ID, Timestamp tsDate, String sTrx) {
        return MNTTimeExpenseLine.getS_TimeExpense_ID(this.getCtx(), AD_User_ID, tsDate, sTrx);
    }

    public int getNextLineNo(int S_TimeExpense_ID, String sTrx) {
        return DB.getSQLValue(sTrx, "SELECT NVL(MAX(Line),0)+10 AS DefaultValue FROM S_TimeExpenseLine WHERE S_TimeExpense_ID=?", S_TimeExpense_ID);
    }

    public int getNextPrjLineNo(int C_Project_ID, String sTrx) {
        return DB.getSQLValue(sTrx, "SELECT NVL(MAX(Line),0)+10 AS DefaultValue FROM C_ProjectLine WHERE C_Project_ID=?", C_Project_ID);
    }

    public X_S_TimeExpenseLine getTimeExpenseLine(int S_TimeExpenseLine_ID, String sTrx) {
        Query qTELine = new Query(this.getCtx(), "S_TimeExpenseLine", "S_TimeExpenseLine_ID = ?", sTrx);
        X_S_TimeExpenseLine mTELine = (X_S_TimeExpenseLine)qTELine.setParameters(S_TimeExpenseLine_ID).first();
        return mTELine;
    }

    public X_C_ProjectLine getProjectLine(int C_ProjectLine_ID, String sTrx) {
        Query qTELine = new Query(this.getCtx(), "C_ProjectLine", "C_ProjectLine_ID = ?", sTrx);
        X_C_ProjectLine mPLine = (X_C_ProjectLine)qTELine.setParameters(C_ProjectLine_ID).first();
        return mPLine;
    }

    public X_C_ProjectLine getExpenseProjectLine(int C_Project_ID, int M_Product_ID, String sTrx) {
        Query qTELine = new Query(this.getCtx(), "C_ProjectLine", "C_Project_ID = ? AND M_Product_ID = ?", sTrx);
        qTELine.setOnlyActiveRecords(true).setApplyAccessFilter(true);
        X_C_ProjectLine mPLine = (X_C_ProjectLine)qTELine.setParameters(C_Project_ID, M_Product_ID).first();
        return mPLine;
    }

    public MProject getProject(int R_Request_ID, String sTrx) {
        Query qPrj = new Query(this.getCtx(), "C_Project", "C_Project_ID in (SELECT C_Project_ID FROM R_Request WHERE R_Request.R_Request_ID = ?)", sTrx);
        MProject mPrj = (MProject)qPrj.setParameters(R_Request_ID).first();
        return mPrj;
    }

    public MInventory getInventory(int R_Request_ID, String sTrx) {
        Query qInv = new Query(this.getCtx(), "M_Inventory", "C_Project_ID in (SELECT C_Project_ID FROM R_Request WHERE R_Request.R_Request_ID = ?)", sTrx);
        MInventory mInv = (MInventory)qInv.setParameters(R_Request_ID).first();
        return mInv;
    }

    public X_R_RequestAsset getRequestAsset(int R_RequestAsset_ID, String sTrx) {
        Query qRAsset = new Query(this.getCtx(), "R_RequestAsset", "R_RequestAsset_ID = ?", sTrx);
        X_R_RequestAsset mRAsset = (X_R_RequestAsset)qRAsset.setParameters(R_RequestAsset_ID).first();
        return mRAsset;
    }

    protected int createOrUpdateTimeExpenseLine(int R_Request_ID, int AD_User_ID, int S_TimeExpenseLine_ID, Timestamp tsDate, int M_Product_ID, BigDecimal bdQty, BigDecimal bdValue, boolean bIsTimeReport, String sTrx) {
        X_S_TimeExpenseLine mTELine = null;
        BigDecimal bdOriginalQty = BigDecimal.ZERO;
        if (bdQty == null) {
            bdQty = BigDecimal.ZERO;
        }
        if (bdValue == null) {
            bdValue = BigDecimal.ZERO;
        }
        if (bdQty.signum() == 0 && bdValue.signum() == 0) {
            if (S_TimeExpenseLine_ID > 0 && (mTELine = this.getTimeExpenseLine(S_TimeExpenseLine_ID, sTrx)) != null) {
                mTELine.delete(false);
            }
            return -1;
        }
        MRequest rq = ModelFactory.getRequest(this.getCtx(), R_Request_ID, sTrx);
        if (S_TimeExpenseLine_ID > 0) {
            mTELine = this.getTimeExpenseLine(S_TimeExpenseLine_ID, sTrx);
            bdOriginalQty = mTELine.getQty();
        } else {
            int S_TimeExpense_ID = this.getS_TimeExpense_ID(AD_User_ID, tsDate, sTrx);
            mTELine = new MTimeExpenseLine(this.getCtx(), 0, sTrx);
            mTELine.setS_TimeExpense_ID(S_TimeExpense_ID);
            mTELine.setLine(this.getNextLineNo(S_TimeExpense_ID, sTrx));
            mTELine.setDateExpense(TimeUtil.getDay(tsDate));
            if (rq.getC_BPartner_ID() > 0) {
                mTELine.setC_BPartner_ID(rq.getC_BPartner_ID());
            }
            if (rq.getC_Project_ID() > 0) {
                mTELine.setC_Project_ID(rq.getC_Project_ID());
            }
            MNTTimeExpenseLine.setR_Request_ID(mTELine, R_Request_ID);
            if (bIsTimeReport) {
                mTELine.setM_Product_ID(M_Product_ID);
                mTELine.setC_UOM_ID(101);
                mTELine.setIsTimeReport(true);
            }
        }
        mTELine.setQty(bdQty);
        MProject pj = new MProject(this.getCtx(), rq.getC_Project_ID(), sTrx);
        mTELine.setC_Currency_ID(pj.getC_Currency_ID());
        if (!bIsTimeReport) {
            mTELine.setExpenseAmt(bdValue);
            mTELine.setConvertedAmt(bdValue);
            mTELine.setM_Product_ID(M_Product_ID);
            MProduct mProd = MProduct.get(this.getCtx(), M_Product_ID);
            mTELine.setC_UOM_ID(mProd.getC_UOM_ID());
        } else {
            MTimeExpense mte = new MTimeExpense(this.getCtx(), mTELine.getS_TimeExpense_ID(), sTrx);
            MPriceList mntpriceList = new MPriceList(this.getCtx(), mte.getM_PriceList_ID(), sTrx);
            MPriceListVersion mntvpricel = mntpriceList.getPriceListVersion(mTELine.getDateExpense());
            MProductPrice mpp = MProductPrice.get(this.getCtx(), mntvpricel.getM_PriceList_Version_ID(), mTELine.getM_Product_ID(), sTrx);
            if (mpp == null) {
                MProduct mProd = MProduct.get(this.getCtx(), mTELine.getM_Product_ID());
                throw new AdempiereException("No @M_ProductPrice_ID@: " + mProd.getName());
            }
            mTELine.set_ValueOfColumn("TimeCost", (Object)bdQty.multiply(mpp.getPriceStd()));
        }
        mTELine.saveEx(sTrx);
        return mTELine.getS_TimeExpenseLine_ID();
    }

    public void saveItem(int R_Request_ID, ProductItem item, String sTrx) {
        if (item.isMarkedForDelete()) {
            if (item.isNewItem() || item.getC_ProjectLine_ID() <= 0) {
                return;
            }
            X_C_ProjectLine line = this.getProjectLine(item.getC_ProjectLine_ID(), sTrx);
            if (line != null) {
                line.delete(false);
            }
        } else {
            X_C_ProjectLine line = null;
            MProject mProject = null;
            if (item.getC_ProjectLine_ID() > 0) {
                line = this.getProjectLine(item.getC_ProjectLine_ID(), sTrx);
            } else if (!(item.getM_Product_ID() <= 0 || item.isNewItem() && item.getCommittedQty().signum() <= 0 || (mProject = this.getProject(R_Request_ID, sTrx)) == null)) {
                MProduct mProd = MProduct.get(this.getCtx(), item.getM_Product_ID());
                line = new MProjectLine(mProject);
                line.setDescription(mProd.getDescription());
                line.setPlannedQty(Env.ZERO);
            }
            if (line != null) {
                boolean bIsCurrentMaterialIncluded;
                line.setM_Product_ID(item.getM_Product_ID());
                line.setCommittedQty(item.getCommittedQty());
                boolean bIsMaterialIncluded = item.isInGuarantee() || item.isInContract();
                boolean bl = bIsCurrentMaterialIncluded = MNTMProjectLine.isInGuarantee(line) || MNTMProjectLine.isInContract(line);
                if (bIsMaterialIncluded != bIsCurrentMaterialIncluded || item.isNewItem()) {
                    if (item.isInGuarantee() || item.isInContract()) {
                        line.setPlannedPrice(BigDecimal.ZERO);
                    } else {
                        if (mProject == null) {
                            mProject = ModelFactory.getProject(this.getCtx(), line.getC_Project_ID(), sTrx);
                        }
                        MProductPricing mProductPricing = new MProductPricing(line.getM_Product_ID(), mProject.getC_BPartner_ID(), line.getCommittedQty(), true);
                        mProductPricing.setM_PriceList_ID(mProject.getM_PriceList_ID());
                        mProductPricing.setPriceDate(mProject.getDateContract());
                        line.setPlannedPrice(mProductPricing.getPriceStd());
                    }
                }
                MNTMProjectLine.setIsInGuarantee(line, item.isInGuarantee());
                MNTMProjectLine.setIsInContract(line, item.isInContract());
                line.saveEx(sTrx);
                item.setIsNewItem(false);
                item.setC_ProjectLine_ID(line.getC_ProjectLine_ID());
            }
        }
    }

    public void saveItem(int R_Request_ID, AssetItem item, String sTrx) {
        if (item.isMarkedForDelete()) {
            X_R_RequestAsset mRAsset;
            if (item.isNewItem()) {
                return;
            }
            if (item.isHeaderAsset()) {
                MRequest mRequest = ModelFactory.getRequest(this.getCtx(), R_Request_ID, sTrx);
                mRequest.setA_Asset_ID(0);
                mRequest.saveEx();
            } else if (item.getR_RequestAsset_ID() > 0 && (mRAsset = this.getRequestAsset(item.getR_RequestAsset_ID(), sTrx)) != null) {
                mRAsset.delete(false);
            }
        } else if (!item.isHeaderAsset()) {
            X_R_RequestAsset mRAsset = null;
            if (item.getR_RequestAsset_ID() > 0) {
                mRAsset = this.getRequestAsset(item.getR_RequestAsset_ID(), sTrx);
            } else {
                mRAsset = new X_R_RequestAsset(this.getCtx(), 0, sTrx);
                mRAsset.setR_Request_ID(R_Request_ID);
            }
            mRAsset.setA_Asset_ID(item.getA_Asset_ID());
            mRAsset.setM_Product_ID(item.getM_Product_ID());
            mRAsset.saveEx(sTrx);
        }
    }

    public int getAppointmentPrintProcess() {
        String sSQL = "SELECT AD_Process_ID FROM AD_Process WHERE Value = ? ";
        int AD_Process_ID = DB.getSQLValue(null, sSQL, APP_PRINT_PROCESS_NAME);
        return AD_Process_ID;
    }
}

