/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.soap;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.HeaderConstants;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.AuthTokenException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.service.AuthProvider;
import com.zimbra.cs.session.Session;
import com.zimbra.cs.session.SessionCache;
import com.zimbra.cs.session.SoapSession;
import com.zimbra.soap.ProxyTarget;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.QName;
import org.mortbay.util.ajax.Continuation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZimbraSoapContext {
    private static Log sLog = LogFactory.getLog(ZimbraSoapContext.class);
    public static final int MAX_HOP_COUNT = 5;
    private ZAuthToken mRawAuthToken;
    private AuthToken mAuthToken;
    private String mAuthTokenAccountId;
    private String mRequestedAccountId;
    private SoapProtocol mRequestProtocol;
    private SoapProtocol mResponseProtocol;
    private boolean mChangeConstraintType;
    private int mMaximumChangeId;
    private boolean mSessionEnabled;
    private boolean mSessionProxied;
    private SessionInfo mSessionInfo;
    private boolean mUnqualifiedItemIds;
    private boolean mWaitForNotifications;
    private boolean mCanceledWaitForNotifications;
    private Continuation mContinuation;
    private ProxyTarget mProxyTarget;
    private boolean mIsProxyRequest;
    private int mHopCount;
    private boolean mMountpointTraversed;
    private String mUserAgent;
    private String mRequestIP;

    public ZimbraSoapContext(AuthToken authToken, String accountId, SoapProtocol reqProtocol, SoapProtocol respProtocol) throws ServiceException {
        this(authToken, accountId, reqProtocol, respProtocol, 0);
    }

    public ZimbraSoapContext(AuthToken authToken, String accountId, SoapProtocol reqProtocol, SoapProtocol respProtocol, int hopCount) throws ServiceException {
        this.mChangeConstraintType = true;
        this.mMaximumChangeId = -1;
        this.mCanceledWaitForNotifications = false;
        this.mAuthToken = authToken;
        this.mRawAuthToken = authToken.toZAuthToken();
        this.mAuthTokenAccountId = authToken.getAccountId();
        this.mRequestedAccountId = accountId;
        this.mRequestProtocol = reqProtocol;
        this.mResponseProtocol = respProtocol;
        this.mSessionEnabled = false;
        this.mHopCount = hopCount;
    }

    public ZimbraSoapContext(ZimbraSoapContext zsc) throws ServiceException {
        this(zsc, zsc.mRequestedAccountId);
    }

    public ZimbraSoapContext(ZimbraSoapContext zsc, String targetAccountId) throws ServiceException {
        this.mChangeConstraintType = true;
        this.mMaximumChangeId = -1;
        this.mCanceledWaitForNotifications = false;
        this.mRawAuthToken = zsc.mRawAuthToken;
        this.mAuthToken = zsc.mAuthToken;
        this.mAuthTokenAccountId = zsc.mAuthTokenAccountId;
        this.mRequestedAccountId = targetAccountId;
        this.mRequestProtocol = zsc.mRequestProtocol;
        this.mResponseProtocol = zsc.mResponseProtocol;
        this.mSessionInfo = zsc.mSessionInfo;
        this.mSessionEnabled = zsc.mSessionEnabled;
        this.mSessionProxied = true;
        this.mUnqualifiedItemIds = zsc.mUnqualifiedItemIds;
        this.mMountpointTraversed = zsc.mMountpointTraversed;
        this.setHopCount(zsc.mHopCount + 1);
    }

    public ZimbraSoapContext(Element ctxt, Map<String, Object> context, SoapProtocol requestProtocol) throws ServiceException {
        Element userAgent;
        Element notify;
        String targetServerId;
        Element change;
        Element eAccount;
        Provisioning prov;
        block34: {
            Element eFormat;
            this.mChangeConstraintType = true;
            this.mMaximumChangeId = -1;
            this.mCanceledWaitForNotifications = false;
            if (ctxt != null && !ctxt.getQName().equals(HeaderConstants.CONTEXT)) {
                throw new IllegalArgumentException("expected ctxt, got: " + ctxt.getQualifiedName());
            }
            prov = Provisioning.getInstance();
            this.mResponseProtocol = this.mRequestProtocol = requestProtocol;
            Element element = eFormat = ctxt == null ? null : ctxt.getOptionalElement("format");
            if (eFormat != null) {
                String format = eFormat.getAttribute("type", "xml");
                if (format.equals("xml") && requestProtocol == SoapProtocol.SoapJS) {
                    this.mResponseProtocol = SoapProtocol.Soap12;
                } else if (format.equals("js")) {
                    this.mResponseProtocol = SoapProtocol.SoapJS;
                }
            }
            try {
                this.mAuthToken = AuthProvider.getAuthToken(ctxt, context);
                if (this.mAuthToken != null) {
                    this.mRawAuthToken = this.mAuthToken.toZAuthToken();
                    if (this.mAuthToken.isExpired()) {
                        throw ServiceException.AUTH_EXPIRED();
                    }
                    this.mAuthTokenAccountId = this.mAuthToken.getAccountId();
                }
            }
            catch (AuthTokenException e) {
                this.mAuthToken = null;
                if (!sLog.isDebugEnabled()) break block34;
                sLog.debug((Object)("ZimbraContext AuthToken error: " + e.getMessage()), e);
            }
        }
        Element element = eAccount = ctxt == null ? null : ctxt.getOptionalElement("account");
        if (eAccount != null) {
            Account account;
            String key = eAccount.getAttribute("by", null);
            String value = eAccount.getText();
            if (key == null) {
                this.mRequestedAccountId = null;
            } else if (key.equals("name")) {
                account = prov.get(Provisioning.AccountBy.name, value, this.mAuthToken);
                if (account == null) {
                    throw ServiceException.DEFEND_ACCOUNT_HARVEST(value);
                }
                this.mRequestedAccountId = account.getId();
            } else if (key.equals("id")) {
                account = prov.get(Provisioning.AccountBy.id, value, this.mAuthToken);
                if (account == null) {
                    throw ServiceException.DEFEND_ACCOUNT_HARVEST(value);
                }
                this.mRequestedAccountId = value;
            } else {
                throw ServiceException.INVALID_REQUEST("unknown value for by: " + key, null);
            }
            this.mMountpointTraversed = eAccount.getAttributeBool("link", false);
        } else {
            this.mRequestedAccountId = null;
        }
        if (ctxt != null) {
            int hopCount = (int)Math.max(ctxt.getAttributeLong("hops", 0L), 0L);
            this.setHopCount(hopCount);
        }
        Element element2 = change = ctxt == null ? null : ctxt.getOptionalElement("change");
        if (change != null) {
            try {
                String token = change.getAttribute("token", "-1");
                int delimiter = token.indexOf(45);
                this.mMaximumChangeId = Integer.parseInt(delimiter < 1 ? token : token.substring(0, delimiter));
                this.mChangeConstraintType = change.getAttribute("type", "mod").equals("mod");
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        this.mIsProxyRequest = false;
        String string = targetServerId = ctxt == null ? null : ctxt.getAttribute("targetServer", null);
        if (targetServerId != null) {
            HttpServletRequest req = (HttpServletRequest)context.get("servlet.request");
            if (req != null) {
                this.mProxyTarget = new ProxyTarget(targetServerId, this.mAuthToken, req);
                this.mIsProxyRequest = !this.mProxyTarget.isTargetLocal();
            } else {
                sLog.warn("Missing SERVLET_REQUEST key in request context");
            }
        }
        int seqNo = -1;
        Element element3 = notify = ctxt == null ? null : ctxt.getOptionalElement("notify");
        if (notify != null) {
            seqNo = (int)notify.getAttributeLong("seq", 0L);
        }
        if (ctxt != null) {
            Element session;
            boolean suppress = ctxt.getOptionalElement("nonotify") != null;
            if (!(suppress |= ctxt.getOptionalElement("nosession") != null) && (session = ctxt.getOptionalElement("session")) != null) {
                this.mSessionEnabled = true;
                this.mSessionProxied = session.getAttributeBool("proxy", false);
                String sessionId = null;
                sessionId = session.getTextTrim();
                if ("".equals(sessionId)) {
                    sessionId = session.getAttribute("id", null);
                }
                if (sessionId != null) {
                    this.mSessionInfo = new SessionInfo(sessionId, (int)session.getAttributeLong("seq", seqNo), false);
                }
            }
        }
        this.mUnqualifiedItemIds = ctxt != null && ctxt.getOptionalElement("noqualify") != null;
        Element element4 = userAgent = ctxt == null ? null : ctxt.getOptionalElement("userAgent");
        if (userAgent != null) {
            String name = userAgent.getAttribute("name", null);
            String version = userAgent.getAttribute("version", null);
            if (!StringUtil.isNullOrEmpty(name)) {
                this.mUserAgent = name;
                if (!StringUtil.isNullOrEmpty(version)) {
                    this.mUserAgent = this.mUserAgent + "/" + version;
                }
            }
        }
        this.mRequestIP = (String)context.get("request.ip");
    }

    public void recordMountpointTraversal() throws ServiceException {
        if (this.mMountpointTraversed) {
            throw ServiceException.PERM_DENIED("cannot mount a mountpoint");
        }
        this.mMountpointTraversed = true;
    }

    public String toString() {
        String sessionPart = this.mSessionEnabled ? ", session=" + this.mSessionInfo : "";
        return "LC(mbox=" + this.mAuthTokenAccountId + sessionPart + ")";
    }

    public String getRequestedAccountId() {
        return this.mRequestedAccountId != null ? this.mRequestedAccountId : this.mAuthTokenAccountId;
    }

    public String getAuthtokenAccountId() {
        return this.mAuthTokenAccountId;
    }

    void setAuthToken(AuthToken auth) {
        this.mAuthToken = auth;
        this.mAuthTokenAccountId = auth.getAccountId();
    }

    public boolean isDelegatedRequest() {
        return this.mAuthTokenAccountId != null && !this.mAuthTokenAccountId.equalsIgnoreCase(this.getRequestedAccountId());
    }

    public boolean isUsingAdminPrivileges() {
        return this.mAuthToken != null && AuthToken.isAnyAdmin(this.mAuthToken);
    }

    public ZimbraSoapContext disableNotifications() {
        this.mSessionEnabled = false;
        this.mSessionInfo = null;
        return this;
    }

    public boolean isNotificationEnabled() {
        return this.mSessionEnabled;
    }

    public boolean isSessionProxied() {
        return this.mSessionProxied;
    }

    SessionInfo getSessionInfo() {
        return this.mSessionInfo;
    }

    public SessionInfo setProxySession(String sessionId) {
        this.mSessionInfo = !this.mSessionEnabled || sessionId == null ? null : new SessionInfo(sessionId, 0, false);
        this.mSessionProxied = true;
        return this.mSessionInfo;
    }

    SessionInfo recordNewSession(String sessionId) {
        if (!this.mSessionEnabled || sessionId == null) {
            this.mSessionInfo = null;
        } else if (this.mSessionInfo == null) {
            this.mSessionInfo = new SessionInfo(sessionId, 0, true);
        } else {
            this.mSessionInfo.sessionId = sessionId;
            this.mSessionInfo.created = true;
        }
        return this.mSessionInfo;
    }

    protected void clearSessionInfo() {
        this.mSessionInfo = null;
        this.mSessionProxied = false;
    }

    public boolean hasCreatedSession() {
        return this.mSessionInfo != null && this.mSessionInfo.created;
    }

    public boolean hasSession() {
        return this.mSessionInfo != null;
    }

    public boolean beginWaitForNotifications(Continuation continuation, boolean includeDelegates) throws ServiceException {
        this.mWaitForNotifications = true;
        this.mContinuation = continuation;
        Session session = SessionCache.lookup(this.mSessionInfo.sessionId, this.mAuthTokenAccountId);
        if (!(session instanceof SoapSession)) {
            return false;
        }
        SoapSession ss = (SoapSession)session;
        SoapSession.RegisterNotificationResult result = ss.registerNotificationConnection(this.mSessionInfo.getPushChannel(!includeDelegates));
        switch (result) {
            case NO_NOTIFY: {
                return false;
            }
            case DATA_READY: {
                return false;
            }
            case BLOCKING: {
                return true;
            }
        }
        return false;
    }

    public synchronized void signalNotification(boolean canceled) {
        this.mWaitForNotifications = false;
        this.mCanceledWaitForNotifications = canceled;
        this.mContinuation.resume();
    }

    public synchronized boolean isCanceledWaitForNotifications() {
        return this.mCanceledWaitForNotifications;
    }

    public synchronized boolean waitingForNotifications() {
        return this.mWaitForNotifications;
    }

    public Element toProxyCtxt(SoapProtocol proto) {
        Element ctxt = proto.getFactory().createElement(HeaderConstants.CONTEXT);
        ctxt.addAttribute("hops", this.mHopCount);
        String pxyAuthToken = this.mAuthToken.getProxyAuthToken();
        if (pxyAuthToken != null) {
            new ZAuthToken(pxyAuthToken).encodeSoapCtxt(ctxt);
        } else if (this.mRawAuthToken != null) {
            this.mRawAuthToken.encodeSoapCtxt(ctxt);
        }
        if (this.mResponseProtocol != this.mRequestProtocol) {
            ctxt.addElement("format").addAttribute("type", this.mResponseProtocol == SoapProtocol.SoapJS ? "js" : "xml");
        }
        if (!this.mSessionEnabled) {
            ctxt.addUniqueElement("nosession");
        } else if (this.mSessionInfo != null) {
            ZimbraSoapContext.encodeSession(ctxt, this.mSessionInfo.sessionId, null).addAttribute("proxy", true);
        } else {
            ctxt.addUniqueElement("session").addAttribute("proxy", true);
        }
        Element eAcct = ctxt.addElement("account").addAttribute("link", this.mMountpointTraversed);
        if (this.mRequestedAccountId != null && !this.mRequestedAccountId.equalsIgnoreCase(this.mAuthTokenAccountId)) {
            eAcct.addAttribute("by", "id").setText(this.mRequestedAccountId);
        }
        if (this.mUnqualifiedItemIds) {
            ctxt.addUniqueElement("noqualify");
        }
        return ctxt;
    }

    public static Element encodeSession(Element parent, String sessionId, Session.Type sessionType) {
        Element oldSession = parent.getOptionalElement("session");
        if (oldSession != null) {
            oldSession.detach();
        }
        String typeStr = sessionType == Session.Type.ADMIN ? "admin" : null;
        Element eSession = parent.addUniqueElement("session");
        eSession.addAttribute("type", typeStr).addAttribute("id", sessionId).setText(sessionId);
        return eSession;
    }

    public SoapProtocol getRequestProtocol() {
        return this.mRequestProtocol;
    }

    public SoapProtocol getResponseProtocol() {
        return this.mResponseProtocol;
    }

    public Element createElement(String name) {
        return this.mResponseProtocol.getFactory().createElement(name);
    }

    public Element createElement(QName qname) {
        return this.mResponseProtocol.getFactory().createElement(qname);
    }

    public Element createRequestElement(String name) {
        return this.mRequestProtocol.getFactory().createElement(name);
    }

    public Element createRequestElement(QName qname) {
        return this.mRequestProtocol.getFactory().createElement(qname);
    }

    public AuthToken getAuthToken() {
        return this.mAuthToken;
    }

    public ZAuthToken getRawAuthToken() {
        return this.mRawAuthToken;
    }

    public ProxyTarget getProxyTarget() {
        return this.mProxyTarget;
    }

    public boolean isProxyRequest() {
        return this.mIsProxyRequest;
    }

    public String getUserAgent() {
        return this.mUserAgent;
    }

    public String getRequestIP() {
        return this.mRequestIP;
    }

    boolean getChangeConstraintType() {
        return this.mChangeConstraintType;
    }

    int getChangeConstraintLimit() {
        return this.mMaximumChangeId;
    }

    public boolean wantsUnqualifiedIds() {
        return this.mUnqualifiedItemIds;
    }

    private void setHopCount(int hopCount) throws ServiceException {
        if (hopCount > 5) {
            throw ServiceException.TOO_MANY_HOPS(this.mRequestedAccountId);
        }
        this.mHopCount = hopCount;
    }

    public int getHopCount() {
        return this.mHopCount;
    }

    public void resetProxyAuthToken() {
        this.mAuthToken.resetProxyAuthToken();
        this.mRawAuthToken.resetProxyAuthToken();
    }

    final class SessionInfo {
        String sessionId;
        int sequence;
        boolean created;

        SessionInfo(String id, int seqNo, boolean newSession) {
            this.sessionId = id;
            this.sequence = seqNo;
            this.created = newSession;
        }

        public String toString() {
            return this.sessionId;
        }

        public SoapSession.PushChannel getPushChannel(boolean localChangesOnly) {
            return new SoapPushChannel(localChangesOnly);
        }

        private class SoapPushChannel
        implements SoapSession.PushChannel {
            private boolean mLocalChangesOnly;

            SoapPushChannel(boolean localOnly) {
                this.mLocalChangesOnly = localOnly;
            }

            public void closePushChannel() {
                ZimbraSoapContext.this.signalNotification(true);
            }

            public int getLastKnownSequence() {
                return SessionInfo.this.sequence;
            }

            public ZimbraSoapContext getSoapContext() {
                return ZimbraSoapContext.this;
            }

            public boolean localChangesOnly() {
                return this.mLocalChangesOnly;
            }

            public void notificationsReady() {
                ZimbraSoapContext.this.signalNotification(false);
            }
        }
    }
}

