/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.soap;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.util.BufferStream;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.RemoteIP;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.common.util.ZimbraServletOutputStream;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.servlet.ZimbraServlet;
import com.zimbra.cs.stats.ZimbraPerf;
import com.zimbra.cs.util.Zimbra;
import com.zimbra.soap.DocumentService;
import com.zimbra.soap.SoapEngine;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.map.LazyMap;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.ProtocolException;
import org.apache.log4j.PropertyConfigurator;

public class SoapServlet
extends ZimbraServlet {
    private static final long serialVersionUID = 38710345271877593L;
    private static final String PARAM_ENGINE_HANDLER = "engine.handler.";
    public static final String ZIMBRA_AUTH_TOKEN = "zimbra.authToken";
    public static final String SERVLET_CONTEXT = "servlet.context";
    public static final String SERVLET_REQUEST = "servlet.request";
    public static final String SERVLET_RESPONSE = "servlet.response";
    public static final String IS_RESUMED_REQUEST = "zimbra.resumedRequest";
    private static Factory sListFactory = new Factory(){

        public Object create() {
            return new ArrayList();
        }
    };
    private static Map<String, List<DocumentService>> sExtraServices = LazyMap.decorate(new HashMap(), (Factory)sListFactory);
    private static Log sLog = LogFactory.getLog(SoapServlet.class);
    private SoapEngine mEngine;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ServletException {
        String cname;
        long watch = LC.zimbra_log4j_properties_watch.longValue();
        if (watch > 0L) {
            PropertyConfigurator.configureAndWatch((String)LC.zimbra_log4j_properties.value(), (long)watch);
        } else {
            PropertyConfigurator.configure((String)LC.zimbra_log4j_properties.value());
        }
        String name = this.getServletName();
        ZimbraLog.soap.info("Servlet " + name + " starting up");
        super.init();
        this.mEngine = new SoapEngine();
        int i = 0;
        while ((cname = this.getInitParameter(PARAM_ENGINE_HANDLER + i)) != null) {
            this.loadHandler(cname);
            ++i;
        }
        Map<String, List<DocumentService>> map = sExtraServices;
        synchronized (map) {
            List<DocumentService> services = sExtraServices.get(this.getServletName());
            for (DocumentService service : services) {
                this.addService(service);
                ++i;
            }
        }
        this.mEngine.getDocumentDispatcher().clearSoapWhiteList();
        if (i == 0) {
            throw new ServletException("Must specify at least one handler engine.handler." + i);
        }
        try {
            Zimbra.startup();
        }
        catch (OutOfMemoryError e) {
            Zimbra.halt("out of memory", e);
        }
        catch (Throwable t) {
            ZimbraLog.soap.fatal((Object)"Unable to start servlet", t);
            throw new UnavailableException(t.getMessage());
        }
    }

    public void destroy() {
        String name = this.getServletName();
        ZimbraLog.soap.info("Servlet " + name + " shutting down");
        try {
            Zimbra.shutdown();
        }
        catch (ServiceException e) {
            ZimbraLog.soap.error((Object)("ServiceException while shutting down servlet " + name), e);
        }
        catch (RuntimeException e) {
            ZimbraLog.soap.error((Object)("Unchecked Exception while shutting down servlet " + name), e);
            throw e;
        }
        this.mEngine = null;
        super.destroy();
    }

    private void loadHandler(String cname) throws ServletException {
        Object dispatcher;
        Class<?> dispatcherClass = null;
        try {
            dispatcherClass = Class.forName(cname);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ServletException("can't find handler initializer class " + cname, (Throwable)cnfe);
        }
        catch (OutOfMemoryError e) {
            Zimbra.halt("out of memory", e);
        }
        catch (Throwable t) {
            throw new ServletException("can't find handler initializer class " + cname, t);
        }
        try {
            dispatcher = dispatcherClass.newInstance();
        }
        catch (InstantiationException ie) {
            throw new ServletException("can't instantiate class " + cname, (Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            throw new ServletException("can't instantiate class " + cname, (Throwable)iae);
        }
        if (!(dispatcher instanceof DocumentService)) {
            throw new ServletException("class not an instanceof HandlerInitializer: " + cname);
        }
        DocumentService hi = (DocumentService)dispatcher;
        this.addService(hi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addService(String servletName, DocumentService service) {
        Map<String, List<DocumentService>> map = sExtraServices;
        synchronized (map) {
            ZimbraServlet servlet = ZimbraServlet.getServlet(servletName);
            if (servlet != null) {
                ((SoapServlet)servlet).addService(service);
            } else {
                sLog.debug("addService(" + servletName + ", " + StringUtil.getSimpleClassName(service) + "): servlet has not been initialized");
                List<DocumentService> services = sExtraServices.get(servletName);
                services.add(service);
            }
        }
    }

    private void addService(DocumentService service) {
        ZimbraLog.soap.info("Adding service " + StringUtil.getSimpleClassName(service) + " to " + this.getServletName());
        service.registerHandlers(this.mEngine.getDocumentDispatcher());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ZimbraLog.clearContext();
        long startTime = ZimbraPerf.STOPWATCH_SOAP.start();
        try {
            this.doWork(req, resp);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            ZimbraLog.clearContext();
            ZimbraPerf.STOPWATCH_SOAP.stop(startTime);
            throw throwable;
        }
        ZimbraLog.clearContext();
        ZimbraPerf.STOPWATCH_SOAP.stop(startTime);
    }

    private void doWork(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        int len = req.getContentLength();
        boolean isResumed = true;
        byte[] buffer = (byte[])req.getAttribute("com.zimbra.request.buffer");
        if (buffer == null) {
            boolean success;
            isResumed = false;
            int maxSize = 0;
            try {
                maxSize = Provisioning.getInstance().getLocalServer().getIntAttr("zimbraSoapRequestMaxSize", 0);
            }
            catch (ServiceException e) {
                ZimbraLog.soap.warn("Unable to look up %s.  Not limiting the request size.", (Object)"zimbraSoapRequestMaxSize", e);
            }
            if (maxSize <= 0) {
                maxSize = Integer.MAX_VALUE;
            }
            if (len > maxSize) {
                success = false;
            } else {
                BufferStream bs = new BufferStream(len, maxSize, maxSize);
                int in = (int)bs.readFrom((InputStream)req.getInputStream(), len >= 0 ? (long)len : Integer.MAX_VALUE);
                if (len > 0 && in < len) {
                    throw new EOFException("SOAP content truncated " + in + "!=" + len);
                }
                success = in <= maxSize;
                buffer = bs.toByteArray();
            }
            if (!success) {
                String sizeString = len < 0 ? "" : " size " + len;
                String msg = String.format("Request%s exceeded limit of %d bytes set for %s.", sizeString, maxSize, "zimbraSoapRequestMaxSize");
                ServiceException e = ServiceException.INVALID_REQUEST(msg, null);
                ZimbraLog.soap.warn((Object)null, e);
                Element fault = SoapProtocol.Soap12.soapFault(e);
                Element envelope = SoapProtocol.Soap12.soapEnvelope(fault);
                this.sendResponse(req, resp, envelope);
                return;
            }
            req.setAttribute("com.zimbra.request.buffer", (Object)buffer);
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put(SERVLET_CONTEXT, this.getServletContext());
        context.put(SERVLET_REQUEST, req);
        context.put(SERVLET_RESPONSE, resp);
        RemoteIP remoteIp = new RemoteIP(req, ZimbraServlet.getTrustedIPs());
        context.put("soap.request.ip", remoteIp.getClientIP());
        context.put("orig.request.ip", remoteIp.getOrigIP());
        context.put("request.ip", remoteIp.getRequestIP());
        remoteIp.addToLoggingContext();
        if (isResumed) {
            context.put(IS_RESUMED_REQUEST, "1");
        }
        Element envelope = null;
        try {
            envelope = this.mEngine.dispatch(req.getRequestURI(), buffer, context);
        }
        catch (Throwable e) {
            Boolean logged;
            if (e instanceof OutOfMemoryError) {
                Zimbra.halt("handler exception", e);
            }
            if (ZimbraLog.soap.isDebugEnabled() && ((logged = (Boolean)context.get("soap.request.logged")) == null || !logged.booleanValue())) {
                ZimbraLog.soap.debug("SOAP request:\n" + new String(buffer, "utf8"));
            }
            if (e.getClass().getName().equals("org.mortbay.jetty.RetryRequest")) {
                throw (RuntimeException)e;
            }
            ZimbraLog.soap.warn((Object)"handler exception", e);
            Element fault = SoapProtocol.Soap12.soapFault(ServiceException.FAILURE(e.toString(), e));
            envelope = SoapProtocol.Soap12.soapEnvelope(fault);
        }
        if (ZimbraLog.soap.isDebugEnabled()) {
            ZimbraLog.soap.debug("SOAP response: \n" + envelope.prettyPrint());
        }
        this.sendResponse(req, resp, envelope);
    }

    private int soapResponseBufferSize() {
        String val = LC.soap_response_buffer_size.value();
        if (val == null || val.length() == 0) {
            return -1;
        }
        return LC.soap_response_buffer_size.intValue();
    }

    private void sendResponse(HttpServletRequest req, HttpServletResponse resp, Element envelope) throws IOException {
        int responseBufferSize;
        SoapProtocol soapProto = SoapProtocol.determineProtocol(envelope);
        int statusCode = soapProto.hasFault(envelope) ? 500 : 200;
        boolean chunkingDisabled = LC.soap_response_chunked_transfer_encoding_disabled.booleanValue();
        if (!chunkingDisabled) {
            String proto = req.getProtocol();
            try {
                HttpVersion httpVer = HttpVersion.parse(proto);
                chunkingDisabled = httpVer.lessEquals(HttpVersion.HTTP_1_0);
            }
            catch (ProtocolException e) {
                ZimbraLog.soap.warn((Object)("cannot parse http version in request: " + proto + ", http chunked transfer encoding disabled"), e);
                chunkingDisabled = true;
            }
        }
        if ((responseBufferSize = this.soapResponseBufferSize()) != -1) {
            resp.setBufferSize(responseBufferSize);
        }
        resp.setContentType(soapProto.getContentType());
        resp.setStatus(statusCode);
        if (chunkingDisabled) {
            byte[] soapBytes = envelope.toUTF8();
            resp.setContentLength(soapBytes.length);
            resp.getOutputStream().write(soapBytes);
        } else {
            ZimbraServletOutputStream out = new ZimbraServletOutputStream(resp.getOutputStream());
            envelope.output(out);
            out.flush();
        }
    }
}

