/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.soap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.HeaderConstants;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.soap.SoapParseException;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.soap.ZimbraNamespace;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.RedoLogProvider;
import com.zimbra.cs.service.admin.AdminAccessControl;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.session.Session;
import com.zimbra.cs.session.SessionCache;
import com.zimbra.cs.session.SoapSession;
import com.zimbra.cs.stats.ZimbraPerf;
import com.zimbra.cs.util.AccountUtil;
import com.zimbra.cs.util.Config;
import com.zimbra.cs.util.Zimbra;
import com.zimbra.soap.DocumentDispatcher;
import com.zimbra.soap.DocumentHandler;
import com.zimbra.soap.SoapContextExtension;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.ByteArrayInputStream;
import java.util.Map;
import org.dom4j.DocumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapEngine {
    public static final String A_REQUEST_CORRELATOR = "requestId";
    public static final String ZIMBRA_CONTEXT = "zimbra.context";
    public static final String ZIMBRA_ENGINE = "zimbra.engine";
    public static final String ZIMBRA_SESSION = "zimbra.session";
    public static final String REQUEST_IP = "request.ip";
    public static final String SOAP_REQUEST_IP = "soap.request.ip";
    public static final String SOAP_REQUEST_LOGGED = "soap.request.logged";
    public static final String ORIG_REQUEST_IP = "orig.request.ip";
    private static Log mLog = LogFactory.getLog(SoapEngine.class);
    private DocumentDispatcher mDispatcher = new DocumentDispatcher();

    private Element soapFaultEnv(SoapProtocol soapProto, String msg, ServiceException e) {
        this.logFault(msg, e);
        return soapProto.soapEnvelope(soapProto.soapFault(e));
    }

    private Element soapFault(SoapProtocol soapProto, String msg, ServiceException e) {
        this.logFault(msg, e);
        return soapProto.soapFault(e);
    }

    private void logFault(String msg, ServiceException e) {
        if (e.getCode().equals("service.AUTH_EXPIRED") || e.getCode().equals("service.AUTH_REQUIRED")) {
            StackTraceElement[] s = Thread.currentThread().getStackTrace();
            StackTraceElement callSite = s[4];
            e.setIdLabel(callSite);
            mLog.warn(e.getMessage() + ": " + msg);
            mLog.debug((Object)msg, e);
        } else {
            mLog.warn((Object)msg, e);
        }
    }

    private void logDebugSoapRequest(Map<String, Object> context, Element envelope) {
        Boolean logged;
        if (ZimbraLog.soap.isDebugEnabled() && ((logged = (Boolean)context.get(SOAP_REQUEST_LOGGED)) == null || !logged.booleanValue())) {
            ZimbraLog.soap.debug("SOAP request:\n" + envelope.prettyPrint());
            context.put(SOAP_REQUEST_LOGGED, Boolean.TRUE);
        }
    }

    public Element dispatch(String path, byte[] soapMessage, Map<String, Object> context) {
        if (soapMessage == null || soapMessage.length == 0) {
            SoapProtocol soapProto = SoapProtocol.Soap12;
            return this.soapFaultEnv(soapProto, "SOAP exception", ServiceException.PARSE_ERROR("empty request payload", null));
        }
        ByteArrayInputStream in = new ByteArrayInputStream(soapMessage);
        Element document = null;
        try {
            document = soapMessage[0] == 60 ? Element.parseXML(in) : Element.parseJSON(in);
        }
        catch (DocumentException de) {
            SoapProtocol soapProto = SoapProtocol.Soap12;
            return this.soapFaultEnv(soapProto, "SOAP exception", ServiceException.PARSE_ERROR(de.getMessage(), de));
        }
        catch (SoapParseException e) {
            SoapProtocol soapProto = SoapProtocol.SoapJS;
            return this.soapFaultEnv(soapProto, "SOAP exception", ServiceException.PARSE_ERROR(e.getMessage(), e));
        }
        Element resp = this.dispatch(path, document, context);
        this.logDebugSoapRequest(context, document);
        return resp;
    }

    private Element dispatch(String path, Element envelope, Map<String, Object> context) {
        SoapProtocol soapProto = SoapProtocol.determineProtocol(envelope);
        if (soapProto == null) {
            soapProto = SoapProtocol.Soap12;
            return this.soapFaultEnv(soapProto, "SOAP exception", ServiceException.INVALID_REQUEST("unable to determine SOAP version", null));
        }
        ZimbraSoapContext zsc = null;
        Element ectxt = soapProto.getHeader(envelope, HeaderConstants.CONTEXT);
        try {
            zsc = new ZimbraSoapContext(ectxt, context, soapProto);
        }
        catch (ServiceException e) {
            return this.soapFaultEnv(soapProto, "unable to construct SOAP context", e);
        }
        SoapProtocol responseProto = zsc.getResponseProtocol();
        String rid = zsc.getRequestedAccountId();
        if (rid != null) {
            Provisioning prov = Provisioning.getInstance();
            AccountUtil.addAccountToLogContext(prov, rid, "name", "id", zsc.getAuthToken());
            String aid = zsc.getAuthtokenAccountId();
            if (aid != null && !rid.equals(aid)) {
                AccountUtil.addAccountToLogContext(prov, aid, "aname", "aid", zsc.getAuthToken());
            } else if (zsc.getAuthToken() != null && zsc.getAuthToken().getAdminAccountId() != null) {
                AccountUtil.addAccountToLogContext(prov, zsc.getAuthToken().getAdminAccountId(), "aname", "aid", zsc.getAuthToken());
            }
            try {
                Mailbox mbox = MailboxManager.getInstance().getMailboxByAccountId(rid, false);
                if (mbox != null) {
                    ZimbraLog.addMboxToContext(mbox.getId());
                }
            }
            catch (ServiceException e) {
                // empty catch block
            }
            try {
                AuthToken at = zsc.getAuthToken();
                if (at != null) {
                    at.setProxyAuthToken(prov.getProxyAuthToken(rid));
                }
            }
            catch (ServiceException e) {
                mLog.warn("failed to set proxy auth token: " + e.getMessage());
            }
        }
        if (zsc.getUserAgent() != null) {
            ZimbraLog.addUserAgentToContext(zsc.getUserAgent());
        }
        this.logDebugSoapRequest(context, envelope);
        context.put(ZIMBRA_CONTEXT, zsc);
        context.put(ZIMBRA_ENGINE, this);
        Element doc = soapProto.getBodyElement(envelope);
        if (mLog.isDebugEnabled()) {
            mLog.debug("dispatch: doc " + doc.getQualifiedName());
        }
        Element responseBody = null;
        if (!zsc.isProxyRequest()) {
            this.acknowledgeNotifications(zsc);
            if (doc.getQName().equals(ZimbraNamespace.E_BATCH_REQUEST)) {
                boolean contOnError = doc.getAttribute("onerror", "continue").equals("continue");
                responseBody = zsc.createElement(ZimbraNamespace.E_BATCH_RESPONSE);
                ZimbraLog.soap.info(doc.getQualifiedName());
                for (Element req : doc.listElements()) {
                    String id = req.getAttribute(A_REQUEST_CORRELATOR, null);
                    ZimbraLog.soap.info("(batch) " + req.getQualifiedName());
                    Element br = this.dispatchRequest(req, context, zsc);
                    if (id != null) {
                        br.addAttribute(A_REQUEST_CORRELATOR, id);
                    }
                    responseBody.addElement(br);
                    if (contOnError || !responseProto.isFault(br)) continue;
                    break;
                }
            } else {
                String id = doc.getAttribute(A_REQUEST_CORRELATOR, null);
                ZimbraLog.soap.info(doc.getQualifiedName());
                responseBody = this.dispatchRequest(doc, context, zsc);
                if (id != null) {
                    responseBody.addAttribute(A_REQUEST_CORRELATOR, id);
                }
            }
        } else {
            try {
                doc.detach();
                ZimbraSoapContext zscTarget = new ZimbraSoapContext(zsc, zsc.getRequestedAccountId()).disableNotifications();
                ZimbraLog.soap.info(doc.getQualifiedName() + " (Proxying to " + zsc.getProxyTarget().toString() + ")");
                responseBody = zsc.getProxyTarget().dispatch(doc, zscTarget);
                responseBody.detach();
            }
            catch (SoapFaultException e) {
                responseBody = e.getFault() != null ? e.getFault().detach() : responseProto.soapFault(e);
                mLog.debug((Object)"proxy handler exception", e);
            }
            catch (ServiceException e) {
                responseBody = responseProto.soapFault(e);
                mLog.info((Object)"proxy handler exception", e);
            }
            catch (Throwable e) {
                responseBody = responseProto.soapFault(ServiceException.FAILURE(e.toString(), e));
                if (e instanceof OutOfMemoryError) {
                    Zimbra.halt("proxy handler exception", e);
                }
                mLog.warn((Object)"proxy handler exception", e);
            }
        }
        Element responseHeader = this.generateResponseHeader(zsc);
        return responseProto.soapEnvelope(responseBody, responseHeader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Element dispatchRequest(Element request, Map<String, Object> context, ZimbraSoapContext zsc) {
        Element response;
        block32: {
            long startTime = System.currentTimeMillis();
            SoapProtocol soapProto = zsc.getResponseProtocol();
            if (request == null) {
                return this.soapFault(soapProto, "cannot dispatch request", ServiceException.INVALID_REQUEST("no document specified", null));
            }
            DocumentHandler handler = this.mDispatcher.getHandler(request);
            if (handler == null) {
                return this.soapFault(soapProto, "cannot dispatch request", ServiceException.UNKNOWN_DOCUMENT(request.getQualifiedName(), null));
            }
            if (RedoLogProvider.getInstance().isSlave() && !handler.isReadOnly()) {
                return this.soapFault(soapProto, "cannot dispatch request", ServiceException.NON_READONLY_OPERATION_DENIED());
            }
            if (!Config.userServicesEnabled() && !(handler instanceof AdminDocumentHandler)) {
                return this.soapFault(soapProto, "cannot dispatch request", ServiceException.TEMPORARILY_UNAVAILABLE());
            }
            AuthToken at = zsc.getAuthToken();
            boolean needsAuth = handler.needsAuth(context);
            boolean needsAdminAuth = handler.needsAdminAuth(context);
            if ((needsAuth || needsAdminAuth) && at == null) {
                return this.soapFault(soapProto, "cannot dispatch request", ServiceException.AUTH_REQUIRED());
            }
            response = null;
            try {
                AdminAccessControl aac;
                if (needsAdminAuth && !(aac = AdminAccessControl.getAdminAccessControl(at)).isSufficientAdminForSoap(context, handler)) {
                    return this.soapFault(soapProto, "cannot dispatch request", ServiceException.PERM_DENIED("need admin token"));
                }
                String acctId = null;
                boolean isGuestAccount = true;
                boolean delegatedAuth = false;
                if (at != null) {
                    acctId = at.getAccountId();
                    isGuestAccount = acctId.equals("99999999-9999-9999-9999-999999999999");
                    delegatedAuth = at.isDelegatedAuth();
                }
                Provisioning prov = Provisioning.getInstance();
                if (!isGuestAccount) {
                    if (needsAuth || needsAdminAuth) {
                        Account account = Provisioning.getInstance().get(Provisioning.AccountBy.id, acctId, at);
                        if (account == null) {
                            return this.soapFault(soapProto, "acount " + acctId + " not found", ServiceException.AUTH_EXPIRED());
                        }
                        if (at.getValidityValue() != account.getAuthTokenValidityValue()) {
                            return this.soapFault(soapProto, "invalid validity value", ServiceException.AUTH_EXPIRED());
                        }
                        if (delegatedAuth && account.getAccountStatus(prov).equals("maintenance")) {
                            return this.soapFault(soapProto, "delegated account in MAINTENANCE mode", ServiceException.AUTH_EXPIRED());
                        }
                        if (!delegatedAuth && !account.getAccountStatus(prov).equals("active")) {
                            return this.soapFault(soapProto, "account not active", ServiceException.AUTH_EXPIRED());
                        }
                        if (delegatedAuth) {
                            Account admin = Provisioning.getInstance().get(Provisioning.AccountBy.id, at.getAdminAccountId());
                            if (admin == null) {
                                return this.soapFault(soapProto, "delegating account " + at.getAdminAccountId() + " not found", ServiceException.AUTH_EXPIRED());
                            }
                            boolean isAdmin = AdminAccessControl.isSufficientAdminForSoapDelegatedAuth(admin);
                            if (!isAdmin) {
                                return this.soapFault(soapProto, "delegating account is not an admin account", ServiceException.PERM_DENIED("not an admin for delegated auth"));
                            }
                            if (!admin.getAccountStatus(prov).equals("active")) {
                                return this.soapFault(soapProto, "delegating account is not active", ServiceException.AUTH_EXPIRED());
                            }
                        }
                        if (zsc.isDelegatedRequest() && !handler.isAdminCommand()) {
                            boolean inactive;
                            Account target = DocumentHandler.getRequestedAccount(zsc);
                            boolean bl = inactive = target == null || target.getAccountStatus(prov).equals("maintenance");
                            if (!(inactive || at.isAdmin() && AccessManager.getInstance().canAccessAccount(at, target))) {
                                boolean bl2 = inactive = !target.getAccountStatus(prov).equals("active");
                            }
                            if (inactive) {
                                return this.soapFault(soapProto, "target account is not active", AccountServiceException.ACCOUNT_INACTIVE(target == null ? zsc.getRequestedAccountId() : target.getName()));
                            }
                        }
                    }
                    context.put(ZIMBRA_SESSION, handler.getSession(zsc));
                    if (needsAuth || needsAdminAuth) {
                        response = handler.proxyIfNecessary(request, context);
                    }
                }
                if (response != null) break block32;
                Object userObj = handler.preHandle(request, context);
                if (delegatedAuth) {
                    handler.logAuditAccess(at.getAdminAccountId(), acctId, acctId);
                }
                try {
                    response = handler.handle(request, context);
                    Object var20_22 = null;
                    handler.postHandle(userObj);
                }
                catch (Throwable throwable) {
                    Object var20_23 = null;
                    handler.postHandle(userObj);
                    throw throwable;
                }
                ZimbraPerf.SOAP_TRACKER.addStat(this.getStatName(request), startTime);
            }
            catch (SoapFaultException e) {
                Element element = response = e.getFault() != null ? e.getFault().detach() : soapProto.soapFault(ServiceException.FAILURE(e.toString(), e));
                if (!e.isSourceLocal()) {
                    mLog.debug((Object)"handler exception", e);
                }
            }
            catch (AccountServiceException.AuthFailedServiceException e) {
                response = soapProto.soapFault(e);
                mLog.info("handler exception: %s%s", e.getMessage(), e.getReason(", %s"));
            }
            catch (ServiceException e) {
                response = soapProto.soapFault(e);
                mLog.info((Object)"handler exception", e);
            }
            catch (Throwable e) {
                if (e.getClass().getName().equals("org.mortbay.jetty.RetryRequest")) {
                    throw (RuntimeException)e;
                }
                response = soapProto.soapFault(ServiceException.FAILURE(e.toString(), e));
                if (e instanceof OutOfMemoryError) {
                    Zimbra.halt("handler exception", e);
                }
                mLog.warn((Object)"handler exception", e);
            }
        }
        return response;
    }

    private String getStatName(Element request) {
        String op;
        Element action;
        if (request == null) {
            return null;
        }
        String statName = request.getName();
        if (statName.endsWith("ActionRequest") && (action = request.getOptionalElement("action")) != null && (op = action.getAttribute("op", null)) != null) {
            statName = String.format("%s.%s", statName, op);
        }
        return statName;
    }

    public DocumentDispatcher getDocumentDispatcher() {
        return this.mDispatcher;
    }

    private void acknowledgeNotifications(ZimbraSoapContext zsc) {
        Session session;
        String authAccountId = zsc.getAuthtokenAccountId();
        ZimbraSoapContext.SessionInfo sinfo = zsc.getSessionInfo();
        if (sinfo != null && sinfo.sequence > 0 && (session = SessionCache.lookup(sinfo.sessionId, authAccountId)) instanceof SoapSession) {
            ((SoapSession)session).acknowledgeNotifications(sinfo.sequence);
        }
    }

    private Element generateResponseHeader(ZimbraSoapContext zsc) {
        String authAccountId = zsc.getAuthtokenAccountId();
        String requestedAccountId = zsc.getRequestedAccountId();
        Element ctxt = zsc.createElement(HeaderConstants.CONTEXT);
        boolean requiresChangeHeader = requestedAccountId != null;
        try {
            Session session;
            ZimbraSoapContext.SessionInfo sinfo = zsc.getSessionInfo();
            Session session2 = session = sinfo == null ? null : SessionCache.lookup(sinfo.sessionId, authAccountId);
            if (session != null) {
                ZimbraSoapContext.encodeSession(ctxt, session.getSessionId(), session.getSessionType());
                if (session instanceof SoapSession) {
                    SoapSession soap = (SoapSession)session;
                    if (session.getTargetAccountId().equals(requestedAccountId)) {
                        requiresChangeHeader = false;
                    }
                    if (sinfo.created || soap.requiresRefresh(sinfo.sequence)) {
                        soap.putRefresh(ctxt, zsc);
                    }
                    soap.putNotifications(ctxt, zsc, sinfo.sequence);
                    SoapContextExtension.addExtensionHeaders(ctxt, zsc, requestedAccountId != null ? requestedAccountId : session.getTargetAccountId());
                }
            }
            if (requiresChangeHeader) {
                try {
                    String explicitAcct = requestedAccountId.equals(authAccountId) ? null : requestedAccountId;
                    Mailbox mbox = DocumentHandler.getRequestedMailbox(zsc);
                    if (mbox != null) {
                        ctxt.addUniqueElement("change").addAttribute("token", mbox.getLastChangeID()).addAttribute("acct", explicitAcct);
                    }
                }
                catch (ServiceException e) {
                    // empty catch block
                }
            }
            return ctxt;
        }
        catch (ServiceException e) {
            ZimbraLog.session.info((Object)"ServiceException while putting soap session refresh data", e);
            return null;
        }
    }
}

