/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.soap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapHttpTransport;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.util.Pair;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.httpclient.URLUtil;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyTarget {
    private Server mServer;
    private AuthToken mAuthToken;
    private String mURL;
    private int mMaxAttempts = 0;
    private long mTimeout = -1L;

    public ProxyTarget(String serverId, AuthToken authToken, HttpServletRequest req) throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        this.mServer = prov.get(Provisioning.ServerBy.id, serverId);
        if (this.mServer == null) {
            throw AccountServiceException.NO_SUCH_SERVER(serverId);
        }
        this.mAuthToken = authToken;
        String requestStr = req.getRequestURI();
        String qs = req.getQueryString();
        if (qs != null) {
            requestStr = requestStr + "?" + qs;
        }
        int localAdminPort = prov.getLocalServer().getIntAttr("zimbraAdminPort", 0);
        String url = !prov.isOfflineProxyServer(this.mServer) && req.getLocalPort() == localAdminPort ? URLUtil.getAdminURL(this.mServer, requestStr, true) : URLUtil.getServiceURL(this.mServer, requestStr, false);
        this.mURL = url;
    }

    public ProxyTarget(Server server, AuthToken authToken, String url) {
        this.mServer = server;
        this.mAuthToken = authToken;
        this.mURL = url;
    }

    public ProxyTarget disableRetries() {
        this.mMaxAttempts = 1;
        return this;
    }

    public ProxyTarget setTimeouts(long timeoutMsecs) {
        this.mTimeout = timeoutMsecs;
        return this;
    }

    public Server getServer() {
        return this.mServer;
    }

    public boolean isTargetLocal() throws ServiceException {
        Server localServer = Provisioning.getInstance().getLocalServer();
        return this.mServer.getId().equals(localServer.getId());
    }

    public Element dispatch(Element request) throws ServiceException {
        SoapProtocol proto = request instanceof Element.JSONElement ? SoapProtocol.SoapJS : SoapProtocol.Soap12;
        SoapHttpTransport transport = new SoapHttpTransport(this.mURL);
        try {
            transport.setAuthToken(this.mAuthToken.toZAuthToken());
            transport.setRequestProtocol(proto);
            Element element = transport.invokeWithoutSession(request);
            Object var6_6 = null;
            transport.shutdown();
            return element;
        }
        catch (IOException e) {
            try {
                throw ServiceException.PROXY_ERROR(e, this.mURL);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                transport.shutdown();
                throw throwable;
            }
        }
    }

    public Element dispatch(Element request, ZimbraSoapContext zsc) throws ServiceException {
        return this.execute(request, zsc).getSecond();
    }

    public Pair<Element, Element> execute(Element request, ZimbraSoapContext zsc) throws ServiceException {
        SoapProtocol proto;
        if (zsc == null) {
            return new Pair<Object, Element>(null, this.dispatch(request));
        }
        SoapProtocol soapProtocol = proto = request instanceof Element.JSONElement ? SoapProtocol.SoapJS : SoapProtocol.Soap12;
        if (proto == SoapProtocol.Soap12 && zsc.getRequestProtocol() == SoapProtocol.Soap11) {
            proto = SoapProtocol.Soap11;
        }
        Element envelope = proto.soapEnvelope(request, zsc.toProxyCtxt(proto));
        SoapHttpTransport transport = null;
        try {
            transport = new SoapHttpTransport(this.mURL);
            if (this.mMaxAttempts > 0) {
                transport.setRetryCount(this.mMaxAttempts);
            }
            if (this.mTimeout > 0L) {
                transport.setTimeout((int)Math.min(this.mTimeout, Integer.MAX_VALUE));
            }
            Element response = transport.invokeRaw(envelope);
            Element body = transport.extractBodyElement(response);
            Pair<Element, Element> pair = new Pair<Element, Element>(transport.getZimbraContext(), body);
            Object var10_10 = null;
            if (transport != null) {
                transport.shutdown();
            }
            return pair;
        }
        catch (IOException e) {
            try {
                throw ServiceException.PROXY_ERROR(e, this.mURL);
            }
            catch (Throwable throwable) {
                block9: {
                    Object var10_11 = null;
                    if (transport == null) break block9;
                    transport.shutdown();
                }
                throw throwable;
            }
        }
    }

    public String toString() {
        return "ProxyTarget(url=" + this.mURL + ")";
    }
}

