/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.soap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.session.AdminSession;
import com.zimbra.cs.session.RemoteSoapSession;
import com.zimbra.cs.session.Session;
import com.zimbra.cs.session.SessionCache;
import com.zimbra.cs.session.SoapSession;
import com.zimbra.cs.util.Zimbra;
import com.zimbra.soap.ProxyTarget;
import com.zimbra.soap.SoapEngine;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DocumentHandler {
    private QName mResponseQName;
    private static String LOCAL_HOST = "";
    private static String LOCAL_HOST_ID = "";

    void setResponseQName(QName response) {
        this.mResponseQName = response;
    }

    protected Element getResponseElement(ZimbraSoapContext zc) {
        return zc.createElement(this.mResponseQName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLocalHost() {
        String string = LOCAL_HOST;
        synchronized (string) {
            if (LOCAL_HOST.length() == 0) {
                try {
                    Server localServer = Provisioning.getInstance().getLocalServer();
                    LOCAL_HOST = localServer.getAttr("zimbraServiceHostname");
                    LOCAL_HOST_ID = localServer.getId();
                }
                catch (Exception e) {
                    Zimbra.halt("could not fetch local server name from LDAP for request proxying");
                }
            }
        }
        return LOCAL_HOST;
    }

    public static String getLocalHostId() {
        if (LOCAL_HOST_ID.length() == 0) {
            DocumentHandler.getLocalHost();
        }
        return LOCAL_HOST_ID;
    }

    public Object preHandle(Element request, Map<String, Object> context) throws ServiceException {
        return null;
    }

    public void postHandle(Object userObj) {
    }

    public void preProxy(Element request, Map<String, Object> context) throws ServiceException {
    }

    public void postProxy(Element request, Element response, Map<String, Object> context) throws ServiceException {
    }

    public abstract Element handle(Element var1, Map<String, Object> var2) throws ServiceException;

    public static ZimbraSoapContext getZimbraSoapContext(Map<String, Object> context) {
        return (ZimbraSoapContext)context.get("zimbra.context");
    }

    public static OperationContext getOperationContext(ZimbraSoapContext zsc, Map<String, Object> context) throws ServiceException {
        return DocumentHandler.getOperationContext(zsc, context == null ? null : (Session)context.get("zimbra.session"));
    }

    public static OperationContext getOperationContext(ZimbraSoapContext zsc, Session session) throws ServiceException {
        AuthToken at = zsc.getAuthToken();
        OperationContext octxt = new OperationContext(at);
        octxt.setChangeConstraint(zsc.getChangeConstraintType(), zsc.getChangeConstraintLimit());
        octxt.setRequestIP(zsc.getRequestIP()).setSession(session);
        octxt.setUserAgent(zsc.getUserAgent());
        return octxt;
    }

    public static Account getAuthenticatedAccount(ZimbraSoapContext zsc) throws ServiceException {
        String id = zsc.getAuthtokenAccountId();
        AuthToken at = zsc.getAuthToken();
        if ("99999999-9999-9999-9999-999999999999".equals(id) || at != null && !at.isZimbraUser()) {
            return new ACL.GuestAccount(at);
        }
        Account acct = Provisioning.getInstance().get(Provisioning.AccountBy.id, id, zsc.getAuthToken());
        if (acct == null) {
            throw ServiceException.AUTH_REQUIRED();
        }
        return acct;
    }

    public static Account getRequestedAccount(ZimbraSoapContext zsc) throws ServiceException {
        String id = zsc.getRequestedAccountId();
        Account acct = Provisioning.getInstance().get(Provisioning.AccountBy.id, id, zsc.getAuthToken());
        if (acct == null) {
            if (zsc.isDelegatedRequest()) {
                throw ServiceException.DEFEND_ACCOUNT_HARVEST(id);
            }
            throw ServiceException.AUTH_EXPIRED();
        }
        return acct;
    }

    public static Mailbox getRequestedMailbox(ZimbraSoapContext zsc) throws ServiceException {
        String id = zsc.getRequestedAccountId();
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccountId(id);
        if (mbox != null) {
            ZimbraLog.addMboxToContext(mbox.getId());
        }
        return mbox;
    }

    private static boolean isRequestLocal(ZimbraSoapContext zsc) {
        try {
            Account acct = DocumentHandler.getAuthenticatedAccount(zsc);
            return acct != null && Provisioning.onLocalServer(acct);
        }
        catch (ServiceException e) {
            ZimbraLog.session.info((Object)"error determining whether authenticated account is local", e);
            return false;
        }
    }

    public boolean needsAuth(Map<String, Object> context) {
        return true;
    }

    public boolean needsAdminAuth(Map<String, Object> context) {
        return false;
    }

    public Boolean canAccessAccountCommon(ZimbraSoapContext zsc, Account target, boolean allowSelf) throws ServiceException {
        if (zsc.getAuthtokenAccountId() == null || target == null) {
            return Boolean.FALSE;
        }
        if (allowSelf && target.getId().equals(zsc.getAuthtokenAccountId())) {
            return Boolean.TRUE;
        }
        if (!zsc.getAuthToken().isDelegatedAuth() && !zsc.isDelegatedRequest()) {
            this.logAuditAccess(null, zsc.getAuthtokenAccountId(), target.getId());
        }
        return null;
    }

    public boolean canAccessAccount(ZimbraSoapContext zsc, Account target) throws ServiceException {
        Boolean canAccess = this.canAccessAccountCommon(zsc, target, true);
        if (canAccess != null) {
            return canAccess;
        }
        return AccessManager.getInstance().canAccessAccount(zsc.getAuthToken(), target);
    }

    public boolean canModifyOptions(ZimbraSoapContext zsc, Account acct) throws ServiceException {
        if (zsc.isDelegatedRequest()) {
            return this.canAccessAccount(zsc, acct) && DocumentHandler.getAuthenticatedAccount(zsc).getBooleanAttr("zimbraFeatureOptionsEnabled", true);
        }
        return acct.getBooleanAttr("zimbraFeatureOptionsEnabled", true);
    }

    public boolean domainAuthSufficient(Map<String, Object> context) {
        return false;
    }

    public boolean isAdminCommand() {
        return false;
    }

    public boolean isReadOnly() {
        return true;
    }

    protected boolean clientIsLocal(Map<String, Object> context) {
        HttpServletRequest req = (HttpServletRequest)context.get("servlet.request");
        return req == null ? true : "127.0.0.1".equals(req.getRemoteAddr());
    }

    public Session updateAuthenticatedAccount(ZimbraSoapContext zsc, AuthToken authToken, Map<String, Object> context, boolean getSession) {
        Session session;
        String oldAccountId = zsc.getAuthtokenAccountId();
        String accountId = authToken.getAccountId();
        if (accountId != null && !accountId.equals(oldAccountId)) {
            zsc.clearSessionInfo();
        }
        zsc.setAuthToken(authToken);
        Session session2 = session = getSession ? this.getSession(zsc) : null;
        if (context != null) {
            context.put("zimbra.session", session);
        }
        return session;
    }

    public static Session getReferencedSession(ZimbraSoapContext zsc) {
        if (zsc == null) {
            return null;
        }
        ZimbraSoapContext.SessionInfo sinfo = zsc.getSessionInfo();
        return sinfo == null ? null : SessionCache.lookup(sinfo.sessionId, zsc.getAuthtokenAccountId());
    }

    public Session.Type getDefaultSessionType() {
        return Session.Type.SOAP;
    }

    protected final Session getSession(ZimbraSoapContext zsc, Map<String, Object> context) {
        Session session = (Session)context.get("zimbra.session");
        return session != null ? session : this.getSession(zsc);
    }

    protected final Session getSession(ZimbraSoapContext zsc) {
        return this.getSession(zsc, this.getDefaultSessionType());
    }

    protected Session getSession(ZimbraSoapContext zsc, Session.Type stype) {
        Session delegate;
        if (zsc == null || stype == null || !zsc.isNotificationEnabled()) {
            return null;
        }
        String authAccountId = zsc.getAuthtokenAccountId();
        if (authAccountId == null) {
            return null;
        }
        boolean isLocal = DocumentHandler.isRequestLocal(zsc);
        if (stype == Session.Type.SOAP && !isLocal && !zsc.isSessionProxied()) {
            return null;
        }
        Session s = null;
        ZimbraSoapContext.SessionInfo sinfo = zsc.getSessionInfo();
        if (sinfo != null) {
            s = SessionCache.lookup(sinfo.sessionId, authAccountId);
            if (s == null) {
                ZimbraLog.session.info("requested session no longer exists: " + sinfo.sessionId);
                zsc.clearSessionInfo();
            } else if (s.getSessionType() != stype) {
                s = null;
            }
        }
        if (s == null) {
            try {
                if (stype == Session.Type.SOAP) {
                    s = isLocal ? new SoapSession(authAccountId).register() : new RemoteSoapSession(authAccountId).register();
                } else if (stype == Session.Type.ADMIN) {
                    s = new AdminSession(authAccountId).register();
                }
            }
            catch (ServiceException e) {
                ZimbraLog.session.info((Object)"exception while creating session", e);
            }
            if (s != null) {
                zsc.recordNewSession(s.getSessionId());
            }
        }
        if (s instanceof SoapSession && zsc.isDelegatedRequest() && (delegate = ((SoapSession)s).getDelegateSession(zsc.getRequestedAccountId())) != null) {
            s = delegate;
        }
        return s;
    }

    protected void endSession(Session s) {
        SessionCache.clearSession(s);
    }

    protected static Server getServer(String acctId) throws ServiceException {
        Account acct = Provisioning.getInstance().get(Provisioning.AccountBy.id, acctId);
        if (acct == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(acctId);
        }
        String hostname = acct.getAttr("zimbraMailHost");
        if (hostname == null) {
            throw ServiceException.PROXY_ERROR(AccountServiceException.NO_SUCH_SERVER(""), "");
        }
        Server server = Provisioning.getInstance().get(Provisioning.ServerBy.name, hostname);
        if (server == null) {
            throw ServiceException.PROXY_ERROR(AccountServiceException.NO_SUCH_SERVER(hostname), "");
        }
        return server;
    }

    protected static String getXPath(Element request, String[] xpath) {
        int depth = 0;
        while (depth < xpath.length - 1 && request != null) {
            request = request.getOptionalElement(xpath[depth++]);
        }
        return request == null ? null : request.getAttribute(xpath[depth], null);
    }

    protected static Element getXPathElement(Element request, String[] xpath) {
        int depth = 0;
        while (depth < xpath.length && request != null) {
            request = request.getOptionalElement(xpath[depth++]);
        }
        return request;
    }

    protected static void setXPath(Element request, String[] xpath, String value) throws ServiceException {
        if (xpath == null || xpath.length == 0) {
            return;
        }
        int depth = 0;
        while (depth < xpath.length - 1 && request != null) {
            request = request.getOptionalElement(xpath[depth++]);
        }
        if (request == null) {
            throw ServiceException.INVALID_REQUEST("could not find path", null);
        }
        request.addAttribute(xpath[depth], value);
    }

    protected Element proxyIfNecessary(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = DocumentHandler.getZimbraSoapContext(context);
        String acctId = zsc.getRequestedAccountId();
        if (acctId != null && zsc.getProxyTarget() == null && !this.isAdminCommand() && !Provisioning.onLocalServer(DocumentHandler.getRequestedAccount(zsc))) {
            return this.proxyRequest(request, context, acctId);
        }
        return null;
    }

    protected Element proxyRequest(Element request, Map<String, Object> context, String acctId) throws ServiceException {
        ZimbraSoapContext zsc = DocumentHandler.getZimbraSoapContext(context);
        ZimbraSoapContext zscTarget = new ZimbraSoapContext(zsc, acctId);
        return this.proxyRequest(request, context, DocumentHandler.getServer(acctId), zscTarget);
    }

    protected Element proxyRequest(Element request, Map<String, Object> context, Server server) throws ServiceException {
        ZimbraSoapContext zsc = DocumentHandler.getZimbraSoapContext(context);
        ZimbraSoapContext pxyCtxt = new ZimbraSoapContext(zsc);
        return this.proxyRequest(request, context, server, pxyCtxt);
    }

    protected Element proxyRequest(Element request, Map<String, Object> context, Server server, ZimbraSoapContext zsc) throws ServiceException {
        SoapEngine engine = (SoapEngine)context.get("zimbra.engine");
        boolean isLocal = DocumentHandler.getLocalHostId().equalsIgnoreCase(server.getId());
        if (isLocal) {
            zsc.resetProxyAuthToken();
        }
        Element response = null;
        request.detach();
        if (isLocal && engine != null) {
            HashMap<String, Object> contextTarget = new HashMap<String, Object>(context);
            contextTarget.put("zimbra.engine", engine);
            contextTarget.put("zimbra.context", zsc);
            response = engine.dispatchRequest(request, contextTarget, zsc);
            if (zsc.getResponseProtocol().isFault(response)) {
                zsc.getResponseProtocol().updateArgumentsForRemoteFault(response, zsc.getRequestedAccountId());
                throw new SoapFaultException("error in proxied request", true, response);
            }
        } else {
            this.preProxy(request, context);
            HttpServletRequest httpreq = (HttpServletRequest)context.get("servlet.request");
            ProxyTarget proxy = new ProxyTarget(server.getId(), zsc.getAuthToken(), httpreq);
            response = DocumentHandler.proxyWithNotification(request, proxy, zsc, (Session)context.get("zimbra.session"));
            this.postProxy(request, response, context);
        }
        return response;
    }

    public static Element proxyWithNotification(Element request, ProxyTarget proxy, ZimbraSoapContext zscProxy, ZimbraSoapContext zscInbound) throws ServiceException {
        return DocumentHandler.proxyWithNotification(request, proxy, zscProxy, DocumentHandler.getReferencedSession(zscInbound));
    }

    public static Element proxyWithNotification(Element request, ProxyTarget proxy, ZimbraSoapContext zscProxy, Session localSession) throws ServiceException {
        Server server = proxy.getServer();
        boolean isLocal = DocumentHandler.getLocalHostId().equalsIgnoreCase(server.getId());
        if (isLocal) {
            zscProxy.resetProxyAuthToken();
        }
        if (zscProxy.isNotificationEnabled()) {
            if (localSession instanceof SoapSession.DelegateSession) {
                localSession = ((SoapSession.DelegateSession)localSession).getParentSession();
            }
            if (!(localSession instanceof SoapSession) || localSession.getMailbox() == null) {
                zscProxy.disableNotifications();
            } else if (!isLocal) {
                zscProxy.setProxySession(((SoapSession)localSession).getRemoteSessionId(server));
            } else {
                zscProxy.setProxySession(localSession.getSessionId());
            }
        }
        Pair<Element, Element> envelope = proxy.execute(request, zscProxy);
        if (localSession instanceof SoapSession && zscProxy.isNotificationEnabled()) {
            ((SoapSession)localSession).handleRemoteNotifications(server, envelope.getFirst());
        }
        return envelope.getSecond().detach();
    }

    private String getAccountLogName(Provisioning prov, String acctId) {
        if (acctId == null) {
            return "";
        }
        try {
            Account acct = prov.get(Provisioning.AccountBy.id, acctId);
            if (acct != null) {
                return acct.getName();
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return acctId;
    }

    public void logAuditAccess(String delegatingAcctId, String authedAcctId, String targetAcctId) {
        if (!ZimbraLog.misc.isInfoEnabled()) {
            return;
        }
        String reqName = this.mResponseQName.getQualifiedName().substring(0, this.mResponseQName.getQualifiedName().length() - 8);
        Provisioning prov = Provisioning.getInstance();
        String delegatingAcctName = this.getAccountLogName(prov, delegatingAcctId);
        String authedAcctName = this.getAccountLogName(prov, authedAcctId);
        String targetAcctName = this.getAccountLogName(prov, targetAcctId);
        ZimbraLog.misc.info("delegated access: doc=" + reqName + (delegatingAcctId == null ? "" : ", delegating account=" + delegatingAcctName) + ", authenticated account=" + authedAcctName + ", target account=" + targetAcctName);
    }
}

