/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.soap;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.DocumentHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentDispatcher {
    private static final String REQUEST_SUFFIX = "Request";
    private static final String RESPONSE_SUFFIX = "Response";
    Map<QName, DocumentHandler> mHandlers = new HashMap<QName, DocumentHandler>();
    Map<QName, QName> mResponses = new HashMap<QName, QName>();
    ArrayList<String> mIncludeList;

    public DocumentDispatcher() {
        String whiteListString = LC.get("admin_soap_white_list");
        ZimbraLog.soap.debug("Loading admin SOAP white list");
        if (whiteListString.length() > 0) {
            this.mIncludeList = new ArrayList<String>(Arrays.asList(whiteListString.split("(,[\n\r]*)")));
        } else {
            ZimbraLog.soap.debug("No white list found. All available admin SOAP handlers will be loaded.");
        }
    }

    public void clearSoapWhiteList() {
        if (this.mIncludeList != null) {
            ZimbraLog.soap.debug("clearing admin SOAP white list");
            this.mIncludeList.clear();
        }
    }

    public void registerHandler(QName qname, DocumentHandler handler) {
        if (handler instanceof AdminDocumentHandler) {
            if (this.mIncludeList != null && !this.mIncludeList.isEmpty() && !this.mIncludeList.contains(String.format("%s::%s", qname.getNamespaceURI(), qname.getQualifiedName()))) {
                ZimbraLog.soap.debug(String.format("skipping %s::%s", qname.getNamespaceURI(), qname.getQualifiedName()));
                return;
            }
            ZimbraLog.soap.debug(String.format("Registering %s::%s", qname.getNamespaceURI(), qname.getQualifiedName()));
        }
        this.mHandlers.put(qname, handler);
        QName respQName = this.mResponses.get(qname);
        if (respQName == null) {
            String reqName = qname.getName();
            String respName = reqName.endsWith(REQUEST_SUFFIX) ? reqName.substring(0, reqName.length() - REQUEST_SUFFIX.length()) + RESPONSE_SUFFIX : reqName + RESPONSE_SUFFIX;
            respQName = new QName(respName, qname.getNamespace());
            this.mResponses.put(qname, respQName);
        }
        handler.setResponseQName(respQName);
    }

    public void unRegisterHandler(QName qname, DocumentHandler handler) {
        QName respQName;
        DocumentHandler qHandler = this.mHandlers.get(qname);
        if (qHandler != null) {
            this.mHandlers.remove(qname);
        }
        if ((respQName = this.mResponses.get(qname)) != null) {
            this.mResponses.remove(qname);
        }
    }

    public DocumentHandler getHandler(Element doc) {
        DocumentHandler handler = this.mHandlers.get(doc.getQName());
        return handler;
    }

    public Element dispatch(Element doc, Map<String, Object> context) throws ServiceException, SoapFaultException {
        DocumentHandler handler = this.mHandlers.get(doc.getQName());
        if (handler == null) {
            throw ServiceException.UNKNOWN_DOCUMENT(doc.getQualifiedName(), null);
        }
        return handler.handle(doc, context);
    }

    public Map<QName, DocumentHandler> getHandlers() {
        return Collections.unmodifiableMap(this.mHandlers);
    }
}

