/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.extension.ExtensionUtil;
import com.zimbra.qa.unittest.TestAccount;
import com.zimbra.qa.unittest.TestAuthentication;
import com.zimbra.qa.unittest.TestBlobInputStream;
import com.zimbra.qa.unittest.TestConcurrency;
import com.zimbra.qa.unittest.TestConnectionPool;
import com.zimbra.qa.unittest.TestContacts;
import com.zimbra.qa.unittest.TestConversion;
import com.zimbra.qa.unittest.TestDataSource;
import com.zimbra.qa.unittest.TestDbUtil;
import com.zimbra.qa.unittest.TestDocument;
import com.zimbra.qa.unittest.TestEmailUtil;
import com.zimbra.qa.unittest.TestFileUpload;
import com.zimbra.qa.unittest.TestFileUtil;
import com.zimbra.qa.unittest.TestFilter;
import com.zimbra.qa.unittest.TestFilterExisting;
import com.zimbra.qa.unittest.TestFolderFilterRules;
import com.zimbra.qa.unittest.TestFolders;
import com.zimbra.qa.unittest.TestGetMsg;
import com.zimbra.qa.unittest.TestImapImport;
import com.zimbra.qa.unittest.TestIndex;
import com.zimbra.qa.unittest.TestItemCache;
import com.zimbra.qa.unittest.TestLmtp;
import com.zimbra.qa.unittest.TestLogger;
import com.zimbra.qa.unittest.TestMailItem;
import com.zimbra.qa.unittest.TestMailSender;
import com.zimbra.qa.unittest.TestMaxMessageSize;
import com.zimbra.qa.unittest.TestMetadata;
import com.zimbra.qa.unittest.TestMimeHandler;
import com.zimbra.qa.unittest.TestNotification;
import com.zimbra.qa.unittest.TestOutOfOffice;
import com.zimbra.qa.unittest.TestParsedMessage;
import com.zimbra.qa.unittest.TestPop3ImapAuth;
import com.zimbra.qa.unittest.TestPop3Import;
import com.zimbra.qa.unittest.TestPurge;
import com.zimbra.qa.unittest.TestRedoLog;
import com.zimbra.qa.unittest.TestScheduledTaskManager;
import com.zimbra.qa.unittest.TestSendAndReceive;
import com.zimbra.qa.unittest.TestSoap;
import com.zimbra.qa.unittest.TestSpam;
import com.zimbra.qa.unittest.TestSpellCheck;
import com.zimbra.qa.unittest.TestTagFilterRules;
import com.zimbra.qa.unittest.TestTags;
import com.zimbra.qa.unittest.TestTaskScheduler;
import com.zimbra.qa.unittest.TestUnread;
import com.zimbra.qa.unittest.TestUserServlet;
import com.zimbra.qa.unittest.TestUtil;
import com.zimbra.qa.unittest.TestUtilCode;
import com.zimbra.qa.unittest.TestWaitSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.testng.ITestListener;
import org.testng.TestListenerAdapter;
import org.testng.TestNG;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZimbraSuite
extends TestSuite {
    private static final List<Class<? extends TestCase>> sClasses = new ArrayList<Class<? extends TestCase>>();

    public static void addTest(Class<? extends TestCase> clazz) {
        sClasses.add(clazz);
    }

    public static void removeTest(Class<? extends TestCase> clazz) {
        sClasses.remove(clazz);
    }

    public static TestListenerAdapter runUserTests(List<String> testNames) throws ServiceException {
        ArrayList<Class<? extends TestCase>> tests = new ArrayList<Class<? extends TestCase>>();
        for (String testName : testNames) {
            if (testName.indexOf(46) < 0) {
                boolean found = false;
                for (Class<? extends TestCase> c : sClasses) {
                    if (!testName.equals(c.getSimpleName())) continue;
                    tests.add(c);
                    found = true;
                }
                if (found) continue;
                ZimbraLog.test.warn("Could not find test %s.  Make sure it's registered with %s.", testName, ZimbraSuite.class.getName());
                continue;
            }
            Class<TestCase> testClass = null;
            try {
                testClass = Class.forName(testName).asSubclass(TestCase.class);
            }
            catch (ClassNotFoundException e) {
                try {
                    testClass = ExtensionUtil.findClass(testName).asSubclass(TestCase.class);
                }
                catch (ClassNotFoundException e2) {
                    throw ServiceException.FAILURE("Error instantiating test " + testName, e2);
                }
            }
            tests.add(testClass);
        }
        return ZimbraSuite.runTestsInternal(tests);
    }

    public static TestListenerAdapter runTestSuite() {
        return ZimbraSuite.runTestsInternal(sClasses);
    }

    private static TestListenerAdapter runTestsInternal(Collection<Class<? extends TestCase>> testClasses) {
        TestNG testng = TestUtil.newTestNG();
        TestListenerAdapter listener = new TestListenerAdapter();
        testng.addListener((ITestListener)listener);
        testng.addListener((ITestListener)new TestLogger());
        Class[] classArray = new Class[testClasses.size()];
        testClasses.toArray(classArray);
        testng.setTestClasses(classArray);
        testng.setJUnit(Boolean.valueOf(true));
        testng.run();
        return listener;
    }

    static {
        sClasses.add(TestWaitSet.class);
        sClasses.add(TestUtilCode.class);
        sClasses.add(TestEmailUtil.class);
        sClasses.add(TestOutOfOffice.class);
        sClasses.add(TestDbUtil.class);
        sClasses.add(TestUnread.class);
        sClasses.add(TestTags.class);
        sClasses.add(TestItemCache.class);
        sClasses.add(TestFolders.class);
        sClasses.add(TestSpellCheck.class);
        sClasses.add(TestAuthentication.class);
        sClasses.add(TestAccount.class);
        sClasses.add(TestConversion.class);
        sClasses.add(TestMailItem.class);
        sClasses.add(TestConcurrency.class);
        sClasses.add(TestFolderFilterRules.class);
        sClasses.add(TestTagFilterRules.class);
        sClasses.add(TestPop3Import.class);
        sClasses.add(TestFilter.class);
        sClasses.add(TestPop3ImapAuth.class);
        sClasses.add(TestContacts.class);
        sClasses.add(TestTaskScheduler.class);
        sClasses.add(TestSendAndReceive.class);
        sClasses.add(TestConnectionPool.class);
        sClasses.add(TestLmtp.class);
        sClasses.add(TestMimeHandler.class);
        sClasses.add(TestScheduledTaskManager.class);
        sClasses.add(TestDataSource.class);
        sClasses.add(TestPurge.class);
        sClasses.add(TestImapImport.class);
        sClasses.add(TestNotification.class);
        sClasses.add(TestMaxMessageSize.class);
        sClasses.add(TestMetadata.class);
        sClasses.add(TestSoap.class);
        sClasses.add(TestBlobInputStream.class);
        sClasses.add(TestRedoLog.class);
        sClasses.add(TestFileUtil.class);
        sClasses.add(TestIndex.class);
        sClasses.add(TestParsedMessage.class);
        sClasses.add(TestUserServlet.class);
        sClasses.add(TestDocument.class);
        sClasses.add(TestFileUpload.class);
        sClasses.add(TestFilterExisting.class);
        sClasses.add(TestSpam.class);
        sClasses.add(TestMailSender.class);
        sClasses.add(TestGetMsg.class);
    }
}

