/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.CliUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import com.zimbra.cs.account.soap.SoapProvisioning;
import com.zimbra.cs.service.AuthProvider;
import com.zimbra.cs.service.FileUploadServlet;
import com.zimbra.qa.unittest.TestProvisioningUtil;
import com.zimbra.qa.unittest.TestUtil;
import java.io.ByteArrayInputStream;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import junit.framework.TestCase;

public class TestZimbraId
extends TestCase {
    private static final String TEST_NAME = "test-zimbraid";
    private static final String TEST_ID = TestProvisioningUtil.genTestId();
    private static final String USER = "user1";
    private static final String PASSWORD = "test123";
    private static final String DOMAIN = TestProvisioningUtil.baseDomainName("test-zimbraid", TEST_ID);
    private static final String ZIMBRA_ID = "1234567890@" + TEST_ID;
    private static LdapProvisioning sLdapProv;
    private static SoapProvisioning sSoapProv;

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void createAccountWithZimbraId(Provisioning prov, String note) throws Exception {
        String userName = "acct-with-zimbra-id-" + note + "@" + DOMAIN;
        String zimbraId = ZIMBRA_ID + "-" + note;
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraId", zimbraId);
        Account acct = prov.createAccount(userName, PASSWORD, attrs);
        TestZimbraId.assertNotNull((Object)acct);
        TestZimbraId.assertEquals((String)acct.getId(), (String)zimbraId);
        Account acctById = prov.get(Provisioning.AccountBy.id, zimbraId);
        TestZimbraId.assertNotNull((Object)acctById);
    }

    public void testCreateAccountWithZimbraId() throws Exception {
        this.createAccountWithZimbraId(sLdapProv, "ldap");
        this.createAccountWithZimbraId(sSoapProv, "soap");
    }

    public void createAccountWithInvalidZimbraId(Provisioning prov) throws Exception {
        String userName = "acct-with-invalid-zimbra-id@" + DOMAIN;
        String zimbraId = "containing:colon";
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraId", zimbraId);
        try {
            Account acct = prov.createAccount(userName, PASSWORD, attrs);
        }
        catch (ServiceException e) {
            TestZimbraId.assertEquals((String)"service.INVALID_REQUEST", (String)e.getCode());
            return;
        }
        TestZimbraId.fail();
    }

    public void testCreateAccountWithInvalidZimbraId() throws Exception {
        this.createAccountWithInvalidZimbraId(sLdapProv);
        this.createAccountWithInvalidZimbraId(sSoapProv);
    }

    public void createAccountWithCosName(Provisioning prov, String note) throws Exception {
        String cosName = "cos-testCreateAccountWithCosName-" + note + "-" + TEST_ID;
        Cos cos = prov.createCos(cosName, new HashMap<String, Object>());
        String userName = "acct-with-cos-name-" + note + "@" + DOMAIN;
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraCOSId", cosName);
        Account acct = prov.createAccount(userName, PASSWORD, attrs);
        Cos acctCos = prov.getCOS(acct);
        TestZimbraId.assertEquals((String)cos.getName(), (String)acctCos.getName());
        TestZimbraId.assertEquals((String)cos.getId(), (String)acctCos.getId());
    }

    public void testCreateAccountWithCosName() throws Exception {
        this.createAccountWithCosName(sLdapProv, "ldap");
        this.createAccountWithCosName(sSoapProv, "soap");
    }

    public void createAccountWithCosId(Provisioning prov, String note) throws Exception {
        String cosName = "cos-testCreateAccountWithCosId-" + note + "-" + TEST_ID;
        Cos cos = prov.createCos(cosName, new HashMap<String, Object>());
        String userName = "acct-with-cos-id-" + note + "@" + DOMAIN;
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraCOSId", cos.getId());
        Account acct = prov.createAccount(userName, PASSWORD, attrs);
        Cos acctCos = prov.getCOS(acct);
        TestZimbraId.assertEquals((String)cos.getName(), (String)acctCos.getName());
        TestZimbraId.assertEquals((String)cos.getId(), (String)acctCos.getId());
    }

    public void testCreateAccountWithCosId() throws Exception {
        this.createAccountWithCosId(sLdapProv, "ldap");
        this.createAccountWithCosId(sSoapProv, "soap");
    }

    public void testFileUpload() throws Exception {
        Account acct = TestUtil.getAccount(USER);
        int bodyLen = 128;
        byte[] body = new byte[bodyLen];
        SecureRandom sr = new SecureRandom();
        sr.nextBytes(body);
        FileUploadServlet.Upload ulSaved = FileUploadServlet.saveUpload(new ByteArrayInputStream(body), "zimbraId-test", "text/plain", acct.getId());
        AuthToken authToken = AuthProvider.getAuthToken(acct);
        FileUploadServlet.Upload ulFetched = FileUploadServlet.fetchUpload(acct.getId(), ulSaved.getId(), authToken);
        TestZimbraId.assertEquals((String)ulSaved.getId(), (String)ulFetched.getId());
        TestZimbraId.assertEquals((String)ulSaved.getName(), (String)ulFetched.getName());
        TestZimbraId.assertEquals((long)ulSaved.getSize(), (long)ulFetched.getSize());
        TestZimbraId.assertEquals((String)ulSaved.getContentType(), (String)ulFetched.getContentType());
        TestZimbraId.assertEquals((String)ulSaved.toString(), (String)ulFetched.toString());
        byte[] bytesUploaded = ByteUtil.getContent(ulFetched.getInputStream(), -1);
        TestZimbraId.assertTrue((boolean)Arrays.equals(body, bytesUploaded));
    }

    public static void main(String[] args) throws Exception {
        TestUtil.runTest(TestZimbraId.class);
    }

    static {
        try {
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            Domain domain = Provisioning.getInstance().createDomain(DOMAIN, attrs);
        }
        catch (ServiceException e) {
            TestZimbraId.fail();
        }
        Provisioning prov = Provisioning.getInstance();
        TestZimbraId.assertTrue((boolean)(prov instanceof LdapProvisioning));
        sLdapProv = (LdapProvisioning)prov;
        CliUtil.toolSetup();
        sSoapProv = new SoapProvisioning();
        sSoapProv.soapSetURI("https://localhost:7071/service/admin/soap/");
        try {
            sSoapProv.soapZimbraAdminAuthenticate();
        }
        catch (Exception e) {
            System.out.println("soapZimbraAdminAuthenticate failed");
            e.printStackTrace();
            System.exit(1);
        }
    }
}

