/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.CliUtil;
import com.zimbra.common.util.ZimbraHttpConnectionManager;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.soap.SoapProvisioning;
import com.zimbra.qa.unittest.TestUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.StringTokenizer;
import junit.framework.TestCase;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class TestZimbraHttpConnectionManager
extends TestCase {
    private boolean runIt() {
        String testName = this.getName();
        if (!Test.valueOf(testName).runIt()) {
            System.out.println("Skippping test: " + testName);
            return false;
        }
        return true;
    }

    private static void dumpResponse(int respCode, HttpMethod method, String prefix) throws IOException {
        prefix = prefix + " - ";
        int statusCode = method.getStatusCode();
        String statusLine = method.getStatusLine().toString();
        System.out.println(prefix + "respCode=" + respCode);
        System.out.println(prefix + "statusCode=" + statusCode);
        System.out.println(prefix + "statusLine=" + statusLine);
        System.out.println(prefix + "Headers");
        Header[] respHeaders = method.getResponseHeaders();
        for (int i = 0; i < respHeaders.length; ++i) {
            String header = respHeaders[i].toString();
            System.out.println(prefix + header.trim());
        }
        byte[] bytes = ByteUtil.getContent(method.getResponseBodyAsStream(), 0);
        System.out.println(prefix + bytes.length + " bytes read");
    }

    public void testReaper() throws Exception {
        if (!this.runIt()) {
            return;
        }
        String[] urisToGet = new String[]{"http://hc.apache.org:80/", "http://hc.apache.org:80/httpclient-3.x/status.html", "http://hc.apache.org:80/httpclient-3.x/methods/", "http://svn.apache.org/viewvc/httpcomponents/oac.hc3x/"};
        ZimbraHttpConnectionManager connMgr = ZimbraHttpConnectionManager.getExternalHttpConnMgr();
        TestGetThread[] threads = new TestGetThread[urisToGet.length];
        for (int i = 0; i < threads.length; ++i) {
            GetMethod get = new GetMethod(urisToGet[i]);
            get.setFollowRedirects(true);
            threads[i] = new TestGetThread(connMgr.newHttpClient(), get, i + 1);
        }
        ZimbraHttpConnectionManager.startReaperThread();
        for (int j = 0; j < threads.length; ++j) {
            threads[j].start();
        }
    }

    public void testHttpState() throws Exception {
        if (!this.runIt()) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSoTimeoutViaHttpMethod() throws Exception {
        block6: {
            if (!this.runIt()) {
                return;
            }
            int serverPort = 7778;
            String path = "/Users/pshao/p4/main/ZimbraServer/src/java/com/zimbra/qa/unittest/TestZimbraHttpConnectionManager.java";
            int soTimeout = 3000;
            long waitInServer = 10000L;
            String qp = "?waitInServer=" + waitInServer;
            SimpleHttpServer.start(serverPort);
            HttpClient httpClient = ZimbraHttpConnectionManager.getExternalHttpConnMgr().newHttpClient();
            GetMethod method = new GetMethod("http://localhost:" + serverPort + path + qp);
            method.getParams().setParameter("http.socket.timeout", soTimeout);
            long startTime = System.currentTimeMillis();
            try {
                try {
                    int respCode = httpClient.executeMethod(method);
                    TestZimbraHttpConnectionManager.dumpResponse(respCode, method, "");
                    TestZimbraHttpConnectionManager.fail();
                }
                catch (SocketTimeoutException e) {
                    long endTime = System.currentTimeMillis();
                    long elapsedTime = endTime - startTime;
                    System.out.println("Timed out after " + elapsedTime + " msecs");
                    Object var17_13 = null;
                    method.releaseConnection();
                    break block6;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TestZimbraHttpConnectionManager.fail();
                    Object var17_14 = null;
                    method.releaseConnection();
                    break block6;
                }
                Object var17_12 = null;
            }
            catch (Throwable throwable) {
                Object var17_15 = null;
                method.releaseConnection();
                throw throwable;
            }
            method.releaseConnection();
        }
        SimpleHttpServer.shutdown();
    }

    public void testHttpClientConnectionManagerTimeout() throws Exception {
        if (!this.runIt()) {
            return;
        }
        int serverPort = 7778;
        String path = "/Users/pshao/p4/main/ZimbraServer/src/java/com/zimbra/qa/unittest/TestZimbraHttpConnectionManager.java";
        long waitInServer = 10000L;
        String qp = "?waitInServer=" + waitInServer;
        SimpleHttpServer.start(serverPort);
        ZimbraHttpConnectionManager connMgr = ZimbraHttpConnectionManager.getExternalHttpConnMgr();
        GetMethod method1 = new GetMethod("http://localhost:" + serverPort + path + qp);
        TestGetThread thread1 = new TestGetThread(connMgr.newHttpClient(), method1, 1);
        thread1.start();
        Thread.sleep(1000L);
        GetMethod method2 = new GetMethod("http://localhost:" + serverPort + path + qp);
        TestGetThread thread2 = new TestGetThread(connMgr.newHttpClient(), method1, 2);
        thread2.start();
        Thread.sleep(60000L);
        SimpleHttpServer.shutdown();
    }

    private static void runSoapProv(String msg) {
        System.out.println(msg);
        SoapProvisioning sp = new SoapProvisioning();
        String uri = LC.zimbra_admin_service_scheme.value() + LC.zimbra_zmprov_default_soap_server.value() + ":" + LC.zimbra_admin_service_port.intValue() + "/service/admin/soap/";
        sp.soapSetURI(uri);
        try {
            sp.getDomainInfo(Provisioning.DomainBy.name, "phoebe.mac");
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    private void runSoapProvParallel(int num) {
        for (int i = 0; i < num; ++i) {
            SoapProvThread thread = new SoapProvThread(Integer.valueOf(i).toString());
            thread.start();
        }
    }

    private void runSoapProvSerial(int num) {
        for (int i = 0; i < num; ++i) {
            TestZimbraHttpConnectionManager.runSoapProv(Integer.valueOf(i).toString());
        }
    }

    public void testSoapProv() throws Exception {
        if (!this.runIt()) {
            return;
        }
        this.runSoapProvParallel(3);
    }

    public static void main(String[] args) throws Exception {
        CliUtil.toolSetup("INFO");
        TestUtil.runTest(TestZimbraHttpConnectionManager.class);
        System.out.println("Waiting...");
        Thread.sleep(86400000L);
    }

    private static class SoapProvThread
    extends Thread {
        private String mId;

        public SoapProvThread(String id) {
            this.mId = id;
        }

        public void run() {
            TestZimbraHttpConnectionManager.runSoapProv(this.mId);
            try {
                Thread.sleep(3600000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static class HttpRequestHandler
    implements Runnable {
        static final String CRLF = "\r\n";
        Socket socket;
        InputStream input;
        OutputStream output;
        BufferedReader br;

        private HttpRequestHandler(Socket socket) throws Exception {
            this.socket = socket;
            this.input = socket.getInputStream();
            this.output = socket.getOutputStream();
            this.br = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        }

        public void run() {
            try {
                this.processRequest();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void processRequest() throws Exception {
            block12: {
                String headerLine;
                StringTokenizer s;
                String temp;
                do {
                    headerLine = this.br.readLine();
                    System.out.println(headerLine);
                    if (headerLine.equals(CRLF) || headerLine.equals("")) break block12;
                } while (!(temp = (s = new StringTokenizer(headerLine)).nextToken()).equals("GET"));
                String req = s.nextToken();
                String[] parts = req.split("\\?");
                String fileName = parts[0];
                String qp = null;
                long waitInServer = 0L;
                if (parts.length == 2) {
                    String[] params;
                    qp = parts[1];
                    for (String param : params = qp.split("&")) {
                        String[] nameValue = param.split("=");
                        if (!nameValue[0].equals("waitInServer")) continue;
                        waitInServer = Long.valueOf(nameValue[1]);
                    }
                }
                if (waitInServer != 0L) {
                    System.out.println("Waiting " + waitInServer + " milli seconds in SimpleHttpServer");
                    Thread.sleep(waitInServer);
                }
                FileInputStream fis = null;
                boolean fileExists = true;
                try {
                    fis = new FileInputStream(fileName);
                }
                catch (FileNotFoundException e) {
                    fileExists = false;
                }
                String serverLine = "Server: fpont simple java httpServer\r\n";
                String statusLine = null;
                String contentTypeLine = null;
                String entityBody = null;
                String contentLengthLine = null;
                if (fileExists) {
                    statusLine = "HTTP/1.0 200 OK\r\n";
                    contentTypeLine = "Content-type: text/plain\r\n";
                    contentLengthLine = "Content-Length: " + new Integer(fis.available()).toString() + CRLF;
                } else {
                    statusLine = "HTTP/1.0 404 Not Found\r\n";
                    contentTypeLine = "Content-type: text/html\r\n";
                    entityBody = "<HTML><HEAD><TITLE>404 Not Found</TITLE></HEAD><BODY>404 Not Found<br>usage:http://www.snaip.com:4444/fileName.html</BODY></HTML>";
                    contentLengthLine = "Content-Length: " + entityBody.length() + CRLF;
                }
                this.output.write(statusLine.getBytes());
                this.output.write(serverLine.getBytes());
                this.output.write(contentTypeLine.getBytes());
                this.output.write(contentLengthLine.getBytes());
                this.output.write(CRLF.getBytes());
                if (fileExists) {
                    HttpRequestHandler.sendBytes(fis, this.output);
                    fis.close();
                } else {
                    this.output.write(entityBody.getBytes());
                }
            }
            try {
                this.output.close();
                this.br.close();
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private static void sendBytes(FileInputStream fis, OutputStream os) throws Exception {
            byte[] buffer = new byte[1024];
            int bytes = 0;
            while ((bytes = fis.read(buffer)) != -1) {
                os.write(buffer, 0, bytes);
            }
        }
    }

    private static class SimpleHttpServer
    implements Runnable {
        private static Thread mServerThread = null;
        private static SimpleHttpServer sServer = null;
        private int mPort;
        private ServerSocket mServerSocket;
        private boolean mShutdownRequested = false;
        private static final String WAIT_IN_SERVER = "waitInServer";

        private static synchronized void start(int port) {
            if (mServerThread != null) {
                System.out.println("SimpleHttpServer start: server already started");
                return;
            }
            sServer = new SimpleHttpServer(port);
            mServerThread = new Thread(sServer);
            mServerThread.start();
        }

        private static synchronized void shutdown() {
            if (mServerThread == null) {
                System.out.println("SimpleHttpServer shutdown: server is not running");
                return;
            }
            sServer.requestShutdown();
            mServerThread = null;
        }

        private SimpleHttpServer(int port) {
            this.mPort = port;
        }

        private synchronized void requestShutdown() {
            this.mShutdownRequested = true;
            try {
                this.mServerSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    this.mServerSocket = new ServerSocket(this.mPort);
                    System.out.println("SimpleHttpServer: started on port " + this.mServerSocket.getLocalPort());
                    while (!this.mShutdownRequested) {
                        Socket socket = this.mServerSocket.accept();
                        System.out.println("SimpleHttpServer: new connection accepted " + socket.getInetAddress() + ":" + socket.getPort());
                        try {
                            HttpRequestHandler request = new HttpRequestHandler(socket);
                            Thread thread = new Thread(request);
                            thread.start();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    Object var5_6 = null;
                    System.out.println("SimpleHttpServer: exiting server");
                }
                catch (IOException e) {
                    if (!this.mShutdownRequested) {
                        e.printStackTrace();
                    }
                    Object var5_7 = null;
                    System.out.println("SimpleHttpServer: exiting server");
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                System.out.println("SimpleHttpServer: exiting server");
                throw throwable;
            }
        }
    }

    private static class TestGetThread
    extends Thread {
        private HttpClient mHttpClient;
        private GetMethod mMethod;
        private int mId;

        public TestGetThread(HttpClient httpClient, GetMethod method, int id) {
            this.mHttpClient = httpClient;
            this.mMethod = method;
            this.mId = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            long startTime = System.currentTimeMillis();
            try {
                try {
                    System.out.println(this.mId + " - about to get something from " + this.mMethod.getURI());
                    int respCode = this.mHttpClient.executeMethod(this.mMethod);
                    System.out.println(this.mId + " - get executed");
                }
                catch (Exception e) {
                    System.out.println(this.mId + " - error: " + e);
                    e.printStackTrace();
                    Object var7_5 = null;
                    long endTime = System.currentTimeMillis();
                    long elapsedTime = endTime - startTime;
                    System.out.println("Finished, elapsedTime=" + elapsedTime + " milli seconds");
                    this.mMethod.releaseConnection();
                    System.out.println(this.mId + " - connection released");
                    return;
                }
                Object var7_4 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                long endTime = System.currentTimeMillis();
                long elapsedTime = endTime - startTime;
                System.out.println("Finished, elapsedTime=" + elapsedTime + " milli seconds");
                this.mMethod.releaseConnection();
                System.out.println(this.mId + " - connection released");
                throw throwable;
            }
            long endTime = System.currentTimeMillis();
            long elapsedTime = endTime - startTime;
            System.out.println("Finished, elapsedTime=" + elapsedTime + " milli seconds");
            this.mMethod.releaseConnection();
            System.out.println(this.mId + " - connection released");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Test {
        testReaper(false),
        testHttpState(false),
        testSoTimeoutViaHttpMethod(false),
        testHttpClientConnectionManagerTimeout(true),
        testSoapProv(false);

        private boolean mRunIt;

        private Test(boolean runIt) {
            this.mRunIt = runIt;
        }

        private boolean runIt() {
            return this.mRunIt;
        }
    }
}

