/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.util.Pair;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.service.mail.WaitSetRequest;
import com.zimbra.cs.session.IWaitSet;
import com.zimbra.cs.session.WaitSetAccount;
import com.zimbra.cs.session.WaitSetError;
import com.zimbra.cs.session.WaitSetMgr;
import com.zimbra.qa.unittest.TestUtil;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class TestWaitSet
extends TestCase {
    private static final String WS_USER_NAME = "ws_test_user";
    private static final String USER_1_NAME = "user1";
    private static final String USER_2_NAME = "user3";
    private static final String NAME_PREFIX = TestWaitSet.class.getSimpleName();
    private static final String FAKE_ACCOUNT_ID = "fake";

    public void setUp() throws Exception {
        this.cleanUp();
    }

    public void cleanUp() throws Exception {
        TestUtil.deleteTestData(USER_1_NAME, NAME_PREFIX);
        TestUtil.deleteTestData(USER_2_NAME, NAME_PREFIX);
        try {
            Mailbox wsMbox = TestUtil.getMailbox(WS_USER_NAME);
            wsMbox.deleteMailbox();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            TestUtil.deleteAccount(WS_USER_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testWaitSets() throws Exception {
        this.runMeFirst();
        this.runMeSecond();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runMeFirst() throws Exception {
        Account user1Acct = TestUtil.getAccount(USER_1_NAME);
        ArrayList<WaitSetAccount> add = new ArrayList<WaitSetAccount>();
        add.add(new WaitSetAccount(user1Acct.getId(), null, WaitSetRequest.TypeEnum.m.getMask()));
        Pair<String, List<WaitSetError>> result = WaitSetMgr.create(FAKE_ACCOUNT_ID, true, WaitSetRequest.TypeEnum.m.getMask(), false, add);
        String waitSetId = result.getFirst();
        List<WaitSetError> errors = result.getSecond();
        try {
            String curSeqNo = "0";
            TestWaitSet.assertEquals((int)0, (int)errors.size());
            WaitSetRequest.Callback cb = new WaitSetRequest.Callback();
            IWaitSet ws = WaitSetMgr.lookup(waitSetId);
            errors = ws.doWait(cb, "0", null, null);
            TestWaitSet.assertEquals((int)0, (int)errors.size());
            WaitSetRequest.Callback callback = cb;
            synchronized (callback) {
                TestWaitSet.assertEquals((boolean)false, (boolean)cb.completed);
            }
            String sender = TestUtil.getAddress(USER_1_NAME);
            String recipient = TestUtil.getAddress(USER_1_NAME);
            Object subject = NAME_PREFIX + " testWaitSet 1";
            TestUtil.addMessageLmtp((String)subject, recipient, sender);
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                // empty catch block
            }
            WaitSetRequest.Callback e = cb;
            synchronized (e) {
                TestWaitSet.assertEquals((boolean)true, (boolean)cb.completed);
            }
            curSeqNo = cb.seqNo;
            cb = new WaitSetRequest.Callback();
            ws = WaitSetMgr.lookup(waitSetId);
            Account user2Acct = TestUtil.getAccount(USER_2_NAME);
            ArrayList<WaitSetAccount> add2 = new ArrayList<WaitSetAccount>();
            add2.add(new WaitSetAccount(user2Acct.getId(), null, WaitSetRequest.TypeEnum.m.getMask()));
            errors = ws.doWait(cb, curSeqNo, add2, null);
            TestWaitSet.assertEquals((int)0, (int)errors.size());
            subject = cb;
            synchronized (subject) {
                TestWaitSet.assertEquals((boolean)false, (boolean)cb.completed);
            }
            String sender2 = TestUtil.getAddress(WS_USER_NAME);
            String recipient2 = TestUtil.getAddress(USER_2_NAME);
            String subject2 = NAME_PREFIX + " testWaitSet 3";
            TestUtil.addMessageLmtp(subject2, recipient2, sender2);
            try {
                Thread.sleep(500L);
            }
            catch (Exception e2) {
                // empty catch block
            }
            WaitSetRequest.Callback callback2 = cb;
            synchronized (callback2) {
                TestWaitSet.assertEquals((boolean)true, (boolean)cb.completed);
            }
            String string = cb.seqNo;
            Object var14_18 = null;
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            WaitSetMgr.destroy(FAKE_ACCOUNT_ID, waitSetId);
            throw throwable;
        }
        WaitSetMgr.destroy(FAKE_ACCOUNT_ID, waitSetId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runMeSecond() throws Exception {
        Pair<String, List<WaitSetError>> result = WaitSetMgr.create(FAKE_ACCOUNT_ID, true, WaitSetRequest.TypeEnum.all.getMask(), true, null);
        String waitSetId = result.getFirst();
        String curSeqNo = "0";
        List<WaitSetError> errors = result.getSecond();
        TestWaitSet.assertEquals((int)0, (int)errors.size());
        try {
            WaitSetRequest.Callback cb = new WaitSetRequest.Callback();
            IWaitSet ws = WaitSetMgr.lookup(waitSetId);
            errors = ws.doWait(cb, "0", null, null);
            TestWaitSet.assertEquals((int)0, (int)errors.size());
            WaitSetRequest.Callback callback = cb;
            synchronized (callback) {
                TestWaitSet.assertEquals((boolean)false, (boolean)cb.completed);
            }
            String sender = TestUtil.getAddress(USER_1_NAME);
            String recipient = TestUtil.getAddress(USER_1_NAME);
            String subject = NAME_PREFIX + " testWaitSet 1";
            TestUtil.addMessageLmtp(subject, recipient, sender);
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                // empty catch block
            }
            WaitSetRequest.Callback e = cb;
            synchronized (e) {
                TestWaitSet.assertEquals((boolean)true, (boolean)cb.completed);
            }
            curSeqNo = cb.seqNo;
            cb = new WaitSetRequest.Callback();
            ws = WaitSetMgr.lookup(waitSetId);
            errors = ws.doWait(cb, "0", null, null);
            try {
                Thread.sleep(500L);
            }
            catch (Exception e2) {
                // empty catch block
            }
            TestWaitSet.assertEquals((int)0, (int)errors.size());
            WaitSetRequest.Callback e2 = cb;
            synchronized (e2) {
                TestWaitSet.assertEquals((boolean)true, (boolean)cb.completed);
            }
            curSeqNo = cb.seqNo;
            cb = new WaitSetRequest.Callback();
            ws = WaitSetMgr.lookup(waitSetId);
            errors = ws.doWait(cb, curSeqNo, null, null);
            TestWaitSet.assertEquals((int)0, (int)errors.size());
            e2 = cb;
            synchronized (e2) {
                TestWaitSet.assertEquals((boolean)false, (boolean)cb.completed);
            }
            TestUtil.createAccount(WS_USER_NAME);
            e2 = cb;
            synchronized (e2) {
                TestWaitSet.assertEquals((boolean)false, (boolean)cb.completed);
            }
            sender = TestUtil.getAddress(WS_USER_NAME);
            recipient = TestUtil.getAddress(WS_USER_NAME);
            subject = NAME_PREFIX + " testWaitSet 2";
            TestUtil.addMessageLmtp(subject, recipient, sender);
            try {
                Thread.sleep(500L);
            }
            catch (Exception e22) {
                // empty catch block
            }
            WaitSetRequest.Callback callback2 = cb;
            synchronized (callback2) {
                TestWaitSet.assertEquals((boolean)true, (boolean)cb.completed);
            }
            curSeqNo = cb.seqNo;
            Object var17_20 = null;
        }
        catch (Throwable throwable) {
            Object var17_21 = null;
            WaitSetMgr.destroy(FAKE_ACCOUNT_ID, waitSetId);
            throw throwable;
        }
        WaitSetMgr.destroy(FAKE_ACCOUNT_ID, waitSetId);
    }

    public void tearDown() throws Exception {
        this.cleanUp();
    }
}

