/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.FileSegmentDataSource;
import com.zimbra.common.util.FileUtil;
import com.zimbra.common.util.ListUtil;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.SystemUtil;
import com.zimbra.common.util.TimeoutMap;
import com.zimbra.common.util.TruncatingWriter;
import com.zimbra.common.util.ValueCounter;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.qa.unittest.TestUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUtilCode
extends TestCase {
    private static final String NAME_PREFIX = TestUtilCode.class.getSimpleName();

    public void setUp() throws Exception {
        this.cleanUp();
    }

    public void testFillTemplate() {
        String template = "The quick ${COLOR} ${ANIMAL}\njumped over the ${ADJECTIVE} dogs.\n";
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("COLOR", "brown");
        vars.put("ANIMAL", "fox");
        vars.put("ADJECTIVE", "lazy");
        String result = StringUtil.fillTemplate(template, vars);
        String expected = "The quick brown fox\njumped over the lazy dogs.\n";
        TestUtilCode.assertEquals((String)expected, (String)result);
    }

    public void testFillTemplateWithNewlineValue() {
        String template = "New message received at ${RECIPIENT_ADDRESS}.${NEWLINE}Sender: ${SENDER_ADDRESS}${NEWLINE}Subject: ${SUBJECT}";
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("SENDER_ADDRESS", "sender@example.zimbra.com");
        vars.put("RECIPIENT_ADDRESS", "recipient@example.zimbra.com");
        vars.put("RECIPIENT_DOMAIN", "example.zimbra.com");
        vars.put("NOTIFICATION_ADDRESS", "notify@example.zimbra.com");
        vars.put("SUBJECT", "Cool stuff");
        vars.put("NEWLINE", "\n");
        String expected = "New message received at recipient@example.zimbra.com.\nSender: sender@example.zimbra.com\nSubject: Cool stuff";
        String actual = StringUtil.fillTemplate(template, vars);
        TestUtilCode.assertEquals((String)("expected: '" + expected + "', actual: '" + actual + "'"), (String)expected, (String)actual);
    }

    public void testFillTemplateWithBraces() {
        String template = "Beginning ${VAR} { end }";
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("VAR", "middle");
        String result = StringUtil.fillTemplate(template, vars);
        String expected = "Beginning middle { end }";
        TestUtilCode.assertEquals((String)expected, (String)result);
    }

    public void testJoin() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        list.add("b");
        list.add("c");
        TestUtilCode.assertEquals((String)"a,b,c", (String)StringUtil.join(",", list));
        Object[] array = new String[list.size()];
        list.toArray(array);
        TestUtilCode.assertEquals((String)"a,b,c", (String)StringUtil.join(",", array));
        list.set(0, "");
        TestUtilCode.assertEquals((String)",b,c", (String)StringUtil.join(",", list));
        list.toArray(array);
        TestUtilCode.assertEquals((String)",b,c", (String)StringUtil.join(",", array));
    }

    public void testSimpleClassName() {
        TestUtilCode.assertEquals((String)"MyClass", (String)StringUtil.getSimpleClassName("my.package.MyClass"));
        Integer i = 0;
        TestUtilCode.assertEquals((String)"Integer", (String)StringUtil.getSimpleClassName(i));
    }

    public void testValueCounter() throws Exception {
        ValueCounter<String> vc = new ValueCounter<String>();
        vc.increment("one");
        vc.increment("two");
        vc.increment("two");
        vc.increment("two");
        vc.decrement("two");
        vc.increment("three", 3);
        TestUtilCode.assertEquals((String)"one", (int)1, (int)vc.getCount("one"));
        TestUtilCode.assertEquals((String)"two", (int)2, (int)vc.getCount("two"));
        TestUtilCode.assertEquals((String)"three", (int)3, (int)vc.getCount("three"));
        TestUtilCode.assertEquals((String)"total", (int)6, (int)vc.getTotal());
        TestUtilCode.assertEquals((String)"size", (int)3, (int)vc.size());
        vc.clear();
        TestUtilCode.assertEquals((String)"one", (int)0, (int)vc.getCount("one"));
        TestUtilCode.assertEquals((String)"two", (int)0, (int)vc.getCount("two"));
        TestUtilCode.assertEquals((String)"total", (int)0, (int)vc.getTotal());
        TestUtilCode.assertEquals((String)"size", (int)0, (int)vc.size());
    }

    public void testTimeoutMap() throws Exception {
        int i;
        int i2;
        ZimbraLog.test.debug("testTimeoutMap()");
        TimeoutMap map = new TimeoutMap(500L);
        HashMap<Integer, Integer> timeouts = new HashMap<Integer, Integer>();
        for (i2 = 1; i2 <= 49; ++i2) {
            timeouts.put(i2, i2);
        }
        map.putAll(timeouts);
        for (i2 = 50; i2 <= 99; ++i2) {
            map.put(i2, i2);
        }
        Integer oneHundred = 100;
        for (i = 1; i <= 99; ++i) {
            TestUtilCode.assertTrue((String)("1: map does not contain key " + i), (boolean)map.containsKey(i));
            TestUtilCode.assertTrue((String)("1: map does not contain value " + i), (boolean)map.containsValue(i));
            TestUtilCode.assertEquals((String)("1: value for key " + i + " does not match"), (int)i, (int)((Integer)map.get(i)));
        }
        TestUtilCode.assertEquals((String)"1: Map size is incorrect", (int)99, (int)map.size());
        TestUtilCode.assertFalse((String)"1: map contains key 100", (boolean)map.containsKey(oneHundred));
        TestUtilCode.assertFalse((String)"1: map contains value 100", (boolean)map.containsValue(oneHundred));
        TestUtilCode.assertNull((String)"1: map value for key 100 is not null", map.get(oneHundred));
        Thread.sleep(700L);
        map.put(oneHundred, oneHundred);
        TestUtilCode.assertEquals((String)"Map size is incorrect", (int)1, (int)map.size());
        for (i = 1; i <= 99; ++i) {
            TestUtilCode.assertFalse((String)("2: map contains key " + i), (boolean)map.containsKey(i));
            TestUtilCode.assertFalse((String)("2: map contains value " + i), (boolean)map.containsValue(i));
            TestUtilCode.assertNull((String)("2: value for key " + i + " is not null"), map.get(i));
        }
        TestUtilCode.assertTrue((String)"2: map does not contain key 100", (boolean)map.containsKey(oneHundred));
        TestUtilCode.assertTrue((String)"2: map does not contain value 100", (boolean)map.containsValue(oneHundred));
        TestUtilCode.assertEquals((String)"2: value for key 100 does not match", (Object)oneHundred, map.get(oneHundred));
    }

    public void testSplit() throws Exception {
        for (int i = 0; i < 50; ++i) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int j = 0; j < i; ++j) {
                list.add(j);
            }
            List listOfLists = ListUtil.split(list, 10);
            int expectedSize = 0;
            if (list.size() > 0) {
                expectedSize = (list.size() - 1) / 10 + 1;
            }
            TestUtilCode.assertEquals((String)("Unexpected number of splits for list of size " + list.size()), (int)expectedSize, (int)listOfLists.size());
            for (int j = 0; j < i; ++j) {
                int listNum = j / 10;
                int index = j % 10;
                String context = String.format("j=%d, listNum=%d, index=%d", j, listNum, index);
                TestUtilCode.assertEquals((String)context, list.get(j), listOfLists.get(listNum).get(index));
            }
            ZimbraLog.test.debug(String.format("Split a list of %d items into %d lists", list.size(), listOfLists.size()));
            TestUtilCode.assertTrue((String)("Lists don't match: " + StringUtil.join(",", list)), (boolean)TestUtilCode.compareLists(list, listOfLists));
        }
    }

    public void testInnermostException() throws Exception {
        TestUtilCode.assertNull((Object)SystemUtil.getInnermostException(null));
        Exception inner = new Exception("inner");
        Exception middle = new Exception("middle", inner);
        Exception outer = new Exception("outer", middle);
        TestUtilCode.assertSame((Object)inner, (Object)SystemUtil.getInnermostException(outer));
    }

    public void testSHA1Digest() throws Exception {
        byte[] data = "I am not a number.  I am a free man.".getBytes();
        String expected = "cc1ce56b9820cb5c4d6df9c9e39de0c7bf5b44a3";
        String expectedBase64 = "zBzla5ggy1xNbfnJ453gx79bRKM=";
        TestUtilCode.assertEquals((String)expected, (String)ByteUtil.getSHA1Digest(data, false));
        TestUtilCode.assertEquals((String)expectedBase64, (String)ByteUtil.getSHA1Digest(data, true));
        TestUtilCode.assertEquals((String)expectedBase64, (String)ByteUtil.getDigest(data));
        TestUtilCode.assertEquals((String)expected, (String)ByteUtil.getSHA1Digest(new ByteArrayInputStream(data), false));
        TestUtilCode.assertEquals((String)expectedBase64, (String)ByteUtil.getSHA1Digest(new ByteArrayInputStream(data), true));
    }

    public void testGetReaderContent() throws Exception {
        String s = "12345";
        TestUtilCode.assertEquals((String)"", (String)ByteUtil.getContent(new StringReader(s), 0, true));
        TestUtilCode.assertEquals((String)"123", (String)ByteUtil.getContent(new StringReader(s), 3, true));
        TestUtilCode.assertEquals((String)"12345", (String)ByteUtil.getContent(new StringReader(s), 5, true));
        TestUtilCode.assertEquals((String)"12345", (String)ByteUtil.getContent(new StringReader(s), 10, true));
        TestUtilCode.assertEquals((String)"12345", (String)ByteUtil.getContent(new StringReader(s), -1, true));
        StringReader reader = new StringReader(s);
        ByteUtil.getContent(reader, 3, false);
        TestUtilCode.assertEquals((String)"4", (String)ByteUtil.getContent(reader, 1, true));
        try {
            ByteUtil.getContent(reader, 1, false);
            TestUtilCode.fail((String)"IOException was not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testAccountLoggerNullAccountName() throws Exception {
        ZimbraLog.addAccountNameToContext(null);
        ZimbraLog.test.addAccountLogger(TestUtil.getAddress("user1"), Log.Level.info);
        ZimbraLog.test.debug("Testing addAccountNameToContext(null).");
    }

    public void testAccountLoggerMultipleAccountNames() throws Exception {
        String address1 = TestUtil.getAddress("user1");
        String address2 = TestUtil.getAddress("user2");
        ZimbraLog.addAccountNameToContext(address1);
        ZimbraLog.addAccountNameToContext(address2);
        Set<String> names = ZimbraLog.getAccountNamesFromContext();
        TestUtilCode.assertEquals((int)1, (int)names.size());
        TestUtilCode.assertTrue((boolean)names.contains(address2));
    }

    public void testGzip() throws Exception {
        String s = "Put the message in a box";
        byte[] original = s.getBytes();
        byte[] compressed = ByteUtil.compress(original);
        byte[] uncompressed = ByteUtil.uncompress(compressed);
        TestUtilCode.assertFalse((boolean)ByteUtil.isGzipped(original));
        TestUtilCode.assertTrue((boolean)ByteUtil.isGzipped(compressed));
        TestUtilCode.assertFalse((boolean)ByteUtil.isGzipped(uncompressed));
        TestUtilCode.assertEquals((String)s, (String)new String(uncompressed));
        File file = File.createTempFile("TestUtilCode.testGzip-uncompressed", null);
        FileOutputStream out = new FileOutputStream(file);
        out.write(original);
        out.close();
        TestUtilCode.assertFalse((boolean)FileUtil.isGzipped(file));
        file.delete();
        file = File.createTempFile("TestUtilCode.testGzip-compressed", null);
        out = new FileOutputStream(file);
        out.write(compressed);
        out.close();
        TestUtilCode.assertTrue((boolean)FileUtil.isGzipped(file));
        file.delete();
    }

    public void testTruncatingWriter() throws Exception {
        this.doTruncatingWriterTest(0);
        this.doTruncatingWriterTest(5);
        this.doTruncatingWriterTest(100);
    }

    private void doTruncatingWriterTest(int maxChars) throws Exception {
        String original = "Come talk to me";
        StringWriter sw = new StringWriter();
        TruncatingWriter w = new TruncatingWriter(sw, maxChars);
        w.append(original);
        String s = sw.toString();
        int actualChars = Math.min(maxChars, original.length());
        TestUtilCode.assertEquals((int)actualChars, (int)s.length());
        TestUtilCode.assertEquals((String)original.substring(0, actualChars), (String)s);
    }

    private static <E> boolean compareLists(List<E> list, List<List<E>> listOfLists) {
        int i = 0;
        for (List<E> curList : listOfLists) {
            for (E item : curList) {
                if (!item.equals(list.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public void testFileSegmentDataSource() throws Exception {
        File file = File.createTempFile(NAME_PREFIX, null);
        String content = "12345";
        FileOutputStream out = new FileOutputStream(file);
        out.write(content.getBytes());
        out.close();
        FileSegmentDataSource ds = new FileSegmentDataSource(file, 0L, 5L);
        TestUtilCode.assertEquals((String)"12345", (String)new String(ByteUtil.getContent(ds.getInputStream(), 5)));
        TestUtilCode.assertEquals((String)"12345", (String)new String(ByteUtil.getContent(ds.getInputStream(), 5)));
        ds = new FileSegmentDataSource(file, 1L, 3L);
        TestUtilCode.assertEquals((String)"234", (String)new String(ByteUtil.getContent(ds.getInputStream(), 5)));
        file.delete();
    }

    public void tearDown() throws Exception {
        this.cleanUp();
    }

    private void cleanUp() throws Exception {
        ZimbraLog.test.removeAccountLogger(TestUtil.getAddress("user1"));
    }

    public static void main(String[] args) throws Exception {
        TestUtil.cliSetup();
        TestUtil.runTest(TestUtilCode.class);
    }
}

