/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.soap.SoapHttpTransport;
import com.zimbra.common.soap.SoapTransport;
import com.zimbra.common.util.CliUtil;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.soap.SoapProvisioning;
import com.zimbra.cs.client.LmcSession;
import com.zimbra.cs.client.soap.LmcAdminAuthRequest;
import com.zimbra.cs.client.soap.LmcAdminAuthResponse;
import com.zimbra.cs.client.soap.LmcAuthRequest;
import com.zimbra.cs.client.soap.LmcAuthResponse;
import com.zimbra.cs.client.soap.LmcSoapClientException;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.lmtpserver.utils.LmtpClient;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.util.BuildInfo;
import com.zimbra.cs.util.JMSession;
import com.zimbra.cs.zclient.ZContact;
import com.zimbra.cs.zclient.ZDataSource;
import com.zimbra.cs.zclient.ZEmailAddress;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZGetInfoResult;
import com.zimbra.cs.zclient.ZGetMessageParams;
import com.zimbra.cs.zclient.ZGrant;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZMessage;
import com.zimbra.cs.zclient.ZMountpoint;
import com.zimbra.cs.zclient.ZSearchHit;
import com.zimbra.cs.zclient.ZSearchParams;
import com.zimbra.cs.zclient.ZTag;
import com.zimbra.qa.unittest.MessageBuilder;
import com.zimbra.qa.unittest.TestLogger;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.util.SharedByteArrayInputStream;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.testng.ITestListener;
import org.testng.TestListenerAdapter;
import org.testng.TestNG;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUtil
extends Assert {
    public static final String DEFAULT_PASSWORD = "test123";
    private static boolean sIsCliInitialized = false;

    public static boolean accountExists(String userName) throws ServiceException {
        String address = TestUtil.getAddress(userName);
        Account account = Provisioning.getInstance().get(Provisioning.AccountBy.name, address);
        return account != null;
    }

    public static Account getAccount(String userName) throws ServiceException {
        String address = TestUtil.getAddress(userName);
        return Provisioning.getInstance().get(Provisioning.AccountBy.name, address);
    }

    public static String getDomain() throws ServiceException {
        Config config = Provisioning.getInstance().getConfig();
        String domain = config.getAttr("zimbraDefaultDomainName", null);
        assert (domain != null && domain.length() > 0);
        return domain;
    }

    public static Mailbox getMailbox(String userName) throws ServiceException {
        Account account = TestUtil.getAccount(userName);
        return MailboxManager.getInstance().getMailboxByAccount(account);
    }

    public static String getAddress(String userName) throws ServiceException {
        if (userName.contains("@")) {
            return userName;
        }
        return userName + "@" + TestUtil.getDomain();
    }

    public static String getSoapUrl() {
        String scheme;
        int port;
        try {
            port = Provisioning.getInstance().getLocalServer().getIntAttr("zimbraMailPort", 0);
            if (port > 0) {
                scheme = "http";
            } else {
                port = Provisioning.getInstance().getLocalServer().getIntAttr("zimbraMailSSLPort", 0);
                scheme = "https";
            }
        }
        catch (ServiceException e) {
            ZimbraLog.test.error((Object)"Unable to get user SOAP port", e);
            port = 80;
            scheme = "http";
        }
        return scheme + "://localhost:" + port + "/service/soap/";
    }

    public static String getAdminSoapUrl() {
        int port;
        try {
            port = Provisioning.getInstance().getLocalServer().getIntAttr("zimbraAdminPort", 0);
        }
        catch (ServiceException e) {
            ZimbraLog.test.error((Object)"Unable to get admin SOAP port", e);
            port = LC.zimbra_admin_service_port.intValue();
        }
        return "https://localhost:" + port + "/service/admin/soap/";
    }

    public static LmcSession getSoapSession(String userName) throws ServiceException, LmcSoapClientException, IOException, SoapFaultException {
        LmcAuthRequest auth = new LmcAuthRequest();
        auth.setUsername(TestUtil.getAddress(userName));
        auth.setPassword(DEFAULT_PASSWORD);
        LmcAuthResponse authResp = (LmcAuthResponse)auth.invoke(TestUtil.getSoapUrl());
        return authResp.getSession();
    }

    public static LmcSession getAdminSoapSession() throws Exception {
        LmcAdminAuthRequest auth = new LmcAdminAuthRequest();
        auth.setUsername(TestUtil.getAddress("admin"));
        auth.setPassword(DEFAULT_PASSWORD);
        LmcAdminAuthResponse authResp = (LmcAdminAuthResponse)auth.invoke(TestUtil.getAdminSoapUrl());
        return authResp.getSession();
    }

    public static Message addMessage(Mailbox mbox, String subject) throws Exception {
        return TestUtil.addMessage(mbox, 2, subject, System.currentTimeMillis());
    }

    public static Message addMessage(Mailbox mbox, int folderId, String subject, long timestamp) throws Exception {
        String message = TestUtil.getTestMessage(subject, null, null, new Date(timestamp));
        ParsedMessage pm = new ParsedMessage(message.getBytes(), (Long)timestamp, false);
        return mbox.addMessage(null, pm, folderId, false, Flag.BITMASK_UNREAD, null);
    }

    private static String getTestMessage(String subject) throws ServiceException, MessagingException, IOException {
        return new MessageBuilder().withSubject(subject).create();
    }

    public static String getTestMessage(String subject, String recipient, String sender, Date date) throws ServiceException, MessagingException, IOException {
        return new MessageBuilder().withSubject(subject).withRecipient(recipient).withSender(sender).withDate(date).create();
    }

    static String addDomainIfNecessary(String user) throws ServiceException {
        if (user == null || user.contains("@")) {
            return user;
        }
        return String.format("%s@%s", user, TestUtil.getDomain());
    }

    public static boolean addMessageLmtp(String subject, String recipient, String sender) throws Exception {
        return TestUtil.addMessageLmtp(subject, new String[]{recipient}, sender);
    }

    public static boolean addMessageLmtp(String subject, String[] recipients, String sender) throws Exception {
        String message = TestUtil.getTestMessage(subject, recipients[0], sender, null);
        return TestUtil.addMessageLmtp(recipients, sender, message);
    }

    public static boolean addMessageLmtp(String[] recipients, String sender, String message) throws Exception {
        String[] recipWithDomain = new String[recipients.length];
        for (int i = 0; i < recipients.length; ++i) {
            recipWithDomain[i] = TestUtil.addDomainIfNecessary(recipients[i]);
        }
        Provisioning prov = Provisioning.getInstance();
        LmtpClient lmtp = new LmtpClient("localhost", prov.getLocalServer().getIntAttr("zimbraLmtpBindPort", 7025));
        byte[] data = message.getBytes();
        boolean success = lmtp.sendMessage((InputStream)new ByteArrayInputStream(data), recipWithDomain, sender, "TestUtil", Long.valueOf(data.length));
        lmtp.close();
        return success;
    }

    public static String addMessage(ZMailbox mbox, String subject) throws ServiceException, IOException, MessagingException {
        return TestUtil.addMessage(mbox, subject, Integer.toString(2));
    }

    public static String addMessage(ZMailbox mbox, String subject, String folderId) throws ServiceException, IOException, MessagingException {
        String message = TestUtil.getTestMessage(subject);
        return mbox.addMessage(folderId, null, null, 0L, message, true);
    }

    public static String addMessage(ZMailbox mbox, String subject, String folderId, String flags) throws ServiceException, IOException, MessagingException {
        String message = TestUtil.getTestMessage(subject);
        return mbox.addMessage(folderId, flags, null, 0L, message, true);
    }

    public static String addRawMessage(ZMailbox mbox, String rawMessage) throws ServiceException {
        return mbox.addMessage(Integer.toString(2), null, null, 0L, rawMessage, true);
    }

    public static void sendMessage(ZMailbox senderMbox, String recipientName, String subject) throws Exception {
        String body = TestUtil.getTestMessage(subject);
        TestUtil.sendMessage(senderMbox, recipientName, subject, body);
    }

    public static void sendMessage(ZMailbox senderMbox, String recipientName, String subject, String body) throws Exception {
        TestUtil.sendMessage(senderMbox, recipientName, subject, body, null);
    }

    public static void sendMessage(ZMailbox senderMbox, String recipientName, String subject, String body, String attachmentUploadId) throws Exception {
        ZMailbox.ZOutgoingMessage msg = new ZMailbox.ZOutgoingMessage();
        ArrayList<ZEmailAddress> addresses = new ArrayList<ZEmailAddress>();
        addresses.add(new ZEmailAddress(TestUtil.getAddress(recipientName), null, null, "t"));
        msg.setAddresses(addresses);
        msg.setSubject(subject);
        msg.setMessagePart(new ZMailbox.ZOutgoingMessage.MessagePart("text/plain", body));
        msg.setAttachmentUploadId(attachmentUploadId);
        senderMbox.sendMessage(msg, null, false);
    }

    public static List<Integer> search(Mailbox mbox, String query, byte type) throws Exception {
        return TestUtil.search(mbox, query, new byte[]{type});
    }

    public static List<Integer> search(Mailbox mbox, String query, byte[] types) throws Exception {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ZimbraQueryResults r = mbox.search(new OperationContext(mbox), query, types, SortBy.DATE_DESCENDING, 100);
        while (r.hasNext()) {
            ZimbraHit hit = r.getNext();
            ids.add(new Integer(hit.getItemId()));
        }
        r.doneWithSearchResults();
        return ids;
    }

    public static List<String> search(ZMailbox mbox, String query, String type) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ZSearchParams params = new ZSearchParams(query);
        params.setTypes(type);
        for (ZSearchHit hit : mbox.search(params).getHits()) {
            ids.add(hit.getId());
        }
        return ids;
    }

    public static List<ZMessage> search(ZMailbox mbox, String query) throws Exception {
        ArrayList<ZMessage> msgs = new ArrayList<ZMessage>();
        ZSearchParams params = new ZSearchParams(query);
        params.setTypes("message");
        for (ZSearchHit hit : mbox.search(params).getHits()) {
            ZGetMessageParams msgParams = new ZGetMessageParams();
            msgParams.setId(hit.getId());
            msgs.add(mbox.getMessage(msgParams));
        }
        return msgs;
    }

    public static String getContent(ZMailbox mbox, String msgId) throws Exception {
        ZGetMessageParams msgParams = new ZGetMessageParams();
        msgParams.setId(msgId);
        msgParams.setRawContent(true);
        ZMessage msg = mbox.getMessage(msgParams);
        return msg.getContent();
    }

    public static ZMessage waitForMessage(ZMailbox mbox, String query) throws Exception {
        for (int i = 1; i <= 20; ++i) {
            List<ZMessage> msgs = TestUtil.search(mbox, query);
            if (msgs.size() == 1) {
                return msgs.get(0);
            }
            if (msgs.size() > 1) {
                Assert.fail((String)("Unexpected number of messages (" + msgs.size() + ") returned by query '" + query + "'"));
            }
            Thread.sleep(500L);
        }
        Assert.fail((String)("Message for query '" + query + "' never arrived.  Either the MTA is not running or the test failed."));
        return null;
    }

    public static Folder getFolderByPath(Mailbox mbox, String path) throws Exception {
        Folder folder;
        block2: {
            folder = null;
            try {
                folder = mbox.getFolderByPath(null, path);
            }
            catch (MailServiceException e) {
                if (e.getCode() == "mail.NO_SUCH_FOLDER") break block2;
                throw e;
            }
        }
        return folder;
    }

    public static void deleteTestData(String userName, String subjectSubstring) throws ServiceException {
        ZMailbox mbox = TestUtil.getZMailbox(userName);
        TestUtil.deleteMessages(mbox, "is:anywhere " + subjectSubstring);
        TestUtil.deleteMessages(mbox, "in:trash " + subjectSubstring);
        TestUtil.deleteMessages(mbox, "in:junk " + subjectSubstring);
        TestUtil.deleteMessages(mbox, "in:sent " + subjectSubstring);
        TestUtil.deleteMessages(mbox, "subject: " + subjectSubstring);
        for (ZTag tag : mbox.getAllTags()) {
            if (!tag.getName().contains(subjectSubstring)) continue;
            mbox.deleteTag(tag.getId());
        }
        for (ZFolder folder : mbox.getAllFolders()) {
            if (!folder.getName().contains(subjectSubstring)) continue;
            mbox.deleteFolder(folder.getId());
        }
        for (ZContact contact : mbox.getAllContacts(null, ZMailbox.ContactSortBy.nameAsc, false, null)) {
            String fullName = contact.getAttrs().get("fullName");
            if (fullName == null || !fullName.contains(subjectSubstring)) continue;
            mbox.deleteContact(contact.getId());
        }
        List<ZDataSource> dataSources = mbox.getAllDataSources();
        for (ZDataSource ds : dataSources) {
            if (!ds.getName().contains(subjectSubstring)) continue;
            mbox.deleteDataSource(ds);
        }
    }

    private static void deleteMessages(ZMailbox mbox, String query) throws ServiceException {
        ZSearchParams params = new ZSearchParams(query);
        params.setTypes("message");
        List<ZSearchHit> hits = mbox.search(params).getHits();
        if (hits.size() > 0) {
            ArrayList<String> ids = new ArrayList<String>();
            for (ZSearchHit hit : hits) {
                ids.add(hit.getId());
            }
            mbox.deleteMessage(StringUtil.join(",", ids));
        }
    }

    static void cliSetup() throws ServiceException {
        if (!sIsCliInitialized) {
            CliUtil.toolSetup();
            SoapProvisioning sp = new SoapProvisioning();
            sp.soapSetURI("https://localhost:7071/service/admin/soap/");
            sp.soapZimbraAdminAuthenticate();
            Provisioning.setInstance(sp);
            SoapTransport.setDefaultUserAgent("Zimbra Unit Tests", BuildInfo.VERSION);
            sIsCliInitialized = true;
        }
    }

    public static void runTest(Class<?> testClass) {
        TestNG testng = TestUtil.newTestNG();
        ZimbraLog.test.info("Starting unit test %s.\nSee %s/index.html for results.", testClass.getName(), testng.getOutputDirectory());
        TestListenerAdapter listener = new TestListenerAdapter();
        testng.addListener((ITestListener)listener);
        testng.addListener((ITestListener)new TestLogger());
        Class[] classArray = new Class[]{testClass};
        testng.setTestClasses(classArray);
        if (TestCase.class.isAssignableFrom(testClass)) {
            testng.setJUnit(Boolean.valueOf(true));
        }
        testng.run();
    }

    public static ZMailbox getZMailbox(String username) throws ServiceException {
        ZMailbox.Options options = new ZMailbox.Options();
        options.setAccount(TestUtil.getAddress(username));
        options.setAccountBy(Provisioning.AccountBy.name);
        options.setPassword(DEFAULT_PASSWORD);
        options.setUri(TestUtil.getSoapUrl());
        return ZMailbox.getMailbox(options);
    }

    public static Account createAccount(String username) throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        String address = TestUtil.getAddress(username);
        return prov.createAccount(address, DEFAULT_PASSWORD, null);
    }

    public static void deleteAccount(String username) throws ServiceException {
        Account account;
        Provisioning prov = Provisioning.getInstance();
        if (!(prov instanceof SoapProvisioning)) {
            SoapProvisioning sp = new SoapProvisioning();
            sp.soapSetURI("https://localhost:7071/service/admin/soap/");
            sp.soapZimbraAdminAuthenticate();
            prov = sp;
        }
        if ((account = prov.get(Provisioning.AccountBy.name, TestUtil.getAddress(username))) != null) {
            prov.deleteAccount(account.getId());
        }
    }

    public static String getServerAttr(String attrName) throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        Server server = prov.getLocalServer();
        return server.getAttr(attrName, null);
    }

    public static void setServerAttr(String attrName, String attrValue) throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        Server server = prov.getLocalServer();
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put(attrName, attrValue);
        prov.modifyAttrs(server, attrs);
    }

    public static String getAccountAttr(String userName, String attrName) throws ServiceException {
        String accountName = TestUtil.getAddress(userName);
        Account account = Provisioning.getInstance().getAccount(accountName);
        return account.getAttr(attrName);
    }

    public static String[] getAccountMultiAttr(String userName, String attrName) throws ServiceException {
        String accountName = TestUtil.getAddress(userName);
        Account account = Provisioning.getInstance().getAccount(accountName);
        return account.getMultiAttr(attrName);
    }

    public static void setAccountAttr(String userName, String attrName, String attrValue) throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        Account account = prov.get(Provisioning.AccountBy.name, TestUtil.getAddress(userName));
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put(attrName, attrValue);
        prov.modifyAttrs(account, attrs);
    }

    public static void setAccountAttr(String userName, String attrName, String[] attrValues) throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        Account account = prov.get(Provisioning.AccountBy.name, TestUtil.getAddress(userName));
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put(attrName, attrValues);
        prov.modifyAttrs(account, attrs);
    }

    public static String getConfigAttr(String attrName) throws ServiceException {
        return Provisioning.getInstance().getConfig().getAttr(attrName, "");
    }

    public static void setConfigAttr(String attrName, String attrValue) throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        Config config = prov.getConfig();
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put(attrName, attrValue);
        prov.modifyAttrs(config, attrs);
    }

    public static String getDomainAttr(String userName, String attrName) throws ServiceException {
        Account account = TestUtil.getAccount(userName);
        return Provisioning.getInstance().getDomain(account).getAttr(attrName);
    }

    public static void setDomainAttr(String userName, String attrName, Object attrValue) throws ServiceException {
        Account account = TestUtil.getAccount(userName);
        Domain domain = Provisioning.getInstance().getDomain(account);
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put(attrName, attrValue);
        Provisioning.getInstance().modifyAttrs(domain, attrs);
    }

    public static void verifyTag(ZMailbox mbox, ZMessage msg, String tagName) throws Exception {
        List<ZTag> tags = mbox.getTags(msg.getTagIds());
        for (ZTag tag : tags) {
            if (!tag.getName().equals(tagName)) continue;
            return;
        }
        Assert.fail((String)("Message not tagged with " + tagName));
    }

    public static ZMessage getMessage(ZMailbox mbox, String query) throws Exception {
        List<ZMessage> results = TestUtil.search(mbox, query);
        String errorMsg = String.format("Unexpected number of messages returned by query '%s'", query);
        Assert.assertEquals((String)errorMsg, (int)1, (int)results.size());
        return results.get(0);
    }

    public static void verifyFlag(ZMailbox mbox, ZMessage msg, ZMessage.Flag flag) {
        String flags = msg.getFlags();
        String errorMsg = String.format("Flag %s not found in %s", Character.valueOf(flag.getFlagChar()), msg.getFlags());
        Assert.assertTrue((String)errorMsg, (flags.indexOf(flag.getFlagChar()) >= 0 ? 1 : 0) != 0);
    }

    public static ZFolder createFolder(ZMailbox mbox, String path) throws ServiceException {
        String parentId = Integer.toString(1);
        String name = null;
        int idxLastSlash = path.lastIndexOf(47);
        if (idxLastSlash < 0) {
            name = path;
        } else if (idxLastSlash == 0) {
            name = path.substring(1);
        } else {
            String parentPath = path.substring(0, idxLastSlash);
            name = path.substring(idxLastSlash + 1);
            ZFolder parent = mbox.getFolderByPath(parentPath);
            if (parent == null) {
                String msg = String.format("Creating folder %s: parent %s does not exist", name, parentPath);
                throw ServiceException.FAILURE(msg, null);
            }
            parentId = parent.getId();
        }
        return mbox.createFolder(parentId, name, ZFolder.View.message, null, null, null);
    }

    public static ZFolder createFolder(ZMailbox mbox, String parentId, String folderName) throws ServiceException {
        return mbox.createFolder(parentId, folderName, ZFolder.View.message, null, null, null);
    }

    public static ZMountpoint createMountpoint(ZMailbox remoteMbox, String remotePath, ZMailbox localMbox, String mountpointName) throws ServiceException {
        ZFolder remoteFolder = remoteMbox.getFolderByPath(remotePath);
        if (remoteFolder == null) {
            remoteFolder = TestUtil.createFolder(remoteMbox, remotePath);
        }
        ZGetInfoResult remoteInfo = remoteMbox.getAccountInfo(true);
        remoteMbox.modifyFolderGrant(remoteFolder.getId(), ZGrant.GranteeType.all, null, "rwidx", null);
        return localMbox.createMountpoint(Integer.toString(1), mountpointName, null, null, null, ZMailbox.OwnerBy.BY_ID, remoteInfo.getId(), ZMailbox.SharedItemBy.BY_ID, remoteFolder.getId());
    }

    public static ZDataSource getDataSource(ZMailbox mbox, String name) throws ServiceException {
        for (ZDataSource ds : mbox.getAllDataSources()) {
            if (!ds.getName().equals(name)) continue;
            return ds;
        }
        return null;
    }

    public static void importDataSource(ZDataSource dataSource, ZMailbox localMbox, ZMailbox remoteMbox) throws Exception {
        TestUtil.importDataSource(dataSource, localMbox, remoteMbox, true);
    }

    public static void importDataSource(ZDataSource dataSource, ZMailbox localMbox, ZMailbox remoteMbox, boolean expectedSuccess) throws Exception {
        ZMailbox.ZImportStatus status;
        ArrayList<ZDataSource> dataSources = new ArrayList<ZDataSource>();
        dataSources.add(dataSource);
        try {
            localMbox.importData(dataSources);
            TestUtil.assertTrue((boolean)expectedSuccess);
        }
        catch (SoapFaultException e) {
            if (expectedSuccess) {
                throw e;
            }
            return;
        }
        String type = dataSource.getType().toString();
        do {
            Thread.sleep(500L);
            status = null;
            for (ZMailbox.ZImportStatus iter : localMbox.getImportStatus()) {
                if (!iter.getId().equals(dataSource.getId())) continue;
                status = iter;
            }
            TestUtil.assertNotNull((String)("No import status returned for data source " + dataSource.getName()), status);
            TestUtil.assertEquals((String)"Unexpected data source type", (String)type, (String)status.getType());
        } while (status.isRunning());
        TestUtil.assertTrue((String)("Import failed: " + status.getError()), (boolean)status.getSuccess());
        localMbox.noOp();
        if (remoteMbox != null) {
            remoteMbox.noOp();
        }
    }

    public static SoapTransport getAdminSoapTransport() throws SoapFaultException, IOException, ServiceException {
        SoapHttpTransport transport = new SoapHttpTransport(TestUtil.getAdminSoapUrl());
        Element.XMLElement auth = new Element.XMLElement(AdminConstants.AUTH_REQUEST);
        ((Element)auth).addElement("name").setText(TestUtil.getAddress("admin"));
        ((Element)auth).addElement("password").setText(DEFAULT_PASSWORD);
        Element response = transport.invoke(auth);
        String authToken = response.getElement("authToken").getText();
        transport.setAuthToken(authToken);
        return transport;
    }

    public static void assertMessageContains(String message, String subMessage) throws IOException {
        String line;
        BufferedReader msgReader = new BufferedReader(new StringReader(message));
        BufferedReader subReader = new BufferedReader(new StringReader(subMessage));
        String firstLine = subReader.readLine();
        boolean foundFirstLine = false;
        while ((line = msgReader.readLine()) != null) {
            if (!line.equals(firstLine)) continue;
            foundFirstLine = true;
            break;
        }
        String context = String.format("Could not find '%s' in message:\n", firstLine, message);
        TestUtil.assertTrue((String)context, (boolean)foundFirstLine);
        while (true) {
            line = msgReader.readLine();
            String subLine = subReader.readLine();
            if (line == null || subLine == null) break;
            TestUtil.assertEquals((String)subLine, (String)line);
        }
    }

    public static void assertEquals(Element expected, Element actual) {
        TestUtil.assertEquals(expected, actual, expected.prettyPrint(), actual.prettyPrint());
    }

    private static void assertEquals(Element expected, Element actual, String expectedDump, String actualDump) {
        TestUtil.assertEquals((String)expected.getName(), (String)actual.getName());
        List<Element> expectedChildren = expected.listElements();
        List<Element> actualChildren = actual.listElements();
        String context = String.format("Element %s, expected:\n%s\nactual:\n%s", expected.getName(), expectedDump, actualDump);
        TestUtil.assertEquals((String)(context + " children"), (String)TestUtil.getElementNames(expectedChildren), (String)TestUtil.getElementNames(actualChildren));
        for (int i = 0; i < expectedChildren.size(); ++i) {
            TestUtil.assertEquals(expectedChildren.get(i), actualChildren.get(i), expectedDump, actualDump);
        }
        TestUtil.assertEquals((String)expected.getTextTrim(), (String)actual.getTextTrim());
        Set<Element.Attribute> expectedAttrs = expected.listAttributes();
        Set<Element.Attribute> actualAttrs = actual.listAttributes();
        TestUtil.assertEquals((String)(context + " attributes"), (String)TestUtil.getAttributesAsString(expectedAttrs), (String)TestUtil.getAttributesAsString(actualAttrs));
    }

    public static void assertEquals(byte[] expected, byte[] actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null) {
            Assert.fail((String)"expected was null but actual was not.");
        }
        if (actual == null) {
            Assert.fail((String)"expected was not null but actual was.");
        }
        TestUtil.assertEquals((String)"Arrays have different length.", (int)expected.length, (int)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            TestUtil.assertEquals((String)("Data mismatch at byte " + i), (byte)expected[i], (byte)actual[i]);
        }
    }

    private static String getElementNames(List<Element> elements) {
        StringBuilder buf = new StringBuilder();
        for (Element e : elements) {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(e.getName());
        }
        return buf.toString();
    }

    private static String getAttributesAsString(Set<Element.Attribute> attrs) {
        TreeSet<String> attrStrings = new TreeSet<String>();
        for (Element.Attribute attr : attrs) {
            attrStrings.add(String.format("%s=%s", attr.getKey(), attr.getValue()));
        }
        return StringUtil.join(",", attrStrings);
    }

    public static TestNG newTestNG() {
        TestNG testng = new TestNG();
        testng.setOutputDirectory("/opt/zimbra/test-output");
        return testng;
    }

    public static String getHeaderValue(ZMailbox mbox, ZMessage msg, String headerName) throws Exception {
        String content = msg.getContent();
        if (content == null) {
            content = TestUtil.getContent(mbox, msg.getId());
        }
        TestUtil.assertNotNull((String)"Content was not fetched from the server", (Object)content);
        MimeMessage mimeMsg = new MimeMessage(JMSession.getSession(), (InputStream)new SharedByteArrayInputStream(content.getBytes()));
        return mimeMsg.getHeader(headerName, null);
    }
}

