/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.tar.TarEntry;
import com.zimbra.common.util.tar.TarInputStream;
import com.zimbra.cs.util.JMSession;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.qa.unittest.TestUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.mail.internet.MimeMessage;
import javax.mail.util.SharedByteArrayInputStream;
import junit.framework.TestCase;

public class TestUserServlet
extends TestCase {
    private static final String NAME_PREFIX = TestUserServlet.class.getSimpleName();
    private static final String USER_NAME = "user1";

    public void setUp() throws Exception {
        this.cleanUp();
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        TestUtil.addMessage(mbox, NAME_PREFIX);
    }

    public void testTarFormatter() throws Exception {
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        this.verifyTarball(mbox, "//?fmt=tgz", true, true);
        this.verifyTarball(mbox, "//?fmt=tgz&body=1", true, true);
        this.verifyTarball(mbox, "//?fmt=tgz&body=0", true, false);
        this.verifyTarball(mbox, "//?fmt=tgz&meta=1", true, true);
        this.verifyTarball(mbox, "//?fmt=tgz&meta=0", false, true);
    }

    private void verifyTarball(ZMailbox mbox, String relativePath, boolean hasMeta, boolean hasBody) throws Exception {
        InputStream in = mbox.getRESTResource(relativePath);
        TarInputStream tarIn = new TarInputStream((InputStream)new GZIPInputStream(in), "UTF-8");
        TarEntry entry = null;
        boolean foundMeta = false;
        boolean foundMessage = false;
        while ((entry = tarIn.getNextEntry()) != null) {
            if (entry.getName().endsWith(".meta")) {
                TestUserServlet.assertTrue((String)("Fround " + entry.getName()), (boolean)hasMeta);
                foundMeta = true;
            }
            if (!entry.getName().endsWith(".eml")) continue;
            byte[] content = new byte[(int)entry.getSize()];
            TestUserServlet.assertEquals((int)content.length, (int)tarIn.read(content));
            MimeMessage message = new MimeMessage(JMSession.getSession(), (InputStream)new SharedByteArrayInputStream(content));
            byte[] body = ByteUtil.getContent(message.getInputStream(), 0);
            if (hasBody) {
                TestUserServlet.assertTrue((String)(entry.getName() + " has no body"), (body.length > 0 ? 1 : 0) != 0);
            } else {
                TestUserServlet.assertEquals((String)(entry.getName() + " has a body"), (int)0, (int)body.length);
            }
            foundMessage = true;
        }
        tarIn.close();
        TestUserServlet.assertTrue((boolean)foundMessage);
        if (hasMeta) {
            TestUserServlet.assertTrue((boolean)foundMeta);
        }
    }

    public void testZipFormatter() throws Exception {
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        this.verifyZipFile(mbox, "/Inbox/?fmt=zip", true);
        this.verifyZipFile(mbox, "/Inbox/?fmt=zip&body=1", true);
        this.verifyZipFile(mbox, "/Inbox/?fmt=zip&body=0", false);
    }

    private void verifyZipFile(ZMailbox mbox, String relativePath, boolean hasBody) throws Exception {
        ZipEntry entry;
        InputStream in = mbox.getRESTResource(relativePath);
        ZipInputStream zipIn = new ZipInputStream(in);
        boolean foundMessage = false;
        while ((entry = zipIn.getNextEntry()) != null) {
            if (!entry.getName().endsWith(".eml")) continue;
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            ByteUtil.copy(zipIn, false, buf, true);
            byte[] content = buf.toByteArray();
            MimeMessage message = new MimeMessage(JMSession.getSession(), (InputStream)new SharedByteArrayInputStream(content));
            byte[] body = ByteUtil.getContent(message.getInputStream(), 0);
            if (hasBody) {
                TestUserServlet.assertTrue((String)(entry.getName() + " has no body"), (body.length > 0 ? 1 : 0) != 0);
            } else {
                TestUserServlet.assertEquals((String)(entry.getName() + " has a body"), (int)0, (int)body.length);
            }
            foundMessage = true;
        }
        zipIn.close();
        TestUserServlet.assertTrue((boolean)foundMessage);
    }

    public void tearDown() throws Exception {
        this.cleanUp();
    }

    private void cleanUp() throws Exception {
        TestUtil.deleteTestData(USER_NAME, NAME_PREFIX);
    }

    public static void main(String[] args) throws Exception {
        TestUtil.cliSetup();
        TestUtil.runTest(TestUserServlet.class);
    }
}

