/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.db.DbMailItem;
import com.zimbra.cs.db.DbResults;
import com.zimbra.cs.db.DbUtil;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.mailbox.Conversation;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.qa.unittest.TestUtil;
import junit.framework.TestCase;

public class TestUnread
extends TestCase {
    private Mailbox mMbox;
    private Account mAccount;
    private static String USER_NAME = "user1";
    private static String TEST_NAME = "TestUnread";
    private static String FOLDER1_NAME = TEST_NAME + " Folder 1";
    private static String FOLDER2_NAME = TEST_NAME + " Folder 2";
    private static String TAG1_NAME = TEST_NAME + " Tag 1";
    private static String TAG2_NAME = TEST_NAME + " Tag 2";
    private static String TAG3_NAME = TEST_NAME + " Tag 3";
    private int mMessage1Id;
    private int mMessage2Id;
    private int mMessage3Id;
    private int mFolder1Id;
    private int mFolder2Id;
    private int mTag1Id;
    private int mTag2Id;
    private int mTag3Id;
    private int mConvId;

    public TestUnread(String testName) {
        super(testName);
    }

    private Message getMessage1() throws Exception {
        return this.mMbox.getMessageById(null, this.mMessage1Id);
    }

    private Message getMessage2() throws Exception {
        return this.mMbox.getMessageById(null, this.mMessage2Id);
    }

    private Message getMessage3() throws Exception {
        return this.mMbox.getMessageById(null, this.mMessage3Id);
    }

    private Conversation getConv() throws Exception {
        return this.mMbox.getConversationById(null, this.mConvId);
    }

    private Folder getFolder1() throws Exception {
        return this.mMbox.getFolderById(null, this.mFolder1Id);
    }

    private Folder getFolder2() throws Exception {
        return this.mMbox.getFolderById(null, this.mFolder2Id);
    }

    private Tag getTag1() throws Exception {
        return this.mMbox.getTagById(null, this.mTag1Id);
    }

    private Tag getTag2() throws Exception {
        return this.mMbox.getTagById(null, this.mTag2Id);
    }

    private Tag getTag3() throws Exception {
        return this.mMbox.getTagById(null, this.mTag3Id);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.mAccount = TestUtil.getAccount(USER_NAME);
        this.mMbox = MailboxManager.getInstance().getMailboxByAccount(this.mAccount);
        TestUtil.deleteTestData(USER_NAME, TEST_NAME);
        Message msg = TestUtil.addMessage(this.mMbox, TEST_NAME);
        this.mMessage1Id = msg.getId();
        ZimbraLog.test.debug("Created message 1, id=" + this.mMessage1Id);
        msg = TestUtil.addMessage(this.mMbox, "RE: " + TEST_NAME);
        this.mMessage2Id = msg.getId();
        ZimbraLog.test.debug("Created message 2, id=" + this.mMessage2Id);
        msg = TestUtil.addMessage(this.mMbox, "RE: " + TEST_NAME);
        this.mMessage3Id = msg.getId();
        ZimbraLog.test.debug("Created message 3, id=" + this.mMessage3Id);
        this.mConvId = this.getMessage1().getConversationId();
        ZimbraLog.test.debug("Created conversation, id=" + this.mConvId);
        Folder folder = this.mMbox.createFolder(null, FOLDER1_NAME, 2, (byte)-1, 0, (byte)0, null);
        this.mFolder1Id = folder.getId();
        folder = this.mMbox.createFolder(null, FOLDER2_NAME, this.mFolder1Id, (byte)-1, 0, (byte)0, null);
        this.mFolder2Id = folder.getId();
        Tag tag = this.mMbox.createTag(null, TAG1_NAME, (byte)0);
        this.mTag1Id = tag.getId();
        tag = this.mMbox.createTag(null, TAG2_NAME, (byte)0);
        this.mTag2Id = tag.getId();
        tag = this.mMbox.createTag(null, TAG3_NAME, (byte)0);
        this.mTag3Id = tag.getId();
        this.mMbox.move(null, this.mMessage1Id, this.getMessage1().getType(), this.mFolder1Id);
        this.mMbox.move(null, this.mMessage2Id, this.getMessage1().getType(), this.mFolder2Id);
        this.mMbox.move(null, this.mMessage3Id, this.getMessage1().getType(), this.mFolder2Id);
        this.mMbox.alterTag(null, this.mMessage1Id, this.getMessage1().getType(), this.getTag1().getId(), true);
        this.mMbox.alterTag(null, this.mMessage1Id, this.getMessage1().getType(), this.getTag2().getId(), true);
        this.mMbox.alterTag(null, this.mMessage2Id, this.getMessage2().getType(), this.getTag2().getId(), true);
    }

    public void testReadMessage1() throws Exception {
        ZimbraLog.test.debug("testReadMessage1");
        this.verifySetUp();
        this.setUnread(this.getMessage1(), false);
        this.verifyMessage1Read();
    }

    public void testReadMessage2() throws Exception {
        ZimbraLog.test.debug("testReadMessage2");
        this.verifySetUp();
        this.setUnread(this.getMessage2(), false);
        TestUnread.assertEquals((String)"getMessage1().getUnreadCount()", (int)1, (int)this.getMessage1().getUnreadCount());
        TestUnread.assertEquals((String)"getMessage2().getUnreadCount()", (int)0, (int)this.getMessage2().getUnreadCount());
        TestUnread.assertEquals((String)"getMessage3().getUnreadCount()", (int)1, (int)this.getMessage3().getUnreadCount());
        TestUnread.assertEquals((String)"getConv().getUnreadCount()", (int)2, (int)this.getConv().getUnreadCount());
        TestUnread.assertEquals((String)"getFolder1().getUnreadCount()", (int)1, (int)this.getFolder1().getUnreadCount());
        TestUnread.assertEquals((String)"getFolder2().getUnreadCount()", (int)1, (int)this.getFolder2().getUnreadCount());
        TestUnread.assertEquals((String)"getTag1().getUnreadCount()", (int)1, (int)this.getTag1().getUnreadCount());
        TestUnread.assertEquals((String)"getTag2().getUnreadCount()", (int)1, (int)this.getTag2().getUnreadCount());
        TestUnread.assertEquals((String)"getTag3().getUnreadCount()", (int)0, (int)this.getTag3().getUnreadCount());
        this.verifyAllUnreadFlags();
    }

    public void testReadAllMessages() throws Exception {
        ZimbraLog.test.debug("testReadAllMessages");
        this.verifySetUp();
        this.setUnread(this.getMessage1(), false);
        this.setUnread(this.getMessage2(), false);
        this.setUnread(this.getMessage3(), false);
        this.verifyAllRead();
    }

    public void testReadConversation() throws Exception {
        ZimbraLog.test.debug("testReadConversation");
        this.setUnread(this.getConv(), false);
        this.verifyAllRead();
    }

    public void testReadFolder1() throws Exception {
        ZimbraLog.test.debug("testReadFolder1");
        this.verifySetUp();
        this.setUnread(this.getFolder1(), false);
        this.verifyMessage1Read();
    }

    public void testReadFolder2() throws Exception {
        ZimbraLog.test.debug("testReadFolder2");
        this.verifySetUp();
        this.setUnread(this.getFolder2(), false);
        TestUnread.assertEquals((String)"getMessage1().getUnreadCount()", (int)1, (int)this.getMessage1().getUnreadCount());
        TestUnread.assertEquals((String)"getMessage2().getUnreadCount()", (int)0, (int)this.getMessage2().getUnreadCount());
        TestUnread.assertEquals((String)"getMessage3().getUnreadCount()", (int)0, (int)this.getMessage3().getUnreadCount());
        TestUnread.assertEquals((String)"getConv().getUnreadCount()", (int)1, (int)this.getConv().getUnreadCount());
        TestUnread.assertEquals((String)"getFolder1().getUnreadCount()", (int)1, (int)this.getFolder1().getUnreadCount());
        TestUnread.assertEquals((String)"getFolder2().getUnreadCount()", (int)0, (int)this.getFolder2().getUnreadCount());
        TestUnread.assertEquals((String)"getTag1().getUnreadCount()", (int)1, (int)this.getTag1().getUnreadCount());
        TestUnread.assertEquals((String)"getTag2().getUnreadCount()", (int)1, (int)this.getTag2().getUnreadCount());
        TestUnread.assertEquals((String)"getTag3().getUnreadCount()", (int)0, (int)this.getTag3().getUnreadCount());
    }

    public void testReadAllFolders() throws Exception {
        ZimbraLog.test.debug("testReadAllMessages");
        this.verifySetUp();
        this.setUnread(this.getFolder1(), false);
        this.setUnread(this.getFolder2(), false);
        this.verifyAllRead();
    }

    public void testReadTag1() throws Exception {
        ZimbraLog.test.debug("testReadTag1");
        this.verifySetUp();
        this.setUnread(this.getTag1(), false);
        this.verifyMessage1Read();
    }

    public void testReadTag2() throws Exception {
        ZimbraLog.test.debug("testReadTag2");
        this.verifySetUp();
        this.setUnread(this.getTag2(), false);
        TestUnread.assertEquals((String)"getMessage1().getUnreadCount()", (int)0, (int)this.getMessage1().getUnreadCount());
        TestUnread.assertEquals((String)"getMessage2().getUnreadCount()", (int)0, (int)this.getMessage2().getUnreadCount());
        TestUnread.assertEquals((String)"getMessage3().getUnreadCount()", (int)1, (int)this.getMessage3().getUnreadCount());
        TestUnread.assertEquals((String)"getConv().getUnreadCount()", (int)1, (int)this.getConv().getUnreadCount());
        TestUnread.assertEquals((String)"getFolder1().getUnreadCount()", (int)0, (int)this.getFolder1().getUnreadCount());
        TestUnread.assertEquals((String)"getFolder2().getUnreadCount()", (int)1, (int)this.getFolder2().getUnreadCount());
        TestUnread.assertEquals((String)"getTag1().getUnreadCount()", (int)0, (int)this.getTag1().getUnreadCount());
        TestUnread.assertEquals((String)"getTag2().getUnreadCount()", (int)0, (int)this.getTag2().getUnreadCount());
        TestUnread.assertEquals((String)"getTag3().getUnreadCount()", (int)0, (int)this.getTag3().getUnreadCount());
        this.verifyAllUnreadFlags();
    }

    public void testMoveMessage() throws Exception {
        ZimbraLog.test.debug("testMoveMessage");
        this.verifySetUp();
        this.mMbox.move(null, this.mMessage2Id, this.getMessage2().getType(), this.mFolder1Id);
        TestUnread.assertEquals((String)"getMessage2().getUnreadCount()", (int)1, (int)this.getMessage2().getUnreadCount());
        TestUnread.assertEquals((String)"getFolder1().getUnreadCount()", (int)2, (int)this.getFolder1().getUnreadCount());
        TestUnread.assertEquals((String)"getFolder2().getUnreadCount()", (int)1, (int)this.getFolder2().getUnreadCount());
        this.setUnread(this.getMessage2(), false);
        TestUnread.assertEquals((String)"getMessage2().getUnreadCount()", (int)0, (int)this.getMessage2().getUnreadCount());
        TestUnread.assertEquals((String)"getFolder1().getUnreadCount()", (int)1, (int)this.getFolder1().getUnreadCount());
        TestUnread.assertEquals((String)"getFolder2().getUnreadCount()", (int)1, (int)this.getFolder2().getUnreadCount());
        this.mMbox.move(null, this.mMessage2Id, this.getMessage2().getType(), this.mFolder2Id);
        TestUnread.assertEquals((String)"getMessage2().getUnreadCount()", (int)0, (int)this.getMessage2().getUnreadCount());
        TestUnread.assertEquals((String)"getFolder1().getUnreadCount()", (int)1, (int)this.getFolder1().getUnreadCount());
        TestUnread.assertEquals((String)"getFolder2().getUnreadCount()", (int)1, (int)this.getFolder2().getUnreadCount());
    }

    public void testMoveConversation() throws Exception {
        ZimbraLog.test.debug("testMoveConversation");
        this.verifySetUp();
        this.setUnread(this.getMessage1(), false);
        this.mMbox.move(null, this.getConv().getId(), this.getConv().getType(), this.mFolder1Id);
        TestUnread.assertEquals((String)"getMessage1().getUnreadCount()", (int)0, (int)this.getMessage1().getUnreadCount());
        TestUnread.assertEquals((String)"getMessage2().getUnreadCount()", (int)1, (int)this.getMessage2().getUnreadCount());
        TestUnread.assertEquals((String)"getMessage3().getUnreadCount()", (int)1, (int)this.getMessage3().getUnreadCount());
        TestUnread.assertEquals((String)"getConv().getUnreadCount()", (int)2, (int)this.getConv().getUnreadCount());
        TestUnread.assertEquals((String)"getFolder1().getUnreadCount()", (int)2, (int)this.getFolder1().getUnreadCount());
        TestUnread.assertEquals((String)"getFolder2().getUnreadCount()", (int)0, (int)this.getFolder2().getUnreadCount());
        this.mMbox.move(null, this.getConv().getId(), this.getConv().getType(), this.mFolder2Id);
        TestUnread.assertEquals((String)"getMessage1().getUnreadCount()", (int)0, (int)this.getMessage1().getUnreadCount());
        TestUnread.assertEquals((String)"getMessage2().getUnreadCount()", (int)1, (int)this.getMessage2().getUnreadCount());
        TestUnread.assertEquals((String)"getMessage3().getUnreadCount()", (int)1, (int)this.getMessage3().getUnreadCount());
        TestUnread.assertEquals((String)"getConv().getUnreadCount()", (int)2, (int)this.getConv().getUnreadCount());
        TestUnread.assertEquals((String)"getFolder1().getUnreadCount()", (int)0, (int)this.getFolder1().getUnreadCount());
        TestUnread.assertEquals((String)"getFolder2().getUnreadCount()", (int)2, (int)this.getFolder2().getUnreadCount());
    }

    public void testTagMessage() throws Exception {
        ZimbraLog.test.debug("testTagMessage");
        this.verifySetUp();
        this.mMbox.alterTag(null, this.mMessage3Id, this.getMessage3().getType(), this.getTag3().getId(), true);
        TestUnread.assertEquals((String)"getTag3().getUnreadCount()", (int)1, (int)this.getTag3().getUnreadCount());
        this.mMbox.alterTag(null, this.mMessage2Id, this.getMessage2().getType(), this.getTag3().getId(), true);
        TestUnread.assertEquals((String)"getTag3().getUnreadCount()", (int)2, (int)this.getTag3().getUnreadCount());
        this.mMbox.alterTag(null, this.mMessage3Id, this.getMessage3().getType(), this.getTag3().getId(), false);
        TestUnread.assertEquals((String)"getTag3().getUnreadCount()", (int)1, (int)this.getTag3().getUnreadCount());
    }

    public void testTagConversation() throws Exception {
        ZimbraLog.test.debug("testTagConversation");
        this.verifySetUp();
        this.mMbox.alterTag(null, this.getConv().getId(), this.getConv().getType(), this.getTag3().getId(), true);
        TestUnread.assertEquals((String)"getTag3().getUnreadCount()", (int)3, (int)this.getTag3().getUnreadCount());
        this.mMbox.alterTag(null, this.getConv().getId(), this.getConv().getType(), this.getTag3().getId(), false);
        TestUnread.assertEquals((String)"getTag3().getUnreadCount()", (int)0, (int)this.getTag3().getUnreadCount());
    }

    public void testMoveToTrash() throws Exception {
        ZimbraLog.test.debug("testMoveToTrash");
        this.verifySetUp();
        Folder inbox = this.mMbox.getFolderById(null, 2);
        int unreadCount = inbox.getUnreadCount();
        this.mMbox.move(null, this.getConv().getId(), this.getConv().getType(), 2);
        TestUnread.assertEquals((String)"Move conversation to inbox", (int)(unreadCount + 3), (int)inbox.getUnreadCount());
        this.setUnread(this.getMessage2(), false);
        TestUnread.assertEquals((String)"Read message 2", (int)(unreadCount + 2), (int)inbox.getUnreadCount());
        this.mMbox.move(null, this.mMessage1Id, this.getMessage1().getType(), 3);
        TestUnread.assertEquals((String)"Move message to trash", (int)(unreadCount + 1), (int)inbox.getUnreadCount());
        this.mMbox.move(null, this.getConv().getId(), this.getConv().getType(), 3);
        TestUnread.assertEquals((String)"Move conversation to trash", (int)unreadCount, (int)inbox.getUnreadCount());
    }

    public void testSearch() throws Exception {
        ZimbraLog.test.debug("testSearch");
        this.verifySetUp();
        byte[] types = new byte[]{5};
        ZimbraQueryResults results = this.mMbox.search(new OperationContext(this.mMbox), "is:unread", types, SortBy.DATE_DESCENDING, 100);
        TestUnread.assertTrue((String)"No search results found", (boolean)results.hasNext());
        results.doneWithSearchResults();
    }

    public void testDeleteConversation() throws Exception {
        ZimbraLog.test.debug("testDeleteConversation");
        this.verifySetUp();
        this.mMbox.delete(null, this.getConv().getId(), this.getConv().getType());
        TestUnread.assertEquals((String)"getFolder1().getUnreadCount()", (int)0, (int)this.getFolder1().getUnreadCount());
        TestUnread.assertEquals((String)"getFolder2().getUnreadCount()", (int)0, (int)this.getFolder2().getUnreadCount());
        TestUnread.assertEquals((String)"getTag1().getUnreadCount()", (int)0, (int)this.getTag1().getUnreadCount());
        TestUnread.assertEquals((String)"getTag2().getUnreadCount()", (int)0, (int)this.getTag2().getUnreadCount());
        TestUnread.assertEquals((String)"getTag3().getUnreadCount()", (int)0, (int)this.getTag3().getUnreadCount());
    }

    public void testDeleteFolder2() throws Exception {
        ZimbraLog.test.debug("testDeleteFolder2");
        this.verifySetUp();
        this.mMbox.delete(null, this.mFolder2Id, this.getFolder2().getType());
        TestUnread.assertEquals((String)"getMessage1().getUnreadCount()", (int)1, (int)this.getMessage1().getUnreadCount());
        TestUnread.assertEquals((String)"getConv().getUnreadCount()", (int)1, (int)this.getConv().getUnreadCount());
        TestUnread.assertEquals((String)"getFolder1().getUnreadCount()", (int)1, (int)this.getFolder1().getUnreadCount());
        TestUnread.assertEquals((String)"getTag1().getUnreadCount()", (int)1, (int)this.getTag1().getUnreadCount());
        TestUnread.assertEquals((String)"getTag2().getUnreadCount()", (int)1, (int)this.getTag2().getUnreadCount());
        TestUnread.assertEquals((String)"getTag3().getUnreadCount()", (int)0, (int)this.getTag3().getUnreadCount());
    }

    public void testDeleteFolder1() throws Exception {
        ZimbraLog.test.debug("testDeleteFolder1");
        this.verifySetUp();
        this.mMbox.delete(null, this.mFolder1Id, this.getFolder1().getType());
        TestUnread.assertEquals((String)"getTag1().getUnreadCount()", (int)0, (int)this.getTag1().getUnreadCount());
        TestUnread.assertEquals((String)"getTag2().getUnreadCount()", (int)0, (int)this.getTag2().getUnreadCount());
        TestUnread.assertEquals((String)"getTag3().getUnreadCount()", (int)0, (int)this.getTag3().getUnreadCount());
    }

    private void verifyMessage1Read() throws Exception {
        TestUnread.assertEquals((String)"getMessage1().getUnreadCount()", (int)0, (int)this.getMessage1().getUnreadCount());
        TestUnread.assertEquals((String)"getMessage2().getUnreadCount()", (int)1, (int)this.getMessage2().getUnreadCount());
        TestUnread.assertEquals((String)"getMessage3().getUnreadCount()", (int)1, (int)this.getMessage3().getUnreadCount());
        TestUnread.assertEquals((String)"getConv().getUnreadCount()", (int)2, (int)this.getConv().getUnreadCount());
        TestUnread.assertEquals((String)"getFolder1().getUnreadCount()", (int)0, (int)this.getFolder1().getUnreadCount());
        TestUnread.assertEquals((String)"getFolder2().getUnreadCount()", (int)2, (int)this.getFolder2().getUnreadCount());
        TestUnread.assertEquals((String)"getTag1().getUnreadCount()", (int)0, (int)this.getTag1().getUnreadCount());
        TestUnread.assertEquals((String)"getTag2().getUnreadCount()", (int)1, (int)this.getTag2().getUnreadCount());
        TestUnread.assertEquals((String)"getTag3().getUnreadCount()", (int)0, (int)this.getTag3().getUnreadCount());
        this.verifyAllUnreadFlags();
    }

    private void verifyAllUnreadFlags() throws Exception {
        this.verifyUnreadFlag(this.getMessage1());
        this.verifyUnreadFlag(this.getMessage2());
        this.verifyUnreadFlag(this.getMessage3());
        this.verifyUnreadFlag(this.getConv());
        this.verifyUnreadFlag(this.getFolder1());
        this.verifyUnreadFlag(this.getFolder2());
        this.verifyUnreadFlag(this.getTag1());
        this.verifyUnreadFlag(this.getTag2());
        DbResults results = DbUtil.executeQuery("SELECT COUNT(*) FROM " + DbMailItem.getMailItemTableName(this.mMbox) + " WHERE mailbox_id = " + this.mMbox.getId() + " AND flags & " + Flag.BITMASK_UNREAD + " > 0");
        int numRows = results.getInt(1);
        TestUnread.assertEquals((String)("Found " + numRows + " items with old unread flag set"), (int)0, (int)numRows);
    }

    private void verifyUnreadFlag(MailItem item) throws Exception {
        String flagString = item.getFlagString();
        if (item.isUnread()) {
            TestUnread.assertTrue((String)("unread bit test: " + item.getFlagBitmask()), ((item.getFlagBitmask() & Flag.BITMASK_UNREAD) > 0 ? 1 : 0) != 0);
            TestUnread.assertTrue((String)("unread flag string: " + flagString), (flagString.indexOf(Flag.getAbbreviation(-10)) >= 0 ? 1 : 0) != 0);
        } else {
            TestUnread.assertTrue((String)("read bit test: " + item.getFlagBitmask()), ((item.getFlagBitmask() & Flag.BITMASK_UNREAD) == 0 ? 1 : 0) != 0);
            TestUnread.assertTrue((String)("read flag string: " + flagString), (flagString.indexOf(Flag.getAbbreviation(-10)) == -1 ? 1 : 0) != 0);
        }
        if (item.getType() == 5) {
            DbResults results = DbUtil.executeQuery("SELECT unread FROM " + DbMailItem.getMailItemTableName(item) + " WHERE mailbox_id = " + item.getMailboxId() + " AND id = " + item.getId());
            TestUnread.assertEquals((String)"Verify unread flag in the database", (boolean)item.isUnread(), (boolean)results.getBoolean(1));
        }
    }

    private void verifyAllRead() throws Exception {
        TestUnread.assertEquals((String)"getMessage1().getUnreadCount()", (int)0, (int)this.getMessage1().getUnreadCount());
        TestUnread.assertEquals((String)"getMessage2().getUnreadCount()", (int)0, (int)this.getMessage2().getUnreadCount());
        TestUnread.assertEquals((String)"getMessage3().getUnreadCount()", (int)0, (int)this.getMessage3().getUnreadCount());
        TestUnread.assertEquals((String)"getConv().getUnreadCount()", (int)0, (int)this.getConv().getUnreadCount());
        TestUnread.assertEquals((String)"getFolder1().getUnreadCount()", (int)0, (int)this.getFolder1().getUnreadCount());
        TestUnread.assertEquals((String)"getFolder2().getUnreadCount()", (int)0, (int)this.getFolder2().getUnreadCount());
        TestUnread.assertEquals((String)"getTag1().getUnreadCount()", (int)0, (int)this.getTag1().getUnreadCount());
        TestUnread.assertEquals((String)"getTag2().getUnreadCount()", (int)0, (int)this.getTag2().getUnreadCount());
        TestUnread.assertEquals((String)"getTag3().getUnreadCount()", (int)0, (int)this.getTag3().getUnreadCount());
        this.verifyAllUnreadFlags();
    }

    private void setUnread(MailItem item, boolean unread) throws Exception {
        this.mMbox.alterTag(null, item.getId(), item.getType(), -10, unread);
        item = this.mMbox.getItemById(null, item.getId(), item.getType());
        this.verifyUnreadFlag(item);
    }

    private void verifySetUp() throws Exception {
        TestUnread.assertEquals((String)"getMessage1().getUnreadCount()", (int)1, (int)this.getMessage1().getUnreadCount());
        TestUnread.assertEquals((String)"getMessage2().getUnreadCount()", (int)1, (int)this.getMessage2().getUnreadCount());
        TestUnread.assertEquals((String)"getMessage3().getUnreadCount()", (int)1, (int)this.getMessage3().getUnreadCount());
        TestUnread.assertEquals((String)"getConv().getUnreadCount()", (int)3, (int)this.getConv().getUnreadCount());
        TestUnread.assertEquals((String)"getFolder1().getUnreadCount()", (int)1, (int)this.getFolder1().getUnreadCount());
        TestUnread.assertEquals((String)"getFolder2().getUnreadCount()", (int)2, (int)this.getFolder2().getUnreadCount());
        TestUnread.assertEquals((String)"getTag1().getUnreadCount()", (int)1, (int)this.getTag1().getUnreadCount());
        TestUnread.assertEquals((String)"getTag2().getUnreadCount()", (int)2, (int)this.getTag2().getUnreadCount());
        TestUnread.assertEquals((String)"getTag3().getUnreadCount()", (int)0, (int)this.getTag3().getUnreadCount());
        TestUnread.assertEquals((String)"getMessage1().getFolderId()", (int)this.mFolder1Id, (int)this.getMessage1().getFolderId());
        TestUnread.assertEquals((String)"getMessage2().getFolderId()", (int)this.mFolder2Id, (int)this.getMessage2().getFolderId());
        TestUnread.assertEquals((String)"getMessage3().getFolderId()", (int)this.mFolder2Id, (int)this.getMessage3().getFolderId());
        TestUnread.assertTrue((String)"getMessage1().isTagged(getTag1())", (boolean)this.getMessage1().isTagged(this.getTag1()));
        TestUnread.assertTrue((String)"getMessage1().isTagged(getTag2())", (boolean)this.getMessage1().isTagged(this.getTag2()));
        TestUnread.assertTrue((String)"getMessage2().isTagged(getTag2())", (boolean)this.getMessage2().isTagged(this.getTag2()));
    }

    protected void tearDown() throws Exception {
        TestUtil.deleteTestData(USER_NAME, TEST_NAME);
    }
}

