/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.mailbox.Conversation;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.stats.ZimbraPerf;
import com.zimbra.qa.unittest.TestUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestTags
extends TestCase {
    private DbPool.Connection mConn;
    private Mailbox mMbox;
    private Account mAccount;
    private static String TAG_PREFIX = "TestTags";
    private static String MSG_SUBJECT = "Test tags";
    private Message mMessage1;
    private Message mMessage2;
    private Message mMessage3;
    private Message mMessage4;
    private Conversation mConv;
    private Tag[] mTags = new Tag[0];

    protected void setUp() throws Exception {
        ZimbraLog.test.debug("TestTags.setUp()");
        super.setUp();
        this.mAccount = TestUtil.getAccount("user1");
        this.mMbox = MailboxManager.getInstance().getMailboxByAccount(this.mAccount);
        this.mConn = DbPool.getConnection();
        this.cleanUp();
        this.mMessage1 = TestUtil.addMessage(this.mMbox, MSG_SUBJECT + " 1");
        this.mMessage2 = TestUtil.addMessage(this.mMbox, MSG_SUBJECT + " 2");
        this.mMessage3 = TestUtil.addMessage(this.mMbox, MSG_SUBJECT + " 3");
        this.mMessage4 = TestUtil.addMessage(this.mMbox, MSG_SUBJECT + " 4");
        this.mConv = this.mMbox.getConversationById(null, this.mMessage1.getConversationId());
        this.refresh();
    }

    public void testManyTags() throws Exception {
        int i;
        boolean runTest = false;
        if (!runTest) {
            return;
        }
        int numPrepares = ZimbraPerf.getPrepareCount();
        int numTags = 63 - this.mMbox.getTagList(null).size();
        TestTags.assertTrue((String)"Can't create any new tags", (numTags != 0 ? 1 : 0) != 0);
        this.mTags = new Tag[numTags];
        for (i = 0; i < this.mTags.length; ++i) {
            this.mTags[i] = this.mMbox.createTag(null, TAG_PREFIX + (i + 1), (byte)0);
        }
        this.refresh();
        for (i = 0; i < this.mTags.length; ++i) {
            this.mMbox.alterTag(null, this.mMessage1.getId(), this.mMessage1.getType(), this.mTags[i].getId(), true);
            this.refresh();
        }
        numPrepares = ZimbraPerf.getPrepareCount() - numPrepares;
        ZimbraLog.test.debug("testManyTags generated " + numPrepares + " SQL statements.");
    }

    public void testTagSearch() throws Exception {
        this.mTags = new Tag[4];
        for (int i = 0; i < this.mTags.length; ++i) {
            this.mTags[i] = this.mMbox.createTag(null, TAG_PREFIX + (i + 1), (byte)0);
        }
        this.refresh();
        this.mMbox.alterTag(null, this.mConv.getId(), this.mConv.getType(), this.mTags[0].getId(), true);
        this.mMbox.alterTag(null, this.mMessage2.getId(), this.mMessage2.getType(), this.mTags[0].getId(), false);
        this.mMbox.alterTag(null, this.mMessage3.getId(), this.mMessage3.getType(), this.mTags[0].getId(), false);
        this.mMbox.alterTag(null, this.mMessage4.getId(), this.mMessage4.getType(), this.mTags[0].getId(), false);
        this.mMbox.alterTag(null, this.mMessage2.getId(), this.mMessage2.getType(), this.mTags[1].getId(), true);
        this.mMbox.alterTag(null, this.mMessage3.getId(), this.mMessage3.getType(), this.mTags[1].getId(), true);
        this.mMbox.alterTag(null, this.mMessage3.getId(), this.mMessage3.getType(), this.mTags[2].getId(), true);
        this.refresh();
        Set<Integer> ids = this.search("tag:" + this.mTags[0].getName(), (byte)5);
        TestTags.assertEquals((String)"1: result size", (int)1, (int)ids.size());
        TestTags.assertTrue((String)"1: no message 1", (boolean)ids.contains(new Integer(this.mMessage1.getId())));
        ids = this.search("tag:" + this.mTags[0].getName() + " or tag:" + this.mTags[1].getName(), (byte)5);
        TestTags.assertEquals((String)"2a: result size", (int)3, (int)ids.size());
        TestTags.assertTrue((String)"2a: no message 1", (boolean)ids.contains(new Integer(this.mMessage1.getId())));
        TestTags.assertTrue((String)"2a: no message 2", (boolean)ids.contains(new Integer(this.mMessage2.getId())));
        TestTags.assertTrue((String)"2a: no message 3", (boolean)ids.contains(new Integer(this.mMessage3.getId())));
        ids = this.search("tag:" + this.mTags[1].getName() + " tag:" + this.mTags[2].getName(), (byte)5);
        TestTags.assertEquals((String)"2b: result size", (int)1, (int)ids.size());
        TestTags.assertTrue((String)"2b: no message 3", (boolean)ids.contains(new Integer(this.mMessage3.getId())));
        ids = this.search("not tag:" + this.mTags[0].getName(), (byte)5);
        TestTags.assertFalse((String)"3: message 1 found", (boolean)ids.contains(new Integer(this.mMessage1.getId())));
        TestTags.assertTrue((String)"3: no message 2", (boolean)ids.contains(new Integer(this.mMessage2.getId())));
        TestTags.assertTrue((String)"3: no message 3", (boolean)ids.contains(new Integer(this.mMessage3.getId())));
        TestTags.assertTrue((String)"3: no message 4", (boolean)ids.contains(new Integer(this.mMessage4.getId())));
        ids = this.search("not tag:" + this.mTags[1].getName() + " not tag:" + this.mTags[2].getName(), (byte)5);
        TestTags.assertTrue((String)"4: no message 1", (boolean)ids.contains(new Integer(this.mMessage1.getId())));
        TestTags.assertFalse((String)"4: contains message 2", (boolean)ids.contains(new Integer(this.mMessage2.getId())));
        TestTags.assertFalse((String)"4: contains message 3", (boolean)ids.contains(new Integer(this.mMessage3.getId())));
        TestTags.assertTrue((String)"4: no message 4", (boolean)ids.contains(new Integer(this.mMessage4.getId())));
        ids = this.search("tag:" + this.mTags[1].getName() + " not tag:" + this.mTags[2].getName(), (byte)5);
        TestTags.assertFalse((String)"5: message 1 found", (boolean)ids.contains(new Integer(this.mMessage1.getId())));
        TestTags.assertTrue((String)"5: no message 2", (boolean)ids.contains(new Integer(this.mMessage2.getId())));
        TestTags.assertFalse((String)"5: contains message 3", (boolean)ids.contains(new Integer(this.mMessage3.getId())));
        TestTags.assertFalse((String)"5: contains message 4", (boolean)ids.contains(new Integer(this.mMessage4.getId())));
        ids = this.search("tag:" + this.mTags[3].getName(), (byte)5);
        TestTags.assertEquals((String)"6: search should have returned no results", (int)0, (int)ids.size());
    }

    public void testFlagSearch() throws Exception {
        Flag replied = this.mMbox.getFlagById(-3);
        Flag flagged = this.mMbox.getFlagById(-6);
        Flag forwarded = this.mMbox.getFlagById(-4);
        this.mMbox.alterTag(null, this.mConv.getId(), this.mConv.getType(), replied.getId(), true);
        this.mMbox.alterTag(null, this.mMessage2.getId(), this.mMessage2.getType(), replied.getId(), false);
        this.mMbox.alterTag(null, this.mMessage3.getId(), this.mMessage3.getType(), replied.getId(), false);
        this.mMbox.alterTag(null, this.mMessage4.getId(), this.mMessage4.getType(), replied.getId(), false);
        this.mMbox.alterTag(null, this.mMessage2.getId(), this.mMessage2.getType(), flagged.getId(), true);
        this.mMbox.alterTag(null, this.mMessage3.getId(), this.mMessage3.getType(), flagged.getId(), true);
        this.mMbox.alterTag(null, this.mMessage3.getId(), this.mMessage3.getType(), forwarded.getId(), true);
        this.refresh();
        Set<Integer> ids = this.search("is:replied", (byte)5);
        TestTags.assertTrue((String)"1: no message 1", (boolean)ids.contains(new Integer(this.mMessage1.getId())));
        TestTags.assertFalse((String)"1: message 2 found", (boolean)ids.contains(new Integer(this.mMessage2.getId())));
        TestTags.assertFalse((String)"1: message 3 found", (boolean)ids.contains(new Integer(this.mMessage3.getId())));
        TestTags.assertFalse((String)"1: message 4 found", (boolean)ids.contains(new Integer(this.mMessage4.getId())));
        ids = this.search("is:flagged is:forwarded", (byte)5);
        TestTags.assertFalse((String)"2a: message 1 found", (boolean)ids.contains(new Integer(this.mMessage1.getId())));
        TestTags.assertFalse((String)"2a: message 2 found", (boolean)ids.contains(new Integer(this.mMessage2.getId())));
        TestTags.assertTrue((String)"2a: no message 3", (boolean)ids.contains(new Integer(this.mMessage3.getId())));
        TestTags.assertFalse((String)"2a: message 4 found", (boolean)ids.contains(new Integer(this.mMessage4.getId())));
        ids = this.search("is:replied or is:flagged", (byte)5);
        TestTags.assertTrue((String)"2b: no message 1", (boolean)ids.contains(new Integer(this.mMessage1.getId())));
        TestTags.assertTrue((String)"2b: no message 2", (boolean)ids.contains(new Integer(this.mMessage2.getId())));
        TestTags.assertTrue((String)"2b: no message 3", (boolean)ids.contains(new Integer(this.mMessage3.getId())));
        TestTags.assertFalse((String)"2b: message 4 found", (boolean)ids.contains(new Integer(this.mMessage4.getId())));
        ids = this.search("not is:replied", (byte)5);
        TestTags.assertFalse((String)"3: contains message 1", (boolean)ids.contains(new Integer(this.mMessage1.getId())));
        TestTags.assertTrue((String)"3: no message 2", (boolean)ids.contains(new Integer(this.mMessage2.getId())));
        TestTags.assertTrue((String)"3: no message 3", (boolean)ids.contains(new Integer(this.mMessage3.getId())));
        TestTags.assertTrue((String)"3: no message 4", (boolean)ids.contains(new Integer(this.mMessage4.getId())));
        ids = this.search("not is:flagged not is:forwarded", (byte)5);
        TestTags.assertTrue((String)"4: no message 1", (boolean)ids.contains(new Integer(this.mMessage1.getId())));
        TestTags.assertFalse((String)"4: contains message 2", (boolean)ids.contains(new Integer(this.mMessage2.getId())));
        TestTags.assertFalse((String)"4: contains message 3", (boolean)ids.contains(new Integer(this.mMessage3.getId())));
        TestTags.assertTrue((String)"4: no message 4", (boolean)ids.contains(new Integer(this.mMessage4.getId())));
        ids = this.search("is:flagged not is:forwarded", (byte)5);
        TestTags.assertFalse((String)"5: contains message 1", (boolean)ids.contains(new Integer(this.mMessage1.getId())));
        TestTags.assertTrue((String)"5: no message 2", (boolean)ids.contains(new Integer(this.mMessage2.getId())));
        TestTags.assertFalse((String)"5: contains message 3", (boolean)ids.contains(new Integer(this.mMessage3.getId())));
        TestTags.assertFalse((String)"5: contains message 4", (boolean)ids.contains(new Integer(this.mMessage4.getId())));
    }

    public void testSearchUnreadAsTag() throws Exception {
        boolean unseenSearchSucceeded = false;
        try {
            this.search("tag:\\Unseen", (byte)5);
            unseenSearchSucceeded = true;
        }
        catch (ServiceException e) {
            TestTags.assertEquals((String)"Unexpected exception type", (String)"mail.NO_SUCH_TAG", (String)e.getCode());
        }
        TestTags.assertFalse((String)"tag:\\Unseen search should not have succeeded", (boolean)unseenSearchSucceeded);
        Set<Integer> isUnreadIds = this.search("is:unread", (byte)5);
        Set<Integer> tagUnreadIds = this.search("tag:\\Unread", (byte)5);
        if (!isUnreadIds.containsAll(tagUnreadIds)) {
            TestTags.fail((String)("Mismatch in search results.  is:unread returned (" + StringUtil.join(",", isUnreadIds) + "), tag:\\Unread returned (" + StringUtil.join(",", tagUnreadIds) + ")"));
        }
    }

    private Set<Integer> search(String query, byte type) throws Exception {
        List<Integer> ids = TestUtil.search(this.mMbox, query, type);
        return new HashSet<Integer>(ids);
    }

    private void refresh() throws Exception {
        if (this.mMessage1 != null) {
            this.mMessage1 = this.mMbox.getMessageById(null, this.mMessage1.getId());
        }
        if (this.mMessage2 != null) {
            this.mMessage2 = this.mMbox.getMessageById(null, this.mMessage2.getId());
        }
        if (this.mMessage3 != null) {
            this.mMessage3 = this.mMbox.getMessageById(null, this.mMessage3.getId());
        }
        if (this.mMessage4 != null) {
            this.mMessage4 = this.mMbox.getMessageById(null, this.mMessage4.getId());
        }
        if (this.mConv != null) {
            this.mConv = this.mMbox.getConversationById(null, this.mConv.getId());
        }
        for (int i = 0; i < this.mTags.length; ++i) {
            this.mTags[i] = this.mMbox.getTagById(null, this.mTags[i].getId());
        }
    }

    protected void tearDown() throws Exception {
        ZimbraLog.test.debug("TestTags.tearDown()");
        this.cleanUp();
        DbPool.quietClose(this.mConn);
        super.tearDown();
    }

    private void cleanUp() throws Exception {
        Set<Integer> messageIds = this.search("subject:\"Test tags\"", (byte)5);
        Iterator<Comparable<Integer>> i = messageIds.iterator();
        while (i.hasNext()) {
            int id = i.next();
            this.mMbox.delete(null, id, (byte)5);
        }
        List<Tag> tagList = this.mMbox.getTagList(null);
        if (tagList == null) {
            return;
        }
        for (Tag tag : tagList) {
            if (!tag.getName().startsWith(TAG_PREFIX)) continue;
            this.mMbox.delete(null, tag.getId(), tag.getType());
        }
    }
}

