/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.cs.zclient.ZFilterAction;
import com.zimbra.cs.zclient.ZFilterCondition;
import com.zimbra.cs.zclient.ZFilterRule;
import com.zimbra.cs.zclient.ZFilterRules;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZMessage;
import com.zimbra.cs.zclient.ZTag;
import com.zimbra.qa.unittest.TestUtil;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class TestTagFilterRules
extends TestCase {
    private static final String USER_NAME = "user1";
    private static final String NAME_PREFIX = "TestTagFilterRules";
    private static final String TAG_NAME = "TestTagFilterRules";
    private static final String NEW_TAG_NAME = "TestTagFilterRules2";
    private ZMailbox mMbox;
    private ZTag mTag;
    private ZFilterRules mOriginalRules;

    public void setUp() throws Exception {
        this.cleanUp();
        this.mMbox = TestUtil.getZMailbox(USER_NAME);
        this.mTag = this.mMbox.createTag("TestTagFilterRules", ZTag.Color.purple);
        this.mOriginalRules = this.mMbox.getFilterRules();
        this.mMbox.saveFilterRules(this.getRules());
    }

    public void testRenameTag() throws Exception {
        String sender = TestUtil.getAddress(USER_NAME);
        String recipient = TestUtil.getAddress(USER_NAME);
        String subject = "TestTagFilterRules testRenameTag 1";
        TestUtil.addMessageLmtp(subject, recipient, sender);
        ZMessage msg = TestUtil.getMessage(this.mMbox, "tag:TestTagFilterRules");
        TestUtil.verifyTag(this.mMbox, msg, "TestTagFilterRules");
        this.mMbox.renameTag(this.mTag.getId(), NEW_TAG_NAME);
        ZFilterAction.ZTagAction action = (ZFilterAction.ZTagAction)this.mMbox.getFilterRules(true).getRules().get(0).getActions().get(0);
        TestTagFilterRules.assertEquals((String)"Tag name didn't change", (String)NEW_TAG_NAME, (String)action.getTagName());
        subject = "TestTagFilterRules testRenameTag 2";
        TestUtil.addMessageLmtp(subject, recipient, sender);
        List<ZMessage> messages = TestUtil.search(this.mMbox, "tag:TestTagFilterRules2");
        TestTagFilterRules.assertEquals((String)"Incorrect number of tagged messages", (int)2, (int)messages.size());
        for (ZMessage msg2 : messages) {
            TestUtil.verifyTag(this.mMbox, msg2, NEW_TAG_NAME);
        }
    }

    public void tearDown() throws Exception {
        this.mMbox.saveFilterRules(this.mOriginalRules);
        this.cleanUp();
    }

    public void cleanUp() throws Exception {
        TestUtil.deleteTestData(USER_NAME, "TestTagFilterRules");
    }

    private ZFilterRules getRules() throws Exception {
        ArrayList<ZFilterRule> rules = new ArrayList<ZFilterRule>();
        ArrayList<ZFilterCondition> conditions = new ArrayList<ZFilterCondition>();
        ArrayList<ZFilterAction> actions = new ArrayList<ZFilterAction>();
        conditions.add(new ZFilterCondition.ZHeaderCondition("subject", ZFilterCondition.HeaderOp.CONTAINS, "TestTagFilterRules"));
        actions.add(new ZFilterAction.ZTagAction("TestTagFilterRules"));
        rules.add(new ZFilterRule("TestTagFilterRules", true, false, conditions, actions));
        return new ZFilterRules(rules);
    }

    public static void main(String[] args) throws Exception {
        TestUtil.cliSetup();
        TestUtil.runTest(TestTagFilterRules.class);
    }
}

