/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.client.LmcSession;
import com.zimbra.cs.client.soap.LmcCheckSpellingRequest;
import com.zimbra.cs.client.soap.LmcCheckSpellingResponse;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.qa.unittest.TestUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import junit.framework.TestCase;

public class TestSpellCheck
extends TestCase {
    private static final String USER_NAME = "user1";
    private static final String TEXT = "On a cycle the fram is gone. You're completely in cotnact with it all.\nYou're in the scene, not just watching it anymore, and the sense of presence\nis overwhelming. That concrete whizing by five inches below your foot is the\nreal thing, the same \"stuff\" you walk on, it's right there, so blurred you can't\nfocus on it, yet you can put your foot down and touch it anytime, and the\nwhole thing, the whole experience, is nevr removed from immediate\nconsciousness.";
    private String[] mOriginalDictionaries;
    private boolean mAvailable = false;

    public void setUp() throws Exception {
        this.mOriginalDictionaries = Provisioning.getInstance().getLocalServer().getSpellAvailableDictionary();
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        ZMailbox.CheckSpellingResult result = mbox.checkSpelling("test");
        this.mAvailable = result.getIsAvailable();
        if (!this.mAvailable) {
            ZimbraLog.test.info("Spell checking service is not available.  Skipping tests.");
        }
    }

    public void testCheckSpelling() throws Exception {
        if (!this.mAvailable) {
            return;
        }
        LmcSession session = TestUtil.getSoapSession(USER_NAME);
        LmcCheckSpellingRequest req = new LmcCheckSpellingRequest(TEXT);
        req.setSession(session);
        LmcCheckSpellingResponse response = (LmcCheckSpellingResponse)req.invoke(TestUtil.getSoapUrl());
        TestSpellCheck.assertTrue((boolean)response.isAvailable());
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Iterator<String> i = response.getMisspelledWordsIterator();
        while (i.hasNext()) {
            String word = i.next();
            map.put(word, response.getSuggestions(word));
        }
        TestSpellCheck.assertEquals((String)"Number of misspelled words", (int)4, (int)map.size());
        TestSpellCheck.assertTrue((String)"fram", (response.getSuggestions("fram").length > 0 ? 1 : 0) != 0);
        TestSpellCheck.assertTrue((String)"cotnact", (response.getSuggestions("cotnact").length > 0 ? 1 : 0) != 0);
        TestSpellCheck.assertTrue((String)"whizing", (response.getSuggestions("whizing").length > 0 ? 1 : 0) != 0);
        TestSpellCheck.assertTrue((String)"nevr", (response.getSuggestions("nevr").length > 0 ? 1 : 0) != 0);
        ZimbraLog.test.debug("Successfully tested spell checking");
    }

    public void testGetDictionaries() throws Exception {
        Server server = Provisioning.getInstance().getLocalServer();
        server.setSpellAvailableDictionary(new String[]{"dict1", "dict2"});
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        Element.XMLElement request = new Element.XMLElement(MailConstants.GET_SPELL_DICTIONARIES_REQUEST);
        Element response = mbox.invoke(request);
        HashSet<String> expected = new HashSet<String>();
        expected.add("dict1");
        expected.add("dict2");
        HashSet<String> actual = new HashSet<String>();
        for (Element eDict : response.listElements("dictionary")) {
            actual.add(eDict.getText());
        }
        TestSpellCheck.assertEquals((int)2, (int)actual.size());
        actual.removeAll(expected);
        TestSpellCheck.assertEquals((int)0, (int)actual.size());
    }

    public void testUnexpectedCharacters() throws Exception {
        if (!this.mAvailable) {
            return;
        }
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        ZMailbox.CheckSpellingResult result = mbox.checkSpelling("one \u00a0tuo two");
        TestSpellCheck.assertEquals((int)1, (int)result.getMisspellings().size());
    }

    public void testSpanish() throws Exception {
        if (!this.mAvailable) {
            return;
        }
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        ZMailbox.CheckSpellingResult result = mbox.checkSpelling("reunion", "es");
        TestSpellCheck.assertEquals((int)1, (int)result.getMisspellings().size());
        ZMailbox.Misspelling misspelling = result.getMisspellings().get(0);
        TestSpellCheck.assertEquals((String)"reunion", (String)misspelling.getWord());
        String expected = "reuni\u00f3n";
        for (String suggestion : misspelling.getSuggestions()) {
            if (!suggestion.equals(expected)) continue;
            return;
        }
        TestSpellCheck.fail((String)("Could not find expected suggestion '" + expected + "'"));
    }

    public void tearDown() throws Exception {
        Provisioning.getInstance().getLocalServer().setSpellAvailableDictionary(this.mOriginalDictionaries);
    }

    public static void main(String[] args) throws Exception {
        TestUtil.cliSetup();
        TestUtil.runTest(TestSpellCheck.class);
    }
}

