/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.service.util.SpamHandler;
import com.zimbra.cs.util.JMSession;
import com.zimbra.qa.unittest.TestUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.mail.internet.MimeMessage;
import junit.framework.TestCase;

public class TestSpam
extends TestCase {
    private static final String NAME_PREFIX = TestCase.class.getSimpleName();
    private static final String USER_NAME = "user1";
    private String mOriginalSpamHeaderValue;

    public void setUp() throws Exception {
        this.mOriginalSpamHeaderValue = Provisioning.getInstance().getConfig().getSpamHeaderValue();
    }

    public void testSpam() throws Exception {
        String coreContent = TestUtil.getTestMessage(NAME_PREFIX + " testSpam", USER_NAME, USER_NAME, null);
        MimeMessage msg = new MimeMessage(JMSession.getSession(), (InputStream)new ByteArrayInputStream(coreContent.getBytes()));
        TestSpam.assertFalse((boolean)SpamHandler.isSpam(msg));
        String headerName = Provisioning.getInstance().getConfig().getSpamHeader();
        String singleLineSpamContent = headerName + ": YES\r\n" + coreContent;
        msg = new MimeMessage(JMSession.getSession(), (InputStream)new ByteArrayInputStream(singleLineSpamContent.getBytes()));
        TestSpam.assertTrue((boolean)SpamHandler.isSpam(msg));
        Provisioning.getInstance().getConfig().setSpamHeaderValue("spam.*");
        String folderSpamContent = headerName + ": spam, SpamAssassin (score=5.701, required 5,\r\n" + "   DCC_CHECK 1.37, FH_RELAY_NODNS 1.45, RATWARE_RCVD_PF 2.88)\r\n" + coreContent;
        msg = new MimeMessage(JMSession.getSession(), (InputStream)new ByteArrayInputStream(folderSpamContent.getBytes()));
        TestSpam.assertTrue((boolean)SpamHandler.isSpam(msg));
    }

    public void tearDown() throws Exception {
        Provisioning.getInstance().getConfig().setSpamHeaderValue(this.mOriginalSpamHeaderValue);
    }

    public static void main(String[] args) throws Exception {
        TestUtil.cliSetup();
        TestUtil.runTest(TestSpam.class);
    }
}

