/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.soap.SoapHttpTransport;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.qa.unittest.TestUtil;
import junit.framework.TestCase;

public class TestSoap
extends TestCase {
    private static final String NAME_PREFIX = TestSoap.class.getSimpleName();
    private String mOriginalSoapRequestMaxSize;
    private String mOriginalSoapExposeVersion;

    public void setUp() throws Exception {
        Server server = Provisioning.getInstance().getLocalServer();
        this.mOriginalSoapRequestMaxSize = server.getAttr("zimbraSoapRequestMaxSize", "");
        this.mOriginalSoapExposeVersion = server.getAttr("zimbraSoapExposeVersion", "");
        this.cleanUp();
    }

    public void testSoapRequestMaxSize() throws Exception {
        StringBuilder messageBody = new StringBuilder();
        for (int i = 1; i <= 100; ++i) {
            messageBody.append("Morey Amsterdam was a great man.  Morey Amsterdam was not a sandwich.\r\n");
        }
        this.setSoapRequestMaxSize(100000);
        ZMailbox mbox = TestUtil.getZMailbox("user1");
        TestUtil.sendMessage(mbox, "user1", NAME_PREFIX + " 1", messageBody.toString());
        this.setSoapRequestMaxSize(1000);
        try {
            TestUtil.sendMessage(mbox, "user1", NAME_PREFIX + " 2", messageBody.toString());
            TestSoap.fail((String)"SOAP request should not have succeeded.");
        }
        catch (SoapFaultException e) {
            TestSoap.assertTrue((String)("Unexpected error: " + e.toString()), (boolean)e.toString().contains("bytes set for zimbraSoapRequestMaxSize"));
        }
    }

    public void testAccountGetInfoRequest() throws Exception {
        SoapHttpTransport transport = new SoapHttpTransport(TestUtil.getSoapUrl());
        Element request = Element.create(transport.getRequestProtocol(), AccountConstants.GET_VERSION_INFO_REQUEST);
        TestUtil.setServerAttr("zimbraSoapExposeVersion", "TRUE");
        Element response = transport.invoke(request);
        this.validateSoapVersionResponse(response);
        TestUtil.setServerAttr("zimbraSoapExposeVersion", "FALSE");
        request = Element.create(transport.getRequestProtocol(), AccountConstants.GET_VERSION_INFO_REQUEST);
        try {
            response = transport.invoke(request);
            TestSoap.fail((String)"GetInfoRequest should have failed");
        }
        catch (SoapFaultException e) {
            TestSoap.assertEquals((String)"service.PERM_DENIED", (String)e.getCode());
        }
    }

    public void testAdminGetInfoRequest() throws Exception {
        SoapHttpTransport transport = new SoapHttpTransport(TestUtil.getAdminSoapUrl());
        Element request = Element.create(transport.getRequestProtocol(), AdminConstants.GET_VERSION_INFO_REQUEST);
        Element response = transport.invoke(request);
        this.validateSoapVersionResponse(response);
    }

    private void validateSoapVersionResponse(Element response) throws ServiceException {
        TestSoap.assertEquals((String)AccountConstants.GET_VERSION_INFO_RESPONSE.getName(), (String)response.getName());
        Element info = response.getElement("info");
        TestSoap.assertNotNull((Object)info.getAttribute("buildDate"));
        TestSoap.assertNotNull((Object)info.getAttribute("host"));
        TestSoap.assertNotNull((Object)info.getAttribute("release"));
        TestSoap.assertNotNull((Object)info.getAttribute("version"));
    }

    public void tearDown() throws Exception {
        TestUtil.setServerAttr("zimbraSoapRequestMaxSize", this.mOriginalSoapRequestMaxSize);
        TestUtil.setServerAttr("zimbraSoapExposeVersion", this.mOriginalSoapExposeVersion);
        this.cleanUp();
    }

    private void cleanUp() throws Exception {
        TestUtil.deleteTestData("user1", NAME_PREFIX);
    }

    private void setSoapRequestMaxSize(int numBytes) throws Exception {
        TestUtil.setServerAttr("zimbraSoapRequestMaxSize", Integer.toString(numBytes));
    }

    public static void main(String[] args) throws Exception {
        TestUtil.cliSetup();
        TestUtil.runTest(TestSoap.class);
    }
}

