/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ShareInfoData;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZGrant;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.qa.unittest.TestProvisioningUtil;
import com.zimbra.qa.unittest.TestUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestShareInfo
extends TestCase {
    private static String TEST_NAME = "test-shareinfo";
    private static String TEST_ID = TestProvisioningUtil.genTestId();
    private static String PASSWORD = "test123";
    private static Provisioning mProv;
    private static String DOMAIN_NAME;

    private static void init() throws Exception {
        mProv = Provisioning.getInstance();
        Domain d = TestShareInfo.getDomain();
    }

    private static Domain getDomain() throws Exception {
        Domain domain = mProv.get(Provisioning.DomainBy.name, DOMAIN_NAME);
        if (domain == null) {
            domain = mProv.createDomain(DOMAIN_NAME, new HashMap<String, Object>());
        }
        return domain;
    }

    private String getEmail(String localPart, String testName) {
        return localPart + "-" + testName + "@" + DOMAIN_NAME;
    }

    private String getEmail(String localPart, String testName, String domainName) {
        return localPart + "-" + testName + "@" + domainName;
    }

    private int createFolderAndGrantRight(Account owner, Account grantee, String folderPath, String rights) throws ServiceException {
        ZMailbox ownerMbox = TestUtil.getZMailbox(owner.getName());
        ZFolder folder = TestUtil.createFolder(ownerMbox, folderPath);
        ownerMbox.modifyFolderGrant(folder.getId(), ZGrant.GranteeType.usr, grantee.getName(), rights, null);
        return Integer.valueOf(folder.getId());
    }

    private int createFolderAndGrantRight(Account owner, DistributionList grantee, String folderPath, String rights) throws ServiceException {
        ZMailbox ownerMbox = TestUtil.getZMailbox(owner.getName());
        ZFolder folder = TestUtil.createFolder(ownerMbox, folderPath);
        ownerMbox.modifyFolderGrant(folder.getId(), ZGrant.GranteeType.grp, grantee.getName(), rights, null);
        return Integer.valueOf(folder.getId());
    }

    private void grantRight(Account owner, DistributionList grantee, String folderId, String rights) throws ServiceException {
        ZMailbox ownerMbox = TestUtil.getZMailbox(owner.getName());
        ownerMbox.modifyFolderGrant(folderId, ZGrant.GranteeType.grp, grantee.getName(), rights, null);
    }

    private ZFolder createFolder(Account owner, String folderPath) throws ServiceException {
        ZMailbox ownerMbox = TestUtil.getZMailbox(owner.getName());
        ZFolder folder = TestUtil.createFolder(ownerMbox, folderPath);
        return folder;
    }

    private void deleteFolder(Account owner, String folderId) throws Exception {
        ZMailbox ownerMbox = TestUtil.getZMailbox(owner.getName());
        ownerMbox.deleteFolder(folderId);
    }

    private void doTestPublishShareInfo(DistributionList publishingEntry, Provisioning.PublishShareInfoAction action, Account ownerForPublishing, Account ownerForGet, String folderPath, Expected expectedDirectOnly, Expected expectedIncludeAll) throws ServiceException {
        mProv.publishShareInfo(publishingEntry, action, ownerForPublishing, folderPath);
        Expected verifyMe = ownerForGet == null ? expectedIncludeAll : expectedDirectOnly;
        VerifyPublishedVisitor visitor = new VerifyPublishedVisitor(verifyMe);
        mProv.getPublishedShareInfo(publishingEntry, ownerForGet, visitor);
        verifyMe.OK();
    }

    private void doTestPublish(DistributionList publishingEntry, Account ownerForPublishing, Account ownerForGet, String folderPath, Expected expectedDirectOnly, Expected expectedIncludeAll) throws ServiceException {
        this.doTestPublishShareInfo(publishingEntry, Provisioning.PublishShareInfoAction.add, ownerForPublishing, ownerForGet, folderPath, expectedDirectOnly, expectedIncludeAll);
    }

    private void doTestUnpublish(DistributionList publishingEntry, Account ownerForPublishing, Account ownerForGet, String folderPath, Expected expectedDirectOnly, Expected expectedIncludeAll) throws ServiceException {
        this.doTestPublishShareInfo(publishingEntry, Provisioning.PublishShareInfoAction.remove, ownerForPublishing, ownerForGet, folderPath, expectedDirectOnly, expectedIncludeAll);
    }

    private void doTestGetShareInfo(Account authedAcct, Account ownerAcct, Expected expected) throws ServiceException {
        TestProvisioningUtil.SoapProvisioningUser prov = TestProvisioningUtil.getSoapProvisioningUser(authedAcct.getName(), PASSWORD);
        VerifyPublishedVisitor visitor = new VerifyPublishedVisitor(expected);
        ((Provisioning)prov).getShareInfo(ownerAcct, visitor);
        expected.OK();
    }

    public void testDLShareInfoGrantToDL() throws Exception {
        String testName = this.getName();
        String ownerEmail = this.getEmail("owner", testName);
        Account owner = mProv.createAccount(ownerEmail, PASSWORD, null);
        String granteeEmail = this.getEmail("grantee-dl", testName);
        DistributionList grantee = mProv.createDistributionList(granteeEmail, null);
        String acctInDlEmail = this.getEmail("acct-in-dl", testName);
        Account acctInDl = mProv.createAccount(acctInDlEmail, PASSWORD, null);
        grantee.addMembers(new String[]{acctInDlEmail});
        String acctNotInDlEmail = this.getEmail("acct-not-in-dl", testName);
        Account acctNotInDl = mProv.createAccount(acctNotInDlEmail, PASSWORD, null);
        String dlInDlEmail = this.getEmail("dl-in-dl", testName);
        DistributionList dlInDL = mProv.createDistributionList(dlInDlEmail, null);
        grantee.addMembers(new String[]{dlInDlEmail});
        String dlNotInDlEmail = this.getEmail("dl-not-in-dl", testName);
        DistributionList dlNotInDL = mProv.createDistributionList(dlNotInDlEmail, null);
        String folderPath = "/test";
        short rights = 3;
        int folderId = this.createFolderAndGrantRight(owner, grantee, folderPath, ACL.rightsToString(rights));
        String subFolderPath = "/test/sub";
        ZFolder subFolder = this.createFolder(owner, subFolderPath);
        int subFolderId = Integer.valueOf(subFolder.getId());
        Expected.ExpectedShareInfo esi = new Expected.ExpectedShareInfo(owner.getId(), owner.getName(), folderId, folderPath, rights, 2, grantee.getId(), grantee.getName());
        Expected expectedDirectOnly = new Expected();
        expectedDirectOnly.add(esi);
        Expected expectedAll = new Expected();
        expectedAll.add(esi);
        this.doTestPublish(grantee, owner, owner, folderPath, expectedDirectOnly, expectedAll);
        expectedDirectOnly = new Expected();
        expectedDirectOnly.add(esi);
        expectedAll = new Expected();
        expectedAll.add(esi);
        this.doTestPublish(dlInDL, owner, owner, folderPath, expectedDirectOnly, expectedAll);
        expectedDirectOnly = new Expected();
        expectedAll = new Expected();
        this.doTestPublish(dlNotInDL, owner, owner, folderPath, expectedDirectOnly, expectedAll);
        Expected.ExpectedShareInfo esiSubFolder = new Expected.ExpectedShareInfo(owner.getId(), owner.getName(), subFolderId, subFolderPath, rights, 2, grantee.getId(), grantee.getName());
        expectedDirectOnly = new Expected();
        expectedDirectOnly.add(esi);
        expectedDirectOnly.add(esiSubFolder);
        expectedAll = new Expected();
        expectedAll.add(esi);
        expectedAll.add(esiSubFolder);
        this.doTestPublish(grantee, owner, owner, subFolderPath, expectedDirectOnly, expectedAll);
        expectedDirectOnly = new Expected();
        expectedDirectOnly.add(esi);
        expectedDirectOnly.add(esiSubFolder);
        expectedAll = new Expected();
        expectedAll.add(esi);
        expectedAll.add(esiSubFolder);
        this.doTestPublish(dlInDL, owner, owner, subFolderPath, expectedDirectOnly, expectedAll);
        expectedDirectOnly = new Expected();
        expectedAll = new Expected();
        this.doTestPublish(dlNotInDL, owner, owner, subFolderPath, expectedDirectOnly, expectedAll);
    }

    public void testGetShareInfoByOwner() throws Exception {
        String testName = this.getName();
        String owner1Email = this.getEmail("owner1", testName);
        Account owner1 = mProv.createAccount(owner1Email, PASSWORD, null);
        String owner2Email = this.getEmail("owner2", testName);
        Account owner2 = mProv.createAccount(owner2Email, PASSWORD, null);
        String granteeEmail = this.getEmail("grantee-dl", testName);
        DistributionList grantee = mProv.createDistributionList(granteeEmail, null);
        String acctInDlEmail = this.getEmail("acct-in-dl", testName);
        Account acctInDl = mProv.createAccount(acctInDlEmail, PASSWORD, null);
        grantee.addMembers(new String[]{acctInDlEmail});
        String acctNotInDlEmail = this.getEmail("acct-not-in-dl", testName);
        Account acctNotInDl = mProv.createAccount(acctNotInDlEmail, PASSWORD, null);
        String folderPathOwner1 = "/test-of-owner1";
        short rights = 3;
        int folderIdOfOwner1 = this.createFolderAndGrantRight(owner1, grantee, folderPathOwner1, ACL.rightsToString(rights));
        String folderPathOwner2 = "/test-of-owner2";
        int folderIdOfOwner2 = this.createFolderAndGrantRight(owner2, grantee, folderPathOwner2, ACL.rightsToString(rights));
        Expected.ExpectedShareInfo esiOwner1 = new Expected.ExpectedShareInfo(owner1.getId(), owner1.getName(), folderIdOfOwner1, folderPathOwner1, rights, 2, grantee.getId(), grantee.getName());
        Expected.ExpectedShareInfo esiOwner2 = new Expected.ExpectedShareInfo(owner2.getId(), owner2.getName(), folderIdOfOwner2, folderPathOwner2, rights, 2, grantee.getId(), grantee.getName());
        Expected expectedDirectOnly = new Expected();
        expectedDirectOnly.add(esiOwner1);
        Expected expectedAll = new Expected();
        expectedAll.add(esiOwner1);
        this.doTestPublish(grantee, owner1, null, folderPathOwner1, expectedDirectOnly, expectedAll);
        expectedDirectOnly = new Expected();
        expectedDirectOnly.add(esiOwner1);
        expectedDirectOnly.add(esiOwner2);
        expectedAll = new Expected();
        expectedAll.add(esiOwner1);
        expectedAll.add(esiOwner2);
        this.doTestPublish(grantee, owner2, null, folderPathOwner2, expectedDirectOnly, expectedAll);
    }

    public void testRemoveShareInfo() throws Exception {
        String testName = this.getName();
        String ownerEmail = this.getEmail("owner", testName);
        Account owner = mProv.createAccount(ownerEmail, PASSWORD, null);
        String granteeEmail = this.getEmail("grantee-dl", testName);
        DistributionList grantee = mProv.createDistributionList(granteeEmail, null);
        String folderPath = "/test";
        short rights = 3;
        int folderId = this.createFolderAndGrantRight(owner, grantee, folderPath, ACL.rightsToString(rights));
        String subFolder1Path = "/test/sub1";
        ZFolder subFolder1 = this.createFolder(owner, subFolder1Path);
        int subFolder1Id = Integer.valueOf(subFolder1.getId());
        String subFolder2Path = "/test/sub1/sub2";
        ZFolder subFolder2 = this.createFolder(owner, subFolder2Path);
        int subFolder2Id = Integer.valueOf(subFolder2.getId());
        Expected.ExpectedShareInfo esi = new Expected.ExpectedShareInfo(owner.getId(), owner.getName(), folderId, folderPath, rights, 2, grantee.getId(), grantee.getName());
        Expected.ExpectedShareInfo esiSubFolder1 = new Expected.ExpectedShareInfo(owner.getId(), owner.getName(), subFolder1Id, subFolder1Path, rights, 2, grantee.getId(), grantee.getName());
        Expected.ExpectedShareInfo esiSubFolder2 = new Expected.ExpectedShareInfo(owner.getId(), owner.getName(), subFolder2Id, subFolder2Path, rights, 2, grantee.getId(), grantee.getName());
        Expected expectedAll = null;
        Expected expectedDirectOnly = new Expected();
        expectedDirectOnly.add(esi);
        this.doTestPublish(grantee, owner, owner, folderPath, expectedDirectOnly, expectedAll);
        expectedDirectOnly = new Expected();
        expectedDirectOnly.add(esi);
        expectedDirectOnly.add(esiSubFolder1);
        this.doTestPublish(grantee, owner, owner, subFolder1Path, expectedDirectOnly, expectedAll);
        expectedDirectOnly = new Expected();
        expectedDirectOnly.add(esi);
        expectedDirectOnly.add(esiSubFolder1);
        expectedDirectOnly.add(esiSubFolder2);
        this.doTestPublish(grantee, owner, owner, subFolder2Path, expectedDirectOnly, expectedAll);
        this.deleteFolder(owner, "" + subFolder1Id);
        expectedDirectOnly = new Expected();
        expectedDirectOnly.add(esi);
        expectedDirectOnly.add(esiSubFolder2);
        this.doTestUnpublish(grantee, owner, owner, subFolder1Path, expectedDirectOnly, expectedAll);
        expectedDirectOnly = new Expected();
        this.doTestUnpublish(grantee, owner, owner, null, expectedDirectOnly, expectedAll);
    }

    public void testRepublish() throws Exception {
        String testName = this.getName();
        String ownerEmail = this.getEmail("owner", testName);
        Account owner = mProv.createAccount(ownerEmail, PASSWORD, null);
        String granteeEmail = this.getEmail("grantee-dl", testName);
        DistributionList grantee = mProv.createDistributionList(granteeEmail, null);
        String folderPath = "/test";
        short rights = 3;
        int folderId = this.createFolderAndGrantRight(owner, grantee, folderPath, ACL.rightsToString(rights));
        Expected.ExpectedShareInfo esi = new Expected.ExpectedShareInfo(owner.getId(), owner.getName(), folderId, folderPath, rights, 2, grantee.getId(), grantee.getName());
        Expected expectedDirectOnly = null;
        Expected expectedAll = null;
        expectedDirectOnly = new Expected();
        expectedDirectOnly.add(esi);
        this.doTestPublish(grantee, owner, owner, folderPath, expectedDirectOnly, expectedAll);
        short newRights = 259;
        this.grantRight(owner, grantee, String.valueOf(folderId), ACL.rightsToString(newRights));
        Expected.ExpectedShareInfo esiWithNewRights = new Expected.ExpectedShareInfo(owner.getId(), owner.getName(), folderId, folderPath, newRights, 2, grantee.getId(), grantee.getName());
        expectedDirectOnly = new Expected();
        expectedDirectOnly.add(esiWithNewRights);
        this.doTestPublish(grantee, owner, owner, folderPath, expectedDirectOnly, expectedAll);
    }

    public static void main(String[] args) throws Exception {
        TestUtil.cliSetup();
        TestShareInfo.init();
        TestUtil.runTest(TestShareInfo.class);
    }

    static {
        DOMAIN_NAME = TestProvisioningUtil.baseDomainName(TEST_NAME, TEST_ID);
    }

    private static class VerifyPublishedVisitor
    implements Provisioning.PublishedShareInfoVisitor {
        Expected mExpected;

        VerifyPublishedVisitor(Expected expected) {
            this.mExpected = expected;
        }

        public void visit(ShareInfoData sid) throws ServiceException {
            this.mExpected.verify(sid);
        }
    }

    static class Expected {
        private List<ExpectedShareInfo> mExpected = new ArrayList<ExpectedShareInfo>();

        Expected() {
        }

        ExpectedShareInfo add(String ownerAcctId, String ownerAcctName, int folderid, String folderPath, short rights, byte granteeType, String granteeId, String granteeName) {
            ExpectedShareInfo esi = new ExpectedShareInfo(ownerAcctId, ownerAcctName, folderid, folderPath, rights, granteeType, granteeId, granteeName);
            this.mExpected.add(esi);
            return esi;
        }

        ExpectedShareInfo add(ExpectedShareInfo copy) {
            ExpectedShareInfo esi = new ExpectedShareInfo(copy);
            this.mExpected.add(esi);
            return esi;
        }

        private void remove(ExpectedShareInfo esi) {
            this.mExpected.remove(esi);
        }

        void verify(ShareInfoData sid) throws ServiceException {
            for (ExpectedShareInfo esi : this.mExpected) {
                if (!esi.isTheSame(sid)) continue;
                this.mExpected.remove(esi);
                return;
            }
            sid.dump();
            Assert.fail();
        }

        void OK() {
            Assert.assertTrue((boolean)this.mExpected.isEmpty());
        }

        static class ExpectedShareInfo {
            private String mOwnerAcctId;
            private String mOwnerAcctName;
            private int mFolderId;
            private String mFolderPath;
            private short mRights;
            private byte mGranteeType;
            private String mGranteeId;
            private String mGranteeName;

            ExpectedShareInfo(String ownerAcctId, String ownerAcctName, int folderid, String folderPath, short rights, byte granteeType, String granteeId, String granteeName) {
                this.mOwnerAcctId = ownerAcctId;
                this.mOwnerAcctName = ownerAcctName;
                this.mFolderId = folderid;
                this.mFolderPath = folderPath;
                this.mRights = rights;
                this.mGranteeType = granteeType;
                this.mGranteeId = granteeId;
                this.mGranteeName = granteeName;
            }

            ExpectedShareInfo(ExpectedShareInfo copy) {
                this(copy.mOwnerAcctId, copy.mOwnerAcctName, copy.mFolderId, copy.mFolderPath, copy.mRights, copy.mGranteeType, copy.mGranteeId, copy.mGranteeName);
            }

            boolean isTheSame(ShareInfoData sid) throws ServiceException {
                if (!this.mOwnerAcctId.equals(sid.getOwnerAcctId())) {
                    return false;
                }
                if (!this.mOwnerAcctName.equals(sid.getOwnerAcctEmail())) {
                    return false;
                }
                if (this.mFolderId != sid.getFolderId()) {
                    return false;
                }
                if (!this.mFolderPath.equals(sid.getFolderPath())) {
                    return false;
                }
                if (this.mRights != ACL.stringToRights(sid.getRights())) {
                    return false;
                }
                if (this.mGranteeType != ACL.stringToType(sid.getGranteeType())) {
                    return false;
                }
                if (!this.mGranteeId.equals(sid.getGranteeId())) {
                    return false;
                }
                return this.mGranteeName.equals(sid.getGranteeName());
            }
        }
    }
}

