/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.zclient.ZEmailAddress;
import com.zimbra.cs.zclient.ZGetMessageParams;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZMessage;
import com.zimbra.qa.unittest.MessageBuilder;
import com.zimbra.qa.unittest.TestUtil;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;

public class TestSendAndReceive
extends TestCase {
    private static final String NAME_PREFIX = TestSendAndReceive.class.getSimpleName();
    private static final String USER_NAME = "user1";
    private static final Pattern PAT_RECEIVED = Pattern.compile("Received: .*from.*LHLO.*");
    private static final Pattern PAT_RETURN_PATH = Pattern.compile("Return-Path: (.*)");
    private String mOriginalSmtpSendAddAuthenticatedUser;
    private String mOriginalDomainSmtpPort;
    private String[] mOriginalSmtpHostname;

    public void setUp() throws Exception {
        this.cleanUp();
        this.mOriginalSmtpSendAddAuthenticatedUser = TestUtil.getConfigAttr("zimbraSmtpSendAddAuthenticatedUser");
        this.mOriginalDomainSmtpPort = TestUtil.getDomainAttr(USER_NAME, "zimbraSmtpPort");
        this.mOriginalSmtpHostname = Provisioning.getInstance().getLocalServer().getSmtpHostname();
    }

    public void testReceivedHeaders() throws Exception {
        String sender = TestUtil.getAddress("user2");
        String recipient = TestUtil.getAddress(USER_NAME);
        TestUtil.addMessageLmtp(NAME_PREFIX + " testReceivedHeaders()", recipient, sender);
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        List<ZMessage> messages = TestUtil.search(mbox, NAME_PREFIX);
        TestSendAndReceive.assertEquals((String)"Unexpected message count", (int)1, (int)messages.size());
        ZGetMessageParams params = new ZGetMessageParams();
        params.setId(messages.get(0).getId());
        params.setRawContent(true);
        ZMessage message = mbox.getMessage(params);
        String content = message.getContent();
        boolean foundReceived = false;
        boolean foundReturnPath = false;
        BufferedReader reader = new BufferedReader(new StringReader(content));
        String line = reader.readLine();
        while (line != null) {
            Matcher matcher = PAT_RECEIVED.matcher(line);
            if (matcher.matches()) {
                ZimbraLog.test.debug("Found " + line);
                foundReceived = true;
            }
            if ((matcher = PAT_RETURN_PATH.matcher(line)).matches()) {
                foundReturnPath = true;
                TestSendAndReceive.assertEquals((String)"Sender doesn't match", (String)sender, (String)matcher.group(1));
                ZimbraLog.test.debug("Found " + line);
            }
            line = reader.readLine();
        }
        reader.close();
        TestSendAndReceive.assertTrue((String)("Received header not found.  Content=\n" + content), (boolean)foundReceived);
        TestSendAndReceive.assertTrue((String)("Return-Path header not found.  Content=\n" + content), (boolean)foundReturnPath);
    }

    public void testZimbraReceivedHeader() throws Exception {
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        List<ZMessage> messages = TestUtil.search(mbox, "subject:\"Test Phone Number Formats\"");
        TestSendAndReceive.assertEquals((String)"Unexpected message count", (int)1, (int)messages.size());
        ZMessage msg = messages.get(0);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(msg.getReceivedDate());
        TestSendAndReceive.assertEquals((int)2005, (int)cal.get(1));
        TestSendAndReceive.assertEquals((int)1, (int)cal.get(2));
        TestSendAndReceive.assertEquals((int)27, (int)cal.get(5));
    }

    public void testAuthenticatedUserHeader() throws Exception {
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        TestUtil.setConfigAttr("zimbraSmtpSendAddAuthenticatedUser", "FALSE");
        String subject = NAME_PREFIX + " testAuthenticatedUserHeader false";
        TestUtil.sendMessage(mbox, USER_NAME, subject);
        ZMessage msg = TestUtil.waitForMessage(mbox, "in:inbox subject:\"" + subject + "\"");
        TestSendAndReceive.assertNull((Object)TestUtil.getHeaderValue(mbox, msg, "X-Authenticated-User"));
        TestUtil.setConfigAttr("zimbraSmtpSendAddAuthenticatedUser", "TRUE");
        subject = NAME_PREFIX + " testAuthenticatedUserHeader true";
        TestUtil.sendMessage(mbox, USER_NAME, subject);
        msg = TestUtil.waitForMessage(mbox, "in:inbox subject:\"" + subject + "\"");
        TestSendAndReceive.assertEquals((String)mbox.getName(), (String)TestUtil.getHeaderValue(mbox, msg, "X-Authenticated-User"));
    }

    public void testDomainSmtpSettings() throws Exception {
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        String subject = NAME_PREFIX + " testDomainSmtpSettings 1";
        TestUtil.sendMessage(mbox, USER_NAME, subject);
        TestUtil.waitForMessage(mbox, "in:inbox subject:\"" + subject + "\"");
        TestUtil.setDomainAttr(USER_NAME, "zimbraSmtpPort", "35");
        subject = NAME_PREFIX + " testDomainSmtpSettings 2";
        boolean sendFailed = false;
        try {
            TestUtil.sendMessage(mbox, USER_NAME, subject);
        }
        catch (SoapFaultException e) {
            TestSendAndReceive.assertEquals((String)"mail.TRY_AGAIN", (String)e.getCode());
            sendFailed = true;
        }
        TestSendAndReceive.assertTrue((String)"Message send should have failed", (boolean)sendFailed);
    }

    public void testBogusSmtpHostname() throws Exception {
        ArrayList<String> smtpHosts = new ArrayList<String>();
        Collections.addAll(smtpHosts, this.mOriginalSmtpHostname);
        for (int i = 1; i <= 10; ++i) {
            smtpHosts.add("bogushost" + i);
        }
        String[] hostsArray = new String[smtpHosts.size()];
        smtpHosts.toArray(hostsArray);
        Provisioning.getInstance().getLocalServer().setSmtpHostname(hostsArray);
        String subject = NAME_PREFIX + " testBogusSmtpHostname";
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        TestUtil.sendMessage(mbox, USER_NAME, subject);
        TestUtil.waitForMessage(mbox, "in:inbox subject:\"" + subject + "\"");
    }

    public void testMalformedContentType() throws Exception {
        String subject = NAME_PREFIX + " testMalformedContentType";
        MessageBuilder builder = new MessageBuilder().withSender(USER_NAME).withRecipient(USER_NAME).withSubject(subject).withAttachment("This is an attachment", "test.txt", "text/plain");
        BufferedReader reader = new BufferedReader(new StringReader(builder.create()));
        StringBuilder msgBuf = new StringBuilder();
        String line = reader.readLine();
        boolean replaced = false;
        while (line != null) {
            if (line.matches("Content-Type.*test.txt.*")) {
                line = line.replace("Content-Type: text/plain;", "Content-Type: text/plain;;");
                TestSendAndReceive.assertTrue((String)("Unexpected line: " + line), (boolean)line.contains(";;"));
                replaced = true;
            }
            msgBuf.append(line).append("\r\n");
            line = reader.readLine();
        }
        TestSendAndReceive.assertTrue((String)"Could not find text/plain attachment.", (boolean)replaced);
        ZMailbox mbox = TestUtil.getZMailbox(USER_NAME);
        TestUtil.addMessageLmtp(new String[]{USER_NAME}, USER_NAME, msgBuf.toString());
        ZMessage srcMsg = TestUtil.getMessage(mbox, "subject:\"" + subject + "\"");
        ZMessage.ZMimePart srcAttachPart = srcMsg.getMimeStructure().getChildren().get(1);
        TestSendAndReceive.assertEquals((String)"test.txt", (String)srcAttachPart.getFileName());
        ZMailbox.ZOutgoingMessage outgoing = new ZMailbox.ZOutgoingMessage();
        outgoing.setMessagePart(new ZMailbox.ZOutgoingMessage.MessagePart("text/plain", "Forwarding attachment."));
        outgoing.setMessagePartsToAttach(Arrays.asList(new ZMailbox.ZOutgoingMessage.AttachedMessagePart(srcMsg.getId(), srcAttachPart.getPartName(), null)));
        String address = TestUtil.getAddress(USER_NAME);
        ZEmailAddress sender = new ZEmailAddress(address, null, null, "f");
        ZEmailAddress recipient = new ZEmailAddress(address, null, null, "t");
        outgoing.setAddresses(Arrays.asList(sender, recipient));
        String fwdSubject = NAME_PREFIX + " testMalformedContentType forward";
        outgoing.setSubject(fwdSubject);
        mbox.sendMessage(outgoing, null, false);
        ZMessage fwd = TestUtil.waitForMessage(mbox, "in:inbox subject:\"" + fwdSubject + "\"");
        ZMessage.ZMimePart fwdAttachPart = fwd.getMimeStructure().getChildren().get(1);
        TestSendAndReceive.assertEquals((String)"test.txt", (String)fwdAttachPart.getFileName());
    }

    public void tearDown() throws Exception {
        this.cleanUp();
        TestUtil.setConfigAttr("zimbraSmtpSendAddAuthenticatedUser", this.mOriginalSmtpSendAddAuthenticatedUser);
        TestUtil.setDomainAttr(USER_NAME, "zimbraSmtpPort", this.mOriginalDomainSmtpPort);
        Provisioning.getInstance().getLocalServer().setSmtpHostname(this.mOriginalSmtpHostname);
    }

    private void cleanUp() throws Exception {
        TestUtil.deleteTestData(USER_NAME, NAME_PREFIX);
    }

    public static void main(String[] args) throws Exception {
        TestUtil.cliSetup();
        TestUtil.runTest(TestSendAndReceive.class);
    }
}

