/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.util.CliUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.GranteeType;
import com.zimbra.cs.account.accesscontrol.RightModifier;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import com.zimbra.cs.account.soap.SoapProvisioning;
import com.zimbra.qa.unittest.TestProvisioningUtil;
import com.zimbra.qa.unittest.TestUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSearchDirectory
extends TestCase {
    private static String TEST_NAME = "test-sd";
    private static String DOMAIN_NAME = TestProvisioningUtil.baseDomainName(TEST_NAME, null);
    private static final String PASSWORD = "test123";
    private static final String FILTER_1 = "(|(uid=*%n*)(cn=*%n*)(sn=*%n*)(gn=*%n*)(displayName=*%n*)(zimbraId=%n)(mail=*%n*)(zimbraMailAlias=*%n*)(zimbraMailDeliveryAddress=*%n*)(zimbraDomainName=*%n*))";
    private static final String[] ATTRS = new String[]{"displayName", "zimbraId", "zimbraMailHost", "uid", "zimbraAccountStatus", "zimbraLastLogonTimestamp", "description", "zimbraMailStatus", "zimbraCalResType", "zimbraDomainType", "zimbraDomainName"};

    private static void createAccounts(Provisioning prov, String domainName, int numAccounts) throws Exception {
        Domain domain;
        if (prov == null) {
            prov = Provisioning.getInstance();
        }
        if ((domain = prov.get(Provisioning.DomainBy.name, domainName)) == null) {
            domain = prov.createDomain(domainName, new HashMap<String, Object>());
        }
        for (int i = 0; i < numAccounts; ++i) {
            String acctName = "user-" + (i + 1) + "@" + domainName;
            Account acct = prov.createAccount(acctName, PASSWORD, new HashMap<String, Object>());
            TestSearchDirectory.assertNotNull((Object)acct);
            if ((i + 1) % 100 != 0) continue;
            System.out.println("Created " + (i + 1) + " accounts");
        }
    }

    private static Account createDelegatedAdmin(Provisioning prov, String acctName) throws Exception {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraIsDelegatedAdminAccount", "TRUE");
        return prov.createAccount(acctName, PASSWORD, attrs);
    }

    private static void assertEquals(Set<String> expected, List<NamedEntry> actual) {
        TestSearchDirectory.assertEquals((int)expected.size(), (int)actual.size());
        for (NamedEntry entry : actual) {
            TestSearchDirectory.assertTrue((boolean)expected.contains(entry.getName()));
        }
    }

    private String expandFilter(String filter, String key) {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("n", key);
        return LdapProvisioning.expandStr(filter, vars);
    }

    private List searchDirectory(String filter, String key, boolean expectTooMany) throws Exception {
        int flags = 0;
        flags |= 1;
        flags |= 2;
        flags |= 4;
        flags |= 8;
        String query = this.expandFilter(filter, key);
        Provisioning.SearchOptions options = new Provisioning.SearchOptions();
        options.setDomain(null);
        options.setFlags(flags |= 0x10);
        options.setMaxResults(5000);
        options.setQuery(query);
        options.setReturnAttrs(ATTRS);
        options.setSortAscending(true);
        options.setSortAttr("name");
        options.setConvertIDNToAscii(true);
        List<NamedEntry> results = null;
        boolean good = false;
        try {
            results = Provisioning.getInstance().searchDirectory(options);
            good = true;
        }
        catch (AccountServiceException e) {
            if (expectTooMany && e.getCode().equals("account.TOO_MANY_SEARCH_RESULTS")) {
                good = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TestSearchDirectory.assertTrue((boolean)good);
        return results;
    }

    public void disable_testSearchDirectory() throws Exception {
        Domain domain1 = Provisioning.getInstance().get(Provisioning.DomainBy.name, "test-gal.ldaptest");
        Domain domain2 = Provisioning.getInstance().get(Provisioning.DomainBy.name, "goodbyewhen-lm-corp-yahoo-com-2.local");
        Cos cos = Provisioning.getInstance().get(Provisioning.CosBy.name, "default");
        System.out.flush();
        for (int i = 0; i < 10; ++i) {
            System.out.flush();
            System.out.println("iteration " + (i + 1));
            System.out.flush();
            System.out.println("search all");
            System.out.flush();
            List results = this.searchDirectory(FILTER_1, "user", true);
            System.out.println("search one");
            System.out.flush();
            results = this.searchDirectory(FILTER_1, "user-10001", false);
            TestSearchDirectory.assertEquals((int)1, (int)results.size());
            Account acct = (Account)results.get(0);
            TestSearchDirectory.assertEquals((String)"user-10001", (String)acct.getName().substring(0, 10));
        }
    }

    public void disable_testBug39514() throws Exception {
        List tests = Bug39514.setup();
        for (Bug39514.TestData test : tests) {
            Bug39514.doTest(test.mAdminName, test.mAdminPassword, test.mExpectedNumEntriesFound);
        }
        Bug39514.teardown();
    }

    public void testBug40499() throws Exception {
        List tests = Bug40499.setup();
        for (Bug40499.TestData test : tests) {
            Bug40499.doTest(test);
        }
        Bug39514.teardown();
    }

    public static void main(String[] args) throws Exception {
        CliUtil.toolSetup();
        TestUtil.runTest(TestSearchDirectory.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Bug40499 {
        private static boolean verbose = true;

        private Bug40499() {
        }

        private static List<TestData> setup() throws Exception {
            String DEFAULT_DOMAIN_NAME = TestUtil.getDomain();
            SoapProvisioning prov = TestProvisioningUtil.getSoapProvisioning();
            String denyDomainName = "bug40499-deny." + DOMAIN_NAME;
            String allowDomainName = "bug40499-allow." + DOMAIN_NAME;
            Domain denyDomain = ((Provisioning)prov).createDomain(denyDomainName, new HashMap<String, Object>());
            Domain allowDomain = ((Provisioning)prov).createDomain(allowDomainName, new HashMap<String, Object>());
            String denyAdminName = "da@" + denyDomainName;
            String allowAdminName = "da@" + allowDomainName;
            Account denyAdmin = TestSearchDirectory.createDelegatedAdmin(prov, denyAdminName);
            Account allowAdmin = TestSearchDirectory.createDelegatedAdmin(prov, allowAdminName);
            String right = "adminConsoleDomainRights";
            ((Provisioning)prov).grantRight(TargetType.global.getCode(), null, null, GranteeType.GT_USER.getCode(), Provisioning.GranteeBy.id, denyAdmin.getId(), right, null);
            ((Provisioning)prov).grantRight(TargetType.global.getCode(), null, null, GranteeType.GT_USER.getCode(), Provisioning.GranteeBy.id, allowAdmin.getId(), right, null);
            ((Provisioning)prov).grantRight(TargetType.domain.getCode(), Provisioning.TargetBy.id, denyDomain.getId(), GranteeType.GT_USER.getCode(), Provisioning.GranteeBy.id, denyAdmin.getId(), right, RightModifier.RM_DENY);
            TestData test1 = new TestData(denyAdminName, TestSearchDirectory.PASSWORD, new String[]{DEFAULT_DOMAIN_NAME, allowDomainName});
            TestData test2 = new TestData(allowAdminName, TestSearchDirectory.PASSWORD, new String[]{DEFAULT_DOMAIN_NAME, allowDomainName, denyDomainName});
            ArrayList<TestData> tests = new ArrayList<TestData>();
            tests.add(test1);
            tests.add(test2);
            return tests;
        }

        private static void teardown() throws Exception {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static void doTest(TestData testData) throws Exception {
            System.out.println("\n\n=========================");
            System.out.println("Testing as " + testData.mAdminName);
            SoapProvisioning prov = TestProvisioningUtil.getSoapProvisioning(testData.mAdminName, testData.mAdminPassword);
            String[] attrs = new String[]{"zimbraId", "zimbraDomainname"};
            Provisioning.SearchOptions options = new Provisioning.SearchOptions();
            options.setBase(null);
            options.setConvertIDNToAscii(true);
            options.setDomain(null);
            options.setFlags(16);
            options.setMaxResults(5000);
            options.setQuery("");
            options.setReturnAttrs(attrs);
            options.setSortAscending(true);
            options.setSortAttr("name");
            List<NamedEntry> results = null;
            long startTime = System.currentTimeMillis();
            try {
                try {
                    results = prov.searchDirectory(options);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Object var9_7 = null;
                    long endTime = System.currentTimeMillis();
                    long elapsedTime = endTime - startTime;
                    System.out.println("Finished, elapsedTime=" + elapsedTime + " milli seconds");
                    if (results != null) {
                        System.out.println("Found " + results.size() + " entries");
                        if (verbose) {
                            System.out.println();
                            for (NamedEntry entry : results) {
                                System.out.println(entry.getName());
                            }
                        }
                    }
                    TestSearchDirectory.assertEquals(testData.mExpected, results);
                    return;
                }
                Object var9_6 = null;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                long endTime = System.currentTimeMillis();
                long elapsedTime = endTime - startTime;
                System.out.println("Finished, elapsedTime=" + elapsedTime + " milli seconds");
                if (results != null) {
                    System.out.println("Found " + results.size() + " entries");
                    if (verbose) {
                        System.out.println();
                        for (NamedEntry entry : results) {
                            System.out.println(entry.getName());
                        }
                    }
                }
                TestSearchDirectory.assertEquals(testData.mExpected, results);
                throw throwable;
            }
            long endTime = System.currentTimeMillis();
            long elapsedTime = endTime - startTime;
            System.out.println("Finished, elapsedTime=" + elapsedTime + " milli seconds");
            if (results != null) {
                System.out.println("Found " + results.size() + " entries");
                if (verbose) {
                    System.out.println();
                    for (NamedEntry entry : results) {
                        System.out.println(entry.getName());
                    }
                }
            }
            TestSearchDirectory.assertEquals(testData.mExpected, results);
        }

        private static class TestData {
            String mAdminName;
            String mAdminPassword;
            Set<String> mExpected;

            TestData(String adminName, String adminPassword, String[] expected) {
                this.mAdminName = adminName;
                this.mAdminPassword = adminPassword;
                this.mExpected = new HashSet<String>(Arrays.asList(expected));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Bug39514 {
        private static final int numAcctsInDomain1 = 5;
        private static final int numAcctsInDomain2 = 10;
        private static boolean verbose = false;

        private Bug39514() {
        }

        private static List<TestData> setup() throws Exception {
            SoapProvisioning prov = TestProvisioningUtil.getSoapProvisioning();
            String domain1Name = "domain-1." + DOMAIN_NAME;
            String domain2Name = "domain-2." + DOMAIN_NAME;
            String adminAcct11Name = "admin-1-1@" + domain1Name;
            String adminAcct12Name = "admin-1-2@" + domain1Name;
            String adminAcct21Name = "admin-2-1@" + domain2Name;
            String adminAcct22Name = "admin-2-2@" + domain2Name;
            Account adminAcct11 = ((Provisioning)prov).get(Provisioning.AccountBy.name, adminAcct11Name);
            Account adminAcct12 = ((Provisioning)prov).get(Provisioning.AccountBy.name, adminAcct12Name);
            Account adminAcct21 = ((Provisioning)prov).get(Provisioning.AccountBy.name, adminAcct21Name);
            Account adminAcct22 = ((Provisioning)prov).get(Provisioning.AccountBy.name, adminAcct22Name);
            TestData test11 = new TestData(adminAcct11Name, TestSearchDirectory.PASSWORD, 19);
            TestData test12 = new TestData(adminAcct12Name, TestSearchDirectory.PASSWORD, 7);
            TestData test21 = new TestData(adminAcct21Name, TestSearchDirectory.PASSWORD, 19);
            TestData test22 = new TestData(adminAcct22Name, TestSearchDirectory.PASSWORD, 12);
            TestData globalAdmin = new TestData(LC.zimbra_ldap_user.value(), LC.zimbra_ldap_password.value(), 28);
            ArrayList<TestData> tests = new ArrayList<TestData>();
            tests.add(test11);
            tests.add(test12);
            tests.add(test21);
            tests.add(test22);
            tests.add(globalAdmin);
            if (adminAcct11 != null && adminAcct12 != null && adminAcct21 != null && adminAcct12 != null) {
                return tests;
            }
            Domain domain1 = ((Provisioning)prov).createDomain(domain1Name, new HashMap<String, Object>());
            Domain domain2 = ((Provisioning)prov).createDomain(domain2Name, new HashMap<String, Object>());
            TestSearchDirectory.createAccounts(prov, domain1Name, 5);
            TestSearchDirectory.createAccounts(prov, domain2Name, 10);
            HashMap<String, Object> adminGroup1Attrs = new HashMap<String, Object>();
            adminGroup1Attrs.put("zimbraIsAdminGroup", "TRUE");
            DistributionList adminGroup1 = ((Provisioning)prov).createDistributionList("adminGroup-1@" + domain1Name, adminGroup1Attrs);
            HashMap<String, Object> adminGroup2Attrs = new HashMap<String, Object>();
            adminGroup2Attrs.put("zimbraIsAdminGroup", "TRUE");
            DistributionList adminGroup2 = ((Provisioning)prov).createDistributionList("adminGroup-2@" + domain2Name, adminGroup2Attrs);
            String right = "domainAdminConsoleRights";
            ((Provisioning)prov).grantRight(TargetType.domain.getCode(), Provisioning.TargetBy.id, domain1.getId(), GranteeType.GT_GROUP.getCode(), Provisioning.GranteeBy.id, adminGroup1.getId(), right, null);
            ((Provisioning)prov).grantRight(TargetType.domain.getCode(), Provisioning.TargetBy.id, domain2.getId(), GranteeType.GT_GROUP.getCode(), Provisioning.GranteeBy.id, adminGroup2.getId(), right, null);
            adminAcct11 = TestSearchDirectory.createDelegatedAdmin(prov, adminAcct11Name);
            adminAcct12 = TestSearchDirectory.createDelegatedAdmin(prov, adminAcct12Name);
            adminAcct21 = TestSearchDirectory.createDelegatedAdmin(prov, adminAcct21Name);
            adminAcct22 = TestSearchDirectory.createDelegatedAdmin(prov, adminAcct22Name);
            ((Provisioning)prov).addMembers(adminGroup1, new String[]{adminAcct11Name, adminAcct12Name});
            ((Provisioning)prov).addMembers(adminGroup2, new String[]{adminAcct21Name, adminAcct22Name});
            ((Provisioning)prov).addMembers(adminGroup1, new String[]{adminAcct21Name});
            ((Provisioning)prov).addMembers(adminGroup2, new String[]{adminAcct11Name});
            return tests;
        }

        private static void teardown() throws Exception {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static void doTest(String adminName, String adminPassword, int expectedNumEntries) throws Exception {
            System.out.println("\n\n=========================");
            System.out.println("Testing as " + adminName);
            SoapProvisioning prov = TestProvisioningUtil.getSoapProvisioning(adminName, adminPassword);
            String[] attrs = new String[]{"displayName", "zimbraId", "zimbraMailHost", "uid", "zimbraCOSId", "zimbraAccountStatus", "zimbraLastLogonTimestamp", "description", "zimbraIsDelegatedAdminAccount", "zimbraIsAdminAccount", "zimbraMailStatus", "zimbraIsAdminGroup", "zimbraCalResType", "zimbraDomainType", "zimbraDomainName", "zimbraIsDelegatedAdminAccount", "zimbraIsAdminGroup"};
            Provisioning.SearchOptions options = new Provisioning.SearchOptions();
            options.setBase(null);
            options.setConvertIDNToAscii(true);
            options.setDomain(null);
            options.setFlags(3);
            options.setMaxResults(5000);
            options.setQuery("");
            options.setReturnAttrs(attrs);
            options.setSortAscending(true);
            options.setSortAttr("name");
            List<NamedEntry> results = null;
            long startTime = System.currentTimeMillis();
            try {
                try {
                    results = prov.searchDirectory(options);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Object var11_9 = null;
                    long endTime = System.currentTimeMillis();
                    long elapsedTime = endTime - startTime;
                    System.out.println("Finished, elapsedTime=" + elapsedTime + " milli seconds");
                    if (results != null) {
                        System.out.println("Found " + results.size() + " entries");
                        if (verbose) {
                            System.out.println();
                            for (NamedEntry entry : results) {
                                System.out.println(entry.getName());
                            }
                        }
                    }
                    Assert.assertEquals((int)expectedNumEntries, (int)results.size());
                    return;
                }
                Object var11_8 = null;
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                long endTime = System.currentTimeMillis();
                long elapsedTime = endTime - startTime;
                System.out.println("Finished, elapsedTime=" + elapsedTime + " milli seconds");
                if (results != null) {
                    System.out.println("Found " + results.size() + " entries");
                    if (verbose) {
                        System.out.println();
                        for (NamedEntry entry : results) {
                            System.out.println(entry.getName());
                        }
                    }
                }
                Assert.assertEquals((int)expectedNumEntries, (int)results.size());
                throw throwable;
            }
            long endTime = System.currentTimeMillis();
            long elapsedTime = endTime - startTime;
            System.out.println("Finished, elapsedTime=" + elapsedTime + " milli seconds");
            if (results != null) {
                System.out.println("Found " + results.size() + " entries");
                if (verbose) {
                    System.out.println();
                    for (NamedEntry entry : results) {
                        System.out.println(entry.getName());
                    }
                }
            }
            Assert.assertEquals((int)expectedNumEntries, (int)results.size());
        }

        private static class TestData {
            String mAdminName;
            String mAdminPassword;
            Integer mExpectedNumEntriesFound;

            TestData(String adminName, String adminPassword, Integer expectedNumEntriesFound) {
                this.mAdminName = adminName;
                this.mAdminPassword = adminPassword;
                this.mExpectedNumEntriesFound = expectedNumEntriesFound;
            }
        }
    }
}

