/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.cs.db.DbResults;
import com.zimbra.cs.db.DbScheduledTask;
import com.zimbra.cs.db.DbUtil;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.ScheduledTask;
import com.zimbra.cs.mailbox.ScheduledTaskManager;
import com.zimbra.qa.unittest.TestTask;
import com.zimbra.qa.unittest.TestUtil;
import java.util.Date;
import java.util.List;
import junit.framework.TestCase;

public class TestScheduledTaskManager
extends TestCase {
    static final String TASK_NAME = "TestTask";
    private static final String USER_NAME = "user1";

    public void setUp() throws Exception {
        this.cleanUp();
    }

    public void testSingleTask() throws Exception {
        this.checkNumPersistedTasks(0);
        TestTask task = new TestTask();
        long now = System.currentTimeMillis();
        task.setExecTime(new Date(now + 1000L));
        Mailbox mbox = TestUtil.getMailbox(USER_NAME);
        task.setMailboxId(mbox.getId());
        ScheduledTaskManager.schedule(task);
        this.checkNumPersistedTasks(1);
        Thread.sleep(1250L);
        TestScheduledTaskManager.assertEquals((String)"TestTask was not called", (int)1, (int)task.getNumCalls());
        this.checkNumPersistedTasks(0);
    }

    public void testRecurringTask() throws Exception {
        this.checkNumPersistedTasks(0);
        TestTask task = new TestTask();
        task.setIntervalMillis(200L);
        Mailbox mbox = TestUtil.getMailbox(USER_NAME);
        task.setMailboxId(mbox.getId());
        ScheduledTaskManager.schedule(task);
        this.checkNumPersistedTasks(1);
        Thread.sleep(1000L);
        ScheduledTaskManager.cancel(TestTask.class.getName(), TASK_NAME, mbox.getId(), false);
        Thread.sleep(200L);
        int numCalls = task.getNumCalls();
        TestScheduledTaskManager.assertTrue((String)("Unexpected number of task runs: " + numCalls), (numCalls > 0 ? 1 : 0) != 0);
        this.checkNumPersistedTasks(0);
        Thread.sleep(400L);
        TestScheduledTaskManager.assertEquals((String)"Task still ran after being cancelled", (int)numCalls, (int)task.getNumCalls());
    }

    public void testTaskProperties() throws Exception {
        this.checkNumPersistedTasks(0);
        ScheduledTask task = new TestTask();
        long now = System.currentTimeMillis();
        task.setExecTime(new Date(now + 60000L));
        Mailbox mbox = TestUtil.getMailbox(USER_NAME);
        task.setMailboxId(mbox.getId());
        task.setProperty("prop1", "value1");
        task.setProperty("prop2", "value2");
        task.setProperty("prop3", null);
        ScheduledTaskManager.schedule(task);
        this.checkNumPersistedTasks(1);
        List<ScheduledTask> tasks = DbScheduledTask.getTasks(TestTask.class.getName(), mbox.getId());
        TestScheduledTaskManager.assertEquals((int)1, (int)tasks.size());
        task = tasks.get(0);
        TestScheduledTaskManager.assertEquals((String)"value1", (String)task.getProperty("prop1"));
        TestScheduledTaskManager.assertEquals((String)"value2", (String)task.getProperty("prop2"));
        TestScheduledTaskManager.assertEquals(null, (String)task.getProperty("prop3"));
        ScheduledTaskManager.cancel(TestTask.class.getName(), task.getName(), mbox.getId(), true);
        this.checkNumPersistedTasks(0);
    }

    public void tearDown() throws Exception {
        this.cleanUp();
    }

    public void cleanUp() throws Exception {
        Mailbox mbox = TestUtil.getMailbox(USER_NAME);
        ScheduledTaskManager.cancel(TestTask.class.getName(), TASK_NAME, mbox.getId(), true);
    }

    private void checkNumPersistedTasks(int expected) throws Exception {
        DbResults results = DbUtil.executeQuery("SELECT COUNT(*) FROM " + DbScheduledTask.TABLE_SCHEDULED_TASK + " WHERE class_name = '" + TestTask.class.getName() + "'");
        TestScheduledTaskManager.assertEquals((String)"Unexpected number of persisted tasks", (int)expected, (int)results.getInt(1));
    }
}

