/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.cs.security.sasl.SaslInputBuffer;
import com.zimbra.cs.security.sasl.SaslOutputBuffer;
import com.zimbra.cs.security.sasl.SaslSecurityLayer;
import java.nio.ByteBuffer;
import javax.security.sasl.SaslException;
import junit.framework.TestCase;

public class TestSasl
extends TestCase {
    private static final int SIZE = 23456;

    public void testSaslInputBuffer() throws SaslException {
        SaslInputBuffer buffer = new SaslInputBuffer(23456);
        ByteBuffer data = TestSasl.fill(ByteBuffer.allocate(23460).putInt(23456));
        int n = 2;
        while (data.hasRemaining()) {
            ByteBuffer bb = data.slice();
            if (bb.remaining() > n) {
                bb.limit(n);
            }
            buffer.put(bb);
            TestSasl.assertFalse((boolean)bb.hasRemaining());
            data.position(data.position() + bb.position());
            if (data.hasRemaining()) {
                TestSasl.assertFalse((boolean)buffer.isComplete());
            }
            n *= 2;
        }
        TestSasl.assertTrue((boolean)buffer.isComplete());
        byte[] unwrapped = buffer.unwrap(new SecurityLayer());
        TestSasl.checkData(unwrapped, 23456);
        buffer.clear();
        TestSasl.assertFalse((boolean)buffer.isComplete());
    }

    public void testSaslOutputBuffer() throws SaslException {
        SaslOutputBuffer buffer = new SaslOutputBuffer(1, 23456);
        ByteBuffer data = TestSasl.fill(ByteBuffer.allocate(23456));
        int n = 2;
        while (data.hasRemaining()) {
            ByteBuffer bb = data.slice();
            if (bb.remaining() > n) {
                bb.limit(n);
            }
            buffer.put(bb);
            TestSasl.assertFalse((boolean)bb.hasRemaining());
            data.position(data.position() + bb.position());
            if (data.hasRemaining()) {
                TestSasl.assertFalse((boolean)buffer.isFull());
            }
            n *= 2;
        }
        TestSasl.assertTrue((boolean)buffer.isFull());
        ByteBuffer bb = ByteBuffer.allocate(100);
        buffer.put(bb);
        TestSasl.assertEquals((int)100, (int)bb.remaining());
        byte[] wrapped = buffer.wrap(new SecurityLayer());
        TestSasl.checkData(wrapped, 23456);
        buffer.clear();
        TestSasl.assertFalse((boolean)buffer.isFull());
    }

    public void testKrb5Auth() throws Exception {
    }

    private static ByteBuffer fill(ByteBuffer bb) {
        int i = 0;
        while (bb.hasRemaining()) {
            bb.put((byte)i);
            ++i;
        }
        bb.flip();
        return bb;
    }

    private static void checkData(byte[] b, int size) {
        TestSasl.assertNotNull((Object)b);
        TestSasl.assertEquals((int)size, (int)b.length);
        for (int i = 0; i < size; ++i) {
            TestSasl.assertEquals((byte)((byte)i), (byte)b[i]);
        }
    }

    private static class SecurityLayer
    extends SaslSecurityLayer {
        private SecurityLayer() {
        }

        public String getMechanismName() {
            return "TEST";
        }

        public byte[] wrap(byte[] b, int off, int len) {
            byte[] r = new byte[len];
            System.arraycopy(b, off, r, 0, len);
            return r;
        }

        public byte[] unwrap(byte[] b, int off, int len) {
            return this.wrap(b, off, len);
        }

        public Object getNegotiatedProperty(String name) {
            return null;
        }

        public void dispose() {
        }
    }
}

