/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.CliUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Alias;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Identity;
import com.zimbra.cs.account.MailTarget;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.Signature;
import com.zimbra.cs.account.XMPPComponent;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.account.soap.SoapProvisioning;
import com.zimbra.qa.unittest.TestProvisioningUtil;
import com.zimbra.qa.unittest.TestUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRenameDomain
extends TestCase {
    private LdapProvisioning mLdapProv;
    private SoapProvisioning mSoapProv;
    private Provisioning mProv;
    private String TEST_ID;
    private static String PASSWORD = "test123";
    private static int NUM_ACCOUNTS = 3;
    private static int NUM_CAS = 3;
    private static int NUM_DLS_NESTED = 2;
    private static int NUM_DLS_TOP = 2;
    private static int NUM_DOMAINS = 3;
    private static int NUM_SUB_DOMAINS = 2;
    private static int NUM_XMPPCOMPONENTS = 3;
    private static int NUM_SIGNATURES = 2;
    private static int NUM_IDENTITIES = 2;
    private static int NUM_DATASOURCES = 2;
    private static String NAME_LEAF_OLD_DOMAIN = "olddomain";
    private static String NAME_LEAF_NEW_DOMAIN = "newdomain";
    private static String UNICODESTR = "\u4e2d\u6587";
    private static String NAMEPREFIX_ACCOUNT = "acct-";
    private static String NAMEPREFIX_ALIAS = "alias-";
    private static String NAMEPREFIX_DATASOURCE = "datasource-";
    private static String NAMEPREFIX_DL_NESTED = "nesteddl-";
    private static String NAMEPREFIX_DL_TOP = "topdl-";
    private static String NAMEPREFIX_IDENTITY = "identity-";
    private static String NAMEPREFIX_OTHERDOMAIN = "otherdomain-";
    private static String NAMEPREFIX_SIGNATURE = "signature-";
    private static String NAMEPREFIX_SUB_DOMAIN = "subdomian-";
    private static int OLD_DOMAIN = 0;
    private static int NEW_DOMAIN = -1;
    private static final int OBJ_ACCT = 1;
    private static final int OBJ_DL_NESTED = 2;
    private static final int OBJ_DL_TOP = 4;
    private static final Set<String> sAttrsToVerify = new HashSet<String>();

    int NUM_OBJS(int objType) throws Exception {
        switch (objType) {
            case 1: {
                return NUM_ACCOUNTS;
            }
            case 2: {
                return NUM_DLS_NESTED;
            }
            case 4: {
                return NUM_DLS_TOP;
            }
        }
        throw new Exception();
    }

    String OBJ_NAME(int objType, int index, int domainIdx) throws Exception {
        switch (objType) {
            case 1: {
                return this.ACCOUNT_NAME(index, domainIdx);
            }
            case 2: {
                return this.NESTED_DL_NAME(index, domainIdx);
            }
            case 4: {
                return this.TOP_DL_NAME(index, domainIdx);
            }
        }
        throw new Exception();
    }

    String GET_ALIAS_NAME(int objType, int targetIdx, int targetDomainIdx, int aliasDomainIdx) throws Exception {
        switch (objType) {
            case 1: {
                return this.ACCOUNT_ALIAS_NAME(targetIdx, targetDomainIdx, aliasDomainIdx);
            }
            case 2: {
                return this.NESTED_DL_ALIAS_NAME(targetIdx, targetDomainIdx, aliasDomainIdx);
            }
            case 4: {
                return this.TOP_DL_ALIAS_NAME(targetIdx, targetDomainIdx, aliasDomainIdx);
            }
        }
        throw new Exception();
    }

    private void setLdapProv() {
        this.mProv = this.mLdapProv;
    }

    private void setSoapProv() {
        this.mProv = this.mSoapProv;
    }

    private void init() throws Exception {
        this.TEST_ID = TestProvisioningUtil.genTestId();
        System.out.println("\nTest " + this.TEST_ID + "\n");
        Provisioning prov = Provisioning.getInstance();
        TestRenameDomain.assertTrue((boolean)(prov instanceof LdapProvisioning));
        this.mLdapProv = (LdapProvisioning)prov;
        this.mSoapProv = new SoapProvisioning();
        this.mSoapProv.soapSetURI("https://localhost:7071/service/admin/soap/");
        this.mSoapProv.soapZimbraAdminAuthenticate();
    }

    private void prepareDomain() throws Exception {
        int i;
        this.setLdapProv();
        for (i = 0; i < NUM_DOMAINS; ++i) {
            this.createDomain(this.DOMAIN_NAME(i));
        }
        for (i = 0; i < NUM_SUB_DOMAINS; ++i) {
            this.createDomain(this.SUB_DOMAIN_NAME(i, OLD_DOMAIN));
        }
        for (i = 0; i < NUM_DOMAINS; ++i) {
            this.populateDomain(i);
        }
        for (i = 0; i < NUM_DOMAINS; ++i) {
            this.setupDLs(i);
        }
        Domain oldDomain = this.mProv.get(Provisioning.DomainBy.name, this.DOMAIN_NAME(OLD_DOMAIN));
        for (int i2 = 0; i2 < NUM_XMPPCOMPONENTS; ++i2) {
            this.createXMPPComponent(i2, oldDomain);
        }
    }

    private int DOMAIN_INDEX_AFTER_RENAME(int domainIdx) {
        if (domainIdx == OLD_DOMAIN) {
            return NEW_DOMAIN;
        }
        return domainIdx;
    }

    private String DOMAIN_NAME(String leafDomainName) {
        return leafDomainName + "." + UNICODESTR + "." + TestProvisioningUtil.baseDomainName("renamedomain", this.TEST_ID);
    }

    private String SUB_DOMAIN_NAME(int index, int parentDomain) {
        int idx = index + 1;
        String parentDomainName = this.DOMAIN_NAME(parentDomain);
        return NAMEPREFIX_SUB_DOMAIN + idx + "." + parentDomainName;
    }

    private String LEAF_DOMAIN_NAME(int index) {
        if (index == OLD_DOMAIN) {
            return NAME_LEAF_OLD_DOMAIN;
        }
        if (index == NEW_DOMAIN) {
            return NAME_LEAF_NEW_DOMAIN;
        }
        return NAMEPREFIX_OTHERDOMAIN + index;
    }

    private String DOMAIN_NAME(int index) {
        return this.DOMAIN_NAME(this.LEAF_DOMAIN_NAME(index));
    }

    private String XMPPCOMPONENT_NAME(int index, String domainName) {
        return "xmppcomponent-" + index + "." + domainName;
    }

    private String ACCOUNT_LOCAL(int index) {
        return NAMEPREFIX_ACCOUNT + String.valueOf(index + 1);
    }

    private String ACCOUNT_NAME(int index, int domainIdx) {
        return this.ACCOUNT_LOCAL(index) + "@" + this.DOMAIN_NAME(domainIdx);
    }

    private Set<String> ACCOUNT_NAMES(int index, int domainIdx, boolean afterRename) {
        int dIdx = afterRename ? this.DOMAIN_INDEX_AFTER_RENAME(domainIdx) : domainIdx;
        HashSet<String> names = new HashSet<String>();
        String name = this.ACCOUNT_NAME(index, dIdx);
        names.add(name);
        for (int d = 0; d < NUM_DOMAINS; ++d) {
            String aliasName = this.ACCOUNT_ALIAS_NAME(index, d, afterRename ? this.DOMAIN_INDEX_AFTER_RENAME(d) : d);
            names.add(aliasName);
        }
        return names;
    }

    private String ACCOUNT_ALIAS_NAME(int targetIdx, int targetDomainIdx, int aliasDomainIdx) {
        return NAMEPREFIX_ALIAS + this.ACCOUNT_LOCAL(targetIdx) + "-" + this.LEAF_DOMAIN_NAME(targetDomainIdx) + "@" + this.DOMAIN_NAME(aliasDomainIdx);
    }

    private String TOP_DL_LOCAL(int index) {
        return NAMEPREFIX_DL_TOP + String.valueOf(index + 1);
    }

    private String TOP_DL_NAME(int index, int domainIdx) {
        return this.TOP_DL_LOCAL(index) + "@" + this.DOMAIN_NAME(domainIdx);
    }

    private Set<String> TOP_DL_NAMES(int index, int domainIdx, boolean afterRename) {
        int dIdx = afterRename ? this.DOMAIN_INDEX_AFTER_RENAME(domainIdx) : domainIdx;
        HashSet<String> names = new HashSet<String>();
        String name = this.TOP_DL_NAME(index, dIdx);
        names.add(name);
        for (int d = 0; d < NUM_DOMAINS; ++d) {
            String aliasName = this.TOP_DL_ALIAS_NAME(index, d, afterRename ? this.DOMAIN_INDEX_AFTER_RENAME(d) : d);
            names.add(aliasName);
        }
        return names;
    }

    private String TOP_DL_ALIAS_NAME(int targetIdx, int targetDomainIdx, int aliasDomainIdx) {
        return NAMEPREFIX_ALIAS + this.TOP_DL_LOCAL(targetIdx) + "-" + this.LEAF_DOMAIN_NAME(targetDomainIdx) + "@" + this.DOMAIN_NAME(aliasDomainIdx);
    }

    private String NESTED_DL_LOCAL(int index) {
        return NAMEPREFIX_DL_NESTED + String.valueOf(index + 1);
    }

    private String NESTED_DL_NAME(int index, int domainIdx) {
        return this.NESTED_DL_LOCAL(index) + "@" + this.DOMAIN_NAME(domainIdx);
    }

    private Set<String> NESTED_DL_NAMES(int index, int domainIdx, boolean afterRename) {
        int dIdx = afterRename ? this.DOMAIN_INDEX_AFTER_RENAME(domainIdx) : domainIdx;
        HashSet<String> names = new HashSet<String>();
        String name = this.NESTED_DL_NAME(index, dIdx);
        names.add(name);
        for (int d = 0; d < NUM_DOMAINS; ++d) {
            String aliasName = this.NESTED_DL_ALIAS_NAME(index, d, afterRename ? this.DOMAIN_INDEX_AFTER_RENAME(d) : d);
            names.add(aliasName);
        }
        return names;
    }

    private String NESTED_DL_ALIAS_NAME(int targetIdx, int targetDomainIdx, int aliasDomainIdx) {
        return NAMEPREFIX_ALIAS + this.NESTED_DL_LOCAL(targetIdx) + "-" + this.LEAF_DOMAIN_NAME(targetDomainIdx) + "@" + this.DOMAIN_NAME(aliasDomainIdx);
    }

    private String SIGNATURE_NAME(Account acct, int index) {
        int idx = index + 1;
        return NAMEPREFIX_SIGNATURE + idx + "of-acct-" + acct.getName();
    }

    private String SIGNATURE_CONTENT(Account acct, int index) {
        int idx = index + 1;
        return "signature content of " + NAMEPREFIX_SIGNATURE + idx + "of-acct-" + acct.getName();
    }

    private String IDENTITY_NAME(Account acct, int index) {
        int idx = index + 1;
        return NAMEPREFIX_IDENTITY + idx + "of-acct-" + acct.getName();
    }

    private String DATASOURCE_NAME(Account acct, int index) {
        int idx = index + 1;
        return NAMEPREFIX_DATASOURCE + idx + "of-acct-" + acct.getName();
    }

    private void createDomain(String domainName) throws Exception {
        System.out.println("createDomain: " + domainName);
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        Domain domain = this.mProv.createDomain(domainName, attrs);
    }

    private String[] createSignatures(Account acct) throws Exception {
        String[] sigIds = new String[NUM_SIGNATURES];
        for (int i = 0; i < NUM_SIGNATURES; ++i) {
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            attrs.put("zimbraPrefMailSignature", this.SIGNATURE_CONTENT(acct, i));
            Signature entry = this.mProv.createSignature(acct, this.SIGNATURE_NAME(acct, i), attrs);
            sigIds[i] = entry.getId();
        }
        return sigIds;
    }

    private void createIdentities(Account acct, String[] sigIds) throws Exception {
        for (int i = 0; i < NUM_IDENTITIES; ++i) {
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            attrs.put("zimbraPrefDefaultSignatureId", LdapUtil.generateUUID());
            attrs.put("zimbraPrefFromAddress", "micky.mouse@zimbra,com");
            attrs.put("zimbraPrefFromDisplay", "Micky Mouse");
            attrs.put("zimbraPrefReplyToEnabled", "TRUE");
            attrs.put("zimbraPrefReplyToAddress", "goofy@yahoo.com");
            attrs.put("zimbraPrefReplyToDisplay", "Micky");
            if (i < NUM_SIGNATURES) {
                attrs.put("zimbraPrefDefaultSignatureId", sigIds[i]);
            }
            Identity entry = this.mProv.createIdentity(acct, this.IDENTITY_NAME(acct, i), attrs);
        }
    }

    private void createDataSources(Account acct, String[] sigIds) throws Exception {
        for (int i = 0; i < NUM_DATASOURCES; ++i) {
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            attrs.put("zimbraDataSourceEnabled", "TRUE");
            attrs.put("zimbraDataSourceConnectionType", "ssl");
            attrs.put("zimbraDataSourceFolderId", "inbox");
            attrs.put("zimbraDataSourceHost", "pop.google.com");
            attrs.put("zimbraDataSourceLeaveOnServer", "TRUE");
            attrs.put("zimbraDataSourcePassword", PASSWORD);
            attrs.put("zimbraDataSourcePort", "9999");
            attrs.put("zimbraDataSourceUsername", "mickymouse");
            attrs.put("zimbraDataSourceEmailAddress", "micky@google.com");
            attrs.put("zimbraPrefDefaultSignatureId", LdapUtil.generateUUID());
            attrs.put("zimbraPrefFromDisplay", "Micky Mouse");
            attrs.put("zimbraPrefReplyToAddress", "goofy@yahoo.com");
            attrs.put("zimbraPrefReplyToDisplay", "Micky");
            if (i < NUM_SIGNATURES) {
                attrs.put("zimbraPrefDefaultSignatureId", sigIds[i]);
            }
            DataSource entry = this.mProv.createDataSource(acct, DataSource.Type.pop3, this.DATASOURCE_NAME(acct, i), attrs);
        }
    }

    private Account createAccount(String acctName, TestProvisioningUtil.IDNName domainName) throws Exception {
        HashMap<String, Object> acctAttrs = new HashMap<String, Object>();
        acctAttrs.put("zimbraMailCanonicalAddress", "canonical-address@" + domainName.uName());
        acctAttrs.put("zimbraMailForwardingAddress", "forwarding-address@" + domainName.uName());
        acctAttrs.put("zimbraMailCatchAllAddress", "@" + domainName.uName());
        acctAttrs.put("zimbraMailCatchAllCanonicalAddress", "@" + domainName.uName());
        acctAttrs.put("zimbraMailCatchAllForwardingAddress", "@" + domainName.uName());
        Account acct = this.mProv.createAccount(acctName, PASSWORD, acctAttrs);
        return acct;
    }

    private XMPPComponent createXMPPComponent(int xmppIndex, Domain domain) throws Exception {
        Server server = this.mProv.getLocalServer();
        String routableName = this.XMPPCOMPONENT_NAME(xmppIndex, domain.getName());
        HashMap<String, Object> xmppAttrs = new HashMap<String, Object>();
        xmppAttrs.put("zimbraXMPPComponentClassName", "myclass");
        xmppAttrs.put("zimbraXMPPComponentCategory", "mycategory");
        xmppAttrs.put("zimbraXMPPComponentType", "mytype");
        XMPPComponent xmpp = this.mProv.createXMPPComponent(routableName, domain, server, xmppAttrs);
        return xmpp;
    }

    private void populateDomain(int domainIdx) throws Exception {
        int d;
        DistributionList dl;
        HashMap<String, Object> dlAttrs;
        TestProvisioningUtil.IDNName domainName = new TestProvisioningUtil.IDNName(this.DOMAIN_NAME(domainIdx));
        System.out.println("setupDomain: " + domainName.uName());
        for (int a = 0; a < NUM_ACCOUNTS; ++a) {
            Account acct = this.createAccount(this.ACCOUNT_NAME(a, domainIdx), domainName);
            for (int d2 = 0; d2 < NUM_DOMAINS; ++d2) {
                this.mProv.addAlias(acct, this.ACCOUNT_ALIAS_NAME(a, domainIdx, d2));
            }
            String[] signatureIds = this.createSignatures(acct);
            this.createIdentities(acct, signatureIds);
            this.createDataSources(acct, signatureIds);
        }
        for (int nd = 0; nd < NUM_DLS_NESTED; ++nd) {
            dlAttrs = new HashMap<String, Object>();
            dl = this.mProv.createDistributionList(this.NESTED_DL_NAME(nd, domainIdx), dlAttrs);
            for (d = 0; d < NUM_DOMAINS; ++d) {
                this.mProv.addAlias(dl, this.NESTED_DL_ALIAS_NAME(nd, domainIdx, d));
            }
        }
        for (int td = 0; td < NUM_DLS_TOP; ++td) {
            dlAttrs = new HashMap();
            dl = this.mProv.createDistributionList(this.TOP_DL_NAME(td, domainIdx), dlAttrs);
            for (d = 0; d < NUM_DOMAINS; ++d) {
                this.mProv.addAlias(dl, this.TOP_DL_ALIAS_NAME(td, domainIdx, d));
            }
        }
    }

    private void setupDLs(int domainIdx) throws Exception {
        int td;
        int d;
        int d2;
        String domainName = this.DOMAIN_NAME(domainIdx);
        System.out.println("crossLinkDomain: " + domainName);
        ArrayList[][] nestedDLMembers = new ArrayList[NUM_DOMAINS][NUM_DLS_NESTED];
        ArrayList[][] topDLMembers = new ArrayList[NUM_DOMAINS][NUM_DLS_TOP];
        for (d2 = 0; d2 < NUM_DOMAINS; ++d2) {
            for (int nd = 0; nd < NUM_DLS_TOP; ++nd) {
                nestedDLMembers[d2][nd] = new ArrayList();
            }
            for (int td2 = 0; td2 < NUM_DLS_TOP; ++td2) {
                topDLMembers[d2][td2] = new ArrayList();
            }
        }
        for (int a = 0; a < NUM_ACCOUNTS; ++a) {
            Set<String> members = this.ACCOUNT_NAMES(a, domainIdx, false);
            for (d = 0; d < NUM_DOMAINS; ++d) {
                for (int nd = 0; nd < NUM_DLS_NESTED; ++nd) {
                    for (String m : members) {
                        nestedDLMembers[d][nd].add(m);
                    }
                }
                for (td = 0; td < NUM_DLS_TOP; ++td) {
                    for (String m : members) {
                        topDLMembers[d][td].add(m);
                    }
                }
            }
        }
        for (int nd = 0; nd < NUM_DLS_NESTED; ++nd) {
            Set<String> members = this.NESTED_DL_NAMES(nd, domainIdx, false);
            for (d = 0; d < NUM_DOMAINS; ++d) {
                for (td = 0; td < NUM_DLS_TOP; ++td) {
                    for (String m : members) {
                        topDLMembers[d][td].add(m);
                    }
                }
            }
        }
        for (d2 = 0; d2 < NUM_DOMAINS; ++d2) {
            for (int nd = 0; nd < NUM_DLS_NESTED; ++nd) {
                DistributionList dl = this.mProv.get(Provisioning.DistributionListBy.name, this.NESTED_DL_NAME(nd, d2));
                this.mProv.addMembers(dl, nestedDLMembers[d2][nd].toArray(new String[0]));
            }
            for (int td3 = 0; td3 < NUM_DLS_TOP; ++td3) {
                DistributionList dl = this.mProv.get(Provisioning.DistributionListBy.name, this.TOP_DL_NAME(td3, d2));
                this.mProv.addMembers(dl, topDLMembers[d2][td3].toArray(new String[0]));
            }
        }
    }

    private void verifyOldDomain() throws Exception {
        String oldDomainName = this.DOMAIN_NAME(OLD_DOMAIN);
        Domain oldDomain = this.mProv.get(Provisioning.DomainBy.name, oldDomainName);
        TestRenameDomain.assertTrue((oldDomain == null ? 1 : 0) != 0);
    }

    private void dumpAttrs(Map<String, Object> attrsIn, Set<String> specificAttrs) {
        System.out.println();
        TreeMap<String, Object> attrs = new TreeMap<String, Object>(attrsIn);
        for (Map.Entry<String, Object> entry : attrs.entrySet()) {
            String name = entry.getKey();
            if (specificAttrs != null && !specificAttrs.contains(name.toLowerCase())) continue;
            Object value = entry.getValue();
            if (value instanceof String[]) {
                String[] sv;
                for (String aSv : sv = (String[])value) {
                    System.out.println(name + ": " + aSv);
                }
                continue;
            }
            if (!(value instanceof String)) continue;
            System.out.println(name + ": " + value);
        }
        System.out.println();
    }

    private void dumpNames(String desc, List<NamedEntry> entries) {
        System.out.println();
        System.out.println("===== " + (desc == null ? "" : desc) + " =====");
        for (NamedEntry entry : entries) {
            System.out.println(entry.getName());
        }
        System.out.println();
    }

    private void dumpAttrs(Map<String, Object> attrsIn) {
        this.dumpAttrs(attrsIn, null);
    }

    private void dumpStrings(String notes, Collection<String> strings) {
        ArrayList<String> sorted = new ArrayList<String>(strings);
        Collections.sort(sorted);
        System.out.println();
        System.out.println(notes);
        for (String s : sorted) {
            System.out.println(s);
        }
        System.out.println();
    }

    Set<String> namedEntryListToNameSet(List<NamedEntry> entries) {
        HashSet<String> nameSet = new HashSet<String>();
        for (NamedEntry entry : entries) {
            nameSet.add(entry.getName());
        }
        return nameSet;
    }

    private NamedEntry getEntryByName(int objType, String name) throws Exception {
        switch (objType) {
            case 1: {
                return this.mProv.get(Provisioning.AccountBy.name, name);
            }
            case 2: 
            case 4: {
                return this.mProv.get(Provisioning.DistributionListBy.name, name);
            }
        }
        throw new Exception();
    }

    private void verifyDomainStatus(String domainName) throws Exception {
        Domain domain = this.mProv.get(Provisioning.DomainBy.name, domainName);
        TestRenameDomain.assertTrue((domain != null ? 1 : 0) != 0);
        String domainStatus = domain.getAttr("zimbraDomainStatus");
        TestRenameDomain.assertEquals((String)"active", (String)domainStatus);
        String mailStatus = domain.getAttr("zimbraMailStatus");
        TestRenameDomain.assertEquals((String)"enabled", (String)mailStatus);
    }

    private Domain verifyNewDomainBasic(String domainId) throws Exception {
        Domain domainByName = this.mProv.get(Provisioning.DomainBy.name, this.DOMAIN_NAME(NEW_DOMAIN));
        TestRenameDomain.assertTrue((domainByName != null ? 1 : 0) != 0);
        Domain domainById = this.mProv.get(Provisioning.DomainBy.id, domainId);
        TestRenameDomain.assertTrue((domainById != null ? 1 : 0) != 0);
        TestProvisioningUtil.verifySameEntry(domainByName, domainById);
        this.verifyDomainStatus(this.DOMAIN_NAME(NEW_DOMAIN));
        return domainById;
    }

    private void verifyNewDomainAttrs(Domain newDomain, Map<String, Object> oldDomainAttrs) throws Exception {
        Map<String, Object> newDomainAttrs = newDomain.getAttrs(false);
        HashMap<String, Object> oldAttrs = new HashMap<String, Object>(oldDomainAttrs);
        HashMap<String, Object> newAttrs = new HashMap<String, Object>(newDomainAttrs);
        oldAttrs.remove("dc");
        oldAttrs.remove("o");
        oldAttrs.remove("zimbraDomainName");
        oldAttrs.remove("zimbraCreateTimestamp");
        newAttrs.remove("dc");
        newAttrs.remove("o");
        newAttrs.remove("zimbraDomainName");
        newAttrs.remove("zimbraCreateTimestamp");
        for (Map.Entry oldAttr : oldAttrs.entrySet()) {
            String oldKey = (String)oldAttr.getKey();
            Object oldValue = oldAttr.getValue();
            Object newValue = newAttrs.get(oldKey);
            if (oldValue instanceof String[]) {
                TestRenameDomain.assertTrue((boolean)(newValue instanceof String[]));
                HashSet<String> oldV = new HashSet<String>(Arrays.asList((String[])oldValue));
                HashSet<String> newV = new HashSet<String>(Arrays.asList((String[])newValue));
                TestProvisioningUtil.verifyEquals(oldV, newV);
                continue;
            }
            if (!(oldValue instanceof String)) continue;
            try {
                TestRenameDomain.assertEquals(oldValue, newValue);
            }
            catch (AssertionFailedError e) {
                System.out.println("Attribute  " + oldKey + " does not match!");
                throw e;
            }
        }
    }

    private void verifyEntryAttrs(List<NamedEntry> list) throws Exception {
        for (NamedEntry e : list) {
            for (String attr : sAttrsToVerify) {
                String value = e.getAttr(attr);
                if (value == null) continue;
            }
        }
    }

    private void verifyEntries(int domainIdx, Domain domain) throws Exception {
        MailTarget entry;
        TestProvisioningUtil.IDNName name;
        Provisioning.SearchOptions options = new Provisioning.SearchOptions();
        int flags = 5;
        options.setFlags(flags);
        options.setDomain(domain);
        List<NamedEntry> list = this.mProv.searchDirectory(options);
        HashSet<String> expectedEntries = new HashSet<String>();
        for (int a = 0; a < NUM_ACCOUNTS; ++a) {
            name = new TestProvisioningUtil.IDNName(this.ACCOUNT_NAME(a, domainIdx));
            entry = this.mProv.get(Provisioning.AccountBy.name, name.uName());
            TestRenameDomain.assertNotNull((Object)entry);
            expectedEntries.add(name.uName());
        }
        for (int nd = 0; nd < NUM_DLS_NESTED; ++nd) {
            name = new TestProvisioningUtil.IDNName(this.NESTED_DL_NAME(nd, domainIdx));
            entry = this.mProv.get(Provisioning.DistributionListBy.name, name.uName());
            TestRenameDomain.assertNotNull((Object)entry);
            expectedEntries.add(name.uName());
        }
        for (int td = 0; td < NUM_DLS_NESTED; ++td) {
            name = new TestProvisioningUtil.IDNName(this.TOP_DL_NAME(td, domainIdx));
            entry = this.mProv.get(Provisioning.DistributionListBy.name, name.uName());
            TestRenameDomain.assertNotNull((Object)entry);
            expectedEntries.add(name.uName());
        }
        Set<String> actualEntries = this.namedEntryListToNameSet(list);
        TestProvisioningUtil.verifyEquals(expectedEntries, actualEntries);
        this.verifyEntryAttrs(list);
    }

    private void verifyDomainAliases(int domainIdx, Domain domain) throws Exception {
        Provisioning.SearchOptions options = new Provisioning.SearchOptions();
        int flags = 2;
        options.setFlags(flags);
        options.setDomain(domain);
        List<NamedEntry> list = this.mProv.searchDirectory(options);
        HashSet<String> expectedAliases = new HashSet<String>();
        for (int d = 0; d < NUM_DOMAINS; ++d) {
            for (int a = 0; a < NUM_ACCOUNTS; ++a) {
                expectedAliases.add(new TestProvisioningUtil.IDNName(this.ACCOUNT_ALIAS_NAME(a, d, domainIdx)).uName());
            }
            for (int nd = 0; nd < NUM_DLS_NESTED; ++nd) {
                expectedAliases.add(new TestProvisioningUtil.IDNName(this.NESTED_DL_ALIAS_NAME(nd, d, domainIdx)).uName());
            }
            for (int td = 0; td < NUM_DLS_NESTED; ++td) {
                expectedAliases.add(new TestProvisioningUtil.IDNName(this.TOP_DL_ALIAS_NAME(td, d, domainIdx)).uName());
            }
        }
        Set<String> actualAliases = this.namedEntryListToNameSet(list);
        TestProvisioningUtil.verifyEquals(expectedAliases, actualAliases);
        for (NamedEntry entry : list) {
            TestRenameDomain.assertTrue((boolean)(entry instanceof Alias));
            NamedEntry target = this.mProv.searchAliasTarget((Alias)entry, true);
            TestRenameDomain.assertNotNull((Object)target);
        }
    }

    private void verifyAliasesOfEntriesInDomain(int objType, Domain domain) throws Exception {
        for (int i = 0; i < this.NUM_OBJS(objType); ++i) {
            String entryName = this.OBJ_NAME(objType, i, NEW_DOMAIN);
            NamedEntry entry = this.getEntryByName(objType, entryName);
            TestRenameDomain.assertNotNull((Object)entry);
            for (int d = 0; d < NUM_DOMAINS; ++d) {
                int aliasDomainIdx = this.DOMAIN_INDEX_AFTER_RENAME(d);
                String aliasName = this.GET_ALIAS_NAME(objType, i, OLD_DOMAIN, aliasDomainIdx);
                NamedEntry entryByAlias = this.getEntryByName(objType, aliasName);
                TestRenameDomain.assertNotNull((Object)entryByAlias);
                TestProvisioningUtil.verifySameEntry(entry, entryByAlias);
            }
        }
    }

    private void verifyAliases(int domainIdx, Domain domain) throws Exception {
        this.verifyDomainAliases(domainIdx, domain);
        this.verifyAliasesOfEntriesInDomain(1, domain);
        this.verifyAliasesOfEntriesInDomain(2, domain);
        this.verifyAliasesOfEntriesInDomain(4, domain);
    }

    private void verifyMemberOf(int memberType, int dlTypes, int domainIdx) throws Exception {
        for (int i = 0; i < this.NUM_OBJS(memberType); ++i) {
            String name = this.OBJ_NAME(memberType, i, domainIdx);
            NamedEntry entry = this.getEntryByName(memberType, name);
            TestRenameDomain.assertNotNull((Object)entry);
            HashSet<String> expectedNames = new HashSet<String>();
            for (int d = 0; d < NUM_DOMAINS; ++d) {
                int dlIdx;
                int dIdx = this.DOMAIN_INDEX_AFTER_RENAME(d);
                if ((dlTypes & 2) != 0) {
                    for (dlIdx = 0; dlIdx < NUM_DLS_NESTED; ++dlIdx) {
                        expectedNames.add(new TestProvisioningUtil.IDNName(this.NESTED_DL_NAME(dlIdx, dIdx)).aName());
                    }
                }
                if ((dlTypes & 4) == 0) continue;
                for (dlIdx = 0; dlIdx < NUM_DLS_TOP; ++dlIdx) {
                    expectedNames.add(new TestProvisioningUtil.IDNName(this.TOP_DL_NAME(dlIdx, dIdx)).aName());
                }
            }
            HashMap<String, String> via = new HashMap<String, String>();
            List<NamedEntry> lists = memberType == 1 ? this.mProv.getDistributionLists((Account)entry, false, via) : this.mProv.getDistributionLists((DistributionList)entry, false, via);
            Set<String> actualNames = this.namedEntryListToNameSet(lists);
            TestProvisioningUtil.verifyEquals(expectedNames, actualNames);
        }
    }

    private void verifyHasMembers(int dlType, int memberTypes, int domainIdx) throws Exception {
        for (int dlIdx = 0; dlIdx < this.NUM_OBJS(dlType); ++dlIdx) {
            String name = this.OBJ_NAME(dlType, dlIdx, domainIdx);
            DistributionList dl = this.mProv.get(Provisioning.DistributionListBy.name, name);
            TestRenameDomain.assertNotNull((Object)dl);
            HashSet<String> expectedNames = new HashSet<String>();
            for (int d = 0; d < NUM_DOMAINS; ++d) {
                Set<String> names;
                int i;
                int dIdx = this.DOMAIN_INDEX_AFTER_RENAME(d);
                if ((memberTypes & 1) != 0) {
                    for (i = 0; i < NUM_ACCOUNTS; ++i) {
                        names = this.ACCOUNT_NAMES(i, dIdx, true);
                        for (String n : names) {
                            expectedNames.add(new TestProvisioningUtil.IDNName(n).uName());
                        }
                    }
                }
                if ((memberTypes & 2) != 0) {
                    for (i = 0; i < NUM_DLS_NESTED; ++i) {
                        names = this.NESTED_DL_NAMES(i, dIdx, true);
                        for (String n : names) {
                            expectedNames.add(new TestProvisioningUtil.IDNName(n).uName());
                        }
                    }
                }
                if ((memberTypes & 4) == 0) continue;
                for (i = 0; i < NUM_DLS_TOP; ++i) {
                    names = this.TOP_DL_NAMES(i, dIdx, true);
                    for (String n : names) {
                        expectedNames.add(new TestProvisioningUtil.IDNName(n).uName());
                    }
                }
            }
            String[] members = dl.getAllMembers();
            HashSet<String> actualNames = new HashSet<String>(Arrays.asList(members));
            TestProvisioningUtil.verifyEquals(expectedNames, actualNames);
        }
    }

    private void verifyDLMembership(int domainIdx, Domain domain) throws Exception {
        this.verifyMemberOf(1, 6, domainIdx);
        this.verifyMemberOf(2, 4, domainIdx);
        this.verifyHasMembers(2, 1, domainIdx);
        this.verifyHasMembers(4, 3, domainIdx);
    }

    private void verifyDomain(int domainIdx) throws Exception {
        System.out.println("Verifying domain " + this.DOMAIN_NAME(domainIdx));
        String domainName = this.DOMAIN_NAME(domainIdx);
        Domain domain = this.mProv.get(Provisioning.DomainBy.name, domainName);
        this.verifyEntries(domainIdx, domain);
        this.verifyAliases(domainIdx, domain);
        this.verifyDLMembership(domainIdx, domain);
    }

    private void verifyNewDomain(String domainId, Map<String, Object> oldDomainAttrs) throws Exception {
        Domain newDomain = this.verifyNewDomainBasic(domainId);
        this.verifyNewDomainAttrs(newDomain, oldDomainAttrs);
        this.verifyDomain(NEW_DOMAIN);
    }

    private void verifyOtherDomains() throws Exception {
        for (int d = 0; d < NUM_DOMAINS; ++d) {
            if (d == OLD_DOMAIN) continue;
            this.verifyDomain(d);
        }
    }

    private void verifyXMPPComponent(int index, Domain newDomain) throws Exception {
        String newRoutableName = this.XMPPCOMPONENT_NAME(index, newDomain.getName());
        XMPPComponent xmpp = this.mProv.get(Provisioning.XMPPComponentBy.name, newRoutableName);
        TestRenameDomain.assertNotNull((Object)xmpp);
        String domainId = newDomain.getId();
        String xmppDomainId = xmpp.getAttr("zimbraDomainId");
        TestRenameDomain.assertEquals((String)domainId, (String)xmppDomainId);
    }

    private void verifyXMPPComponents() throws Exception {
        Domain newDomain = this.mProv.get(Provisioning.DomainBy.name, this.DOMAIN_NAME(NEW_DOMAIN));
        for (int i = 0; i < NUM_XMPPCOMPONENTS; ++i) {
            this.verifyXMPPComponent(i, newDomain);
        }
    }

    private void renameDomainTest() throws Exception {
        this.prepareDomain();
        Domain oldDomain = this.mProv.get(Provisioning.DomainBy.name, this.DOMAIN_NAME(OLD_DOMAIN));
        String oldDomainId = oldDomain.getId();
        Map<String, Object> oldDomainAttrs = oldDomain.getAttrs(false);
        System.out.println("rd " + oldDomain.getId() + " " + this.DOMAIN_NAME(NEW_DOMAIN));
        ((LdapProvisioning)this.mProv).renameDomain(oldDomain.getId(), this.DOMAIN_NAME(NEW_DOMAIN));
        this.setSoapProv();
        this.verifyOldDomain();
        this.verifyNewDomain(oldDomainId, oldDomainAttrs);
        this.verifyOtherDomains();
        this.setLdapProv();
        this.verifyXMPPComponents();
    }

    private void renameToExistingDomainTest() throws Exception {
        this.setLdapProv();
        String srcDomainName = this.DOMAIN_NAME("src");
        String tgtDomainName = this.DOMAIN_NAME("target");
        Domain srcDomain = this.mProv.createDomain(srcDomainName, new HashMap<String, Object>());
        TestRenameDomain.assertNotNull((Object)srcDomain);
        Domain tgtDomain = this.mProv.createDomain(tgtDomainName, new HashMap<String, Object>());
        TestRenameDomain.assertNotNull((Object)tgtDomain);
        boolean ok = false;
        try {
            ((LdapProvisioning)this.mProv).renameDomain(srcDomain.getId(), tgtDomainName);
        }
        catch (ServiceException e) {
            TestRenameDomain.assertEquals((String)"service.INVALID_REQUEST", (String)e.getCode());
            TestRenameDomain.assertEquals((String)("invalid request: domain " + new TestProvisioningUtil.IDNName(tgtDomainName).aName() + " already exists"), (String)e.getMessage());
        }
        this.verifyDomainStatus(srcDomainName);
        this.verifyDomainStatus(tgtDomainName);
    }

    public void testRenameDomain() throws Exception {
        try {
            System.out.println("\nTest " + this.TEST_ID + " starting\n");
            this.init();
            this.renameDomainTest();
            this.renameToExistingDomainTest();
            System.out.println("\nTest " + this.TEST_ID + " done!");
        }
        catch (ServiceException e) {
            Throwable cause = e.getCause();
            System.out.println("ERROR: " + e.getCode() + " (" + e.getMessage() + ")" + (cause == null ? "" : " (cause: " + cause.getClass().getName() + " " + cause.getMessage() + ")"));
            e.printStackTrace(System.out);
            System.out.println("\nTest " + this.TEST_ID + " failed!");
        }
        catch (AssertionFailedError e) {
            System.out.println("\n===== assertion failed =====");
            System.out.println(e.getMessage());
            e.printStackTrace(System.out);
        }
    }

    public static void main(String[] args) throws Exception {
        CliUtil.toolSetup("INFO");
        ZimbraLog.toolSetupLog4j("INFO", "/opt/zimbra/conf/log4j.properties");
        TestUtil.runTest(TestRenameDomain.class);
    }

    static {
        sAttrsToVerify.add("zimbraMailCanonicalAddress");
        sAttrsToVerify.add("zimbraMailForwardingAddress");
        sAttrsToVerify.add("zimbraMailCatchAllAddress");
        sAttrsToVerify.add("zimbraMailCatchAllCanonicalAddress");
        sAttrsToVerify.add("zimbraMailCatchAllForwardingAddress");
    }
}

