/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.DevNullOutputStream;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.redolog.RedoPlayer;
import com.zimbra.cs.redolog.util.RedoLogVerify;
import com.zimbra.cs.store.MailboxBlob;
import com.zimbra.cs.store.StoreManager;
import com.zimbra.qa.unittest.TestUtil;
import java.io.File;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;

public class TestRedoLog
extends TestCase {
    private static final String USER_NAME = "user1";
    private static final String RESTORED_NAME = "testredolog";
    private static final String NAME_PREFIX = TestRedoLog.class.getSimpleName();

    public void setUp() throws Exception {
        this.cleanUp();
    }

    public void testRedoLogVerify() throws Exception {
        RedoLogVerify verify = new RedoLogVerify(null, new PrintStream(new DevNullOutputStream()));
        TestRedoLog.assertTrue((boolean)verify.verifyFile(this.getRedoLogFile()));
    }

    public void testRestoreMessageToNewAccount() throws Exception {
        long startTime = System.currentTimeMillis();
        Mailbox sourceMbox = TestUtil.getMailbox(USER_NAME);
        Message sourceMsg = TestUtil.addMessage(sourceMbox, NAME_PREFIX + " testRestoreMessageToNewAccount");
        String sourceContent = new String(sourceMsg.getContent());
        TestRedoLog.assertTrue((sourceContent.length() != 0 ? 1 : 0) != 0);
        Account destAccount = TestUtil.createAccount(RESTORED_NAME);
        RedoPlayer player = new RedoPlayer(false, true, false, false);
        HashMap<Long, Long> idMap = new HashMap<Long, Long>();
        Mailbox destMbox = MailboxManager.getInstance().getMailboxByAccount(destAccount);
        idMap.put(sourceMbox.getId(), destMbox.getId());
        player.scanLog(this.getRedoLogFile(), true, idMap, startTime, Long.MAX_VALUE);
        List<Integer> destIds = TestUtil.search(destMbox, "in:inbox " + NAME_PREFIX, (byte)5);
        TestRedoLog.assertEquals((int)1, (int)destIds.size());
        Message destMsg = destMbox.getMessageById(null, destIds.get(0));
        String destContent = new String(destMsg.getContent());
        TestRedoLog.assertEquals((String)sourceContent, (String)destContent);
        MailboxBlob blob = sourceMsg.getBlob();
        TestRedoLog.assertNotNull((Object)blob);
        sourceContent = new String(ByteUtil.getContent(StoreManager.getInstance().getContent(blob), sourceContent.length()));
        TestRedoLog.assertEquals((String)destContent, (String)sourceContent);
    }

    private File getRedoLogFile() {
        return new File("/opt/zimbra/redolog/redo.log");
    }

    public void tearDown() throws Exception {
        this.cleanUp();
    }

    private void cleanUp() throws Exception {
        TestUtil.deleteTestData(USER_NAME, NAME_PREFIX);
        TestUtil.deleteAccount(RESTORED_NAME);
    }
}

