/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.db.DbMailItem;
import com.zimbra.cs.db.DbResults;
import com.zimbra.cs.db.DbUtil;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.qa.unittest.TestUtil;
import java.util.HashMap;
import junit.framework.TestCase;

public class TestPurge
extends TestCase {
    private static final String USER_NAME = "user4";
    private static final String NAME_PREFIX = TestPurge.class.getSimpleName();
    private String mOriginalSystemTrashLifetime;
    private String mOriginalSystemJunkLifetime;
    private String mOriginalSystemMessageLifetime;
    private String mOriginalUserInboxReadLifetime;
    private String mOriginalUserInboxUnreadLifetime;
    private String mOriginalUserSentLifetime;
    private String mOriginalUserTrashLifetime;
    private String mOriginalUserJunkLifetime;
    private String mOriginalUseChangeDateForTrash;
    private long mOriginalTombstoneAge;
    long mPurgedTimestamp = System.currentTimeMillis() - 5356800000L;
    long mLaterCutoff = this.mPurgedTimestamp + 3600000L;
    long mMiddleTimestamp = this.mLaterCutoff + 3600000L;
    long mEarlierCutoff = this.mMiddleTimestamp + 3600000L;
    long mKeptTimestamp = this.mEarlierCutoff + 3600000L;

    public void setUp() throws Exception {
        this.cleanUp();
        Account account = TestUtil.getAccount(USER_NAME);
        this.mOriginalSystemTrashLifetime = account.getAttr("zimbraMailTrashLifetime");
        this.mOriginalSystemJunkLifetime = account.getAttr("zimbraMailSpamLifetime");
        this.mOriginalSystemMessageLifetime = account.getAttr("zimbraMailMessageLifetime");
        this.mOriginalUserInboxReadLifetime = account.getAttr("zimbraPrefInboxReadLifetime");
        this.mOriginalUserInboxUnreadLifetime = account.getAttr("zimbraPrefInboxUnreadLifetime");
        this.mOriginalUserSentLifetime = account.getAttr("zimbraPrefSentLifetime");
        this.mOriginalUserTrashLifetime = account.getAttr("zimbraPrefTrashLifetime");
        this.mOriginalUserJunkLifetime = account.getAttr("zimbraPrefJunkLifetime");
        this.mOriginalUseChangeDateForTrash = account.getAttr("zimbraMailPurgeUseChangeDateForTrash");
        this.mOriginalTombstoneAge = LC.tombstone_max_age_ms.longValue();
    }

    public void testInbox() throws Exception {
        Account account = TestUtil.getAccount(USER_NAME);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPrefInboxUnreadLifetime", "24h");
        attrs.put("zimbraPrefInboxReadLifetime", "16h");
        Provisioning.getInstance().modifyAttrs(account, attrs);
        String prefix = NAME_PREFIX + " testInbox ";
        Mailbox mbox = TestUtil.getMailbox(USER_NAME);
        Message purgedUnread = TestUtil.addMessage(mbox, 2, prefix + "purgedUnread", System.currentTimeMillis() - 90000000L);
        Message keptUnread = TestUtil.addMessage(mbox, 2, prefix + "keptUnread", System.currentTimeMillis() - 64800000L);
        Message purgedRead = TestUtil.addMessage(mbox, 2, prefix + "purgedRead", System.currentTimeMillis() - 64800000L);
        Message keptRead = TestUtil.addMessage(mbox, 2, prefix + "keptRead", System.currentTimeMillis() - 54000000L);
        purgedUnread = this.alterUnread(purgedUnread, true);
        keptUnread = this.alterUnread(keptUnread, true);
        purgedRead = this.alterUnread(purgedRead, false);
        keptRead = this.alterUnread(keptRead, false);
        mbox.purgeMessages(null);
        TestPurge.assertFalse((String)"purgedUnread was kept", (boolean)this.messageExists(purgedUnread.getId()));
        TestPurge.assertTrue((String)"keptUnread was purged", (boolean)this.messageExists(keptUnread.getId()));
        TestPurge.assertFalse((String)"purgedRead was kept", (boolean)this.messageExists(purgedRead.getId()));
        TestPurge.assertTrue((String)"keptRead was purged", (boolean)this.messageExists(keptRead.getId()));
    }

    public void testSent() throws Exception {
        Account account = TestUtil.getAccount(USER_NAME);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPrefSentLifetime", "24h");
        Provisioning.getInstance().modifyAttrs(account, attrs);
        String prefix = NAME_PREFIX + " testSent ";
        Mailbox mbox = TestUtil.getMailbox(USER_NAME);
        Message purged = TestUtil.addMessage(mbox, 5, prefix + "purged", System.currentTimeMillis() - 90000000L);
        Message kept = TestUtil.addMessage(mbox, 5, prefix + "kept", System.currentTimeMillis() - 64800000L);
        mbox.purgeMessages(null);
        TestPurge.assertFalse((String)"purged was kept", (boolean)this.messageExists(purged.getId()));
        TestPurge.assertTrue((String)"kept was purged", (boolean)this.messageExists(kept.getId()));
    }

    public void testTrashUser() throws Exception {
        TestUtil.setAccountAttr(USER_NAME, "zimbraMailPurgeUseChangeDateForTrash", "FALSE");
        Account account = TestUtil.getAccount(USER_NAME);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPrefTrashLifetime", "24h");
        attrs.put("zimbraMailTrashLifetime", "48h");
        Provisioning.getInstance().modifyAttrs(account, attrs);
        String prefix = NAME_PREFIX + " testTrashUser ";
        Mailbox mbox = TestUtil.getMailbox(USER_NAME);
        Message purged = TestUtil.addMessage(mbox, 3, prefix + "purged", System.currentTimeMillis() - 129600000L);
        Message kept = TestUtil.addMessage(mbox, 3, prefix + "kept", System.currentTimeMillis() - 57600000L);
        mbox.purgeMessages(null);
        TestPurge.assertFalse((String)"purged was kept", (boolean)this.messageExists(purged.getId()));
        TestPurge.assertTrue((String)"kept was purged", (boolean)this.messageExists(kept.getId()));
    }

    public void testTrashSystem() throws Exception {
        TestUtil.setAccountAttr(USER_NAME, "zimbraMailPurgeUseChangeDateForTrash", "FALSE");
        Account account = TestUtil.getAccount(USER_NAME);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPrefTrashLifetime", "48h");
        attrs.put("zimbraMailTrashLifetime", "24h");
        Provisioning.getInstance().modifyAttrs(account, attrs);
        String prefix = NAME_PREFIX + " testTrashUser ";
        Mailbox mbox = TestUtil.getMailbox(USER_NAME);
        Message purged = TestUtil.addMessage(mbox, 3, prefix + "purged", System.currentTimeMillis() - 129600000L);
        Message kept = TestUtil.addMessage(mbox, 3, prefix + "kept", System.currentTimeMillis() - 57600000L);
        mbox.purgeMessages(null);
        TestPurge.assertFalse((String)"purged was kept", (boolean)this.messageExists(purged.getId()));
        TestPurge.assertTrue((String)"kept was purged", (boolean)this.messageExists(kept.getId()));
    }

    public void testJunkUser() throws Exception {
        Account account = TestUtil.getAccount(USER_NAME);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPrefJunkLifetime", "24h");
        attrs.put("zimbraMailSpamLifetime", "48h");
        Provisioning.getInstance().modifyAttrs(account, attrs);
        String prefix = NAME_PREFIX + " testJunkUser ";
        Mailbox mbox = TestUtil.getMailbox(USER_NAME);
        Message purged = TestUtil.addMessage(mbox, 4, prefix + "purged", System.currentTimeMillis() - 129600000L);
        Message kept = TestUtil.addMessage(mbox, 4, prefix + "kept", System.currentTimeMillis() - 57600000L);
        mbox.purgeMessages(null);
        TestPurge.assertFalse((String)"purged was kept", (boolean)this.messageExists(purged.getId()));
        TestPurge.assertTrue((String)"kept was purged", (boolean)this.messageExists(kept.getId()));
    }

    public void testJunkSystem() throws Exception {
        Account account = TestUtil.getAccount(USER_NAME);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPrefJunkLifetime", "48h");
        attrs.put("zimbraMailSpamLifetime", "24h");
        Provisioning.getInstance().modifyAttrs(account, attrs);
        String prefix = NAME_PREFIX + " testJunkUser ";
        Mailbox mbox = TestUtil.getMailbox(USER_NAME);
        Message purged = TestUtil.addMessage(mbox, 4, prefix + "purged", System.currentTimeMillis() - 129600000L);
        Message kept = TestUtil.addMessage(mbox, 4, prefix + "kept", System.currentTimeMillis() - 57600000L);
        mbox.purgeMessages(null);
        TestPurge.assertFalse((String)"purged was kept", (boolean)this.messageExists(purged.getId()));
        TestPurge.assertTrue((String)"kept was purged", (boolean)this.messageExists(kept.getId()));
    }

    public void testAll() throws Exception {
        Account account = TestUtil.getAccount(USER_NAME);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailMessageLifetime", "40d");
        Provisioning.getInstance().modifyAttrs(account, attrs);
        String prefix = NAME_PREFIX + " testAll ";
        Mailbox mbox = TestUtil.getMailbox(USER_NAME);
        Folder folder = mbox.createFolder(null, "/" + NAME_PREFIX, (byte)0, (byte)-1);
        Message purged = TestUtil.addMessage(mbox, folder.getId(), prefix + "purged", System.currentTimeMillis() - 3542400000L);
        Message kept = TestUtil.addMessage(mbox, folder.getId(), prefix + "kept", System.currentTimeMillis() - 3369600000L);
        mbox.purgeMessages(null);
        TestPurge.assertFalse((String)"purged was kept", (boolean)this.messageExists(purged.getId()));
        TestPurge.assertTrue((String)"kept was purged", (boolean)this.messageExists(kept.getId()));
    }

    public void testAllSafeguard() throws Exception {
        Account account = TestUtil.getAccount(USER_NAME);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailMessageLifetime", "1h");
        Provisioning.getInstance().modifyAttrs(account, attrs);
        String prefix = NAME_PREFIX + " testAllSafeguard ";
        Mailbox mbox = TestUtil.getMailbox(USER_NAME);
        Folder folder = mbox.createFolder(null, "/" + NAME_PREFIX, (byte)0, (byte)-1);
        Message purged = TestUtil.addMessage(mbox, folder.getId(), prefix + "purged", System.currentTimeMillis() - 2764800000L);
        Message kept = TestUtil.addMessage(mbox, folder.getId(), prefix + "kept", System.currentTimeMillis() - 2592000000L);
        mbox.purgeMessages(null);
        TestPurge.assertFalse((String)"purged was kept", (boolean)this.messageExists(purged.getId()));
        TestPurge.assertTrue((String)"kept was purged", (boolean)this.messageExists(kept.getId()));
    }

    public void testTrashChangeDate() throws Exception {
        TestUtil.setAccountAttr(USER_NAME, "zimbraPrefTrashLifetime", "24h");
        TestUtil.setAccountAttr(USER_NAME, "zimbraMailPurgeUseChangeDateForTrash", "TRUE");
        String subject = NAME_PREFIX + " testChangeDate";
        Mailbox mbox = TestUtil.getMailbox(USER_NAME);
        Message kept = TestUtil.addMessage(mbox, 2, subject, System.currentTimeMillis() - 129600000L);
        mbox.move(null, kept.getId(), (byte)5, 3);
        long cutoff = System.currentTimeMillis() - 86400000L;
        TestPurge.assertTrue((String)("Unexpected message date: " + kept.getDate()), (kept.getDate() < cutoff ? 1 : 0) != 0);
        TestPurge.assertTrue((String)("Unexpected change date: " + kept.getChangeDate()), (kept.getChangeDate() > cutoff ? 1 : 0) != 0);
        mbox.purgeMessages(null);
        TestPurge.assertTrue((String)"kept was purged", (boolean)this.messageExists(kept.getId()));
    }

    public void testFolderInTrash() throws Exception {
        Mailbox mbox = TestUtil.getMailbox(USER_NAME);
        String folderPath = "/Trash/" + NAME_PREFIX + "-testFolderInTrash";
        Folder f = mbox.createFolder(null, folderPath, (byte)0, (byte)5);
        String subject = NAME_PREFIX + " testFolderInTrash";
        Message msg = TestUtil.addMessage(mbox, f.getId(), subject, System.currentTimeMillis());
        ZimbraLog.test.info("Date: %d, change date: %d.", msg.getDate(), msg.getChangeDate());
        Account account = TestUtil.getAccount(USER_NAME);
        account.setPrefTrashLifetime("1s");
        account.setMailPurgeUseChangeDateForTrash(false);
        Thread.sleep(2000L);
        mbox.purgeMessages(null);
        try {
            mbox.getMessageById(null, msg.getId());
            TestPurge.fail((String)("Message " + msg.getId() + " was not deleted."));
        }
        catch (MailServiceException.NoSuchItemException e) {
            // empty catch block
        }
        try {
            mbox.getFolderById(null, f.getId());
            TestPurge.fail((String)("Folder " + f.getId() + " was not deleted."));
        }
        catch (MailServiceException.NoSuchItemException e) {
            // empty catch block
        }
    }

    public void xtestTombstones() throws Exception {
        Mailbox mbox = TestUtil.getMailbox(USER_NAME);
        Message msg = TestUtil.addMessage(mbox, NAME_PREFIX + " testTombstones");
        LC.tombstone_max_age_ms.setDefault("0");
        mbox.purgeMessages(null);
        TestPurge.assertEquals((int)0, (int)this.getNumTombstones(mbox));
        mbox.beginTrackingSync();
        mbox.delete(null, msg.getId(), msg.getType());
        TestPurge.assertEquals((int)1, (int)this.getNumTombstones(mbox));
        LC.tombstone_max_age_ms.setDefault(Long.toString(2678400000L));
        mbox.purgeMessages(null);
        TestPurge.assertEquals((int)1, (int)this.getNumTombstones(mbox));
        LC.tombstone_max_age_ms.setDefault("0");
        Thread.sleep(1000L);
        mbox.purgeMessages(null);
        TestPurge.assertEquals((int)0, (int)this.getNumTombstones(mbox));
    }

    public void testConversations() throws Exception {
        Mailbox mbox = TestUtil.getMailbox(USER_NAME);
        String subject = NAME_PREFIX + " testConversations";
        Message original = TestUtil.addMessage(mbox, subject);
        Message reply = TestUtil.addMessage(mbox, "RE: " + subject);
        int convId = original.getConversationId();
        TestPurge.assertEquals((int)convId, (int)reply.getConversationId());
        TestPurge.assertEquals((int)1, (int)this.getNumConversations(mbox, convId));
        LC.conversation_max_age_ms.setDefault(Long.toString(2678400000L));
        mbox.purgeMessages(null);
        TestPurge.assertEquals((int)1, (int)this.getNumConversations(mbox, convId));
        LC.conversation_max_age_ms.setDefault("0");
        Thread.sleep(1000L);
        mbox.purgeMessages(null);
        TestPurge.assertEquals((int)0, (int)this.getNumConversations(mbox, convId));
    }

    private int getNumConversations(Mailbox mbox, int convId) throws ServiceException {
        DbResults results = DbUtil.executeQuery("SELECT COUNT(*) FROM " + DbMailItem.getConversationTableName(mbox) + " WHERE mailbox_id = " + mbox.getId() + " AND conv_id = " + convId);
        return results.getInt(1);
    }

    private int getNumTombstones(Mailbox mbox) throws ServiceException {
        DbResults results = DbUtil.executeQuery("SELECT COUNT(*) FROM " + DbMailItem.getTombstoneTableName(mbox) + " WHERE mailbox_id = " + mbox.getId());
        return results.getInt(1);
    }

    private Message alterUnread(Message msg, boolean unread) throws Exception {
        Mailbox mbox = TestUtil.getMailbox(USER_NAME);
        mbox.alterTag(null, msg.getId(), msg.getType(), -10, unread);
        return mbox.getMessageById(null, msg.getId());
    }

    private boolean messageExists(int id) throws Exception {
        Mailbox mbox = TestUtil.getMailbox(USER_NAME);
        try {
            mbox.getMessageById(null, id);
        }
        catch (ServiceException e) {
            TestPurge.assertTrue((String)("Unexpected exception type: " + e), (boolean)(e instanceof MailServiceException.NoSuchItemException));
            return false;
        }
        return true;
    }

    public void tearDown() throws Exception {
        LC.tombstone_max_age_ms.setDefault(Long.toString(this.mOriginalTombstoneAge));
        Account account = TestUtil.getAccount(USER_NAME);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailTrashLifetime", this.mOriginalSystemTrashLifetime);
        attrs.put("zimbraMailSpamLifetime", this.mOriginalSystemJunkLifetime);
        attrs.put("zimbraMailMessageLifetime", this.mOriginalSystemMessageLifetime);
        attrs.put("zimbraPrefInboxReadLifetime", this.mOriginalUserInboxReadLifetime);
        attrs.put("zimbraPrefInboxUnreadLifetime", this.mOriginalUserInboxUnreadLifetime);
        attrs.put("zimbraPrefSentLifetime", this.mOriginalUserSentLifetime);
        attrs.put("zimbraPrefTrashLifetime", this.mOriginalUserTrashLifetime);
        attrs.put("zimbraPrefJunkLifetime", this.mOriginalUserJunkLifetime);
        attrs.put("zimbraMailPurgeUseChangeDateForTrash", this.mOriginalUseChangeDateForTrash);
        Provisioning.getInstance().modifyAttrs(account, attrs);
        this.cleanUp();
    }

    private void cleanUp() throws Exception {
        TestUtil.deleteTestData(USER_NAME, NAME_PREFIX);
    }
}

